import { StatefulSetMetadata, StatefulSetMetadataOutputReference, StatefulSetSpec, StatefulSetSpecOutputReference, StatefulSetTimeouts, StatefulSetTimeoutsOutputReference } from './stateful-set-structs';
export * from './stateful-set-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StatefulSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set#id StatefulSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Wait for the rollout of the stateful set to complete. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set#wait_for_rollout StatefulSet#wait_for_rollout}
    */
    readonly waitForRollout?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set#metadata StatefulSet#metadata}
    */
    readonly metadata: StatefulSetMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set#spec StatefulSet#spec}
    */
    readonly spec: StatefulSetSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set#timeouts StatefulSet#timeouts}
    */
    readonly timeouts?: StatefulSetTimeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set kubernetes_stateful_set}
*/
export declare class StatefulSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_stateful_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/stateful_set kubernetes_stateful_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StatefulSetConfig
    */
    constructor(scope: Construct, id: string, config: StatefulSetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForRollout?;
    get waitForRollout(): boolean | cdktf.IResolvable;
    set waitForRollout(value: boolean | cdktf.IResolvable);
    resetWaitForRollout(): void;
    get waitForRolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): StatefulSetMetadataOutputReference;
    putMetadata(value: StatefulSetMetadata): void;
    get metadataInput(): StatefulSetMetadata | undefined;
    private _spec;
    get spec(): StatefulSetSpecOutputReference;
    putSpec(value: StatefulSetSpec): void;
    get specInput(): StatefulSetSpec | undefined;
    private _timeouts;
    get timeouts(): StatefulSetTimeoutsOutputReference;
    putTimeouts(value: StatefulSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StatefulSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
