import * as cdktf from 'cdktf';
import { PodSpecAffinity, PodSpecAffinityOutputReference, PodSpecContainer, PodSpecContainerList, PodSpecDnsConfig, PodSpecDnsConfigOutputReference, PodSpecHostAliases, PodSpecHostAliasesList, PodSpecImagePullSecrets, PodSpecImagePullSecretsList, PodSpecInitContainer, PodSpecInitContainerList } from './structs0';
export interface PodSpecReadinessGate {
    /**
    * refers to a condition in the pod's condition list with matching type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#condition_type Pod#condition_type}
    */
    readonly conditionType: string;
}
export declare function podSpecReadinessGateToTerraform(struct?: PodSpecReadinessGate | cdktf.IResolvable): any;
export declare class PodSpecReadinessGateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecReadinessGate | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecReadinessGate | cdktf.IResolvable | undefined);
    private _conditionType?;
    get conditionType(): string;
    set conditionType(value: string);
    get conditionTypeInput(): string | undefined;
}
export declare class PodSpecReadinessGateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecReadinessGateOutputReference;
}
export interface PodSpecSecurityContextSeLinuxOptions {
    /**
    * Level is SELinux level label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#level Pod#level}
    */
    readonly level?: string;
    /**
    * Role is a SELinux role label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#role Pod#role}
    */
    readonly role?: string;
    /**
    * Type is a SELinux type label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#type Pod#type}
    */
    readonly type?: string;
    /**
    * User is a SELinux user label that applies to the container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#user Pod#user}
    */
    readonly user?: string;
}
export declare function podSpecSecurityContextSeLinuxOptionsToTerraform(struct?: PodSpecSecurityContextSeLinuxOptionsOutputReference | PodSpecSecurityContextSeLinuxOptions): any;
export declare class PodSpecSecurityContextSeLinuxOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecSecurityContextSeLinuxOptions | undefined;
    set internalValue(value: PodSpecSecurityContextSeLinuxOptions | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    resetLevel(): void;
    get levelInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
}
export interface PodSpecSecurityContextSeccompProfile {
    /**
    * Localhost Profile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#localhost_profile Pod#localhost_profile}
    */
    readonly localhostProfile?: string;
    /**
    * Type indicates which kind of seccomp profile will be applied. Valid options are: Localhost, RuntimeDefault, Unconfined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#type Pod#type}
    */
    readonly type?: string;
}
export declare function podSpecSecurityContextSeccompProfileToTerraform(struct?: PodSpecSecurityContextSeccompProfileOutputReference | PodSpecSecurityContextSeccompProfile): any;
export declare class PodSpecSecurityContextSeccompProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecSecurityContextSeccompProfile | undefined;
    set internalValue(value: PodSpecSecurityContextSeccompProfile | undefined);
    private _localhostProfile?;
    get localhostProfile(): string;
    set localhostProfile(value: string);
    resetLocalhostProfile(): void;
    get localhostProfileInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface PodSpecSecurityContextSysctl {
    /**
    * Name of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name: string;
    /**
    * Value of a property to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#value Pod#value}
    */
    readonly value: string;
}
export declare function podSpecSecurityContextSysctlToTerraform(struct?: PodSpecSecurityContextSysctl | cdktf.IResolvable): any;
export declare class PodSpecSecurityContextSysctlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecSecurityContextSysctl | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecSecurityContextSysctl | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class PodSpecSecurityContextSysctlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecSecurityContextSysctl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecSecurityContextSysctlOutputReference;
}
export interface PodSpecSecurityContext {
    /**
    * A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod: 1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw---- If unset, the Kubelet will not modify the ownership and permissions of any volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_group Pod#fs_group}
    */
    readonly fsGroup?: string;
    /**
    * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#run_as_group Pod#run_as_group}
    */
    readonly runAsGroup?: string;
    /**
    * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#run_as_non_root Pod#run_as_non_root}
    */
    readonly runAsNonRoot?: boolean | cdktf.IResolvable;
    /**
    * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#run_as_user Pod#run_as_user}
    */
    readonly runAsUser?: string;
    /**
    * A list of groups applied to the first process run in each container, in addition to the container's primary GID. If unspecified, no groups will be added to any container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#supplemental_groups Pod#supplemental_groups}
    */
    readonly supplementalGroups?: number[];
    /**
    * se_linux_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#se_linux_options Pod#se_linux_options}
    */
    readonly seLinuxOptions?: PodSpecSecurityContextSeLinuxOptions;
    /**
    * seccomp_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#seccomp_profile Pod#seccomp_profile}
    */
    readonly seccompProfile?: PodSpecSecurityContextSeccompProfile;
    /**
    * sysctl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#sysctl Pod#sysctl}
    */
    readonly sysctl?: PodSpecSecurityContextSysctl[] | cdktf.IResolvable;
}
export declare function podSpecSecurityContextToTerraform(struct?: PodSpecSecurityContextOutputReference | PodSpecSecurityContext): any;
export declare class PodSpecSecurityContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecSecurityContext | undefined;
    set internalValue(value: PodSpecSecurityContext | undefined);
    private _fsGroup?;
    get fsGroup(): string;
    set fsGroup(value: string);
    resetFsGroup(): void;
    get fsGroupInput(): string | undefined;
    private _runAsGroup?;
    get runAsGroup(): string;
    set runAsGroup(value: string);
    resetRunAsGroup(): void;
    get runAsGroupInput(): string | undefined;
    private _runAsNonRoot?;
    get runAsNonRoot(): boolean | cdktf.IResolvable;
    set runAsNonRoot(value: boolean | cdktf.IResolvable);
    resetRunAsNonRoot(): void;
    get runAsNonRootInput(): boolean | cdktf.IResolvable | undefined;
    private _runAsUser?;
    get runAsUser(): string;
    set runAsUser(value: string);
    resetRunAsUser(): void;
    get runAsUserInput(): string | undefined;
    private _supplementalGroups?;
    get supplementalGroups(): number[];
    set supplementalGroups(value: number[]);
    resetSupplementalGroups(): void;
    get supplementalGroupsInput(): number[] | undefined;
    private _seLinuxOptions;
    get seLinuxOptions(): PodSpecSecurityContextSeLinuxOptionsOutputReference;
    putSeLinuxOptions(value: PodSpecSecurityContextSeLinuxOptions): void;
    resetSeLinuxOptions(): void;
    get seLinuxOptionsInput(): PodSpecSecurityContextSeLinuxOptions | undefined;
    private _seccompProfile;
    get seccompProfile(): PodSpecSecurityContextSeccompProfileOutputReference;
    putSeccompProfile(value: PodSpecSecurityContextSeccompProfile): void;
    resetSeccompProfile(): void;
    get seccompProfileInput(): PodSpecSecurityContextSeccompProfile | undefined;
    private _sysctl;
    get sysctl(): PodSpecSecurityContextSysctlList;
    putSysctl(value: PodSpecSecurityContextSysctl[] | cdktf.IResolvable): void;
    resetSysctl(): void;
    get sysctlInput(): cdktf.IResolvable | PodSpecSecurityContextSysctl[] | undefined;
}
export interface PodSpecToleration {
    /**
    * Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#effect Pod#effect}
    */
    readonly effect?: string;
    /**
    * Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#key Pod#key}
    */
    readonly key?: string;
    /**
    * Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#operator Pod#operator}
    */
    readonly operator?: string;
    /**
    * TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#toleration_seconds Pod#toleration_seconds}
    */
    readonly tolerationSeconds?: string;
    /**
    * Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#value Pod#value}
    */
    readonly value?: string;
}
export declare function podSpecTolerationToTerraform(struct?: PodSpecToleration | cdktf.IResolvable): any;
export declare class PodSpecTolerationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecToleration | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecToleration | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _tolerationSeconds?;
    get tolerationSeconds(): string;
    set tolerationSeconds(value: string);
    resetTolerationSeconds(): void;
    get tolerationSecondsInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class PodSpecTolerationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecToleration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecTolerationOutputReference;
}
export interface PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions {
    /**
    * The label key that the selector applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#key Pod#key}
    */
    readonly key?: string;
    /**
    * A key's relationship to a set of values. Valid operators ard `In`, `NotIn`, `Exists` and `DoesNotExist`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#operator Pod#operator}
    */
    readonly operator?: string;
    /**
    * An array of string values. If the operator is `In` or `NotIn`, the values array must be non-empty. If the operator is `Exists` or `DoesNotExist`, the values array must be empty. This array is replaced during a strategic merge patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#values Pod#values}
    */
    readonly values?: string[];
}
export declare function podSpecTopologySpreadConstraintLabelSelectorMatchExpressionsToTerraform(struct?: PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable): any;
export declare class PodSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export declare class PodSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecTopologySpreadConstraintLabelSelectorMatchExpressionsOutputReference;
}
export interface PodSpecTopologySpreadConstraintLabelSelector {
    /**
    * A map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of `match_expressions`, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#match_labels Pod#match_labels}
    */
    readonly matchLabels?: {
        [key: string]: string;
    };
    /**
    * match_expressions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#match_expressions Pod#match_expressions}
    */
    readonly matchExpressions?: PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable;
}
export declare function podSpecTopologySpreadConstraintLabelSelectorToTerraform(struct?: PodSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable): any;
export declare class PodSpecTopologySpreadConstraintLabelSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecTopologySpreadConstraintLabelSelector | cdktf.IResolvable | undefined);
    private _matchLabels?;
    get matchLabels(): {
        [key: string]: string;
    };
    set matchLabels(value: {
        [key: string]: string;
    });
    resetMatchLabels(): void;
    get matchLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _matchExpressions;
    get matchExpressions(): PodSpecTopologySpreadConstraintLabelSelectorMatchExpressionsList;
    putMatchExpressions(value: PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | cdktf.IResolvable): void;
    resetMatchExpressions(): void;
    get matchExpressionsInput(): cdktf.IResolvable | PodSpecTopologySpreadConstraintLabelSelectorMatchExpressions[] | undefined;
}
export declare class PodSpecTopologySpreadConstraintLabelSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecTopologySpreadConstraintLabelSelectorOutputReference;
}
export interface PodSpecTopologySpreadConstraint {
    /**
    * describes the degree to which pods may be unevenly distributed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#max_skew Pod#max_skew}
    */
    readonly maxSkew?: number;
    /**
    * the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#topology_key Pod#topology_key}
    */
    readonly topologyKey?: string;
    /**
    * indicates how to deal with a pod if it doesn't satisfy the spread constraint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#when_unsatisfiable Pod#when_unsatisfiable}
    */
    readonly whenUnsatisfiable?: string;
    /**
    * label_selector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#label_selector Pod#label_selector}
    */
    readonly labelSelector?: PodSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable;
}
export declare function podSpecTopologySpreadConstraintToTerraform(struct?: PodSpecTopologySpreadConstraint | cdktf.IResolvable): any;
export declare class PodSpecTopologySpreadConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecTopologySpreadConstraint | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecTopologySpreadConstraint | cdktf.IResolvable | undefined);
    private _maxSkew?;
    get maxSkew(): number;
    set maxSkew(value: number);
    resetMaxSkew(): void;
    get maxSkewInput(): number | undefined;
    private _topologyKey?;
    get topologyKey(): string;
    set topologyKey(value: string);
    resetTopologyKey(): void;
    get topologyKeyInput(): string | undefined;
    private _whenUnsatisfiable?;
    get whenUnsatisfiable(): string;
    set whenUnsatisfiable(value: string);
    resetWhenUnsatisfiable(): void;
    get whenUnsatisfiableInput(): string | undefined;
    private _labelSelector;
    get labelSelector(): PodSpecTopologySpreadConstraintLabelSelectorList;
    putLabelSelector(value: PodSpecTopologySpreadConstraintLabelSelector[] | cdktf.IResolvable): void;
    resetLabelSelector(): void;
    get labelSelectorInput(): cdktf.IResolvable | PodSpecTopologySpreadConstraintLabelSelector[] | undefined;
}
export declare class PodSpecTopologySpreadConstraintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecTopologySpreadConstraintOutputReference;
}
export interface PodSpecVolumeAwsElasticBlockStore {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#partition Pod#partition}
    */
    readonly partition?: number;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: http://kubernetes.io/docs/user-guide/volumes#awselasticblockstore
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#volume_id Pod#volume_id}
    */
    readonly volumeId: string;
}
export declare function podSpecVolumeAwsElasticBlockStoreToTerraform(struct?: PodSpecVolumeAwsElasticBlockStoreOutputReference | PodSpecVolumeAwsElasticBlockStore): any;
export declare class PodSpecVolumeAwsElasticBlockStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeAwsElasticBlockStore | undefined;
    set internalValue(value: PodSpecVolumeAwsElasticBlockStore | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface PodSpecVolumeAzureDisk {
    /**
    * Host Caching mode: None, Read Only, Read Write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#caching_mode Pod#caching_mode}
    */
    readonly cachingMode: string;
    /**
    * The URI the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#data_disk_uri Pod#data_disk_uri}
    */
    readonly dataDiskUri: string;
    /**
    * The Name of the data disk in the blob storage
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#disk_name Pod#disk_name}
    */
    readonly diskName: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * The type for the data disk. Expected values: Shared, Dedicated, Managed. Defaults to Shared
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#kind Pod#kind}
    */
    readonly kind?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podSpecVolumeAzureDiskToTerraform(struct?: PodSpecVolumeAzureDiskOutputReference | PodSpecVolumeAzureDisk): any;
export declare class PodSpecVolumeAzureDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeAzureDisk | undefined;
    set internalValue(value: PodSpecVolumeAzureDisk | undefined);
    private _cachingMode?;
    get cachingMode(): string;
    set cachingMode(value: string);
    get cachingModeInput(): string | undefined;
    private _dataDiskUri?;
    get dataDiskUri(): string;
    set dataDiskUri(value: string);
    get dataDiskUriInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    get diskNameInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodSpecVolumeAzureFile {
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The name of secret that contains Azure Storage Account Name and Key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret_name Pod#secret_name}
    */
    readonly secretName: string;
    /**
    * The namespace of the secret that contains Azure Storage Account Name and Key. For Kubernetes up to 1.18.x the default is the same as the Pod. For Kubernetes 1.19.x and later the default is "default" namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret_namespace Pod#secret_namespace}
    */
    readonly secretNamespace?: string;
    /**
    * Share Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#share_name Pod#share_name}
    */
    readonly shareName: string;
}
export declare function podSpecVolumeAzureFileToTerraform(struct?: PodSpecVolumeAzureFileOutputReference | PodSpecVolumeAzureFile): any;
export declare class PodSpecVolumeAzureFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeAzureFile | undefined;
    set internalValue(value: PodSpecVolumeAzureFile | undefined);
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _secretNamespace?;
    get secretNamespace(): string;
    set secretNamespace(value: string);
    resetSecretNamespace(): void;
    get secretNamespaceInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
}
export interface PodSpecVolumeCephFsSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#namespace Pod#namespace}
    */
    readonly namespace?: string;
}
export declare function podSpecVolumeCephFsSecretRefToTerraform(struct?: PodSpecVolumeCephFsSecretRefOutputReference | PodSpecVolumeCephFsSecretRef): any;
export declare class PodSpecVolumeCephFsSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeCephFsSecretRef | undefined;
    set internalValue(value: PodSpecVolumeCephFsSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface PodSpecVolumeCephFs {
    /**
    * Monitors is a collection of Ceph monitors More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#monitors Pod#monitors}
    */
    readonly monitors: string[];
    /**
    * Used as the mounted root, rather than the full Ceph tree, default is /
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to `false` (read/write). More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * The path to key ring for User, default is /etc/ceph/user.secret More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret_file Pod#secret_file}
    */
    readonly secretFile?: string;
    /**
    * User is the rados user name, default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#user Pod#user}
    */
    readonly user?: string;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret_ref Pod#secret_ref}
    */
    readonly secretRef?: PodSpecVolumeCephFsSecretRef;
}
export declare function podSpecVolumeCephFsToTerraform(struct?: PodSpecVolumeCephFsOutputReference | PodSpecVolumeCephFs): any;
export declare class PodSpecVolumeCephFsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeCephFs | undefined;
    set internalValue(value: PodSpecVolumeCephFs | undefined);
    private _monitors?;
    get monitors(): string[];
    set monitors(value: string[]);
    get monitorsInput(): string[] | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretFile?;
    get secretFile(): string;
    set secretFile(value: string);
    resetSecretFile(): void;
    get secretFileInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _secretRef;
    get secretRef(): PodSpecVolumeCephFsSecretRefOutputReference;
    putSecretRef(value: PodSpecVolumeCephFsSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): PodSpecVolumeCephFsSecretRef | undefined;
}
export interface PodSpecVolumeCinder {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write). More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Volume ID used to identify the volume in Cinder. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#volume_id Pod#volume_id}
    */
    readonly volumeId: string;
}
export declare function podSpecVolumeCinderToTerraform(struct?: PodSpecVolumeCinderOutputReference | PodSpecVolumeCinder): any;
export declare class PodSpecVolumeCinderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeCinder | undefined;
    set internalValue(value: PodSpecVolumeCinder | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
}
export interface PodSpecVolumeConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#key Pod#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#mode Pod#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path?: string;
}
export declare function podSpecVolumeConfigMapItemsToTerraform(struct?: PodSpecVolumeConfigMapItems | cdktf.IResolvable): any;
export declare class PodSpecVolumeConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodSpecVolumeConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeConfigMapItemsOutputReference;
}
export interface PodSpecVolumeConfigMap {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#default_mode Pod#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#optional Pod#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#items Pod#items}
    */
    readonly items?: PodSpecVolumeConfigMapItems[] | cdktf.IResolvable;
}
export declare function podSpecVolumeConfigMapToTerraform(struct?: PodSpecVolumeConfigMapOutputReference | PodSpecVolumeConfigMap): any;
export declare class PodSpecVolumeConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeConfigMap | undefined;
    set internalValue(value: PodSpecVolumeConfigMap | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): PodSpecVolumeConfigMapItemsList;
    putItems(value: PodSpecVolumeConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodSpecVolumeConfigMapItems[] | undefined;
}
export interface PodSpecVolumeCsiNodePublishSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
}
export declare function podSpecVolumeCsiNodePublishSecretRefToTerraform(struct?: PodSpecVolumeCsiNodePublishSecretRefOutputReference | PodSpecVolumeCsiNodePublishSecretRef): any;
export declare class PodSpecVolumeCsiNodePublishSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeCsiNodePublishSecretRef | undefined;
    set internalValue(value: PodSpecVolumeCsiNodePublishSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export interface PodSpecVolumeCsi {
    /**
    * the name of the volume driver to use. More info: https://kubernetes.io/docs/concepts/storage/volumes/#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#driver Pod#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * Whether to set the read-only property in VolumeMounts to "true". If omitted, the default is "false". More info: http://kubernetes.io/docs/user-guide/volumes#csi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Attributes of the volume to publish.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#volume_attributes Pod#volume_attributes}
    */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
    /**
    * node_publish_secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#node_publish_secret_ref Pod#node_publish_secret_ref}
    */
    readonly nodePublishSecretRef?: PodSpecVolumeCsiNodePublishSecretRef;
}
export declare function podSpecVolumeCsiToTerraform(struct?: PodSpecVolumeCsiOutputReference | PodSpecVolumeCsi): any;
export declare class PodSpecVolumeCsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeCsi | undefined;
    set internalValue(value: PodSpecVolumeCsi | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeAttributes?;
    get volumeAttributes(): {
        [key: string]: string;
    };
    set volumeAttributes(value: {
        [key: string]: string;
    });
    resetVolumeAttributes(): void;
    get volumeAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _nodePublishSecretRef;
    get nodePublishSecretRef(): PodSpecVolumeCsiNodePublishSecretRefOutputReference;
    putNodePublishSecretRef(value: PodSpecVolumeCsiNodePublishSecretRef): void;
    resetNodePublishSecretRef(): void;
    get nodePublishSecretRefInput(): PodSpecVolumeCsiNodePublishSecretRef | undefined;
}
export interface PodSpecVolumeDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to "v1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#api_version Pod#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#field_path Pod#field_path}
    */
    readonly fieldPath?: string;
}
export declare function podSpecVolumeDownwardApiItemsFieldRefToTerraform(struct?: PodSpecVolumeDownwardApiItemsFieldRefOutputReference | PodSpecVolumeDownwardApiItemsFieldRef): any;
export declare class PodSpecVolumeDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeDownwardApiItemsFieldRef | undefined;
    set internalValue(value: PodSpecVolumeDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface PodSpecVolumeDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#container_name Pod#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#divisor Pod#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#resource Pod#resource}
    */
    readonly resource: string;
}
export declare function podSpecVolumeDownwardApiItemsResourceFieldRefToTerraform(struct?: PodSpecVolumeDownwardApiItemsResourceFieldRefOutputReference | PodSpecVolumeDownwardApiItemsResourceFieldRef): any;
export declare class PodSpecVolumeDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: PodSpecVolumeDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface PodSpecVolumeDownwardApiItems {
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#mode Pod#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#field_ref Pod#field_ref}
    */
    readonly fieldRef: PodSpecVolumeDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#resource_field_ref Pod#resource_field_ref}
    */
    readonly resourceFieldRef?: PodSpecVolumeDownwardApiItemsResourceFieldRef;
}
export declare function podSpecVolumeDownwardApiItemsToTerraform(struct?: PodSpecVolumeDownwardApiItems | cdktf.IResolvable): any;
export declare class PodSpecVolumeDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): PodSpecVolumeDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: PodSpecVolumeDownwardApiItemsFieldRef): void;
    get fieldRefInput(): PodSpecVolumeDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): PodSpecVolumeDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: PodSpecVolumeDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): PodSpecVolumeDownwardApiItemsResourceFieldRef | undefined;
}
export declare class PodSpecVolumeDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeDownwardApiItemsOutputReference;
}
export interface PodSpecVolumeDownwardApi {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#default_mode Pod#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#items Pod#items}
    */
    readonly items?: PodSpecVolumeDownwardApiItems[] | cdktf.IResolvable;
}
export declare function podSpecVolumeDownwardApiToTerraform(struct?: PodSpecVolumeDownwardApiOutputReference | PodSpecVolumeDownwardApi): any;
export declare class PodSpecVolumeDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeDownwardApi | undefined;
    set internalValue(value: PodSpecVolumeDownwardApi | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _items;
    get items(): PodSpecVolumeDownwardApiItemsList;
    putItems(value: PodSpecVolumeDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodSpecVolumeDownwardApiItems[] | undefined;
}
export interface PodSpecVolumeEmptyDir {
    /**
    * What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#medium Pod#medium}
    */
    readonly medium?: string;
    /**
    * Total amount of local storage required for this EmptyDir volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#size_limit Pod#size_limit}
    */
    readonly sizeLimit?: string;
}
export declare function podSpecVolumeEmptyDirToTerraform(struct?: PodSpecVolumeEmptyDirOutputReference | PodSpecVolumeEmptyDir): any;
export declare class PodSpecVolumeEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeEmptyDir | undefined;
    set internalValue(value: PodSpecVolumeEmptyDir | undefined);
    private _medium?;
    get medium(): string;
    set medium(value: string);
    resetMedium(): void;
    get mediumInput(): string | undefined;
    private _sizeLimit?;
    get sizeLimit(): string;
    set sizeLimit(value: string);
    resetSizeLimit(): void;
    get sizeLimitInput(): string | undefined;
}
export interface PodSpecVolumeFc {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * FC target lun number
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#lun Pod#lun}
    */
    readonly lun: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * FC target worldwide names (WWNs)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#target_ww_ns Pod#target_ww_ns}
    */
    readonly targetWwNs: string[];
}
export declare function podSpecVolumeFcToTerraform(struct?: PodSpecVolumeFcOutputReference | PodSpecVolumeFc): any;
export declare class PodSpecVolumeFcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeFc | undefined;
    set internalValue(value: PodSpecVolumeFc | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetWwNs?;
    get targetWwNs(): string[];
    set targetWwNs(value: string[]);
    get targetWwNsInput(): string[] | undefined;
}
export interface PodSpecVolumeFlexVolumeSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#namespace Pod#namespace}
    */
    readonly namespace?: string;
}
export declare function podSpecVolumeFlexVolumeSecretRefToTerraform(struct?: PodSpecVolumeFlexVolumeSecretRefOutputReference | PodSpecVolumeFlexVolumeSecretRef): any;
export declare class PodSpecVolumeFlexVolumeSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeFlexVolumeSecretRef | undefined;
    set internalValue(value: PodSpecVolumeFlexVolumeSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface PodSpecVolumeFlexVolume {
    /**
    * Driver is the name of the driver to use for this volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#driver Pod#driver}
    */
    readonly driver: string;
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * Extra command options if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#options Pod#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false (read/write).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret_ref Pod#secret_ref}
    */
    readonly secretRef?: PodSpecVolumeFlexVolumeSecretRef;
}
export declare function podSpecVolumeFlexVolumeToTerraform(struct?: PodSpecVolumeFlexVolumeOutputReference | PodSpecVolumeFlexVolume): any;
export declare class PodSpecVolumeFlexVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeFlexVolume | undefined;
    set internalValue(value: PodSpecVolumeFlexVolume | undefined);
    private _driver?;
    get driver(): string;
    set driver(value: string);
    get driverInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): PodSpecVolumeFlexVolumeSecretRefOutputReference;
    putSecretRef(value: PodSpecVolumeFlexVolumeSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): PodSpecVolumeFlexVolumeSecretRef | undefined;
}
export interface PodSpecVolumeFlocker {
    /**
    * Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#dataset_name Pod#dataset_name}
    */
    readonly datasetName?: string;
    /**
    * UUID of the dataset. This is unique identifier of a Flocker dataset
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#dataset_uuid Pod#dataset_uuid}
    */
    readonly datasetUuid?: string;
}
export declare function podSpecVolumeFlockerToTerraform(struct?: PodSpecVolumeFlockerOutputReference | PodSpecVolumeFlocker): any;
export declare class PodSpecVolumeFlockerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeFlocker | undefined;
    set internalValue(value: PodSpecVolumeFlocker | undefined);
    private _datasetName?;
    get datasetName(): string;
    set datasetName(value: string);
    resetDatasetName(): void;
    get datasetNameInput(): string | undefined;
    private _datasetUuid?;
    get datasetUuid(): string;
    set datasetUuid(value: string);
    resetDatasetUuid(): void;
    get datasetUuidInput(): string | undefined;
}
export interface PodSpecVolumeGcePersistentDisk {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#partition Pod#partition}
    */
    readonly partition?: number;
    /**
    * Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#pd_name Pod#pd_name}
    */
    readonly pdName: string;
    /**
    * Whether to force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podSpecVolumeGcePersistentDiskToTerraform(struct?: PodSpecVolumeGcePersistentDiskOutputReference | PodSpecVolumeGcePersistentDisk): any;
export declare class PodSpecVolumeGcePersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeGcePersistentDisk | undefined;
    set internalValue(value: PodSpecVolumeGcePersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _partition?;
    get partition(): number;
    set partition(value: number);
    resetPartition(): void;
    get partitionInput(): number | undefined;
    private _pdName?;
    get pdName(): string;
    set pdName(value: string);
    get pdNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodSpecVolumeGitRepo {
    /**
    * Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#directory Pod#directory}
    */
    readonly directory?: string;
    /**
    * Repository URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#repository Pod#repository}
    */
    readonly repository?: string;
    /**
    * Commit hash for the specified revision.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#revision Pod#revision}
    */
    readonly revision?: string;
}
export declare function podSpecVolumeGitRepoToTerraform(struct?: PodSpecVolumeGitRepoOutputReference | PodSpecVolumeGitRepo): any;
export declare class PodSpecVolumeGitRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeGitRepo | undefined;
    set internalValue(value: PodSpecVolumeGitRepo | undefined);
    private _directory?;
    get directory(): string;
    set directory(value: string);
    resetDirectory(): void;
    get directoryInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    resetRepository(): void;
    get repositoryInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
}
export interface PodSpecVolumeGlusterfs {
    /**
    * The endpoint name that details Glusterfs topology. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#endpoints_name Pod#endpoints_name}
    */
    readonly endpointsName: string;
    /**
    * The Glusterfs volume path. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path: string;
    /**
    * Whether to force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/glusterfs/README.md#create-a-pod
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podSpecVolumeGlusterfsToTerraform(struct?: PodSpecVolumeGlusterfsOutputReference | PodSpecVolumeGlusterfs): any;
export declare class PodSpecVolumeGlusterfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeGlusterfs | undefined;
    set internalValue(value: PodSpecVolumeGlusterfs | undefined);
    private _endpointsName?;
    get endpointsName(): string;
    set endpointsName(value: string);
    get endpointsNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodSpecVolumeHostPath {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#hostpath
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path?: string;
    /**
    * Type for HostPath volume. Allowed values are "" (default), DirectoryOrCreate, Directory, FileOrCreate, File, Socket, CharDevice and BlockDevice
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#type Pod#type}
    */
    readonly type?: string;
}
export declare function podSpecVolumeHostPathToTerraform(struct?: PodSpecVolumeHostPathOutputReference | PodSpecVolumeHostPath): any;
export declare class PodSpecVolumeHostPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeHostPath | undefined;
    set internalValue(value: PodSpecVolumeHostPath | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface PodSpecVolumeIscsi {
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#iscsi
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * Target iSCSI Qualified Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#iqn Pod#iqn}
    */
    readonly iqn: string;
    /**
    * iSCSI interface name that uses an iSCSI transport. Defaults to 'default' (tcp).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#iscsi_interface Pod#iscsi_interface}
    */
    readonly iscsiInterface?: string;
    /**
    * iSCSI target lun number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#lun Pod#lun}
    */
    readonly lun?: number;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#target_portal Pod#target_portal}
    */
    readonly targetPortal: string;
}
export declare function podSpecVolumeIscsiToTerraform(struct?: PodSpecVolumeIscsiOutputReference | PodSpecVolumeIscsi): any;
export declare class PodSpecVolumeIscsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeIscsi | undefined;
    set internalValue(value: PodSpecVolumeIscsi | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _iqn?;
    get iqn(): string;
    set iqn(value: string);
    get iqnInput(): string | undefined;
    private _iscsiInterface?;
    get iscsiInterface(): string;
    set iscsiInterface(value: string);
    resetIscsiInterface(): void;
    get iscsiInterfaceInput(): string | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    resetLun(): void;
    get lunInput(): number | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _targetPortal?;
    get targetPortal(): string;
    set targetPortal(value: string);
    get targetPortalInput(): string | undefined;
}
export interface PodSpecVolumeLocal {
    /**
    * Path of the directory on the host. More info: http://kubernetes.io/docs/user-guide/volumes#local
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path?: string;
}
export declare function podSpecVolumeLocalToTerraform(struct?: PodSpecVolumeLocalOutputReference | PodSpecVolumeLocal): any;
export declare class PodSpecVolumeLocalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeLocal | undefined;
    set internalValue(value: PodSpecVolumeLocal | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface PodSpecVolumeNfs {
    /**
    * Path that is exported by the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path: string;
    /**
    * Whether to force the NFS export to be mounted with read-only permissions. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Server is the hostname or IP address of the NFS server. More info: http://kubernetes.io/docs/user-guide/volumes#nfs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#server Pod#server}
    */
    readonly server: string;
}
export declare function podSpecVolumeNfsToTerraform(struct?: PodSpecVolumeNfsOutputReference | PodSpecVolumeNfs): any;
export declare class PodSpecVolumeNfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeNfs | undefined;
    set internalValue(value: PodSpecVolumeNfs | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
}
export interface PodSpecVolumePersistentVolumeClaim {
    /**
    * ClaimName is the name of a PersistentVolumeClaim in the same
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#claim_name Pod#claim_name}
    */
    readonly claimName?: string;
    /**
    * Will force the ReadOnly setting in VolumeMounts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
}
export declare function podSpecVolumePersistentVolumeClaimToTerraform(struct?: PodSpecVolumePersistentVolumeClaimOutputReference | PodSpecVolumePersistentVolumeClaim): any;
export declare class PodSpecVolumePersistentVolumeClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumePersistentVolumeClaim | undefined;
    set internalValue(value: PodSpecVolumePersistentVolumeClaim | undefined);
    private _claimName?;
    get claimName(): string;
    set claimName(value: string);
    resetClaimName(): void;
    get claimNameInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PodSpecVolumePhotonPersistentDisk {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * ID that identifies Photon Controller persistent disk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#pd_id Pod#pd_id}
    */
    readonly pdId: string;
}
export declare function podSpecVolumePhotonPersistentDiskToTerraform(struct?: PodSpecVolumePhotonPersistentDiskOutputReference | PodSpecVolumePhotonPersistentDisk): any;
export declare class PodSpecVolumePhotonPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumePhotonPersistentDisk | undefined;
    set internalValue(value: PodSpecVolumePhotonPersistentDisk | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _pdId?;
    get pdId(): string;
    set pdId(value: string);
    get pdIdInput(): string | undefined;
}
export interface PodSpecVolumeProjectedSourcesConfigMapItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#key Pod#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#mode Pod#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path?: string;
}
export declare function podSpecVolumeProjectedSourcesConfigMapItemsToTerraform(struct?: PodSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable): any;
export declare class PodSpecVolumeProjectedSourcesConfigMapItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesConfigMapItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodSpecVolumeProjectedSourcesConfigMapItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeProjectedSourcesConfigMapItemsOutputReference;
}
export interface PodSpecVolumeProjectedSourcesConfigMap {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the ConfigMap or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#optional Pod#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#items Pod#items}
    */
    readonly items?: PodSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable;
}
export declare function podSpecVolumeProjectedSourcesConfigMapToTerraform(struct?: PodSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable): any;
export declare class PodSpecVolumeProjectedSourcesConfigMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesConfigMap | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): PodSpecVolumeProjectedSourcesConfigMapItemsList;
    putItems(value: PodSpecVolumeProjectedSourcesConfigMapItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodSpecVolumeProjectedSourcesConfigMapItems[] | undefined;
}
export declare class PodSpecVolumeProjectedSourcesConfigMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeProjectedSourcesConfigMapOutputReference;
}
export interface PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRef {
    /**
    * Version of the schema the FieldPath is written in terms of, defaults to 'v1'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#api_version Pod#api_version}
    */
    readonly apiVersion?: string;
    /**
    * Path of the field to select in the specified API version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#field_path Pod#field_path}
    */
    readonly fieldPath?: string;
}
export declare function podSpecVolumeProjectedSourcesDownwardApiItemsFieldRefToTerraform(struct?: PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference | PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): any;
export declare class PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined);
    private _apiVersion?;
    get apiVersion(): string;
    set apiVersion(value: string);
    resetApiVersion(): void;
    get apiVersionInput(): string | undefined;
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    resetFieldPath(): void;
    get fieldPathInput(): string | undefined;
}
export interface PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#container_name Pod#container_name}
    */
    readonly containerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#divisor Pod#divisor}
    */
    readonly divisor?: string;
    /**
    * Resource to select
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#resource Pod#resource}
    */
    readonly resource: string;
}
export declare function podSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefToTerraform(struct?: PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference | PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): any;
export declare class PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined);
    private _containerName?;
    get containerName(): string;
    set containerName(value: string);
    get containerNameInput(): string | undefined;
    private _divisor?;
    get divisor(): string;
    set divisor(value: string);
    resetDivisor(): void;
    get divisorInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
}
export interface PodSpecVolumeProjectedSourcesDownwardApiItems {
    /**
    * Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#mode Pod#mode}
    */
    readonly mode?: string;
    /**
    * Path is the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path: string;
    /**
    * field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#field_ref Pod#field_ref}
    */
    readonly fieldRef?: PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRef;
    /**
    * resource_field_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#resource_field_ref Pod#resource_field_ref}
    */
    readonly resourceFieldRef?: PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef;
}
export declare function podSpecVolumeProjectedSourcesDownwardApiItemsToTerraform(struct?: PodSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable): any;
export declare class PodSpecVolumeProjectedSourcesDownwardApiItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesDownwardApiItems | cdktf.IResolvable | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _fieldRef;
    get fieldRef(): PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRefOutputReference;
    putFieldRef(value: PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRef): void;
    resetFieldRef(): void;
    get fieldRefInput(): PodSpecVolumeProjectedSourcesDownwardApiItemsFieldRef | undefined;
    private _resourceFieldRef;
    get resourceFieldRef(): PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRefOutputReference;
    putResourceFieldRef(value: PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef): void;
    resetResourceFieldRef(): void;
    get resourceFieldRefInput(): PodSpecVolumeProjectedSourcesDownwardApiItemsResourceFieldRef | undefined;
}
export declare class PodSpecVolumeProjectedSourcesDownwardApiItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeProjectedSourcesDownwardApiItemsOutputReference;
}
export interface PodSpecVolumeProjectedSourcesDownwardApi {
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#items Pod#items}
    */
    readonly items?: PodSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable;
}
export declare function podSpecVolumeProjectedSourcesDownwardApiToTerraform(struct?: PodSpecVolumeProjectedSourcesDownwardApiOutputReference | PodSpecVolumeProjectedSourcesDownwardApi): any;
export declare class PodSpecVolumeProjectedSourcesDownwardApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeProjectedSourcesDownwardApi | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesDownwardApi | undefined);
    private _items;
    get items(): PodSpecVolumeProjectedSourcesDownwardApiItemsList;
    putItems(value: PodSpecVolumeProjectedSourcesDownwardApiItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodSpecVolumeProjectedSourcesDownwardApiItems[] | undefined;
}
export interface PodSpecVolumeProjectedSourcesSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#key Pod#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#mode Pod#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path?: string;
}
export declare function podSpecVolumeProjectedSourcesSecretItemsToTerraform(struct?: PodSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable): any;
export declare class PodSpecVolumeProjectedSourcesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodSpecVolumeProjectedSourcesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeProjectedSourcesSecretItemsOutputReference;
}
export interface PodSpecVolumeProjectedSourcesSecret {
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
    /**
    * Optional: Specify whether the Secret or it's keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#optional Pod#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#items Pod#items}
    */
    readonly items?: PodSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable;
}
export declare function podSpecVolumeProjectedSourcesSecretToTerraform(struct?: PodSpecVolumeProjectedSourcesSecret | cdktf.IResolvable): any;
export declare class PodSpecVolumeProjectedSourcesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _items;
    get items(): PodSpecVolumeProjectedSourcesSecretItemsList;
    putItems(value: PodSpecVolumeProjectedSourcesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodSpecVolumeProjectedSourcesSecretItems[] | undefined;
}
export declare class PodSpecVolumeProjectedSourcesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeProjectedSourcesSecretOutputReference;
}
export interface PodSpecVolumeProjectedSourcesServiceAccountToken {
    /**
    * Audience is the intended audience of the token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#audience Pod#audience}
    */
    readonly audience?: string;
    /**
    * ExpirationSeconds is the expected duration of validity of the service account token. It defaults to 1 hour and must be at least 10 minutes (600 seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#expiration_seconds Pod#expiration_seconds}
    */
    readonly expirationSeconds?: number;
    /**
    * Path specifies a relative path to the mount point of the projected volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path: string;
}
export declare function podSpecVolumeProjectedSourcesServiceAccountTokenToTerraform(struct?: PodSpecVolumeProjectedSourcesServiceAccountTokenOutputReference | PodSpecVolumeProjectedSourcesServiceAccountToken): any;
export declare class PodSpecVolumeProjectedSourcesServiceAccountTokenOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeProjectedSourcesServiceAccountToken | undefined;
    set internalValue(value: PodSpecVolumeProjectedSourcesServiceAccountToken | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _expirationSeconds?;
    get expirationSeconds(): number;
    set expirationSeconds(value: number);
    resetExpirationSeconds(): void;
    get expirationSecondsInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface PodSpecVolumeProjectedSources {
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#config_map Pod#config_map}
    */
    readonly configMap?: PodSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#downward_api Pod#downward_api}
    */
    readonly downwardApi?: PodSpecVolumeProjectedSourcesDownwardApi;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret Pod#secret}
    */
    readonly secret?: PodSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable;
    /**
    * service_account_token block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#service_account_token Pod#service_account_token}
    */
    readonly serviceAccountToken?: PodSpecVolumeProjectedSourcesServiceAccountToken;
}
export declare function podSpecVolumeProjectedSourcesToTerraform(struct?: PodSpecVolumeProjectedSources | cdktf.IResolvable): any;
export declare class PodSpecVolumeProjectedSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeProjectedSources | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeProjectedSources | cdktf.IResolvable | undefined);
    private _configMap;
    get configMap(): PodSpecVolumeProjectedSourcesConfigMapList;
    putConfigMap(value: PodSpecVolumeProjectedSourcesConfigMap[] | cdktf.IResolvable): void;
    resetConfigMap(): void;
    get configMapInput(): cdktf.IResolvable | PodSpecVolumeProjectedSourcesConfigMap[] | undefined;
    private _downwardApi;
    get downwardApi(): PodSpecVolumeProjectedSourcesDownwardApiOutputReference;
    putDownwardApi(value: PodSpecVolumeProjectedSourcesDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): PodSpecVolumeProjectedSourcesDownwardApi | undefined;
    private _secret;
    get secret(): PodSpecVolumeProjectedSourcesSecretList;
    putSecret(value: PodSpecVolumeProjectedSourcesSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | PodSpecVolumeProjectedSourcesSecret[] | undefined;
    private _serviceAccountToken;
    get serviceAccountToken(): PodSpecVolumeProjectedSourcesServiceAccountTokenOutputReference;
    putServiceAccountToken(value: PodSpecVolumeProjectedSourcesServiceAccountToken): void;
    resetServiceAccountToken(): void;
    get serviceAccountTokenInput(): PodSpecVolumeProjectedSourcesServiceAccountToken | undefined;
}
export declare class PodSpecVolumeProjectedSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeProjectedSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeProjectedSourcesOutputReference;
}
export interface PodSpecVolumeProjected {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#default_mode Pod#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#sources Pod#sources}
    */
    readonly sources: PodSpecVolumeProjectedSources[] | cdktf.IResolvable;
}
export declare function podSpecVolumeProjectedToTerraform(struct?: PodSpecVolumeProjected | cdktf.IResolvable): any;
export declare class PodSpecVolumeProjectedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeProjected | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeProjected | cdktf.IResolvable | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _sources;
    get sources(): PodSpecVolumeProjectedSourcesList;
    putSources(value: PodSpecVolumeProjectedSources[] | cdktf.IResolvable): void;
    get sourcesInput(): cdktf.IResolvable | PodSpecVolumeProjectedSources[] | undefined;
}
export declare class PodSpecVolumeProjectedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeProjectedOutputReference;
}
export interface PodSpecVolumeQuobyte {
    /**
    * Group to map volume access to Default is no group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#group Pod#group}
    */
    readonly group?: string;
    /**
    * Whether to force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#registry Pod#registry}
    */
    readonly registry: string;
    /**
    * User to map volume access to Defaults to serivceaccount user
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#user Pod#user}
    */
    readonly user?: string;
    /**
    * Volume is a string that references an already created Quobyte volume by name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#volume Pod#volume}
    */
    readonly volume: string;
}
export declare function podSpecVolumeQuobyteToTerraform(struct?: PodSpecVolumeQuobyteOutputReference | PodSpecVolumeQuobyte): any;
export declare class PodSpecVolumeQuobyteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeQuobyte | undefined;
    set internalValue(value: PodSpecVolumeQuobyte | undefined);
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _volume?;
    get volume(): string;
    set volume(value: string);
    get volumeInput(): string | undefined;
}
export interface PodSpecVolumeRbdSecretRef {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#namespace Pod#namespace}
    */
    readonly namespace?: string;
}
export declare function podSpecVolumeRbdSecretRefToTerraform(struct?: PodSpecVolumeRbdSecretRefOutputReference | PodSpecVolumeRbdSecretRef): any;
export declare class PodSpecVolumeRbdSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeRbdSecretRef | undefined;
    set internalValue(value: PodSpecVolumeRbdSecretRef | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export interface PodSpecVolumeRbd {
    /**
    * A collection of Ceph monitors. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#ceph_monitors Pod#ceph_monitors}
    */
    readonly cephMonitors: string[];
    /**
    * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#rbd
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#keyring Pod#keyring}
    */
    readonly keyring?: string;
    /**
    * The rados user name. Default is admin. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#rados_user Pod#rados_user}
    */
    readonly radosUser?: string;
    /**
    * The rados image name. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#rbd_image Pod#rbd_image}
    */
    readonly rbdImage: string;
    /**
    * The rados pool name. Default is rbd. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#rbd_pool Pod#rbd_pool}
    */
    readonly rbdPool?: string;
    /**
    * Whether to force the read-only setting in VolumeMounts. Defaults to false. More info: http://releases.k8s.io/HEAD/examples/volumes/rbd/README.md#how-to-use-it
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#read_only Pod#read_only}
    */
    readonly readOnly?: boolean | cdktf.IResolvable;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret_ref Pod#secret_ref}
    */
    readonly secretRef?: PodSpecVolumeRbdSecretRef;
}
export declare function podSpecVolumeRbdToTerraform(struct?: PodSpecVolumeRbdOutputReference | PodSpecVolumeRbd): any;
export declare class PodSpecVolumeRbdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeRbd | undefined;
    set internalValue(value: PodSpecVolumeRbd | undefined);
    private _cephMonitors?;
    get cephMonitors(): string[];
    set cephMonitors(value: string[]);
    get cephMonitorsInput(): string[] | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _keyring?;
    get keyring(): string;
    set keyring(value: string);
    resetKeyring(): void;
    get keyringInput(): string | undefined;
    private _radosUser?;
    get radosUser(): string;
    set radosUser(value: string);
    resetRadosUser(): void;
    get radosUserInput(): string | undefined;
    private _rbdImage?;
    get rbdImage(): string;
    set rbdImage(value: string);
    get rbdImageInput(): string | undefined;
    private _rbdPool?;
    get rbdPool(): string;
    set rbdPool(value: string);
    resetRbdPool(): void;
    get rbdPoolInput(): string | undefined;
    private _readOnly?;
    get readOnly(): boolean | cdktf.IResolvable;
    set readOnly(value: boolean | cdktf.IResolvable);
    resetReadOnly(): void;
    get readOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _secretRef;
    get secretRef(): PodSpecVolumeRbdSecretRefOutputReference;
    putSecretRef(value: PodSpecVolumeRbdSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): PodSpecVolumeRbdSecretRef | undefined;
}
export interface PodSpecVolumeSecretItems {
    /**
    * The key to project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#key Pod#key}
    */
    readonly key?: string;
    /**
    * Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#mode Pod#mode}
    */
    readonly mode?: string;
    /**
    * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#path Pod#path}
    */
    readonly path?: string;
}
export declare function podSpecVolumeSecretItemsToTerraform(struct?: PodSpecVolumeSecretItems | cdktf.IResolvable): any;
export declare class PodSpecVolumeSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolumeSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolumeSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class PodSpecVolumeSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolumeSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeSecretItemsOutputReference;
}
export interface PodSpecVolumeSecret {
    /**
    * Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#default_mode Pod#default_mode}
    */
    readonly defaultMode?: string;
    /**
    * Optional: Specify whether the Secret or its keys must be defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#optional Pod#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * Name of the secret in the pod's namespace to use. More info: http://kubernetes.io/docs/user-guide/volumes#secrets
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret_name Pod#secret_name}
    */
    readonly secretName?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#items Pod#items}
    */
    readonly items?: PodSpecVolumeSecretItems[] | cdktf.IResolvable;
}
export declare function podSpecVolumeSecretToTerraform(struct?: PodSpecVolumeSecretOutputReference | PodSpecVolumeSecret): any;
export declare class PodSpecVolumeSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeSecret | undefined;
    set internalValue(value: PodSpecVolumeSecret | undefined);
    private _defaultMode?;
    get defaultMode(): string;
    set defaultMode(value: string);
    resetDefaultMode(): void;
    get defaultModeInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _items;
    get items(): PodSpecVolumeSecretItemsList;
    putItems(value: PodSpecVolumeSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | PodSpecVolumeSecretItems[] | undefined;
}
export interface PodSpecVolumeVsphereVolume {
    /**
    * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fs_type Pod#fs_type}
    */
    readonly fsType?: string;
    /**
    * Path that identifies vSphere volume vmdk
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#volume_path Pod#volume_path}
    */
    readonly volumePath: string;
}
export declare function podSpecVolumeVsphereVolumeToTerraform(struct?: PodSpecVolumeVsphereVolumeOutputReference | PodSpecVolumeVsphereVolume): any;
export declare class PodSpecVolumeVsphereVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpecVolumeVsphereVolume | undefined;
    set internalValue(value: PodSpecVolumeVsphereVolume | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
}
export interface PodSpecVolume {
    /**
    * Volume's name. Must be a DNS_LABEL and unique within the pod. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#name Pod#name}
    */
    readonly name?: string;
    /**
    * aws_elastic_block_store block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#aws_elastic_block_store Pod#aws_elastic_block_store}
    */
    readonly awsElasticBlockStore?: PodSpecVolumeAwsElasticBlockStore;
    /**
    * azure_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#azure_disk Pod#azure_disk}
    */
    readonly azureDisk?: PodSpecVolumeAzureDisk;
    /**
    * azure_file block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#azure_file Pod#azure_file}
    */
    readonly azureFile?: PodSpecVolumeAzureFile;
    /**
    * ceph_fs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#ceph_fs Pod#ceph_fs}
    */
    readonly cephFs?: PodSpecVolumeCephFs;
    /**
    * cinder block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#cinder Pod#cinder}
    */
    readonly cinder?: PodSpecVolumeCinder;
    /**
    * config_map block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#config_map Pod#config_map}
    */
    readonly configMap?: PodSpecVolumeConfigMap;
    /**
    * csi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#csi Pod#csi}
    */
    readonly csi?: PodSpecVolumeCsi;
    /**
    * downward_api block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#downward_api Pod#downward_api}
    */
    readonly downwardApi?: PodSpecVolumeDownwardApi;
    /**
    * empty_dir block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#empty_dir Pod#empty_dir}
    */
    readonly emptyDir?: PodSpecVolumeEmptyDir;
    /**
    * fc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#fc Pod#fc}
    */
    readonly fc?: PodSpecVolumeFc;
    /**
    * flex_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#flex_volume Pod#flex_volume}
    */
    readonly flexVolume?: PodSpecVolumeFlexVolume;
    /**
    * flocker block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#flocker Pod#flocker}
    */
    readonly flocker?: PodSpecVolumeFlocker;
    /**
    * gce_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#gce_persistent_disk Pod#gce_persistent_disk}
    */
    readonly gcePersistentDisk?: PodSpecVolumeGcePersistentDisk;
    /**
    * git_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#git_repo Pod#git_repo}
    */
    readonly gitRepo?: PodSpecVolumeGitRepo;
    /**
    * glusterfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#glusterfs Pod#glusterfs}
    */
    readonly glusterfs?: PodSpecVolumeGlusterfs;
    /**
    * host_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#host_path Pod#host_path}
    */
    readonly hostPath?: PodSpecVolumeHostPath;
    /**
    * iscsi block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#iscsi Pod#iscsi}
    */
    readonly iscsi?: PodSpecVolumeIscsi;
    /**
    * local block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#local Pod#local}
    */
    readonly local?: PodSpecVolumeLocal;
    /**
    * nfs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#nfs Pod#nfs}
    */
    readonly nfs?: PodSpecVolumeNfs;
    /**
    * persistent_volume_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#persistent_volume_claim Pod#persistent_volume_claim}
    */
    readonly persistentVolumeClaim?: PodSpecVolumePersistentVolumeClaim;
    /**
    * photon_persistent_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#photon_persistent_disk Pod#photon_persistent_disk}
    */
    readonly photonPersistentDisk?: PodSpecVolumePhotonPersistentDisk;
    /**
    * projected block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#projected Pod#projected}
    */
    readonly projected?: PodSpecVolumeProjected[] | cdktf.IResolvable;
    /**
    * quobyte block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#quobyte Pod#quobyte}
    */
    readonly quobyte?: PodSpecVolumeQuobyte;
    /**
    * rbd block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#rbd Pod#rbd}
    */
    readonly rbd?: PodSpecVolumeRbd;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#secret Pod#secret}
    */
    readonly secret?: PodSpecVolumeSecret;
    /**
    * vsphere_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#vsphere_volume Pod#vsphere_volume}
    */
    readonly vsphereVolume?: PodSpecVolumeVsphereVolume;
}
export declare function podSpecVolumeToTerraform(struct?: PodSpecVolume | cdktf.IResolvable): any;
export declare class PodSpecVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PodSpecVolume | cdktf.IResolvable | undefined;
    set internalValue(value: PodSpecVolume | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _awsElasticBlockStore;
    get awsElasticBlockStore(): PodSpecVolumeAwsElasticBlockStoreOutputReference;
    putAwsElasticBlockStore(value: PodSpecVolumeAwsElasticBlockStore): void;
    resetAwsElasticBlockStore(): void;
    get awsElasticBlockStoreInput(): PodSpecVolumeAwsElasticBlockStore | undefined;
    private _azureDisk;
    get azureDisk(): PodSpecVolumeAzureDiskOutputReference;
    putAzureDisk(value: PodSpecVolumeAzureDisk): void;
    resetAzureDisk(): void;
    get azureDiskInput(): PodSpecVolumeAzureDisk | undefined;
    private _azureFile;
    get azureFile(): PodSpecVolumeAzureFileOutputReference;
    putAzureFile(value: PodSpecVolumeAzureFile): void;
    resetAzureFile(): void;
    get azureFileInput(): PodSpecVolumeAzureFile | undefined;
    private _cephFs;
    get cephFs(): PodSpecVolumeCephFsOutputReference;
    putCephFs(value: PodSpecVolumeCephFs): void;
    resetCephFs(): void;
    get cephFsInput(): PodSpecVolumeCephFs | undefined;
    private _cinder;
    get cinder(): PodSpecVolumeCinderOutputReference;
    putCinder(value: PodSpecVolumeCinder): void;
    resetCinder(): void;
    get cinderInput(): PodSpecVolumeCinder | undefined;
    private _configMap;
    get configMap(): PodSpecVolumeConfigMapOutputReference;
    putConfigMap(value: PodSpecVolumeConfigMap): void;
    resetConfigMap(): void;
    get configMapInput(): PodSpecVolumeConfigMap | undefined;
    private _csi;
    get csi(): PodSpecVolumeCsiOutputReference;
    putCsi(value: PodSpecVolumeCsi): void;
    resetCsi(): void;
    get csiInput(): PodSpecVolumeCsi | undefined;
    private _downwardApi;
    get downwardApi(): PodSpecVolumeDownwardApiOutputReference;
    putDownwardApi(value: PodSpecVolumeDownwardApi): void;
    resetDownwardApi(): void;
    get downwardApiInput(): PodSpecVolumeDownwardApi | undefined;
    private _emptyDir;
    get emptyDir(): PodSpecVolumeEmptyDirOutputReference;
    putEmptyDir(value: PodSpecVolumeEmptyDir): void;
    resetEmptyDir(): void;
    get emptyDirInput(): PodSpecVolumeEmptyDir | undefined;
    private _fc;
    get fc(): PodSpecVolumeFcOutputReference;
    putFc(value: PodSpecVolumeFc): void;
    resetFc(): void;
    get fcInput(): PodSpecVolumeFc | undefined;
    private _flexVolume;
    get flexVolume(): PodSpecVolumeFlexVolumeOutputReference;
    putFlexVolume(value: PodSpecVolumeFlexVolume): void;
    resetFlexVolume(): void;
    get flexVolumeInput(): PodSpecVolumeFlexVolume | undefined;
    private _flocker;
    get flocker(): PodSpecVolumeFlockerOutputReference;
    putFlocker(value: PodSpecVolumeFlocker): void;
    resetFlocker(): void;
    get flockerInput(): PodSpecVolumeFlocker | undefined;
    private _gcePersistentDisk;
    get gcePersistentDisk(): PodSpecVolumeGcePersistentDiskOutputReference;
    putGcePersistentDisk(value: PodSpecVolumeGcePersistentDisk): void;
    resetGcePersistentDisk(): void;
    get gcePersistentDiskInput(): PodSpecVolumeGcePersistentDisk | undefined;
    private _gitRepo;
    get gitRepo(): PodSpecVolumeGitRepoOutputReference;
    putGitRepo(value: PodSpecVolumeGitRepo): void;
    resetGitRepo(): void;
    get gitRepoInput(): PodSpecVolumeGitRepo | undefined;
    private _glusterfs;
    get glusterfs(): PodSpecVolumeGlusterfsOutputReference;
    putGlusterfs(value: PodSpecVolumeGlusterfs): void;
    resetGlusterfs(): void;
    get glusterfsInput(): PodSpecVolumeGlusterfs | undefined;
    private _hostPath;
    get hostPath(): PodSpecVolumeHostPathOutputReference;
    putHostPath(value: PodSpecVolumeHostPath): void;
    resetHostPath(): void;
    get hostPathInput(): PodSpecVolumeHostPath | undefined;
    private _iscsi;
    get iscsi(): PodSpecVolumeIscsiOutputReference;
    putIscsi(value: PodSpecVolumeIscsi): void;
    resetIscsi(): void;
    get iscsiInput(): PodSpecVolumeIscsi | undefined;
    private _local;
    get local(): PodSpecVolumeLocalOutputReference;
    putLocal(value: PodSpecVolumeLocal): void;
    resetLocal(): void;
    get localInput(): PodSpecVolumeLocal | undefined;
    private _nfs;
    get nfs(): PodSpecVolumeNfsOutputReference;
    putNfs(value: PodSpecVolumeNfs): void;
    resetNfs(): void;
    get nfsInput(): PodSpecVolumeNfs | undefined;
    private _persistentVolumeClaim;
    get persistentVolumeClaim(): PodSpecVolumePersistentVolumeClaimOutputReference;
    putPersistentVolumeClaim(value: PodSpecVolumePersistentVolumeClaim): void;
    resetPersistentVolumeClaim(): void;
    get persistentVolumeClaimInput(): PodSpecVolumePersistentVolumeClaim | undefined;
    private _photonPersistentDisk;
    get photonPersistentDisk(): PodSpecVolumePhotonPersistentDiskOutputReference;
    putPhotonPersistentDisk(value: PodSpecVolumePhotonPersistentDisk): void;
    resetPhotonPersistentDisk(): void;
    get photonPersistentDiskInput(): PodSpecVolumePhotonPersistentDisk | undefined;
    private _projected;
    get projected(): PodSpecVolumeProjectedList;
    putProjected(value: PodSpecVolumeProjected[] | cdktf.IResolvable): void;
    resetProjected(): void;
    get projectedInput(): cdktf.IResolvable | PodSpecVolumeProjected[] | undefined;
    private _quobyte;
    get quobyte(): PodSpecVolumeQuobyteOutputReference;
    putQuobyte(value: PodSpecVolumeQuobyte): void;
    resetQuobyte(): void;
    get quobyteInput(): PodSpecVolumeQuobyte | undefined;
    private _rbd;
    get rbd(): PodSpecVolumeRbdOutputReference;
    putRbd(value: PodSpecVolumeRbd): void;
    resetRbd(): void;
    get rbdInput(): PodSpecVolumeRbd | undefined;
    private _secret;
    get secret(): PodSpecVolumeSecretOutputReference;
    putSecret(value: PodSpecVolumeSecret): void;
    resetSecret(): void;
    get secretInput(): PodSpecVolumeSecret | undefined;
    private _vsphereVolume;
    get vsphereVolume(): PodSpecVolumeVsphereVolumeOutputReference;
    putVsphereVolume(value: PodSpecVolumeVsphereVolume): void;
    resetVsphereVolume(): void;
    get vsphereVolumeInput(): PodSpecVolumeVsphereVolume | undefined;
}
export declare class PodSpecVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PodSpecVolume[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PodSpecVolumeOutputReference;
}
export interface PodSpec {
    /**
    * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#active_deadline_seconds Pod#active_deadline_seconds}
    */
    readonly activeDeadlineSeconds?: number;
    /**
    * AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#automount_service_account_token Pod#automount_service_account_token}
    */
    readonly automountServiceAccountToken?: boolean | cdktf.IResolvable;
    /**
    * Set DNS policy for containers within the pod. Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'. Optional: Defaults to 'ClusterFirst', see [Kubernetes reference](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#dns_policy Pod#dns_policy}
    */
    readonly dnsPolicy?: string;
    /**
    * Enables generating environment variables for service discovery. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#enable_service_links Pod#enable_service_links}
    */
    readonly enableServiceLinks?: boolean | cdktf.IResolvable;
    /**
    * Use the host's ipc namespace. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#host_ipc Pod#host_ipc}
    */
    readonly hostIpc?: boolean | cdktf.IResolvable;
    /**
    * Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#host_network Pod#host_network}
    */
    readonly hostNetwork?: boolean | cdktf.IResolvable;
    /**
    * Use the host's pid namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#host_pid Pod#host_pid}
    */
    readonly hostPid?: boolean | cdktf.IResolvable;
    /**
    * Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#hostname Pod#hostname}
    */
    readonly hostname?: string;
    /**
    * NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#node_name Pod#node_name}
    */
    readonly nodeName?: string;
    /**
    * NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: http://kubernetes.io/docs/user-guide/node-selection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#node_selector Pod#node_selector}
    */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
    * If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#priority_class_name Pod#priority_class_name}
    */
    readonly priorityClassName?: string;
    /**
    * Restart policy for all containers within the pod. One of Always, OnFailure, Never. More info: http://kubernetes.io/docs/user-guide/pod-states#restartpolicy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#restart_policy Pod#restart_policy}
    */
    readonly restartPolicy?: string;
    /**
    * ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: http://releases.k8s.io/HEAD/docs/design/service_accounts.md.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#service_account_name Pod#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#share_process_namespace Pod#share_process_namespace}
    */
    readonly shareProcessNamespace?: boolean | cdktf.IResolvable;
    /**
    * If specified, the fully qualified Pod hostname will be "...svc.". If not specified, the pod will not have a domainname at all..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#subdomain Pod#subdomain}
    */
    readonly subdomain?: string;
    /**
    * Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#termination_grace_period_seconds Pod#termination_grace_period_seconds}
    */
    readonly terminationGracePeriodSeconds?: number;
    /**
    * affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#affinity Pod#affinity}
    */
    readonly affinity?: PodSpecAffinity;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#container Pod#container}
    */
    readonly container?: PodSpecContainer[] | cdktf.IResolvable;
    /**
    * dns_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#dns_config Pod#dns_config}
    */
    readonly dnsConfig?: PodSpecDnsConfig;
    /**
    * host_aliases block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#host_aliases Pod#host_aliases}
    */
    readonly hostAliases?: PodSpecHostAliases[] | cdktf.IResolvable;
    /**
    * image_pull_secrets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#image_pull_secrets Pod#image_pull_secrets}
    */
    readonly imagePullSecrets?: PodSpecImagePullSecrets[] | cdktf.IResolvable;
    /**
    * init_container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#init_container Pod#init_container}
    */
    readonly initContainer?: PodSpecInitContainer[] | cdktf.IResolvable;
    /**
    * readiness_gate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#readiness_gate Pod#readiness_gate}
    */
    readonly readinessGate?: PodSpecReadinessGate[] | cdktf.IResolvable;
    /**
    * security_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#security_context Pod#security_context}
    */
    readonly securityContext?: PodSpecSecurityContext;
    /**
    * toleration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#toleration Pod#toleration}
    */
    readonly toleration?: PodSpecToleration[] | cdktf.IResolvable;
    /**
    * topology_spread_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#topology_spread_constraint Pod#topology_spread_constraint}
    */
    readonly topologySpreadConstraint?: PodSpecTopologySpreadConstraint[] | cdktf.IResolvable;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#volume Pod#volume}
    */
    readonly volume?: PodSpecVolume[] | cdktf.IResolvable;
}
export declare function podSpecToTerraform(struct?: PodSpecOutputReference | PodSpec): any;
export declare class PodSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodSpec | undefined;
    set internalValue(value: PodSpec | undefined);
    private _activeDeadlineSeconds?;
    get activeDeadlineSeconds(): number;
    set activeDeadlineSeconds(value: number);
    resetActiveDeadlineSeconds(): void;
    get activeDeadlineSecondsInput(): number | undefined;
    private _automountServiceAccountToken?;
    get automountServiceAccountToken(): boolean | cdktf.IResolvable;
    set automountServiceAccountToken(value: boolean | cdktf.IResolvable);
    resetAutomountServiceAccountToken(): void;
    get automountServiceAccountTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsPolicy?;
    get dnsPolicy(): string;
    set dnsPolicy(value: string);
    resetDnsPolicy(): void;
    get dnsPolicyInput(): string | undefined;
    private _enableServiceLinks?;
    get enableServiceLinks(): boolean | cdktf.IResolvable;
    set enableServiceLinks(value: boolean | cdktf.IResolvable);
    resetEnableServiceLinks(): void;
    get enableServiceLinksInput(): boolean | cdktf.IResolvable | undefined;
    private _hostIpc?;
    get hostIpc(): boolean | cdktf.IResolvable;
    set hostIpc(value: boolean | cdktf.IResolvable);
    resetHostIpc(): void;
    get hostIpcInput(): boolean | cdktf.IResolvable | undefined;
    private _hostNetwork?;
    get hostNetwork(): boolean | cdktf.IResolvable;
    set hostNetwork(value: boolean | cdktf.IResolvable);
    resetHostNetwork(): void;
    get hostNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _hostPid?;
    get hostPid(): boolean | cdktf.IResolvable;
    set hostPid(value: boolean | cdktf.IResolvable);
    resetHostPid(): void;
    get hostPidInput(): boolean | cdktf.IResolvable | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _nodeName?;
    get nodeName(): string;
    set nodeName(value: string);
    resetNodeName(): void;
    get nodeNameInput(): string | undefined;
    private _nodeSelector?;
    get nodeSelector(): {
        [key: string]: string;
    };
    set nodeSelector(value: {
        [key: string]: string;
    });
    resetNodeSelector(): void;
    get nodeSelectorInput(): {
        [key: string]: string;
    } | undefined;
    private _priorityClassName?;
    get priorityClassName(): string;
    set priorityClassName(value: string);
    resetPriorityClassName(): void;
    get priorityClassNameInput(): string | undefined;
    private _restartPolicy?;
    get restartPolicy(): string;
    set restartPolicy(value: string);
    resetRestartPolicy(): void;
    get restartPolicyInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    private _shareProcessNamespace?;
    get shareProcessNamespace(): boolean | cdktf.IResolvable;
    set shareProcessNamespace(value: boolean | cdktf.IResolvable);
    resetShareProcessNamespace(): void;
    get shareProcessNamespaceInput(): boolean | cdktf.IResolvable | undefined;
    private _subdomain?;
    get subdomain(): string;
    set subdomain(value: string);
    resetSubdomain(): void;
    get subdomainInput(): string | undefined;
    private _terminationGracePeriodSeconds?;
    get terminationGracePeriodSeconds(): number;
    set terminationGracePeriodSeconds(value: number);
    resetTerminationGracePeriodSeconds(): void;
    get terminationGracePeriodSecondsInput(): number | undefined;
    private _affinity;
    get affinity(): PodSpecAffinityOutputReference;
    putAffinity(value: PodSpecAffinity): void;
    resetAffinity(): void;
    get affinityInput(): PodSpecAffinity | undefined;
    private _container;
    get container(): PodSpecContainerList;
    putContainer(value: PodSpecContainer[] | cdktf.IResolvable): void;
    resetContainer(): void;
    get containerInput(): cdktf.IResolvable | PodSpecContainer[] | undefined;
    private _dnsConfig;
    get dnsConfig(): PodSpecDnsConfigOutputReference;
    putDnsConfig(value: PodSpecDnsConfig): void;
    resetDnsConfig(): void;
    get dnsConfigInput(): PodSpecDnsConfig | undefined;
    private _hostAliases;
    get hostAliases(): PodSpecHostAliasesList;
    putHostAliases(value: PodSpecHostAliases[] | cdktf.IResolvable): void;
    resetHostAliases(): void;
    get hostAliasesInput(): cdktf.IResolvable | PodSpecHostAliases[] | undefined;
    private _imagePullSecrets;
    get imagePullSecrets(): PodSpecImagePullSecretsList;
    putImagePullSecrets(value: PodSpecImagePullSecrets[] | cdktf.IResolvable): void;
    resetImagePullSecrets(): void;
    get imagePullSecretsInput(): cdktf.IResolvable | PodSpecImagePullSecrets[] | undefined;
    private _initContainer;
    get initContainer(): PodSpecInitContainerList;
    putInitContainer(value: PodSpecInitContainer[] | cdktf.IResolvable): void;
    resetInitContainer(): void;
    get initContainerInput(): cdktf.IResolvable | PodSpecInitContainer[] | undefined;
    private _readinessGate;
    get readinessGate(): PodSpecReadinessGateList;
    putReadinessGate(value: PodSpecReadinessGate[] | cdktf.IResolvable): void;
    resetReadinessGate(): void;
    get readinessGateInput(): cdktf.IResolvable | PodSpecReadinessGate[] | undefined;
    private _securityContext;
    get securityContext(): PodSpecSecurityContextOutputReference;
    putSecurityContext(value: PodSpecSecurityContext): void;
    resetSecurityContext(): void;
    get securityContextInput(): PodSpecSecurityContext | undefined;
    private _toleration;
    get toleration(): PodSpecTolerationList;
    putToleration(value: PodSpecToleration[] | cdktf.IResolvable): void;
    resetToleration(): void;
    get tolerationInput(): cdktf.IResolvable | PodSpecToleration[] | undefined;
    private _topologySpreadConstraint;
    get topologySpreadConstraint(): PodSpecTopologySpreadConstraintList;
    putTopologySpreadConstraint(value: PodSpecTopologySpreadConstraint[] | cdktf.IResolvable): void;
    resetTopologySpreadConstraint(): void;
    get topologySpreadConstraintInput(): cdktf.IResolvable | PodSpecTopologySpreadConstraint[] | undefined;
    private _volume;
    get volume(): PodSpecVolumeList;
    putVolume(value: PodSpecVolume[] | cdktf.IResolvable): void;
    resetVolume(): void;
    get volumeInput(): cdktf.IResolvable | PodSpecVolume[] | undefined;
}
export interface PodTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#create Pod#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/pod#delete Pod#delete}
    */
    readonly delete?: string;
}
export declare function podTimeoutsToTerraform(struct?: PodTimeoutsOutputReference | PodTimeouts | cdktf.IResolvable): any;
export declare class PodTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PodTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PodTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
