import { JobMetadata, JobMetadataOutputReference, JobSpec, JobSpecOutputReference, JobTimeouts, JobTimeoutsOutputReference } from './job-structs';
export * from './job-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface JobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#id Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#wait_for_completion Job#wait_for_completion}
    */
    readonly waitForCompletion?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#metadata Job#metadata}
    */
    readonly metadata: JobMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#spec Job#spec}
    */
    readonly spec: JobSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/job#timeouts Job#timeouts}
    */
    readonly timeouts?: JobTimeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/job kubernetes_job}
*/
export declare class Job extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/job kubernetes_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JobConfig
    */
    constructor(scope: Construct, id: string, config: JobConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForCompletion?;
    get waitForCompletion(): boolean | cdktf.IResolvable;
    set waitForCompletion(value: boolean | cdktf.IResolvable);
    resetWaitForCompletion(): void;
    get waitForCompletionInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): JobMetadataOutputReference;
    putMetadata(value: JobMetadata): void;
    get metadataInput(): JobMetadata | undefined;
    private _spec;
    get spec(): JobSpecOutputReference;
    putSpec(value: JobSpec): void;
    get specInput(): JobSpec | undefined;
    private _timeouts;
    get timeouts(): JobTimeoutsOutputReference;
    putTimeouts(value: JobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | JobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
