import { DeploymentMetadata, DeploymentMetadataOutputReference, DeploymentSpec, DeploymentSpecOutputReference, DeploymentTimeouts, DeploymentTimeoutsOutputReference } from './deployment-structs';
export * from './deployment-structs';
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment#id Deployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Wait for the rollout of the deployment to complete. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment#wait_for_rollout Deployment#wait_for_rollout}
    */
    readonly waitForRollout?: boolean | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment#metadata Deployment#metadata}
    */
    readonly metadata: DeploymentMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment#spec Deployment#spec}
    */
    readonly spec: DeploymentSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment#timeouts Deployment#timeouts}
    */
    readonly timeouts?: DeploymentTimeouts;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment kubernetes_deployment}
*/
export declare class Deployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/deployment kubernetes_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DeploymentConfig
    */
    constructor(scope: Construct, id: string, config: DeploymentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _waitForRollout?;
    get waitForRollout(): boolean | cdktf.IResolvable;
    set waitForRollout(value: boolean | cdktf.IResolvable);
    resetWaitForRollout(): void;
    get waitForRolloutInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata;
    get metadata(): DeploymentMetadataOutputReference;
    putMetadata(value: DeploymentMetadata): void;
    get metadataInput(): DeploymentMetadata | undefined;
    private _spec;
    get spec(): DeploymentSpecOutputReference;
    putSpec(value: DeploymentSpec): void;
    get specInput(): DeploymentSpec | undefined;
    private _timeouts;
    get timeouts(): DeploymentTimeoutsOutputReference;
    putTimeouts(value: DeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
