import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DefaultServiceAccountV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Enable automatic mounting of the service account token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#automount_service_account_token DefaultServiceAccountV1#automount_service_account_token}
    */
    readonly automountServiceAccountToken?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#id DefaultServiceAccountV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * image_pull_secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#image_pull_secret DefaultServiceAccountV1#image_pull_secret}
    */
    readonly imagePullSecret?: DefaultServiceAccountV1ImagePullSecret[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#metadata DefaultServiceAccountV1#metadata}
    */
    readonly metadata: DefaultServiceAccountV1Metadata;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#secret DefaultServiceAccountV1#secret}
    */
    readonly secret?: DefaultServiceAccountV1Secret[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#timeouts DefaultServiceAccountV1#timeouts}
    */
    readonly timeouts?: DefaultServiceAccountV1Timeouts;
}
export interface DefaultServiceAccountV1ImagePullSecret {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#name DefaultServiceAccountV1#name}
    */
    readonly name?: string;
}
export declare function defaultServiceAccountV1ImagePullSecretToTerraform(struct?: DefaultServiceAccountV1ImagePullSecret | cdktf.IResolvable): any;
export declare class DefaultServiceAccountV1ImagePullSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DefaultServiceAccountV1ImagePullSecret | cdktf.IResolvable | undefined;
    set internalValue(value: DefaultServiceAccountV1ImagePullSecret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class DefaultServiceAccountV1ImagePullSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DefaultServiceAccountV1ImagePullSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DefaultServiceAccountV1ImagePullSecretOutputReference;
}
export interface DefaultServiceAccountV1Metadata {
    /**
    * An unstructured key value map stored with the service account that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#annotations DefaultServiceAccountV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the service account. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#labels DefaultServiceAccountV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the service account, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#name DefaultServiceAccountV1#name}
    */
    readonly name?: string;
    /**
    * Namespace defines the space within which name of the service account must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#namespace DefaultServiceAccountV1#namespace}
    */
    readonly namespace?: string;
}
export declare function defaultServiceAccountV1MetadataToTerraform(struct?: DefaultServiceAccountV1MetadataOutputReference | DefaultServiceAccountV1Metadata): any;
export declare class DefaultServiceAccountV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DefaultServiceAccountV1Metadata | undefined;
    set internalValue(value: DefaultServiceAccountV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface DefaultServiceAccountV1Secret {
    /**
    * Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#name DefaultServiceAccountV1#name}
    */
    readonly name?: string;
}
export declare function defaultServiceAccountV1SecretToTerraform(struct?: DefaultServiceAccountV1Secret | cdktf.IResolvable): any;
export declare class DefaultServiceAccountV1SecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DefaultServiceAccountV1Secret | cdktf.IResolvable | undefined;
    set internalValue(value: DefaultServiceAccountV1Secret | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class DefaultServiceAccountV1SecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DefaultServiceAccountV1Secret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DefaultServiceAccountV1SecretOutputReference;
}
export interface DefaultServiceAccountV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1#create DefaultServiceAccountV1#create}
    */
    readonly create?: string;
}
export declare function defaultServiceAccountV1TimeoutsToTerraform(struct?: DefaultServiceAccountV1TimeoutsOutputReference | DefaultServiceAccountV1Timeouts | cdktf.IResolvable): any;
export declare class DefaultServiceAccountV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DefaultServiceAccountV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DefaultServiceAccountV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1 kubernetes_default_service_account_v1}
*/
export declare class DefaultServiceAccountV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_default_service_account_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/default_service_account_v1 kubernetes_default_service_account_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DefaultServiceAccountV1Config
    */
    constructor(scope: Construct, id: string, config: DefaultServiceAccountV1Config);
    private _automountServiceAccountToken?;
    get automountServiceAccountToken(): boolean | cdktf.IResolvable;
    set automountServiceAccountToken(value: boolean | cdktf.IResolvable);
    resetAutomountServiceAccountToken(): void;
    get automountServiceAccountTokenInput(): boolean | cdktf.IResolvable | undefined;
    get defaultSecretName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imagePullSecret;
    get imagePullSecret(): DefaultServiceAccountV1ImagePullSecretList;
    putImagePullSecret(value: DefaultServiceAccountV1ImagePullSecret[] | cdktf.IResolvable): void;
    resetImagePullSecret(): void;
    get imagePullSecretInput(): cdktf.IResolvable | DefaultServiceAccountV1ImagePullSecret[] | undefined;
    private _metadata;
    get metadata(): DefaultServiceAccountV1MetadataOutputReference;
    putMetadata(value: DefaultServiceAccountV1Metadata): void;
    get metadataInput(): DefaultServiceAccountV1Metadata | undefined;
    private _secret;
    get secret(): DefaultServiceAccountV1SecretList;
    putSecret(value: DefaultServiceAccountV1Secret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | DefaultServiceAccountV1Secret[] | undefined;
    private _timeouts;
    get timeouts(): DefaultServiceAccountV1TimeoutsOutputReference;
    putTimeouts(value: DefaultServiceAccountV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DefaultServiceAccountV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
