import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClusterRoleBindingV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#id ClusterRoleBindingV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#metadata ClusterRoleBindingV1#metadata}
    */
    readonly metadata: ClusterRoleBindingV1Metadata;
    /**
    * role_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#role_ref ClusterRoleBindingV1#role_ref}
    */
    readonly roleRef: ClusterRoleBindingV1RoleRef;
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#subject ClusterRoleBindingV1#subject}
    */
    readonly subject: ClusterRoleBindingV1Subject[] | cdktf.IResolvable;
}
export interface ClusterRoleBindingV1Metadata {
    /**
    * An unstructured key value map stored with the clusterRoleBinding that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#annotations ClusterRoleBindingV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the clusterRoleBinding. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#labels ClusterRoleBindingV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the clusterRoleBinding, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#name ClusterRoleBindingV1#name}
    */
    readonly name?: string;
}
export declare function clusterRoleBindingV1MetadataToTerraform(struct?: ClusterRoleBindingV1MetadataOutputReference | ClusterRoleBindingV1Metadata): any;
export declare class ClusterRoleBindingV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterRoleBindingV1Metadata | undefined;
    set internalValue(value: ClusterRoleBindingV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface ClusterRoleBindingV1RoleRef {
    /**
    * The API group of the user. The only value possible at the moment is `rbac.authorization.k8s.io`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#api_group ClusterRoleBindingV1#api_group}
    */
    readonly apiGroup: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#kind ClusterRoleBindingV1#kind}
    */
    readonly kind: string;
    /**
    * The name of the User to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#name ClusterRoleBindingV1#name}
    */
    readonly name: string;
}
export declare function clusterRoleBindingV1RoleRefToTerraform(struct?: ClusterRoleBindingV1RoleRefOutputReference | ClusterRoleBindingV1RoleRef): any;
export declare class ClusterRoleBindingV1RoleRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterRoleBindingV1RoleRef | undefined;
    set internalValue(value: ClusterRoleBindingV1RoleRef | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface ClusterRoleBindingV1Subject {
    /**
    * The API group of the subject resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#api_group ClusterRoleBindingV1#api_group}
    */
    readonly apiGroup?: string;
    /**
    * The kind of resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#kind ClusterRoleBindingV1#kind}
    */
    readonly kind: string;
    /**
    * The name of the resource to bind to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#name ClusterRoleBindingV1#name}
    */
    readonly name: string;
    /**
    * The Namespace of the subject resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1#namespace ClusterRoleBindingV1#namespace}
    */
    readonly namespace?: string;
}
export declare function clusterRoleBindingV1SubjectToTerraform(struct?: ClusterRoleBindingV1Subject | cdktf.IResolvable): any;
export declare class ClusterRoleBindingV1SubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ClusterRoleBindingV1Subject | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterRoleBindingV1Subject | cdktf.IResolvable | undefined);
    private _apiGroup?;
    get apiGroup(): string;
    set apiGroup(value: string);
    resetApiGroup(): void;
    get apiGroupInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
export declare class ClusterRoleBindingV1SubjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ClusterRoleBindingV1Subject[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ClusterRoleBindingV1SubjectOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1 kubernetes_cluster_role_binding_v1}
*/
export declare class ClusterRoleBindingV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_cluster_role_binding_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/cluster_role_binding_v1 kubernetes_cluster_role_binding_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClusterRoleBindingV1Config
    */
    constructor(scope: Construct, id: string, config: ClusterRoleBindingV1Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): ClusterRoleBindingV1MetadataOutputReference;
    putMetadata(value: ClusterRoleBindingV1Metadata): void;
    get metadataInput(): ClusterRoleBindingV1Metadata | undefined;
    private _roleRef;
    get roleRef(): ClusterRoleBindingV1RoleRefOutputReference;
    putRoleRef(value: ClusterRoleBindingV1RoleRef): void;
    get roleRefInput(): ClusterRoleBindingV1RoleRef | undefined;
    private _subject;
    get subject(): ClusterRoleBindingV1SubjectList;
    putSubject(value: ClusterRoleBindingV1Subject[] | cdktf.IResolvable): void;
    get subjectInput(): cdktf.IResolvable | ClusterRoleBindingV1Subject[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
