import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertificateSigningRequestV1Config extends cdktf.TerraformMetaArguments {
    /**
    * Automatically approve the CertificateSigningRequest
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#auto_approve CertificateSigningRequestV1#auto_approve}
    */
    readonly autoApprove?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#id CertificateSigningRequestV1#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#metadata CertificateSigningRequestV1#metadata}
    */
    readonly metadata: CertificateSigningRequestV1Metadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#spec CertificateSigningRequestV1#spec}
    */
    readonly spec: CertificateSigningRequestV1Spec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#timeouts CertificateSigningRequestV1#timeouts}
    */
    readonly timeouts?: CertificateSigningRequestV1Timeouts;
}
export interface CertificateSigningRequestV1Metadata {
    /**
    * An unstructured key value map stored with the certificate signing request that may be used to store arbitrary metadata. More info: http://kubernetes.io/docs/user-guide/annotations
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#annotations CertificateSigningRequestV1#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Prefix, used by the server, to generate a unique name ONLY IF the `name` field has not been provided. This value will also be combined with a unique suffix. Read more: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#idempotency
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#generate_name CertificateSigningRequestV1#generate_name}
    */
    readonly generateName?: string;
    /**
    * Map of string keys and values that can be used to organize and categorize (scope and select) the certificate signing request. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#labels CertificateSigningRequestV1#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the certificate signing request, must be unique. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#name CertificateSigningRequestV1#name}
    */
    readonly name?: string;
}
export declare function certificateSigningRequestV1MetadataToTerraform(struct?: CertificateSigningRequestV1MetadataOutputReference | CertificateSigningRequestV1Metadata): any;
export declare class CertificateSigningRequestV1MetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateSigningRequestV1Metadata | undefined;
    set internalValue(value: CertificateSigningRequestV1Metadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _generateName?;
    get generateName(): string;
    set generateName(value: string);
    resetGenerateName(): void;
    get generateNameInput(): string | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get resourceVersion(): string;
    get uid(): string;
}
export interface CertificateSigningRequestV1Spec {
    /**
    * request contains an x509 certificate signing request encoded in a "CERTIFICATE REQUEST" PEM block. When serialized as JSON or YAML, the data is additionally base64-encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#request CertificateSigningRequestV1#request}
    */
    readonly request: string;
    /**
    * signerName indicates the requested signer, and is a qualified name.
  
  List/watch requests for CertificateSigningRequests can filter on this field using a "spec.signerName=NAME" fieldSelector.
  
  Well-known Kubernetes signers are:
   1. "kubernetes.io/kube-apiserver-client": issues client certificates that can be used to authenticate to kube-apiserver.
    Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the "csrsigning" controller in kube-controller-manager.
   2. "kubernetes.io/kube-apiserver-client-kubelet": issues client certificates that kubelets use to authenticate to kube-apiserver.
    Requests for this signer can be auto-approved by the "csrapproving" controller in kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
   3. "kubernetes.io/kubelet-serving" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.
    Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
  
  More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers
  
  Custom signerNames can also be specified. The signer defines:
   1. Trust distribution: how trust (CA bundles) are distributed.
   2. Permitted subjects: and behavior when a disallowed subject is requested.
   3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.
   4. Required, permitted, or forbidden key usages / extended key usages.
   5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.
   6. Whether or not requests for CA certificates are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#signer_name CertificateSigningRequestV1#signer_name}
    */
    readonly signerName: string;
    /**
    * usages specifies a set of key usages requested in the issued certificate.
  
  Requests for TLS client certificates typically request: "digital signature", "key encipherment", "client auth".
  
  Requests for TLS serving certificates typically request: "key encipherment", "digital signature", "server auth".
  
  Valid values are:
   "signing", "digital signature", "content commitment",
   "key encipherment", "key agreement", "data encipherment",
   "cert sign", "crl sign", "encipher only", "decipher only", "any",
   "server auth", "client auth",
   "code signing", "email protection", "s/mime",
   "ipsec end system", "ipsec tunnel", "ipsec user",
   "timestamping", "ocsp signing", "microsoft sgc", "netscape sgc"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#usages CertificateSigningRequestV1#usages}
    */
    readonly usages?: string[];
}
export declare function certificateSigningRequestV1SpecToTerraform(struct?: CertificateSigningRequestV1SpecOutputReference | CertificateSigningRequestV1Spec): any;
export declare class CertificateSigningRequestV1SpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateSigningRequestV1Spec | undefined;
    set internalValue(value: CertificateSigningRequestV1Spec | undefined);
    private _request?;
    get request(): string;
    set request(value: string);
    get requestInput(): string | undefined;
    private _signerName?;
    get signerName(): string;
    set signerName(value: string);
    get signerNameInput(): string | undefined;
    private _usages?;
    get usages(): string[];
    set usages(value: string[]);
    resetUsages(): void;
    get usagesInput(): string[] | undefined;
}
export interface CertificateSigningRequestV1Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1#create CertificateSigningRequestV1#create}
    */
    readonly create?: string;
}
export declare function certificateSigningRequestV1TimeoutsToTerraform(struct?: CertificateSigningRequestV1TimeoutsOutputReference | CertificateSigningRequestV1Timeouts | cdktf.IResolvable): any;
export declare class CertificateSigningRequestV1TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateSigningRequestV1Timeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CertificateSigningRequestV1Timeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1 kubernetes_certificate_signing_request_v1}
*/
export declare class CertificateSigningRequestV1 extends cdktf.TerraformResource {
    static readonly tfResourceType = "kubernetes_certificate_signing_request_v1";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/kubernetes/r/certificate_signing_request_v1 kubernetes_certificate_signing_request_v1} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertificateSigningRequestV1Config
    */
    constructor(scope: Construct, id: string, config: CertificateSigningRequestV1Config);
    private _autoApprove?;
    get autoApprove(): boolean | cdktf.IResolvable;
    set autoApprove(value: boolean | cdktf.IResolvable);
    resetAutoApprove(): void;
    get autoApproveInput(): boolean | cdktf.IResolvable | undefined;
    get certificate(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): CertificateSigningRequestV1MetadataOutputReference;
    putMetadata(value: CertificateSigningRequestV1Metadata): void;
    get metadataInput(): CertificateSigningRequestV1Metadata | undefined;
    private _spec;
    get spec(): CertificateSigningRequestV1SpecOutputReference;
    putSpec(value: CertificateSigningRequestV1Spec): void;
    get specInput(): CertificateSigningRequestV1Spec | undefined;
    private _timeouts;
    get timeouts(): CertificateSigningRequestV1TimeoutsOutputReference;
    putTimeouts(value: CertificateSigningRequestV1Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CertificateSigningRequestV1Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
