# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/type/tracing/v3/custom_tag.proto
# plugin: python-betterproto
from dataclasses import dataclass

import betterproto

from ...metadata import v3 as __metadata_v3__


@dataclass(eq=False, repr=False)
class CustomTag(betterproto.Message):
    """Describes custom tags for the active span. [#next-free-field: 6]"""

    tag: str = betterproto.string_field(1)
    """Used to populate the tag name."""

    literal: "CustomTagLiteral" = betterproto.message_field(2, group="type")
    """A literal custom tag."""

    environment: "CustomTagEnvironment" = betterproto.message_field(3, group="type")
    """An environment custom tag."""

    request_header: "CustomTagHeader" = betterproto.message_field(4, group="type")
    """A request header custom tag."""

    metadata: "CustomTagMetadata" = betterproto.message_field(5, group="type")
    """A custom tag to obtain tag value from the metadata."""


@dataclass(eq=False, repr=False)
class CustomTagLiteral(betterproto.Message):
    """Literal type custom tag with static value for the tag value."""

    value: str = betterproto.string_field(1)
    """Static literal value to populate the tag value."""


@dataclass(eq=False, repr=False)
class CustomTagEnvironment(betterproto.Message):
    """Environment type custom tag with environment name and default value."""

    name: str = betterproto.string_field(1)
    """
    Environment variable name to obtain the value to populate the tag value.
    """

    default_value: str = betterproto.string_field(2)
    """
    When the environment variable is not found, the tag value will be populated
    with this default value if specified, otherwise no tag will be populated.
    """


@dataclass(eq=False, repr=False)
class CustomTagHeader(betterproto.Message):
    """Header type custom tag with header name and default value."""

    name: str = betterproto.string_field(1)
    """Header name to obtain the value to populate the tag value."""

    default_value: str = betterproto.string_field(2)
    """
    When the header does not exist, the tag value will be populated with this
    default value if specified, otherwise no tag will be populated.
    """


@dataclass(eq=False, repr=False)
class CustomTagMetadata(betterproto.Message):
    """
    Metadata type custom tag using :ref:`MetadataKey
    <envoy_v3_api_msg_type.metadata.v3.MetadataKey>` to retrieve the protobuf
    value from :ref:`Metadata <envoy_v3_api_msg_config.core.v3.Metadata>`, and
    populate the tag value with `the canonical JSON
    <https://developers.google.com/protocol-buffers/docs/proto3#json>`_
    representation of it.
    """

    kind: "__metadata_v3__.MetadataKind" = betterproto.message_field(1)
    """Specify what kind of metadata to obtain tag value from."""

    metadata_key: "__metadata_v3__.MetadataKey" = betterproto.message_field(2)
    """Metadata key to define the path to retrieve the tag value."""

    default_value: str = betterproto.string_field(3)
    """
    When no valid metadata is found, the tag value would be populated with this
    default value if specified, otherwise no tag would be populated.
    """
