# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/type/http/v3/cookie.proto, envoy/type/http/v3/path_transformation.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto


@dataclass(eq=False, repr=False)
class PathTransformation(betterproto.Message):
    operations: List["PathTransformationOperation"] = betterproto.message_field(1)
    """
    A list of operations to apply. Transformations will be performed in the
    order that they appear.
    """


@dataclass(eq=False, repr=False)
class PathTransformationOperation(betterproto.Message):
    """A type of operation to alter text."""

    normalize_path_rfc_3986: "PathTransformationOperationNormalizePathRfc3986" = (
        betterproto.message_field(2, group="operation_specifier")
    )
    """Enable path normalization per RFC 3986."""

    merge_slashes: "PathTransformationOperationMergeSlashes" = (
        betterproto.message_field(3, group="operation_specifier")
    )
    """Enable merging adjacent slashes."""


@dataclass(eq=False, repr=False)
class PathTransformationOperationNormalizePathRfc3986(betterproto.Message):
    """
    Should text be normalized according to RFC 3986? This typically is used for
    path headers before any processing of requests by HTTP filters or routing.
    This applies percent-encoded normalization and path segment normalization.
    Fails on characters disallowed in URLs (e.g. NULLs). See `Normalization and
    Comparison <https://tools.ietf.org/html/rfc3986#section-6>`_ for details of
    normalization. Note that this options does not perform `case normalization
    <https://tools.ietf.org/html/rfc3986#section-6.2.2.1>`_
    """

    pass


@dataclass(eq=False, repr=False)
class PathTransformationOperationMergeSlashes(betterproto.Message):
    """
    Determines if adjacent slashes are merged into one. A common use case is
    for a request path header. Using this option in ``:ref:
    PathNormalizationOptions <envoy_v3_api_msg_extensions.filters.network.http_
    connection_manager.v3.HttpConnectionManager.PathNormalizationOptions>``
    will allow incoming requests with path ``//dir///file`` to match against
    route with ``prefix`` match set to ``/dir``. When using for header
    transformations, note that slash merging is not part of `HTTP spec
    <https://tools.ietf.org/html/rfc3986>`_ and is provided for convenience.
    """

    pass


@dataclass(eq=False, repr=False)
class Cookie(betterproto.Message):
    """Cookie defines an API for obtaining or generating HTTP cookie."""

    name: str = betterproto.string_field(1)
    """
    The name that will be used to obtain cookie value from downstream HTTP
    request or generate new cookie for downstream.
    """

    ttl: timedelta = betterproto.message_field(2)
    """
    Duration of cookie. This will be used to set the expiry time of a new
    cookie when it is generated. Set this to 0 to use a session cookie.
    """

    path: str = betterproto.string_field(3)
    """
    Path of cookie. This will be used to set the path of a new cookie when it
    is generated. If no path is specified here, no path will be set for the
    cookie.
    """
