# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/tap/v2alpha/common.proto, envoy/service/tap/v2alpha/tap.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....api.v2 import (
    core as ___api_v2_core__,
    route as ___api_v2_route__,
)
from ....data.tap import v2alpha as ___data_tap_v2_alpha__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class OutputSinkFormat(betterproto.Enum):
    """
    Output format. All output is in the form of one or more :ref:`TraceWrapper
    <envoy_api_msg_data.tap.v2alpha.TraceWrapper>` messages. This enumeration
    indicates how those messages are written. Note that not all sinks support
    all output formats. See individual sink documentation for more information.
    """

    JSON_BODY_AS_BYTES = 0
    """
    Each message will be written as JSON. Any :ref:`body
    <envoy_api_msg_data.tap.v2alpha.Body>` data will be present in the
    :ref:`as_bytes <envoy_api_field_data.tap.v2alpha.Body.as_bytes>` field.
    This means that body data will be base64 encoded as per the `proto3 JSON
    mappings <https://developers.google.com/protocol-
    buffers/docs/proto3#json>`_.
    """

    JSON_BODY_AS_STRING = 1
    """
    Each message will be written as JSON. Any :ref:`body
    <envoy_api_msg_data.tap.v2alpha.Body>` data will be present in the
    :ref:`as_string <envoy_api_field_data.tap.v2alpha.Body.as_string>` field.
    This means that body data will be string encoded as per the `proto3 JSON
    mappings <https://developers.google.com/protocol-
    buffers/docs/proto3#json>`_. This format type is useful when it is known
    that that body is human readable (e.g., JSON over HTTP) and the user wishes
    to view it directly without being forced to base64 decode the body.
    """

    PROTO_BINARY = 2
    """
    Binary proto format. Note that binary proto is not self-delimiting. If a
    sink writes multiple binary messages without any length information the
    data stream will not be useful. However, for certain sinks that are self-
    delimiting (e.g., one message per file) this output format makes
    consumption simpler.
    """

    PROTO_BINARY_LENGTH_DELIMITED = 3
    """
    Messages are written as a sequence tuples, where each tuple is the message
    length encoded as a `protobuf 32-bit varint
    <https://developers.google.com/protocol-
    buffers/docs/reference/cpp/google.protobuf.io.coded_stream>`_ followed by
    the binary message. The messages can be read back using the language
    specific protobuf coded stream implementation to obtain the message length
    and the message.
    """

    PROTO_TEXT = 4
    """Text proto format."""


@dataclass(eq=False, repr=False)
class StreamTapsRequest(betterproto.Message):
    """
    [#not-implemented-hide:] Stream message for the Tap API. Envoy will open a
    stream to the server and stream taps without ever expecting a response.
    """

    identifier: "StreamTapsRequestIdentifier" = betterproto.message_field(1)
    """
    Identifier data effectively is a structured metadata. As a performance
    optimization this will only be sent in the first message on the stream.
    """

    trace_id: int = betterproto.uint64_field(2)
    """
    The trace id. this can be used to merge together a streaming trace. Note
    that the trace_id is not guaranteed to be spatially or temporally unique.
    """

    trace: "___data_tap_v2_alpha__.TraceWrapper" = betterproto.message_field(3)
    """The trace data."""


@dataclass(eq=False, repr=False)
class StreamTapsRequestIdentifier(betterproto.Message):
    node: "___api_v2_core__.Node" = betterproto.message_field(1)
    """The node sending taps over the stream."""

    tap_id: str = betterproto.string_field(2)
    """
    The opaque identifier that was set in the :ref:`output config
    <envoy_api_field_service.tap.v2alpha.StreamingGrpcSink.tap_id>`.
    """


@dataclass(eq=False, repr=False)
class StreamTapsResponse(betterproto.Message):
    """[#not-implemented-hide:]"""

    pass


@dataclass(eq=False, repr=False)
class TapConfig(betterproto.Message):
    """Tap configuration."""

    match_config: "MatchPredicate" = betterproto.message_field(1)
    """
    The match configuration. If the configuration matches the data source being
    tapped, a tap will occur, with the result written to the configured output.
    """

    output_config: "OutputConfig" = betterproto.message_field(2)
    """
    The tap output configuration. If a match configuration matches a data
    source being tapped, a tap will occur and the data will be written to the
    configured output.
    """

    tap_enabled: "___api_v2_core__.RuntimeFractionalPercent" = (
        betterproto.message_field(3)
    )
    """
    [#not-implemented-hide:] Specify if Tap matching is enabled. The % of
    requests\connections for which the tap matching is enabled. When not
    enabled, the request\connection will not be recorded. .. note::   This
    field defaults to 100/:ref:`HUNDRED
    <envoy_api_enum_type.FractionalPercent.DenominatorType>`.
    """


@dataclass(eq=False, repr=False)
class MatchPredicate(betterproto.Message):
    """
    Tap match configuration. This is a recursive structure which allows complex
    nested match configurations to be built using various logical operators.
    [#next-free-field: 9]
    """

    or_match: "MatchPredicateMatchSet" = betterproto.message_field(1, group="rule")
    """
    A set that describes a logical OR. If any member of the set matches, the
    match configuration matches.
    """

    and_match: "MatchPredicateMatchSet" = betterproto.message_field(2, group="rule")
    """
    A set that describes a logical AND. If all members of the set match, the
    match configuration matches.
    """

    not_match: "MatchPredicate" = betterproto.message_field(3, group="rule")
    """
    A negation match. The match configuration will match if the negated match
    condition matches.
    """

    any_match: bool = betterproto.bool_field(4, group="rule")
    """The match configuration will always match."""

    http_request_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        5, group="rule"
    )
    """HTTP request headers match configuration."""

    http_request_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        6, group="rule"
    )
    """HTTP request trailers match configuration."""

    http_response_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        7, group="rule"
    )
    """HTTP response headers match configuration."""

    http_response_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        8, group="rule"
    )
    """HTTP response trailers match configuration."""


@dataclass(eq=False, repr=False)
class MatchPredicateMatchSet(betterproto.Message):
    """A set of match configurations used for logical operations."""

    rules: List["MatchPredicate"] = betterproto.message_field(1)
    """The list of rules that make up the set."""


@dataclass(eq=False, repr=False)
class HttpHeadersMatch(betterproto.Message):
    """HTTP headers match configuration."""

    headers: List["___api_v2_route__.HeaderMatcher"] = betterproto.message_field(1)
    """HTTP headers to match."""


@dataclass(eq=False, repr=False)
class OutputConfig(betterproto.Message):
    """Tap output configuration."""

    sinks: List["OutputSink"] = betterproto.message_field(1)
    """
    Output sinks for tap data. Currently a single sink is allowed in the list.
    Once multiple sink types are supported this constraint will be relaxed.
    """

    max_buffered_rx_bytes: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    """
    For buffered tapping, the maximum amount of received body that will be
    buffered prior to truncation. If truncation occurs, the :ref:`truncated
    <envoy_api_field_data.tap.v2alpha.Body.truncated>` field will be set. If
    not specified, the default is 1KiB.
    """

    max_buffered_tx_bytes: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    """
    For buffered tapping, the maximum amount of transmitted body that will be
    buffered prior to truncation. If truncation occurs, the :ref:`truncated
    <envoy_api_field_data.tap.v2alpha.Body.truncated>` field will be set. If
    not specified, the default is 1KiB.
    """

    streaming: bool = betterproto.bool_field(4)
    """
    Indicates whether taps produce a single buffered message per tap, or
    multiple streamed messages per tap in the emitted :ref:`TraceWrapper
    <envoy_api_msg_data.tap.v2alpha.TraceWrapper>` messages. Note that streamed
    tapping does not mean that no buffering takes place. Buffering may be
    required if data is processed before a match can be determined. See the
    HTTP tap filter :ref:`streaming <config_http_filters_tap_streaming>`
    documentation for more information.
    """


@dataclass(eq=False, repr=False)
class OutputSink(betterproto.Message):
    """Tap output sink configuration."""

    format: "OutputSinkFormat" = betterproto.enum_field(1)
    """Sink output format."""

    streaming_admin: "StreamingAdminSink" = betterproto.message_field(
        2, group="output_sink_type"
    )
    """
    Tap output will be streamed out the :http:post:`/tap` admin endpoint. ..
    attention::   It is only allowed to specify the streaming admin output sink
    if the tap is being   configured from the :http:post:`/tap` admin endpoint.
    Thus, if an extension has   been configured to receive tap configuration
    from some other source (e.g., static   file, XDS, etc.) configuring the
    streaming admin output type will fail.
    """

    file_per_tap: "FilePerTapSink" = betterproto.message_field(
        3, group="output_sink_type"
    )
    """Tap output will be written to a file per tap sink."""

    streaming_grpc: "StreamingGrpcSink" = betterproto.message_field(
        4, group="output_sink_type"
    )
    """
    [#not-implemented-hide:] GrpcService to stream data to. The format argument
    must be PROTO_BINARY.
    """


@dataclass(eq=False, repr=False)
class StreamingAdminSink(betterproto.Message):
    """Streaming admin sink configuration."""

    pass


@dataclass(eq=False, repr=False)
class FilePerTapSink(betterproto.Message):
    """
    The file per tap sink outputs a discrete file for every tapped stream.
    """

    path_prefix: str = betterproto.string_field(1)
    """
    Path prefix. The output file will be of the form <path_prefix>_<id>.pb,
    where <id> is an identifier distinguishing the recorded trace for stream
    instances (the Envoy connection ID, HTTP stream ID, etc.).
    """


@dataclass(eq=False, repr=False)
class StreamingGrpcSink(betterproto.Message):
    """
    [#not-implemented-hide:] Streaming gRPC sink configuration sends the taps
    to an external gRPC server.
    """

    tap_id: str = betterproto.string_field(1)
    """
    Opaque identifier, that will be sent back to the streaming grpc server.
    """

    grpc_service: "___api_v2_core__.GrpcService" = betterproto.message_field(2)
    """The gRPC server that hosts the Tap Sink Service."""


class TapSinkServiceStub(betterproto.ServiceStub):
    async def stream_taps(
        self,
        stream_taps_request_iterator: Union[
            AsyncIterable["StreamTapsRequest"], Iterable["StreamTapsRequest"]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StreamTapsResponse":
        return await self._stream_unary(
            "/envoy.service.tap.v2alpha.TapSinkService/StreamTaps",
            stream_taps_request_iterator,
            StreamTapsRequest,
            StreamTapsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class TapSinkServiceBase(ServiceBase):
    async def stream_taps(
        self, stream_taps_request_iterator: AsyncIterator["StreamTapsRequest"]
    ) -> "StreamTapsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_taps(
        self, stream: "grpclib.server.Stream[StreamTapsRequest, StreamTapsResponse]"
    ) -> None:
        request = stream.__aiter__()
        response = await self.stream_taps(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.tap.v2alpha.TapSinkService/StreamTaps": grpclib.const.Handler(
                self.__rpc_stream_taps,
                grpclib.const.Cardinality.STREAM_UNARY,
                StreamTapsRequest,
                StreamTapsResponse,
            ),
        }
