# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/ratelimit/v2/rls.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....api.v2 import (
    core as ___api_v2_core__,
    ratelimit as ___api_v2_ratelimit__,
)


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class RateLimitResponseCode(betterproto.Enum):
    UNKNOWN = 0
    """The response code is not known."""

    OK = 1
    """
    The response code to notify that the number of requests are under limit.
    """

    OVER_LIMIT = 2
    """
    The response code to notify that the number of requests are over limit.
    """


class RateLimitResponseRateLimitUnit(betterproto.Enum):
    UNKNOWN = 0
    """The time unit is not known."""

    SECOND = 1
    """The time unit representing a second."""

    MINUTE = 2
    """The time unit representing a minute."""

    HOUR = 3
    """The time unit representing an hour."""

    DAY = 4
    """The time unit representing a day."""


@dataclass(eq=False, repr=False)
class RateLimitRequest(betterproto.Message):
    """
    Main message for a rate limit request. The rate limit service is designed
    to be fully generic in the sense that it can operate on arbitrary
    hierarchical key/value pairs. The loaded configuration will parse the
    request and find the most specific limit to apply. In addition, a
    RateLimitRequest can contain multiple "descriptors" to limit on. When
    multiple descriptors are provided, the server will limit on *ALL* of them
    and return an OVER_LIMIT response if any of them are over limit. This
    enables more complex application level rate limiting scenarios if desired.
    """

    domain: str = betterproto.string_field(1)
    """
    All rate limit requests must specify a domain. This enables the
    configuration to be per application without fear of overlap. E.g., "envoy".
    """

    descriptors: List[
        "___api_v2_ratelimit__.RateLimitDescriptor"
    ] = betterproto.message_field(2)
    """
    All rate limit requests must specify at least one RateLimitDescriptor. Each
    descriptor is processed by the service (see below). If any of the
    descriptors are over limit, the entire request is considered to be over
    limit.
    """

    hits_addend: int = betterproto.uint32_field(3)
    """
    Rate limit requests can optionally specify the number of hits a request
    adds to the matched limit. If the value is not set in the message, a
    request increases the matched limit by 1.
    """


@dataclass(eq=False, repr=False)
class RateLimitResponse(betterproto.Message):
    """A response from a ShouldRateLimit call."""

    overall_code: "RateLimitResponseCode" = betterproto.enum_field(1)
    """
    The overall response code which takes into account all of the descriptors
    that were passed in the RateLimitRequest message.
    """

    statuses: List["RateLimitResponseDescriptorStatus"] = betterproto.message_field(2)
    """
    A list of DescriptorStatus messages which matches the length of the
    descriptor list passed in the RateLimitRequest. This can be used by the
    caller to determine which individual descriptors failed and/or what the
    currently configured limits are for all of them.
    """

    headers: List["___api_v2_core__.HeaderValue"] = betterproto.message_field(3)
    """A list of headers to add to the response"""

    request_headers_to_add: List[
        "___api_v2_core__.HeaderValue"
    ] = betterproto.message_field(4)
    """A list of headers to add to the request when forwarded"""


@dataclass(eq=False, repr=False)
class RateLimitResponseRateLimit(betterproto.Message):
    """
    Defines an actual rate limit in terms of requests per unit of time and the
    unit itself.
    """

    name: str = betterproto.string_field(3)
    """A name or description of this limit."""

    requests_per_unit: int = betterproto.uint32_field(1)
    """The number of requests per unit of time."""

    unit: "RateLimitResponseRateLimitUnit" = betterproto.enum_field(2)
    """The unit of time."""


@dataclass(eq=False, repr=False)
class RateLimitResponseDescriptorStatus(betterproto.Message):
    code: "RateLimitResponseCode" = betterproto.enum_field(1)
    """The response code for an individual descriptor."""

    current_limit: "RateLimitResponseRateLimit" = betterproto.message_field(2)
    """
    The current limit as configured by the server. Useful for debugging, etc.
    """

    limit_remaining: int = betterproto.uint32_field(3)
    """The limit remaining in the current time unit."""


class RateLimitServiceStub(betterproto.ServiceStub):
    async def should_rate_limit(
        self,
        rate_limit_request: "RateLimitRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RateLimitResponse":
        return await self._unary_unary(
            "/envoy.service.ratelimit.v2.RateLimitService/ShouldRateLimit",
            rate_limit_request,
            RateLimitResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class RateLimitServiceBase(ServiceBase):
    async def should_rate_limit(
        self, rate_limit_request: "RateLimitRequest"
    ) -> "RateLimitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_should_rate_limit(
        self, stream: "grpclib.server.Stream[RateLimitRequest, RateLimitResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.should_rate_limit(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.ratelimit.v2.RateLimitService/ShouldRateLimit": grpclib.const.Handler(
                self.__rpc_should_rate_limit,
                grpclib.const.Cardinality.UNARY_UNARY,
                RateLimitRequest,
                RateLimitResponse,
            ),
        }
