# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/rate_limit_quota/v3/rlqs.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....type import v3 as ___type_v3__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class RateLimitQuotaUsageReports(betterproto.Message):
    domain: str = betterproto.string_field(1)
    """
    All quota requests must specify the domain. This enables sharing the quota
    server between different applications without fear of overlap. E.g.,
    "envoy". Should only be provided in the first report, all subsequent
    messages on the same stream are considered to be in the same domain. In
    case the domain needs to be changes, close the stream, and reopen a new one
    with the different domain.
    """

    bucket_quota_usages: List[
        "RateLimitQuotaUsageReportsBucketQuotaUsage"
    ] = betterproto.message_field(2)
    """
    A list of quota usage reports. The list is processed by the RLQS server in
    the same order it's provided by the client.
    """


@dataclass(eq=False, repr=False)
class RateLimitQuotaUsageReportsBucketQuotaUsage(betterproto.Message):
    """
    The usage report for a bucket. .. note::   Note that the first report sent
    for a ``BucketId`` indicates to the RLQS server that   the RLQS client is
    subscribing for the future assignments for this ``BucketId``.
    """

    bucket_id: "BucketId" = betterproto.message_field(1)
    """``BucketId`` for which request quota usage is reported."""

    time_elapsed: timedelta = betterproto.message_field(2)
    """Time elapsed since the last report."""

    num_requests_allowed: int = betterproto.uint64_field(3)
    """Requests the data plane has allowed through."""

    num_requests_denied: int = betterproto.uint64_field(4)
    """Requests throttled."""


@dataclass(eq=False, repr=False)
class RateLimitQuotaResponse(betterproto.Message):
    bucket_action: List[
        "RateLimitQuotaResponseBucketAction"
    ] = betterproto.message_field(1)
    """
    An ordered list of actions to be applied to the buckets. The actions are
    applied in the given order, from top to bottom.
    """


@dataclass(eq=False, repr=False)
class RateLimitQuotaResponseBucketAction(betterproto.Message):
    """
    Commands the data plane to apply one of the actions to the bucket with the
    :ref:`bucket_id <envoy_v3_api_field_service.rate_limit_quota.v3.RateLimitQu
    otaResponse.BucketAction.bucket_id>`.
    """

    bucket_id: "BucketId" = betterproto.message_field(1)
    """``BucketId`` for which request the action is applied."""

    quota_assignment_action: "RateLimitQuotaResponseBucketActionQuotaAssignmentAction" = betterproto.message_field(
        2, group="bucket_action"
    )
    """
    Apply the quota assignment to the bucket. Commands the data plane to apply
    a rate limiting strategy to the bucket. The process of applying and
    expiring the rate limiting strategy is detailed in the
    :ref:`QuotaAssignmentAction <envoy_v3_api_msg_service.rate_limit_quota.v3.R
    ateLimitQuotaResponse.BucketAction.QuotaAssignmentAction>` message.
    """

    abandon_action: "RateLimitQuotaResponseBucketActionAbandonAction" = (
        betterproto.message_field(3, group="bucket_action")
    )
    """
    Abandon the bucket. Commands the data plane to abandon the bucket. The
    process of abandoning the bucket is described in the :ref:`AbandonAction <e
    nvoy_v3_api_msg_service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAc
    tion.AbandonAction>` message.
    """


@dataclass(eq=False, repr=False)
class RateLimitQuotaResponseBucketActionQuotaAssignmentAction(betterproto.Message):
    """
    Quota assignment for the bucket. Configures the rate limiting strategy and
    the duration for the given :ref:`bucket_id <envoy_v3_api_field_service.rate
    _limit_quota.v3.RateLimitQuotaResponse.BucketAction.bucket_id>`. **Applying
    the first assignment to the bucket** Once the data plane receives the
    ``QuotaAssignmentAction``, it must send the current usage report for the
    bucket, and start rate limiting requests matched into the bucket using the
    strategy configured in the :ref:`rate_limit_strategy <envoy_v3_api_field_se
    rvice.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.QuotaAssignme
    ntAction.rate_limit_strategy>` field. The assignment becomes bucket's
    ``active`` assignment. **Expiring the assignment** The duration of the
    assignment defined in the :ref:`assignment_time_to_live <envoy_v3_api_field
    _service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.QuotaAssig
    nmentAction.assignment_time_to_live>` field. When the duration runs off,
    the assignment is ``expired``, and no longer ``active``. The data plane
    should stop applying the rate limiting strategy to the bucket, and
    transition the bucket to the "expired assignment" state. This activates the
    behavior configured in the :ref:`expired_assignment_behavior <envoy_v3_api_
    field_extensions.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSetti
    ngs.expired_assignment_behavior>` field. **Replacing the assignment** * If
    the rate limiting strategy is different from bucket's ``active``
    assignment, or   the current bucket assignment is ``expired``, the data
    plane must immediately   end the current assignment, report the bucket
    usage, and apply the new assignment.   The new assignment becomes bucket's
    ``active`` assignment. * If the rate limiting strategy is the same as the
    bucket's ``active`` (not ``expired``)   assignment, the data plane should
    extend the duration of the ``active`` assignment   for the duration of the
    new assignment provided in the :ref:`assignment_time_to_live   <envoy_v3_ap
    i_field_service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.Quo
    taAssignmentAction.assignment_time_to_live>`   field. The ``active``
    assignment is considered unchanged.
    """

    assignment_time_to_live: timedelta = betterproto.message_field(2)
    """
    A duration after which the assignment is be considered ``expired``. The
    process of the expiration is described :ref:`above <envoy_v3_api_msg_servic
    e.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.QuotaAssignmentAc
    tion>`. * If unset, the assignment has no expiration date. * If set to
    ``0``, the assignment expires immediately, forcing the client into the
    :ref:`"expired assignment"   <envoy_v3_api_field_extensions.filters.http.ra
    te_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAssignmentBehavior.ex
    pired_assignment_behavior_timeout>`   state. This may be used by the RLQS
    server in cases when it needs clients to proactively   fall back to the
    pre-configured :ref:`ExpiredAssignmentBehavior   <envoy_v3_api_msg_extensio
    ns.filters.http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.ExpiredAss
    ignmentBehavior>`,   f.e. before the server going into restart. ..
    attention::   Note that :ref:`expiring   <envoy_v3_api_msg_service.rate_lim
    it_quota.v3.RateLimitQuotaResponse.BucketAction.QuotaAssignmentAction>`
    the assignment is not the same as :ref:`abandoning   <envoy_v3_api_msg_serv
    ice.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.AbandonAction>`
    the assignment. While expiring the assignment just transitions the bucket
    to   the "expired assignment" state; abandoning the assignment completely
    erases   the bucket from the data plane memory, and stops the usage
    reports.
    """

    rate_limit_strategy: "___type_v3__.RateLimitStrategy" = betterproto.message_field(3)
    """
    Configures the local rate limiter for the request matched to the bucket. If
    not set, allow all requests.
    """


@dataclass(eq=False, repr=False)
class RateLimitQuotaResponseBucketActionAbandonAction(betterproto.Message):
    """
    Abandon action for the bucket. Indicates that the RLQS server will no
    longer be sending updates for the given :ref:`bucket_id <envoy_v3_api_field
    _service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAction.bucket_id>
    `. If no requests are reported for a bucket, after some time the server
    considers the bucket inactive. The server stops tracking the bucket, and
    instructs the the data plane to abandon the bucket via this message.
    **Abandoning the assignment** The data plane is to erase the bucket
    (including its usage data) from the memory. It should stop tracking the
    bucket, and stop reporting its usage. This effectively resets the data
    plane to the state prior to matching the first request into the bucket.
    **Restarting the subscription** If a new request is matched into a bucket
    previously abandoned, the data plane must behave as if it has never tracked
    the bucket, and it's the first request matched into it: 1. The process of
    :ref:`subscription and reporting    <envoy_v3_api_field_extensions.filters.
    http.rate_limit_quota.v3.RateLimitQuotaBucketSettings.reporting_interval>`
    starts from the beginning. 2. The bucket transitions to the :ref:`"no
    assignment"    <envoy_v3_api_field_extensions.filters.http.rate_limit_quota
    .v3.RateLimitQuotaBucketSettings.no_assignment_behavior>`    state. 3. Once
    the new assignment is received, it's applied per    "Applying the first
    assignment to the bucket" section of the :ref:`QuotaAssignmentAction    <en
    voy_v3_api_msg_service.rate_limit_quota.v3.RateLimitQuotaResponse.BucketAct
    ion.QuotaAssignmentAction>`.
    """

    pass


@dataclass(eq=False, repr=False)
class BucketId(betterproto.Message):
    """
    The identifier for the bucket. Used to match the bucket between the control
    plane (RLQS server), and the data plane (RLQS client), f.e.: * the data
    plane sends a usage report for requests matched into the bucket with
    ``BucketId``   to the control plane * the control plane sends an assignment
    for the bucket with ``BucketId`` to the data plane   Bucket ID. Example: ..
    validated-code-block:: yaml   :type-name:
    envoy.service.rate_limit_quota.v3.BucketId   bucket:     name: my_bucket
    env: staging .. note::   The order of ``BucketId`` keys do not matter.
    Buckets ``{ a: 'A', b: 'B' }`` and   ``{ b: 'B', a: 'A' }`` are identical.
    """

    bucket: Dict[str, str] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )


class RateLimitQuotaServiceStub(betterproto.ServiceStub):
    async def stream_rate_limit_quotas(
        self,
        rate_limit_quota_usage_reports_iterator: Union[
            AsyncIterable["RateLimitQuotaUsageReports"],
            Iterable["RateLimitQuotaUsageReports"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["RateLimitQuotaResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.rate_limit_quota.v3.RateLimitQuotaService/StreamRateLimitQuotas",
            rate_limit_quota_usage_reports_iterator,
            RateLimitQuotaUsageReports,
            RateLimitQuotaResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class RateLimitQuotaServiceBase(ServiceBase):
    async def stream_rate_limit_quotas(
        self,
        rate_limit_quota_usage_reports_iterator: AsyncIterator[
            "RateLimitQuotaUsageReports"
        ],
    ) -> AsyncIterator["RateLimitQuotaResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_rate_limit_quotas(
        self,
        stream: "grpclib.server.Stream[RateLimitQuotaUsageReports, RateLimitQuotaResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_rate_limit_quotas,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.rate_limit_quota.v3.RateLimitQuotaService/StreamRateLimitQuotas": grpclib.const.Handler(
                self.__rpc_stream_rate_limit_quotas,
                grpclib.const.Cardinality.STREAM_STREAM,
                RateLimitQuotaUsageReports,
                RateLimitQuotaResponse,
            ),
        }
