# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/discovery/v2/ads.proto, envoy/service/discovery/v2/hds.proto, envoy/service/discovery/v2/rtds.proto, envoy/service/discovery/v2/sds.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....api import v2 as ___api_v2__
from ....api.v2 import (
    core as ___api_v2_core__,
    endpoint as ___api_v2_endpoint__,
)


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class CapabilityProtocol(betterproto.Enum):
    """
    Different Envoy instances may have different capabilities (e.g. Redis)
    and/or have ports enabled for different protocols.
    """

    HTTP = 0
    TCP = 1
    REDIS = 2


@dataclass(eq=False, repr=False)
class SdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221
    """

    pass


@dataclass(eq=False, repr=False)
class Capability(betterproto.Message):
    """
    Defines supported protocols etc, so the management server can assign proper
    endpoints to healthcheck.
    """

    health_check_protocols: List["CapabilityProtocol"] = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class HealthCheckRequest(betterproto.Message):
    node: "___api_v2_core__.Node" = betterproto.message_field(1)
    capability: "Capability" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EndpointHealth(betterproto.Message):
    endpoint: "___api_v2_endpoint__.Endpoint" = betterproto.message_field(1)
    health_status: "___api_v2_core__.HealthStatus" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class EndpointHealthResponse(betterproto.Message):
    endpoints_health: List["EndpointHealth"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class HealthCheckRequestOrEndpointHealthResponse(betterproto.Message):
    health_check_request: "HealthCheckRequest" = betterproto.message_field(
        1, group="request_type"
    )
    endpoint_health_response: "EndpointHealthResponse" = betterproto.message_field(
        2, group="request_type"
    )


@dataclass(eq=False, repr=False)
class LocalityEndpoints(betterproto.Message):
    locality: "___api_v2_core__.Locality" = betterproto.message_field(1)
    endpoints: List["___api_v2_endpoint__.Endpoint"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClusterHealthCheck(betterproto.Message):
    """
    The cluster name and locality is provided to Envoy for the endpoints that
    it health checks to support statistics reporting, logging and debugging by
    the Envoy instance (outside of HDS). For maximum usefulness, it should
    match the same cluster structure as that provided by EDS.
    """

    cluster_name: str = betterproto.string_field(1)
    health_checks: List["___api_v2_core__.HealthCheck"] = betterproto.message_field(2)
    locality_endpoints: List["LocalityEndpoints"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class HealthCheckSpecifier(betterproto.Message):
    cluster_health_checks: List["ClusterHealthCheck"] = betterproto.message_field(1)
    interval: timedelta = betterproto.message_field(2)
    """The default is 1 second."""


@dataclass(eq=False, repr=False)
class AdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221
    """

    pass


@dataclass(eq=False, repr=False)
class RtdsDummy(betterproto.Message):
    """
    [#not-implemented-hide:] Not configuration. Workaround c++ protobuf issue
    with importing services: https://github.com/google/protobuf/issues/4221
    """

    pass


@dataclass(eq=False, repr=False)
class Runtime(betterproto.Message):
    """
    RTDS resource type. This describes a layer in the runtime virtual
    filesystem.
    """

    name: str = betterproto.string_field(1)
    """
    Runtime resource name. This makes the Runtime a self-describing xDS
    resource.
    """

    layer: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)


class SecretDiscoveryServiceStub(betterproto.ServiceStub):
    async def delta_secrets(
        self,
        api_v2_delta_discovery_request_iterator: Union[
            AsyncIterable["___api_v2__.DeltaDiscoveryRequest"],
            Iterable["___api_v2__.DeltaDiscoveryRequest"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["___api_v2__.DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.SecretDiscoveryService/DeltaSecrets",
            api_v2_delta_discovery_request_iterator,
            ___api_v2__.DeltaDiscoveryRequest,
            ___api_v2__.DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def stream_secrets(
        self,
        api_v2_discovery_request_iterator: Union[
            AsyncIterable["___api_v2__.DiscoveryRequest"],
            Iterable["___api_v2__.DiscoveryRequest"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["___api_v2__.DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.SecretDiscoveryService/StreamSecrets",
            api_v2_discovery_request_iterator,
            ___api_v2__.DiscoveryRequest,
            ___api_v2__.DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_secrets(
        self,
        api_v2_discovery_request: "___api_v2__.DiscoveryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "___api_v2__.DiscoveryResponse":
        return await self._unary_unary(
            "/envoy.service.discovery.v2.SecretDiscoveryService/FetchSecrets",
            api_v2_discovery_request,
            ___api_v2__.DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class HealthDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_health_check(
        self,
        health_check_request_or_endpoint_health_response_iterator: Union[
            AsyncIterable["HealthCheckRequestOrEndpointHealthResponse"],
            Iterable["HealthCheckRequestOrEndpointHealthResponse"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["HealthCheckSpecifier"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.HealthDiscoveryService/StreamHealthCheck",
            health_check_request_or_endpoint_health_response_iterator,
            HealthCheckRequestOrEndpointHealthResponse,
            HealthCheckSpecifier,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_health_check(
        self,
        health_check_request_or_endpoint_health_response: "HealthCheckRequestOrEndpointHealthResponse",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "HealthCheckSpecifier":
        return await self._unary_unary(
            "/envoy.service.discovery.v2.HealthDiscoveryService/FetchHealthCheck",
            health_check_request_or_endpoint_health_response,
            HealthCheckSpecifier,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class AggregatedDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_aggregated_resources(
        self,
        api_v2_discovery_request_iterator: Union[
            AsyncIterable["___api_v2__.DiscoveryRequest"],
            Iterable["___api_v2__.DiscoveryRequest"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["___api_v2__.DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.AggregatedDiscoveryService/StreamAggregatedResources",
            api_v2_discovery_request_iterator,
            ___api_v2__.DiscoveryRequest,
            ___api_v2__.DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def delta_aggregated_resources(
        self,
        api_v2_delta_discovery_request_iterator: Union[
            AsyncIterable["___api_v2__.DeltaDiscoveryRequest"],
            Iterable["___api_v2__.DeltaDiscoveryRequest"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["___api_v2__.DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.AggregatedDiscoveryService/DeltaAggregatedResources",
            api_v2_delta_discovery_request_iterator,
            ___api_v2__.DeltaDiscoveryRequest,
            ___api_v2__.DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class RuntimeDiscoveryServiceStub(betterproto.ServiceStub):
    async def stream_runtime(
        self,
        api_v2_discovery_request_iterator: Union[
            AsyncIterable["___api_v2__.DiscoveryRequest"],
            Iterable["___api_v2__.DiscoveryRequest"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["___api_v2__.DiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/StreamRuntime",
            api_v2_discovery_request_iterator,
            ___api_v2__.DiscoveryRequest,
            ___api_v2__.DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def delta_runtime(
        self,
        api_v2_delta_discovery_request_iterator: Union[
            AsyncIterable["___api_v2__.DeltaDiscoveryRequest"],
            Iterable["___api_v2__.DeltaDiscoveryRequest"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator["___api_v2__.DeltaDiscoveryResponse"]:
        async for response in self._stream_stream(
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/DeltaRuntime",
            api_v2_delta_discovery_request_iterator,
            ___api_v2__.DeltaDiscoveryRequest,
            ___api_v2__.DeltaDiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def fetch_runtime(
        self,
        api_v2_discovery_request: "___api_v2__.DiscoveryRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "___api_v2__.DiscoveryResponse":
        return await self._unary_unary(
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/FetchRuntime",
            api_v2_discovery_request,
            ___api_v2__.DiscoveryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class SecretDiscoveryServiceBase(ServiceBase):
    async def delta_secrets(
        self,
        api_v2_delta_discovery_request_iterator: AsyncIterator[
            "___api_v2__.DeltaDiscoveryRequest"
        ],
    ) -> AsyncIterator["___api_v2__.DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stream_secrets(
        self,
        api_v2_discovery_request_iterator: AsyncIterator[
            "___api_v2__.DiscoveryRequest"
        ],
    ) -> AsyncIterator["___api_v2__.DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_secrets(
        self, api_v2_discovery_request: "___api_v2__.DiscoveryRequest"
    ) -> "___api_v2__.DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_delta_secrets(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DeltaDiscoveryRequest, ___api_v2__.DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_secrets,
            stream,
            request,
        )

    async def __rpc_stream_secrets(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DiscoveryRequest, ___api_v2__.DiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_secrets,
            stream,
            request,
        )

    async def __rpc_fetch_secrets(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DiscoveryRequest, ___api_v2__.DiscoveryResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_secrets(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.discovery.v2.SecretDiscoveryService/DeltaSecrets": grpclib.const.Handler(
                self.__rpc_delta_secrets,
                grpclib.const.Cardinality.STREAM_STREAM,
                ___api_v2__.DeltaDiscoveryRequest,
                ___api_v2__.DeltaDiscoveryResponse,
            ),
            "/envoy.service.discovery.v2.SecretDiscoveryService/StreamSecrets": grpclib.const.Handler(
                self.__rpc_stream_secrets,
                grpclib.const.Cardinality.STREAM_STREAM,
                ___api_v2__.DiscoveryRequest,
                ___api_v2__.DiscoveryResponse,
            ),
            "/envoy.service.discovery.v2.SecretDiscoveryService/FetchSecrets": grpclib.const.Handler(
                self.__rpc_fetch_secrets,
                grpclib.const.Cardinality.UNARY_UNARY,
                ___api_v2__.DiscoveryRequest,
                ___api_v2__.DiscoveryResponse,
            ),
        }


class HealthDiscoveryServiceBase(ServiceBase):
    async def stream_health_check(
        self,
        health_check_request_or_endpoint_health_response_iterator: AsyncIterator[
            "HealthCheckRequestOrEndpointHealthResponse"
        ],
    ) -> AsyncIterator["HealthCheckSpecifier"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_health_check(
        self,
        health_check_request_or_endpoint_health_response: "HealthCheckRequestOrEndpointHealthResponse",
    ) -> "HealthCheckSpecifier":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_health_check(
        self,
        stream: "grpclib.server.Stream[HealthCheckRequestOrEndpointHealthResponse, HealthCheckSpecifier]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_health_check,
            stream,
            request,
        )

    async def __rpc_fetch_health_check(
        self,
        stream: "grpclib.server.Stream[HealthCheckRequestOrEndpointHealthResponse, HealthCheckSpecifier]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_health_check(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.discovery.v2.HealthDiscoveryService/StreamHealthCheck": grpclib.const.Handler(
                self.__rpc_stream_health_check,
                grpclib.const.Cardinality.STREAM_STREAM,
                HealthCheckRequestOrEndpointHealthResponse,
                HealthCheckSpecifier,
            ),
            "/envoy.service.discovery.v2.HealthDiscoveryService/FetchHealthCheck": grpclib.const.Handler(
                self.__rpc_fetch_health_check,
                grpclib.const.Cardinality.UNARY_UNARY,
                HealthCheckRequestOrEndpointHealthResponse,
                HealthCheckSpecifier,
            ),
        }


class AggregatedDiscoveryServiceBase(ServiceBase):
    async def stream_aggregated_resources(
        self,
        api_v2_discovery_request_iterator: AsyncIterator[
            "___api_v2__.DiscoveryRequest"
        ],
    ) -> AsyncIterator["___api_v2__.DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_aggregated_resources(
        self,
        api_v2_delta_discovery_request_iterator: AsyncIterator[
            "___api_v2__.DeltaDiscoveryRequest"
        ],
    ) -> AsyncIterator["___api_v2__.DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_aggregated_resources(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DiscoveryRequest, ___api_v2__.DiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_aggregated_resources,
            stream,
            request,
        )

    async def __rpc_delta_aggregated_resources(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DeltaDiscoveryRequest, ___api_v2__.DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_aggregated_resources,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.discovery.v2.AggregatedDiscoveryService/StreamAggregatedResources": grpclib.const.Handler(
                self.__rpc_stream_aggregated_resources,
                grpclib.const.Cardinality.STREAM_STREAM,
                ___api_v2__.DiscoveryRequest,
                ___api_v2__.DiscoveryResponse,
            ),
            "/envoy.service.discovery.v2.AggregatedDiscoveryService/DeltaAggregatedResources": grpclib.const.Handler(
                self.__rpc_delta_aggregated_resources,
                grpclib.const.Cardinality.STREAM_STREAM,
                ___api_v2__.DeltaDiscoveryRequest,
                ___api_v2__.DeltaDiscoveryResponse,
            ),
        }


class RuntimeDiscoveryServiceBase(ServiceBase):
    async def stream_runtime(
        self,
        api_v2_discovery_request_iterator: AsyncIterator[
            "___api_v2__.DiscoveryRequest"
        ],
    ) -> AsyncIterator["___api_v2__.DiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delta_runtime(
        self,
        api_v2_delta_discovery_request_iterator: AsyncIterator[
            "___api_v2__.DeltaDiscoveryRequest"
        ],
    ) -> AsyncIterator["___api_v2__.DeltaDiscoveryResponse"]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fetch_runtime(
        self, api_v2_discovery_request: "___api_v2__.DiscoveryRequest"
    ) -> "___api_v2__.DiscoveryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_runtime(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DiscoveryRequest, ___api_v2__.DiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.stream_runtime,
            stream,
            request,
        )

    async def __rpc_delta_runtime(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DeltaDiscoveryRequest, ___api_v2__.DeltaDiscoveryResponse]",
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.delta_runtime,
            stream,
            request,
        )

    async def __rpc_fetch_runtime(
        self,
        stream: "grpclib.server.Stream[___api_v2__.DiscoveryRequest, ___api_v2__.DiscoveryResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.fetch_runtime(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/StreamRuntime": grpclib.const.Handler(
                self.__rpc_stream_runtime,
                grpclib.const.Cardinality.STREAM_STREAM,
                ___api_v2__.DiscoveryRequest,
                ___api_v2__.DiscoveryResponse,
            ),
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/DeltaRuntime": grpclib.const.Handler(
                self.__rpc_delta_runtime,
                grpclib.const.Cardinality.STREAM_STREAM,
                ___api_v2__.DeltaDiscoveryRequest,
                ___api_v2__.DeltaDiscoveryResponse,
            ),
            "/envoy.service.discovery.v2.RuntimeDiscoveryService/FetchRuntime": grpclib.const.Handler(
                self.__rpc_fetch_runtime,
                grpclib.const.Cardinality.UNARY_UNARY,
                ___api_v2__.DiscoveryRequest,
                ___api_v2__.DiscoveryResponse,
            ),
        }
