# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/auth/v2/attribute_context.proto, envoy/service/auth/v2/external_auth.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .....google import rpc as ____google_rpc__
from .... import type as ___type__
from ....api.v2 import core as ___api_v2_core__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class AttributeContext(betterproto.Message):
    """
    An attribute is a piece of metadata that describes an activity on a
    network. For example, the size of an HTTP request, or the status code of an
    HTTP response. Each attribute has a type and a name, which is logically
    defined as a proto message field of the `AttributeContext`. The
    `AttributeContext` is a collection of individual attributes supported by
    Envoy authorization system. [#comment: The following items are left out of
    this proto Request.Auth field for jwt tokens Request.Api for api management
    Origin peer that originated the request Caching Protocol request_context
    return values to inject back into the filter chain peer.claims -- from
    X.509 extensions Configuration - field mask to send - which return values
    from request_context are copied back - which return values are copied into
    request_headers] [#next-free-field: 12]
    """

    source: "AttributeContextPeer" = betterproto.message_field(1)
    """
    The source of a network activity, such as starting a TCP connection. In a
    multi hop network activity, the source represents the sender of the last
    hop.
    """

    destination: "AttributeContextPeer" = betterproto.message_field(2)
    """
    The destination of a network activity, such as accepting a TCP connection.
    In a multi hop network activity, the destination represents the receiver of
    the last hop.
    """

    request: "AttributeContextRequest" = betterproto.message_field(4)
    """Represents a network request, such as an HTTP request."""

    context_extensions: Dict[str, str] = betterproto.map_field(
        10, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    This is analogous to http_request.headers, however these contents will not
    be sent to the upstream server. Context_extensions provide an extension
    mechanism for sending additional information to the auth server without
    modifying the proto definition. It maps to the internal opaque context in
    the filter chain.
    """

    metadata_context: "___api_v2_core__.Metadata" = betterproto.message_field(11)
    """Dynamic metadata associated with the request."""


@dataclass(eq=False, repr=False)
class AttributeContextPeer(betterproto.Message):
    """
    This message defines attributes for a node that handles a network request.
    The node can be either a service or an application that sends, forwards, or
    receives the request. Service peers should fill in the `service`,
    `principal`, and `labels` as appropriate. [#next-free-field: 6]
    """

    address: "___api_v2_core__.Address" = betterproto.message_field(1)
    """
    The address of the peer, this is typically the IP address. It can also be
    UDS path, or others.
    """

    service: str = betterproto.string_field(2)
    """
    The canonical service name of the peer. It should be set to :ref:`the HTTP
    x-envoy-downstream-service-cluster
    <config_http_conn_man_headers_downstream-service-cluster>` If a more
    trusted source of the service name is available through mTLS/secure naming,
    it should be used.
    """

    labels: Dict[str, str] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    The labels associated with the peer. These could be pod labels for
    Kubernetes or tags for VMs. The source of the labels could be an X.509
    certificate or other configuration.
    """

    principal: str = betterproto.string_field(4)
    """
    The authenticated identity of this peer. For example, the identity
    associated with the workload such as a service account. If an X.509
    certificate is used to assert the identity this field should be sourced
    from `URI Subject Alternative Names`, `DNS Subject Alternate Names` or
    `Subject` in that order. The primary identity should be the principal. The
    principal format is issuer specific. Example: *    SPIFFE format is
    `spiffe://trust-domain/path` *    Google account format is
    `https://accounts.google.com/{userid}`
    """

    certificate: str = betterproto.string_field(5)
    """
    The X.509 certificate used to authenticate the identify of this peer. When
    present, the certificate contents are encoded in URL and PEM format.
    """


@dataclass(eq=False, repr=False)
class AttributeContextRequest(betterproto.Message):
    """Represents a network request, such as an HTTP request."""

    time: datetime = betterproto.message_field(1)
    """The timestamp when the proxy receives the first byte of the request."""

    http: "AttributeContextHttpRequest" = betterproto.message_field(2)
    """Represents an HTTP request or an HTTP-like request."""


@dataclass(eq=False, repr=False)
class AttributeContextHttpRequest(betterproto.Message):
    """
    This message defines attributes for an HTTP request. HTTP/1.x, HTTP/2, gRPC
    are all considered as HTTP requests. [#next-free-field: 12]
    """

    id: str = betterproto.string_field(1)
    """
    The unique ID for a request, which can be propagated to downstream systems.
    The ID should have low probability of collision within a single day for a
    specific service. For HTTP requests, it should be X-Request-ID or
    equivalent.
    """

    method: str = betterproto.string_field(2)
    """The HTTP request method, such as `GET`, `POST`."""

    headers: Dict[str, str] = betterproto.map_field(
        3, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    The HTTP request headers. If multiple headers share the same key, they must
    be merged according to the HTTP spec. All header keys must be lower-cased,
    because HTTP header keys are case-insensitive.
    """

    path: str = betterproto.string_field(4)
    """
    The request target, as it appears in the first line of the HTTP request.
    This includes the URL path and query-string. No decoding is performed.
    """

    host: str = betterproto.string_field(5)
    """The HTTP request `Host` or 'Authority` header value."""

    scheme: str = betterproto.string_field(6)
    """
    The HTTP URL scheme, such as `http` and `https`. This is set for HTTP/2
    requests only. For HTTP/1.1, use "x-forwarded-for" header value to lookup
    the scheme of the request.
    """

    query: str = betterproto.string_field(7)
    """
    This field is always empty, and exists for compatibility reasons. The HTTP
    URL query is included in `path` field.
    """

    fragment: str = betterproto.string_field(8)
    """
    This field is always empty, and exists for compatibility reasons. The URL
    fragment is not submitted as part of HTTP requests; it is unknowable.
    """

    size: int = betterproto.int64_field(9)
    """The HTTP request size in bytes. If unknown, it must be -1."""

    protocol: str = betterproto.string_field(10)
    """
    The network protocol used with the request, such as "HTTP/1.0", "HTTP/1.1",
    or "HTTP/2". See :repo:`headers.h:ProtocolStrings
    <source/common/http/headers.h>` for a list of all possible values.
    """

    body: str = betterproto.string_field(11)
    """The HTTP request body."""


@dataclass(eq=False, repr=False)
class CheckRequest(betterproto.Message):
    attributes: "AttributeContext" = betterproto.message_field(1)
    """The request attributes."""


@dataclass(eq=False, repr=False)
class DeniedHttpResponse(betterproto.Message):
    """HTTP attributes for a denied response."""

    status: "___type__.HttpStatus" = betterproto.message_field(1)
    """
    This field allows the authorization service to send a HTTP response status
    code to the downstream client other than 403 (Forbidden).
    """

    headers: List["___api_v2_core__.HeaderValueOption"] = betterproto.message_field(2)
    """
    This field allows the authorization service to send HTTP response headers
    to the downstream client. Note that the `append` field in
    `HeaderValueOption` defaults to false when used in this message.
    """

    body: str = betterproto.string_field(3)
    """
    This field allows the authorization service to send a response body data to
    the downstream client.
    """


@dataclass(eq=False, repr=False)
class OkHttpResponse(betterproto.Message):
    """HTTP attributes for an ok response."""

    headers: List["___api_v2_core__.HeaderValueOption"] = betterproto.message_field(2)
    """
    HTTP entity headers in addition to the original request headers. This
    allows the authorization service to append, to add or to override headers
    from the original request before dispatching it to the upstream. Note that
    the `append` field in `HeaderValueOption` defaults to false when used in
    this message. By setting the `append` field to `true`, the filter will
    append the correspondent header value to the matched request header. By
    leaving `append` as false, the filter will either add a new header, or
    override an existing one if there is a match.
    """


@dataclass(eq=False, repr=False)
class CheckResponse(betterproto.Message):
    """Intended for gRPC and Network Authorization servers `only`."""

    status: "____google_rpc__.Status" = betterproto.message_field(1)
    """
    Status `OK` allows the request. Any other status indicates the request
    should be denied.
    """

    denied_response: "DeniedHttpResponse" = betterproto.message_field(
        2, group="http_response"
    )
    """Supplies http attributes for a denied response."""

    ok_response: "OkHttpResponse" = betterproto.message_field(3, group="http_response")
    """Supplies http attributes for an ok response."""


class AuthorizationStub(betterproto.ServiceStub):
    async def check(
        self,
        check_request: "CheckRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CheckResponse":
        return await self._unary_unary(
            "/envoy.service.auth.v2.Authorization/Check",
            check_request,
            CheckResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class AuthorizationBase(ServiceBase):
    async def check(self, check_request: "CheckRequest") -> "CheckResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_check(
        self, stream: "grpclib.server.Stream[CheckRequest, CheckResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.check(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.auth.v2.Authorization/Check": grpclib.const.Handler(
                self.__rpc_check,
                grpclib.const.Cardinality.UNARY_UNARY,
                CheckRequest,
                CheckResponse,
            ),
        }
