# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/service/accesslog/v2/als.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ....api.v2 import core as ___api_v2_core__
from ....data.accesslog import v2 as ___data_accesslog_v2__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class StreamAccessLogsResponse(betterproto.Message):
    """
    Empty response for the StreamAccessLogs API. Will never be sent. See below.
    """

    pass


@dataclass(eq=False, repr=False)
class StreamAccessLogsMessage(betterproto.Message):
    """
    Stream message for the StreamAccessLogs API. Envoy will open a stream to
    the server and stream access logs without ever expecting a response.
    """

    identifier: "StreamAccessLogsMessageIdentifier" = betterproto.message_field(1)
    """
    Identifier data that will only be sent in the first message on the stream.
    This is effectively structured metadata and is a performance optimization.
    """

    http_logs: "StreamAccessLogsMessageHttpAccessLogEntries" = (
        betterproto.message_field(2, group="log_entries")
    )
    tcp_logs: "StreamAccessLogsMessageTcpAccessLogEntries" = betterproto.message_field(
        3, group="log_entries"
    )


@dataclass(eq=False, repr=False)
class StreamAccessLogsMessageIdentifier(betterproto.Message):
    node: "___api_v2_core__.Node" = betterproto.message_field(1)
    """The node sending the access log messages over the stream."""

    log_name: str = betterproto.string_field(2)
    """
    The friendly name of the log configured in :ref:`CommonGrpcAccessLogConfig
    <envoy_api_msg_config.accesslog.v2.CommonGrpcAccessLogConfig>`.
    """


@dataclass(eq=False, repr=False)
class StreamAccessLogsMessageHttpAccessLogEntries(betterproto.Message):
    """Wrapper for batches of HTTP access log entries."""

    log_entry: List[
        "___data_accesslog_v2__.HttpAccessLogEntry"
    ] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class StreamAccessLogsMessageTcpAccessLogEntries(betterproto.Message):
    """Wrapper for batches of TCP access log entries."""

    log_entry: List[
        "___data_accesslog_v2__.TcpAccessLogEntry"
    ] = betterproto.message_field(1)


class AccessLogServiceStub(betterproto.ServiceStub):
    async def stream_access_logs(
        self,
        stream_access_logs_message_iterator: Union[
            AsyncIterable["StreamAccessLogsMessage"],
            Iterable["StreamAccessLogsMessage"],
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "StreamAccessLogsResponse":
        return await self._stream_unary(
            "/envoy.service.accesslog.v2.AccessLogService/StreamAccessLogs",
            stream_access_logs_message_iterator,
            StreamAccessLogsMessage,
            StreamAccessLogsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class AccessLogServiceBase(ServiceBase):
    async def stream_access_logs(
        self,
        stream_access_logs_message_iterator: AsyncIterator["StreamAccessLogsMessage"],
    ) -> "StreamAccessLogsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_stream_access_logs(
        self,
        stream: "grpclib.server.Stream[StreamAccessLogsMessage, StreamAccessLogsResponse]",
    ) -> None:
        request = stream.__aiter__()
        response = await self.stream_access_logs(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/envoy.service.accesslog.v2.AccessLogService/StreamAccessLogs": grpclib.const.Handler(
                self.__rpc_stream_access_logs,
                grpclib.const.Cardinality.STREAM_UNARY,
                StreamAccessLogsMessage,
                StreamAccessLogsResponse,
            ),
        }
