# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/wasm/v3/wasm.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    Dict,
    List,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ....config.core import v3 as ___config_core_v3__


@dataclass(eq=False, repr=False)
class CapabilityRestrictionConfig(betterproto.Message):
    """
    Configuration for restricting Proxy-Wasm capabilities available to modules.
    """

    allowed_capabilities: Dict[str, "SanitizationConfig"] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    The Proxy-Wasm capabilities which will be allowed. Capabilities are mapped
    by name. The ``SanitizationConfig`` which each capability maps to is
    currently unimplemented and ignored, and so should be left empty. The
    capability names are given in the `Proxy-Wasm ABI
    <https://github.com/proxy-wasm/spec/tree/master/abi-versions/vNEXT>`_.
    Additionally, the following WASI capabilities from `this list <https://gith
    ub.com/WebAssembly/WASI/blob/master/phases/snapshot/docs.md#modules>`_ are
    implemented and can be allowed: ``fd_write``, ``fd_read``, ``fd_seek``,
    ``fd_close``, ``fd_fdstat_get``, ``environ_get``, ``environ_sizes_get``,
    ``args_get``, ``args_sizes_get``, ``proc_exit``, ``clock_time_get``,
    ``random_get``.
    """


@dataclass(eq=False, repr=False)
class SanitizationConfig(betterproto.Message):
    """
    Configuration for sanitization of inputs to an allowed capability. NOTE:
    This is currently unimplemented.
    """

    pass


@dataclass(eq=False, repr=False)
class VmConfig(betterproto.Message):
    """Configuration for a Wasm VM. [#next-free-field: 8]"""

    vm_id: str = betterproto.string_field(1)
    """
    An ID which will be used along with a hash of the wasm code (or the name of
    the registered Null VM plugin) to determine which VM will be used for the
    plugin. All plugins which use the same ``vm_id`` and code will use the same
    VM. May be left blank. Sharing a VM between plugins can reduce memory
    utilization and make sharing of data easier which may have security
    implications. [#comment: TODO: add ref for details.]
    """

    runtime: str = betterproto.string_field(2)
    """
    The Wasm runtime type, defaults to the first available Wasm engine used at
    Envoy build-time. The priority to search for the available engine is: v8 ->
    wasmtime -> wamr -> wavm. Available Wasm runtime types are registered as
    extensions. The following runtimes are included in Envoy code base: ..
    _extension_envoy.wasm.runtime.null: **envoy.wasm.runtime.null**: Null
    sandbox, the Wasm module must be compiled and linked into the Envoy binary.
    The registered name is given in the ``code`` field as ``inline_string``. ..
    _extension_envoy.wasm.runtime.v8: **envoy.wasm.runtime.v8**: `V8
    <https://v8.dev/>`_-based WebAssembly runtime. ..
    _extension_envoy.wasm.runtime.wamr: **envoy.wasm.runtime.wamr**: `WAMR
    <https://github.com/bytecodealliance/wasm-micro-runtime/>`_-based
    WebAssembly runtime. This runtime is not enabled in the official build. ..
    _extension_envoy.wasm.runtime.wavm: **envoy.wasm.runtime.wavm**: `WAVM
    <https://wavm.github.io/>`_-based WebAssembly runtime. This runtime is not
    enabled in the official build. .. _extension_envoy.wasm.runtime.wasmtime:
    **envoy.wasm.runtime.wasmtime**: `Wasmtime <https://wasmtime.dev/>`_-based
    WebAssembly runtime. This runtime is not enabled in the official build.
    [#extension-category: envoy.wasm.runtime]
    """

    code: "___config_core_v3__.AsyncDataSource" = betterproto.message_field(3)
    """The Wasm code that Envoy will execute."""

    configuration: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(4)
    """
    The Wasm configuration used in initialization of a new VM (proxy_on_start).
    ``google.protobuf.Struct`` is serialized as JSON before passing it to the
    plugin. ``google.protobuf.BytesValue`` and ``google.protobuf.StringValue``
    are passed directly without the wrapper.
    """

    allow_precompiled: bool = betterproto.bool_field(5)
    """
    Allow the wasm file to include pre-compiled code on VMs which support it.
    Warning: this should only be enable for trusted sources as the precompiled
    code is not verified.
    """

    nack_on_code_cache_miss: bool = betterproto.bool_field(6)
    """
    If true and the code needs to be remotely fetched and it is not in the
    cache then NACK the configuration update and do a background fetch to fill
    the cache, otherwise fetch the code asynchronously and enter warming state.
    """

    environment_variables: "EnvironmentVariables" = betterproto.message_field(7)
    """
    Specifies environment variables to be injected to this VM which will be
    available through WASI's ``environ_get`` and ``environ_get_sizes`` system
    calls. Note that these functions are mostly implicitly called in your
    language's standard library, so you do not need to call them directly and
    you can access to env vars just like when you do on native platforms.
    Warning: Envoy rejects the configuration if there's conflict of key space.
    """


@dataclass(eq=False, repr=False)
class EnvironmentVariables(betterproto.Message):
    host_env_keys: List[str] = betterproto.string_field(1)
    """
    The keys of *Envoy's* environment variables exposed to this VM. In other
    words, if a key exists in Envoy's environment variables, then that key-
    value pair will be injected. Note that if a key does not exist, it will be
    ignored.
    """

    key_values: Dict[str, str] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    Explicitly given key-value pairs to be injected to this VM in the form of
    "KEY=VALUE".
    """


@dataclass(eq=False, repr=False)
class PluginConfig(betterproto.Message):
    """
    Base Configuration for Wasm Plugins e.g. filters and services. [#next-free-
    field: 7]
    """

    name: str = betterproto.string_field(1)
    """
    A unique name for a filters/services in a VM for use in identifying the
    filter/service if multiple filters/services are handled by the same
    ``vm_id`` and ``root_id`` and for logging/debugging.
    """

    root_id: str = betterproto.string_field(2)
    """
    A unique ID for a set of filters/services in a VM which will share a
    RootContext and Contexts if applicable (e.g. an Wasm HttpFilter and an Wasm
    AccessLog). If left blank, all filters/services with a blank root_id with
    the same ``vm_id`` will share Context(s).
    """

    vm_config: "VmConfig" = betterproto.message_field(3, group="vm")
    configuration: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(4)
    """
    Filter/service configuration used to configure or reconfigure a plugin
    (``proxy_on_configure``). ``google.protobuf.Struct`` is serialized as JSON
    before passing it to the plugin. ``google.protobuf.BytesValue`` and
    ``google.protobuf.StringValue`` are passed directly without the wrapper.
    """

    fail_open: bool = betterproto.bool_field(5)
    """
    If there is a fatal error on the VM (e.g. exception, abort(), on_start or
    on_configure return false), then all plugins associated with the VM will
    either fail closed (by default), e.g. by returning an HTTP 503 error, or
    fail open (if 'fail_open' is set to true) by bypassing the filter. Note:
    when on_start or on_configure return false during xDS updates the xDS
    configuration will be rejected and when on_start or on_configuration return
    false on initial startup the proxy will not start.
    """

    capability_restriction_config: "CapabilityRestrictionConfig" = (
        betterproto.message_field(6)
    )
    """
    Configuration for restricting Proxy-Wasm capabilities available to modules.
    """


@dataclass(eq=False, repr=False)
class WasmService(betterproto.Message):
    """
    WasmService is configured as a built-in ``envoy.wasm_service``
    :ref:`WasmService <config_wasm_service>` This opaque configuration will be
    used to create a Wasm Service.
    """

    config: "PluginConfig" = betterproto.message_field(1)
    """General plugin configuration."""

    singleton: bool = betterproto.bool_field(2)
    """
    If true, create a single VM rather than creating one VM per worker. Such a
    singleton can not be used with filters.
    """
