# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import Optional

import betterproto

from ...common import v3 as __common_v3__


class RingHashHashFunction(betterproto.Enum):
    """The hash function used to hash hosts onto the ketama ring."""

    DEFAULT_HASH = 0
    """Currently defaults to XX_HASH."""

    XX_HASH = 1
    """Use `xxHash <https://github.com/Cyan4973/xxHash>`_."""

    MURMUR_HASH_2 = 2
    """
    Use `MurmurHash2 <https://sites.google.com/site/murmurhash/>`_, this is
    compatible with std:hash<string> in GNU libstdc++ 3.4.20 or above. This is
    typically the case when compiled on Linux and not macOS.
    """


@dataclass(eq=False, repr=False)
class RingHash(betterproto.Message):
    """
    This configuration allows the built-in RING_HASH LB policy to be configured
    via the LB policy extension point. See the :ref:`load balancing
    architecture overview <arch_overview_load_balancing_types>` for more
    information. [#next-free-field: 7]
    """

    hash_function: "RingHashHashFunction" = betterproto.enum_field(1)
    """
    The hash function used to hash hosts onto the ketama ring. The value
    defaults to :ref:`XX_HASH<envoy_v3_api_enum_value_config.cluster.v3.Cluster
    .RingHashLbConfig.HashFunction.XX_HASH>`.
    """

    minimum_ring_size: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT64
    )
    """
    Minimum hash ring size. The larger the ring is (that is, the more hashes
    there are for each provided host) the better the request distribution will
    reflect the desired weights. Defaults to 1024 entries, and limited to 8M
    entries. See also :ref:`maximum_ring_size<envoy_v3_api_field_config.cluster
    .v3.Cluster.RingHashLbConfig.maximum_ring_size>`.
    """

    maximum_ring_size: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT64
    )
    """
    Maximum hash ring size. Defaults to 8M entries, and limited to 8M entries,
    but can be lowered to further constrain resource use. See also :ref:`minimu
    m_ring_size<envoy_v3_api_field_config.cluster.v3.Cluster.RingHashLbConfig.m
    inimum_ring_size>`.
    """

    use_hostname_for_hashing: bool = betterproto.bool_field(4)
    """
    If set to `true`, the cluster will use hostname instead of the resolved
    address as the key to consistently hash to an upstream host. Only valid for
    StrictDNS clusters with hostnames which resolve to a single IP address.
    ..note::   This is deprecated and please use
    :ref:`consistent_hashing_lb_config   <envoy_v3_api_field_extensions.load_ba
    lancing_policies.ring_hash.v3.RingHash.consistent_hashing_lb_config>`
    instead.
    """

    hash_balance_factor: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT32
    )
    """
    Configures percentage of average cluster load to bound per upstream host.
    For example, with a value of 150 no upstream host will get a load more than
    1.5 times the average load of all the hosts in the cluster. If not
    specified, the load is not bounded for any upstream host. Typical value for
    this parameter is between 120 and 200. Minimum is 100. This is implemented
    based on the method described in the paper
    https://arxiv.org/abs/1608.01350. For the specified `hash_balance_factor`,
    requests to any upstream host are capped at `hash_balance_factor/100` times
    the average number of requests across the cluster. When a request arrives
    for an upstream host that is currently serving at its max capacity, linear
    probing is used to identify an eligible host. Further, the linear probe is
    implemented using a random jump in hosts ring/table to identify the
    eligible host (this technique is as described in the paper
    https://arxiv.org/abs/1908.08762 - the random jump avoids the cascading
    overflow effect when choosing the next host in the ring/table). If weights
    are specified on the hosts, they are respected. This is an O(N) algorithm,
    unlike other load balancers. Using a lower `hash_balance_factor` results in
    more hosts being probed, so use a higher value if you require better
    performance. ..note::   This is deprecated and please use
    :ref:`consistent_hashing_lb_config   <envoy_v3_api_field_extensions.load_ba
    lancing_policies.ring_hash.v3.RingHash.consistent_hashing_lb_config>`
    instead.
    """

    consistent_hashing_lb_config: "__common_v3__.ConsistentHashingLbConfig" = (
        betterproto.message_field(6)
    )
    """Common configuration for hashing-based load balancing policies."""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("use_hostname_for_hashing"):
            warnings.warn(
                "RingHash.use_hostname_for_hashing is deprecated", DeprecationWarning
            )
        if self.is_set("hash_balance_factor"):
            warnings.warn(
                "RingHash.hash_balance_factor is deprecated", DeprecationWarning
            )
