# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import Optional

import betterproto


@dataclass(eq=False, repr=False)
class ClientSideWeightedRoundRobin(betterproto.Message):
    """
    Configuration for the client_side_weighted_round_robin LB policy. This
    policy differs from the built-in ROUND_ROBIN policy in terms of how the
    endpoint weights are determined. In the ROUND_ROBIN policy, the endpoint
    weights are sent by the control plane via EDS. However, in this policy, the
    endpoint weights are instead determined via qps and CPU utilization metrics
    sent by the endpoint using the Open Request Cost Aggregation (ORCA)
    protocol. The weight of a given endpoint is computed as qps /
    cpu_utilization. See the :ref:`load balancing architecture
    overview<arch_overview_load_balancing_types>` for more information. [#next-
    free-field: 6]
    """

    enable_oob_load_report: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether to enable out-of-band utilization reporting collection from the
    endpoints. By default, per-request utilization reporting is used.
    """

    oob_reporting_period: timedelta = betterproto.message_field(2)
    """
    Load reporting interval to request from the server. Note that the server
    may not provide reports as frequently as the client requests. Used only
    when enable_oob_load_report is true. Default is 10 seconds.
    """

    blackout_period: timedelta = betterproto.message_field(3)
    """
    A given endpoint must report load metrics continuously for at least this
    long before the endpoint weight will be used. This avoids churn when the
    set of endpoint addresses changes. Takes effect both immediately after we
    establish a connection to an endpoint and after weight_expiration_period
    has caused us to stop using the most recent load metrics. Default is 10
    seconds.
    """

    weight_expiration_period: timedelta = betterproto.message_field(4)
    """
    If a given endpoint has not reported load metrics in this long, then we
    stop using the reported weight. This ensures that we do not continue to use
    very stale weights. Once we stop using a stale value, if we later start
    seeing fresh reports again, the blackout_period applies. Defaults to 3
    minutes.
    """

    weight_update_period: timedelta = betterproto.message_field(5)
    """How often endpoint weights are recalculated.  Default is 1 second."""
