# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/http/cache/file_system_http_cache/v3/file_system_http_cache.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import Optional

import betterproto

from .....common.async_files import v3 as ____common_async_files_v3__


@dataclass(eq=False, repr=False)
class FileSystemHttpCacheConfig(betterproto.Message):
    """
    Configuration for a cache implementation that caches in the local file
    system. By default this cache uses a least-recently-used eviction strategy.
    [#next-free-field: 7]
    """

    manager_config: "____common_async_files_v3__.AsyncFileManagerConfig" = (
        betterproto.message_field(1)
    )
    """
    Configuration of a manager for how the file system is used asynchronously.
    """

    cache_path: str = betterproto.string_field(2)
    """
    Path at which the cache files will be stored. This also doubles as the
    unique identifier for a cache, so a cache can be shared between different
    routes, or separate paths can be used to specify separate caches. If the
    same ``cache_path`` is used in more than one ``CacheConfig``, the rest of
    the ``FileSystemHttpCacheConfig`` must also match, and will refer to the
    same cache instance.
    """

    max_cache_size_bytes: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT64
    )
    """
    The maximum size of the cache in bytes - when reached, another entry is
    removed. This is measured as the sum of file sizes, such that it includes
    headers, trailers, and metadata, but does not include e.g. file system
    overhead and block size padding. If unset there is no limit except file
    system failure. [#not-implemented-hide:]
    """

    max_cache_entry_size_bytes: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT64
    )
    """
    The maximum size of a cache entry in bytes - larger responses will not be
    cached. This is measured as the file size for the cache entry, such that it
    includes headers, trailers, and metadata. If unset there is no limit.
    [#not-implemented-hide:]
    """

    max_cache_entry_count: Optional[int] = betterproto.message_field(
        5, wraps=betterproto.TYPE_UINT64
    )
    """
    The maximum number of cache entries - when reached, another entry is
    removed. If unset there is no limit. [#not-implemented-hide:]
    """

    cache_subdivisions: int = betterproto.uint32_field(6)
    """
    A number of folders into which to subdivide the cache. Setting this can
    help with performance in file systems where a large number of inodes in a
    single branch degrades performance. The optimal value in that case would be
    ``sqrt(expected_cache_entry_count)``. On file systems that perform well
    with many inodes, the default value of 1 should be used. [#not-implemented-
    hide:]
    """
