# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/udp/dns_filter/v3/dns_filter.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto

from ......config.core import v3 as _____config_core_v3__
from ......data.dns import v3 as _____data_dns_v3__


@dataclass(eq=False, repr=False)
class DnsFilterConfig(betterproto.Message):
    """Configuration for the DNS filter."""

    stat_prefix: str = betterproto.string_field(1)
    """The stat prefix used when emitting DNS filter statistics"""

    server_config: "DnsFilterConfigServerContextConfig" = betterproto.message_field(2)
    """
    Server context configuration contains the data that the filter uses to
    respond to DNS requests.
    """

    client_config: "DnsFilterConfigClientContextConfig" = betterproto.message_field(3)
    """
    Client context configuration controls Envoy's behavior when it must use
    external resolvers to answer a query. This object is optional and if
    omitted instructs the filter to resolve queries from the data in the
    server_config
    """


@dataclass(eq=False, repr=False)
class DnsFilterConfigServerContextConfig(betterproto.Message):
    """
    This message contains the configuration for the DNS Filter operating in a
    server context. This message will contain the virtual hosts and associated
    addresses with which Envoy will respond to queries
    """

    inline_dns_table: "_____data_dns_v3__.DnsTable" = betterproto.message_field(
        1, group="config_source"
    )
    """Load the configuration specified from the control plane"""

    external_dns_table: "_____config_core_v3__.DataSource" = betterproto.message_field(
        2, group="config_source"
    )
    """
    Seed the filter configuration from an external path. This source is a yaml
    formatted file that contains the DnsTable driving Envoy's responses to DNS
    queries
    """


@dataclass(eq=False, repr=False)
class DnsFilterConfigClientContextConfig(betterproto.Message):
    """
    This message contains the configuration for the DNS Filter operating in a
    client context. This message will contain the timeouts, retry, and
    forwarding configuration for Envoy to make DNS requests to other resolvers
    [#next-free-field: 6]
    """

    resolver_timeout: timedelta = betterproto.message_field(1)
    """
    Sets the maximum time we will wait for the upstream query to complete We
    allow 5s for the upstream resolution to complete, so the minimum value here
    is 1. Note that the total latency for a failed query is the number of
    retries multiplied by the resolver_timeout.
    """

    upstream_resolvers: List[
        "_____config_core_v3__.Address"
    ] = betterproto.message_field(2)
    """
    This field was used for `dns_resolution_config` in Envoy 1.19.0 and 1.19.1.
    Control planes that need to set this field for Envoy 1.19.0 and 1.19.1
    clients should fork the protobufs and change the field type to
    `DnsResolutionConfig`. Control planes that need to simultaneously support
    Envoy 1.18.x and Envoy 1.19.x should avoid Envoy 1.19.0 and 1.19.1. [#not-
    implemented-hide:]
    """

    dns_resolution_config: "_____config_core_v3__.DnsResolutionConfig" = (
        betterproto.message_field(5)
    )
    """
    DNS resolution configuration which includes the underlying dns resolver
    addresses and options. This field is deprecated in favor of
    :ref:`typed_dns_resolver_config <envoy_v3_api_field_extensions.filters.udp.
    dns_filter.v3.DnsFilterConfig.ClientContextConfig.typed_dns_resolver_config
    >`.
    """

    typed_dns_resolver_config: "_____config_core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(4)
    )
    """
    DNS resolver type configuration extension. This extension can be used to
    configure c-ares, apple, or any other DNS resolver types and the related
    parameters. For example, an object of :ref:`CaresDnsResolverConfig <envoy_v
    3_api_msg_extensions.network.dns_resolver.cares.v3.CaresDnsResolverConfig>`
    can be packed into this ``typed_dns_resolver_config``. This configuration
    replaces the :ref:`dns_resolution_config <envoy_v3_api_field_extensions.fil
    ters.udp.dns_filter.v3.DnsFilterConfig.ClientContextConfig.dns_resolution_c
    onfig>` configuration. During the transition period when both
    ``dns_resolution_config`` and ``typed_dns_resolver_config`` exists, when
    ``typed_dns_resolver_config`` is in place, Envoy will use it and ignore
    ``dns_resolution_config``. When ``typed_dns_resolver_config`` is missing,
    the default behavior is in place. [#extension-category:
    envoy.network.dns_resolver]
    """

    max_pending_lookups: int = betterproto.uint64_field(3)
    """
    Controls how many outstanding external lookup contexts the filter tracks.
    The context structure allows the filter to respond to every query even if
    the external resolution times out or is otherwise unsuccessful
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("upstream_resolvers"):
            warnings.warn(
                "DnsFilterConfigClientContextConfig.upstream_resolvers is deprecated",
                DeprecationWarning,
            )
        if self.is_set("dns_resolution_config"):
            warnings.warn(
                "DnsFilterConfigClientContextConfig.dns_resolution_config is deprecated",
                DeprecationWarning,
            )
