# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/network/thrift_proxy/v3/route.proto, envoy/extensions/filters/network/thrift_proxy/v3/thrift_proxy.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ......config.accesslog import v3 as _____config_accesslog_v3__
from ......config.core import v3 as _____config_core_v3__
from ......config.route import v3 as _____config_route_v3__


class TransportType(betterproto.Enum):
    """Thrift transport types supported by Envoy."""

    AUTO_TRANSPORT = 0
    """
    For downstream connections, the Thrift proxy will attempt to determine
    which transport to use. For upstream connections, the Thrift proxy will use
    same transport as the downstream connection.
    """

    FRAMED = 1
    """The Thrift proxy will use the Thrift framed transport."""

    UNFRAMED = 2
    """The Thrift proxy will use the Thrift unframed transport."""

    HEADER = 3
    """
    The Thrift proxy will assume the client is using the Thrift header
    transport.
    """


class ProtocolType(betterproto.Enum):
    """Thrift Protocol types supported by Envoy."""

    AUTO_PROTOCOL = 0
    """
    For downstream connections, the Thrift proxy will attempt to determine
    which protocol to use. Note that the older, non-strict (or lax) binary
    protocol is not included in automatic protocol detection. For upstream
    connections, the Thrift proxy will use the same protocol as the downstream
    connection.
    """

    BINARY = 1
    """The Thrift proxy will use the Thrift binary protocol."""

    LAX_BINARY = 2
    """The Thrift proxy will use Thrift non-strict binary protocol."""

    COMPACT = 3
    """The Thrift proxy will use the Thrift compact protocol."""

    TWITTER = 4
    """
    The Thrift proxy will use the Thrift "Twitter" protocol implemented by the
    finagle library.
    """


@dataclass(eq=False, repr=False)
class RouteConfiguration(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    The name of the route configuration. This name is used in asynchronous
    route discovery. For example, it might match :ref:`route_config_name <envoy
    _v3_api_field_extensions.filters.network.thrift_proxy.v3.Trds.route_config_
    name>` in
    :ref:`envoy_v3_api_msg_extensions.filters.network.thrift_proxy.v3.Trds`.
    """

    routes: List["Route"] = betterproto.message_field(2)
    """
    The list of routes that will be matched, in order, against incoming
    requests. The first route that matches will be used.
    """

    validate_clusters: Optional[bool] = betterproto.message_field(
        3, wraps=betterproto.TYPE_BOOL
    )
    """
    An optional boolean that specifies whether the clusters that the route
    table refers to will be validated by the cluster manager. If set to true
    and a route refers to a non-existent cluster, the route table will not
    load. If set to false and a route refers to a non-existent cluster, the
    route table will load and the router filter will return a INTERNAL_ERROR if
    the route is selected at runtime. This setting defaults to true if the
    route table is statically defined via the :ref:`route_config <envoy_v3_api_
    field_extensions.filters.network.thrift_proxy.v3.ThriftProxy.route_config>`
    option. This setting default to false if the route table is loaded
    dynamically via the :ref:`trds <envoy_v3_api_field_extensions.filters.netwo
    rk.thrift_proxy.v3.ThriftProxy.trds>` option. Users may wish to override
    the default behavior in certain cases (for example when using CDS with a
    static route table).
    """


@dataclass(eq=False, repr=False)
class Route(betterproto.Message):
    match: "RouteMatch" = betterproto.message_field(1)
    """Route matching parameters."""

    route: "RouteAction" = betterproto.message_field(2)
    """Route request to some upstream cluster."""


@dataclass(eq=False, repr=False)
class RouteMatch(betterproto.Message):
    method_name: str = betterproto.string_field(1, group="match_specifier")
    """
    If specified, the route must exactly match the request method name. As a
    special case, an empty string matches any request method name.
    """

    service_name: str = betterproto.string_field(2, group="match_specifier")
    """
    If specified, the route must have the service name as the request method
    name prefix. As a special case, an empty string matches any service name.
    Only relevant when service multiplexing.
    """

    invert: bool = betterproto.bool_field(3)
    """
    Inverts whatever matching is done in the :ref:`method_name <envoy_v3_api_fi
    eld_extensions.filters.network.thrift_proxy.v3.RouteMatch.method_name>` or
    :ref:`service_name <envoy_v3_api_field_extensions.filters.network.thrift_pr
    oxy.v3.RouteMatch.service_name>` fields. Cannot be combined with wildcard
    matching as that would result in routes never being matched. .. note::
    This does not invert matching done as part of the :ref:`headers field   <en
    voy_v3_api_field_extensions.filters.network.thrift_proxy.v3.RouteMatch.head
    ers>` field. To   invert header matching, see :ref:`invert_match
    <envoy_v3_api_field_config.route.v3.HeaderMatcher.invert_match>`.
    """

    headers: List["_____config_route_v3__.HeaderMatcher"] = betterproto.message_field(4)
    """
    Specifies a set of headers that the route should match on. The router will
    check the request’s headers against all the specified headers in the route
    config. A match will happen if all the headers in the route are present in
    the request with the same values (or based on presence if the value field
    is not in the config). Note that this only applies for Thrift transports
    and/or protocols that support headers.
    """


@dataclass(eq=False, repr=False)
class RouteAction(betterproto.Message):
    """[#next-free-field: 8]"""

    cluster: str = betterproto.string_field(1, group="cluster_specifier")
    """
    Indicates a single upstream cluster to which the request should be routed
    to.
    """

    weighted_clusters: "WeightedCluster" = betterproto.message_field(
        2, group="cluster_specifier"
    )
    """
    Multiple upstream clusters can be specified for a given route. The request
    is routed to one of the upstream clusters based on weights assigned to each
    cluster.
    """

    cluster_header: str = betterproto.string_field(6, group="cluster_specifier")
    """
    Envoy will determine the cluster to route to by reading the value of the
    Thrift header named by cluster_header from the request headers. If the
    header is not found or the referenced cluster does not exist Envoy will
    respond with an unknown method exception or an internal error exception,
    respectively.
    """

    metadata_match: "_____config_core_v3__.Metadata" = betterproto.message_field(3)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what is set
    in this field will be considered. Note that this will be merged with what's
    provided in :ref:`WeightedCluster.metadata_match <envoy_v3_api_field_extens
    ions.filters.network.thrift_proxy.v3.WeightedCluster.ClusterWeight.metadata
    _match>`, with values there taking precedence. Keys and values should be
    provided under the "envoy.lb" metadata key.
    """

    rate_limits: List["_____config_route_v3__.RateLimit"] = betterproto.message_field(4)
    """
    Specifies a set of rate limit configurations that could be applied to the
    route. N.B. Thrift service or method name matching can be achieved by
    specifying a RequestHeaders action with the header name ":method-name".
    """

    strip_service_name: bool = betterproto.bool_field(5)
    """
    Strip the service prefix from the method name, if there's a prefix. For
    example, the method call Service:method would end up being just method.
    """

    request_mirror_policies: List[
        "RouteActionRequestMirrorPolicy"
    ] = betterproto.message_field(7)
    """Indicates that the route has request mirroring policies."""


@dataclass(eq=False, repr=False)
class RouteActionRequestMirrorPolicy(betterproto.Message):
    """
    The router is capable of shadowing traffic from one cluster to another. The
    current implementation is "fire and forget," meaning Envoy will not wait
    for the shadow cluster to respond before returning the response from the
    primary cluster. All normal statistics are collected for the shadow cluster
    making this feature useful for testing. .. note::   Shadowing will not be
    triggered if the primary cluster does not exist.
    """

    cluster: str = betterproto.string_field(1)
    """
    Specifies the cluster that requests will be mirrored to. The cluster must
    exist in the cluster manager configuration when the route configuration is
    loaded. If it disappears at runtime, the shadow request will silently be
    ignored.
    """

    runtime_fraction: "_____config_core_v3__.RuntimeFractionalPercent" = (
        betterproto.message_field(2)
    )
    """
    If not specified, all requests to the target cluster will be mirrored. For
    some fraction N/D, a random number in the range [0,D) is selected. If the
    number is <= the value of the numerator N, or if the key is not present,
    the default value, the request will be mirrored.
    """


@dataclass(eq=False, repr=False)
class WeightedCluster(betterproto.Message):
    """
    Allows for specification of multiple upstream clusters along with weights
    that indicate the percentage of traffic to be forwarded to each cluster.
    The router selects an upstream cluster based on these weights.
    """

    clusters: List["WeightedClusterClusterWeight"] = betterproto.message_field(1)
    """Specifies one or more upstream clusters associated with the route."""


@dataclass(eq=False, repr=False)
class WeightedClusterClusterWeight(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the upstream cluster."""

    weight: Optional[int] = betterproto.message_field(2, wraps=betterproto.TYPE_UINT32)
    """
    When a request matches the route, the choice of an upstream cluster is
    determined by its weight. The sum of weights across all entries in the
    clusters array determines the total weight.
    """

    metadata_match: "_____config_core_v3__.Metadata" = betterproto.message_field(3)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what is set
    in this field, combined with what's provided in :ref:`RouteAction's
    metadata_match <envoy_v3_api_field_extensions.filters.network.thrift_proxy.
    v3.RouteAction.metadata_match>`, will be considered. Values here will take
    precedence. Keys and values should be provided under the "envoy.lb"
    metadata key.
    """


@dataclass(eq=False, repr=False)
class Trds(betterproto.Message):
    config_source: "_____config_core_v3__.ConfigSource" = betterproto.message_field(1)
    """
    Configuration source specifier. In case of ``api_config_source`` only
    aggregated ``api_type`` is supported.
    """

    route_config_name: str = betterproto.string_field(2)
    """
    The name of the route configuration. This allows to use different route
    configurations. Tells which route configuration should be fetched from the
    configuration source. Leave unspecified is also valid and means the unnamed
    route configuration.
    """


@dataclass(eq=False, repr=False)
class ThriftProxy(betterproto.Message):
    """[#next-free-field: 11]"""

    transport: "TransportType" = betterproto.enum_field(2)
    """
    Supplies the type of transport that the Thrift proxy should use. Defaults
    to :ref:`AUTO_TRANSPORT<envoy_v3_api_enum_value_extensions.filters.network.
    thrift_proxy.v3.TransportType.AUTO_TRANSPORT>`.
    """

    protocol: "ProtocolType" = betterproto.enum_field(3)
    """
    Supplies the type of protocol that the Thrift proxy should use. Defaults to
    :ref:`AUTO_PROTOCOL<envoy_v3_api_enum_value_extensions.filters.network.thri
    ft_proxy.v3.ProtocolType.AUTO_PROTOCOL>`.
    """

    stat_prefix: str = betterproto.string_field(1)
    """The human readable prefix to use when emitting statistics."""

    route_config: "RouteConfiguration" = betterproto.message_field(4)
    """
    The route table for the connection manager is static and is specified in
    this property. It is invalid to define both ``route_config`` and ``trds``.
    """

    trds: "Trds" = betterproto.message_field(8)
    """
    Use xDS to fetch the route configuration. It is invalid to define both
    ``route_config`` and ``trds``.
    """

    thrift_filters: List["ThriftFilter"] = betterproto.message_field(5)
    """
    A list of individual Thrift filters that make up the filter chain for
    requests made to the Thrift proxy. Order matters as the filters are
    processed sequentially. For backwards compatibility, if no thrift_filters
    are specified, a default Thrift router filter
    (``envoy.filters.thrift.router``) is used. [#extension-category:
    envoy.thrift_proxy.filters]
    """

    payload_passthrough: bool = betterproto.bool_field(6)
    """
    If set to true, Envoy will try to skip decode data after metadata in the
    Thrift message. This mode will only work if the upstream and downstream
    protocols are the same and the transports are Framed or Header, and the
    protocol is not Twitter. Otherwise Envoy will fallback to decode the data.
    """

    max_requests_per_connection: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )
    """
    Optional maximum requests for a single downstream connection. If not
    specified, there is no limit.
    """

    access_log: List[
        "_____config_accesslog_v3__.AccessLog"
    ] = betterproto.message_field(9)
    """
    Configuration for :ref:`access logs <arch_overview_access_logs>` emitted by
    Thrift proxy.
    """

    header_keys_preserve_case: bool = betterproto.bool_field(10)
    """
    If set to true, Envoy will preserve the case of Thrift header keys instead
    of serializing them to lower case as per the default behavior. Note that
    NUL, CR and LF characters will also be preserved as mandated by the Thrift
    spec. More info: https://github.com/apache/thrift/commit/e165fa3c85d00cb984
    f4d9635ed60909a1266ce1.
    """


@dataclass(eq=False, repr=False)
class ThriftFilter(betterproto.Message):
    """ThriftFilter configures a Thrift filter."""

    name: str = betterproto.string_field(1)
    """
    The name of the filter to instantiate. The name must match a supported
    filter. The built-in filters are: [#comment:TODO(zuercher): Auto generate
    the following list] * :ref:`envoy.filters.thrift.router
    <config_thrift_filters_router>` * :ref:`envoy.filters.thrift.rate_limit
    <config_thrift_filters_rate_limit>`
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )


@dataclass(eq=False, repr=False)
class ThriftProtocolOptions(betterproto.Message):
    """
    ThriftProtocolOptions specifies Thrift upstream protocol options. This
    object is used in in :ref:`typed_extension_protocol_options<envoy_v3_api_fi
    eld_config.cluster.v3.Cluster.typed_extension_protocol_options>`, keyed by
    the name ``envoy.filters.network.thrift_proxy``.
    """

    transport: "TransportType" = betterproto.enum_field(1)
    """
    Supplies the type of transport that the Thrift proxy should use for
    upstream connections. Selecting :ref:`AUTO_TRANSPORT<envoy_v3_api_enum_valu
    e_extensions.filters.network.thrift_proxy.v3.TransportType.AUTO_TRANSPORT>`
    , which is the default, causes the proxy to use the same transport as the
    downstream connection.
    """

    protocol: "ProtocolType" = betterproto.enum_field(2)
    """
    Supplies the type of protocol that the Thrift proxy should use for upstream
    connections. Selecting :ref:`AUTO_PROTOCOL<envoy_v3_api_enum_value_extensio
    ns.filters.network.thrift_proxy.v3.ProtocolType.AUTO_PROTOCOL>`, which is
    the default, causes the proxy to use the same protocol as the downstream
    connection.
    """
