# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/network/tcp_proxy/v3/tcp_proxy.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    List,
    Optional,
)

import betterproto

from ......config.accesslog import v3 as _____config_accesslog_v3__
from ......config.core import v3 as _____config_core_v3__
from ......type import v3 as _____type_v3__


@dataclass(eq=False, repr=False)
class TcpProxy(betterproto.Message):
    """[#next-free-field: 16]"""

    stat_prefix: str = betterproto.string_field(1)
    """
    The prefix to use when emitting :ref:`statistics
    <config_network_filters_tcp_proxy_stats>`.
    """

    cluster: str = betterproto.string_field(2, group="cluster_specifier")
    """The upstream cluster to connect to."""

    weighted_clusters: "TcpProxyWeightedCluster" = betterproto.message_field(
        10, group="cluster_specifier"
    )
    """
    Multiple upstream clusters can be specified for a given route. The request
    is routed to one of the upstream clusters based on weights assigned to each
    cluster.
    """

    on_demand: "TcpProxyOnDemand" = betterproto.message_field(14)
    """
    The on demand policy for the upstream cluster. It applies to both
    :ref:`TcpProxy.cluster <envoy_v3_api_field_extensions.filters.network.tcp_p
    roxy.v3.TcpProxy.cluster>` and :ref:`TcpProxy.weighted_clusters <envoy_v3_a
    pi_field_extensions.filters.network.tcp_proxy.v3.TcpProxy.weighted_clusters
    >`.
    """

    metadata_match: "_____config_core_v3__.Metadata" = betterproto.message_field(9)
    """
    Optional endpoint metadata match criteria. Only endpoints in the upstream
    cluster with metadata matching that set in metadata_match will be
    considered. The filter name should be specified as ``envoy.lb``.
    """

    idle_timeout: timedelta = betterproto.message_field(8)
    """
    The idle timeout for connections managed by the TCP proxy filter. The idle
    timeout is defined as the period in which there are no bytes sent or
    received on either the upstream or downstream connection. If not set, the
    default idle timeout is 1 hour. If set to 0s, the timeout will be disabled.
    .. warning::   Disabling this timeout has a highly likelihood of yielding
    connection leaks due to lost TCP   FIN packets, etc.
    """

    downstream_idle_timeout: timedelta = betterproto.message_field(3)
    """
    [#not-implemented-hide:] The idle timeout for connections managed by the
    TCP proxy filter. The idle timeout is defined as the period in which there
    is no active traffic. If not set, there is no idle timeout. When the idle
    timeout is reached the connection will be closed. The distinction between
    downstream_idle_timeout/upstream_idle_timeout provides a means to set
    timeout based on the last byte sent on the downstream/upstream connection.
    """

    upstream_idle_timeout: timedelta = betterproto.message_field(4)
    """[#not-implemented-hide:]"""

    access_log: List[
        "_____config_accesslog_v3__.AccessLog"
    ] = betterproto.message_field(5)
    """
    Configuration for :ref:`access logs <arch_overview_access_logs>` emitted by
    the this tcp_proxy.
    """

    max_connect_attempts: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )
    """
    The maximum number of unsuccessful connection attempts that will be made
    before giving up. If the parameter is not specified, 1 connection attempt
    will be made.
    """

    hash_policy: List["_____type_v3__.HashPolicy"] = betterproto.message_field(11)
    """
    Optional configuration for TCP proxy hash policy. If hash_policy is not
    set, the hash-based load balancing algorithms will select a host randomly.
    Currently the number of hash policies is limited to 1.
    """

    tunneling_config: "TcpProxyTunnelingConfig" = betterproto.message_field(12)
    """
    If set, this configures tunneling, e.g. configuration options to tunnel TCP
    payload over HTTP CONNECT. If this message is absent, the payload will be
    proxied upstream as per usual.
    """

    max_downstream_connection_duration: timedelta = betterproto.message_field(13)
    """
    The maximum duration of a connection. The duration is defined as the period
    since a connection was established. If not set, there is no max duration.
    When max_downstream_connection_duration is reached the connection will be
    closed. Duration must be at least 1ms.
    """

    access_log_flush_interval: timedelta = betterproto.message_field(15)
    """
    The interval to flush access log. The TCP proxy will flush only one access
    log when the connection is closed by default. If this field is set, the TCP
    proxy will flush access log periodically with the specified interval. The
    interval must be at least 1ms.
    """


@dataclass(eq=False, repr=False)
class TcpProxyWeightedCluster(betterproto.Message):
    """
    Allows for specification of multiple upstream clusters along with weights
    that indicate the percentage of traffic to be forwarded to each cluster.
    The router selects an upstream cluster based on these weights.
    """

    clusters: List["TcpProxyWeightedClusterClusterWeight"] = betterproto.message_field(
        1
    )
    """Specifies one or more upstream clusters associated with the route."""


@dataclass(eq=False, repr=False)
class TcpProxyWeightedClusterClusterWeight(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the upstream cluster."""

    weight: int = betterproto.uint32_field(2)
    """
    When a request matches the route, the choice of an upstream cluster is
    determined by its weight. The sum of weights across all entries in the
    clusters array determines the total weight.
    """

    metadata_match: "_____config_core_v3__.Metadata" = betterproto.message_field(3)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what is set
    in this field will be considered for load balancing. Note that this will be
    merged with what's provided in :ref:`TcpProxy.metadata_match <envoy_v3_api_
    field_extensions.filters.network.tcp_proxy.v3.TcpProxy.metadata_match>`,
    with values here taking precedence. The filter name should be specified as
    ``envoy.lb``.
    """


@dataclass(eq=False, repr=False)
class TcpProxyTunnelingConfig(betterproto.Message):
    """
    Configuration for tunneling TCP over other transports or application
    layers. Tunneling is supported over both HTTP/1.1 and HTTP/2. Upstream
    protocol is determined by the cluster configuration. [#next-free-field: 6]
    """

    hostname: str = betterproto.string_field(1)
    """
    The hostname to send in the synthesized CONNECT headers to the upstream
    proxy. This field evaluates command operators if set, otherwise returns
    hostname as is. Example: dynamically set hostname using downstream SNI ..
    code-block:: yaml    tunneling_config:      hostname:
    "%REQUESTED_SERVER_NAME%:443" Example: dynamically set hostname using
    dynamic metadata .. code-block:: yaml    tunneling_config:      hostname:
    "%DYNAMIC_METADATA(tunnel:address)%"
    """

    use_post: bool = betterproto.bool_field(2)
    """
    Use POST method instead of CONNECT method to tunnel the TCP stream. The
    'protocol: bytestream' header is also NOT set for HTTP/2 to comply with the
    spec. The upstream proxy is expected to convert POST payload as raw TCP.
    """

    headers_to_add: List[
        "_____config_core_v3__.HeaderValueOption"
    ] = betterproto.message_field(3)
    """
    Additional request headers to upstream proxy. This is mainly used to
    trigger upstream to convert POST requests back to CONNECT requests. Neither
    ``:-prefixed`` pseudo-headers nor the Host: header can be overridden.
    """

    propagate_response_headers: bool = betterproto.bool_field(4)
    """
    Save the response headers to the downstream info filter state for
    consumption by the network filters. The filter state key is
    ``envoy.tcp_proxy.propagate_response_headers``.
    """

    post_path: str = betterproto.string_field(5)
    """
    The path used with POST method. Default path is ``/``. If post path is
    specified and :ref:`use_post field <envoy_v3_api_field_extensions.filters.n
    etwork.tcp_proxy.v3.TcpProxy.TunnelingConfig.use_post>` isn't true, it will
    be rejected.
    """


@dataclass(eq=False, repr=False)
class TcpProxyOnDemand(betterproto.Message):
    odcds_config: "_____config_core_v3__.ConfigSource" = betterproto.message_field(1)
    """
    An optional configuration for on-demand cluster discovery service. If not
    specified, the on-demand cluster discovery will be disabled. When it's
    specified, the filter will pause a request to an unknown cluster and will
    begin a cluster discovery process. When the discovery is finished
    (successfully or not), the request will be resumed.
    """

    resources_locator: str = betterproto.string_field(2)
    """
    xdstp:// resource locator for on-demand cluster collection. [#not-
    implemented-hide:]
    """

    timeout: timedelta = betterproto.message_field(3)
    """
    The timeout for on demand cluster lookup. If the CDS cannot return the
    required cluster, the downstream request will be closed with the error code
    detail NO_CLUSTER_FOUND. [#not-implemented-hide:]
    """
