# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/http/ratelimit/v3/rate_limit.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import timedelta
from typing import List

import betterproto

from ......config.core import v3 as _____config_core_v3__
from ......config.ratelimit import v3 as _____config_ratelimit_v3__
from ......config.route import v3 as _____config_route_v3__
from ......type import v3 as _____type_v3__
from ......type.metadata import v3 as _____type_metadata_v3__


class RateLimitXRateLimitHeadersRfcVersion(betterproto.Enum):
    """
    Defines the version of the standard to use for X-RateLimit headers. [#next-
    major-version: unify with local ratelimit, should use
    common.ratelimit.v3.XRateLimitHeadersRFCVersion instead.]
    """

    OFF = 0
    """X-RateLimit headers disabled."""

    DRAFT_VERSION_03 = 1
    """
    Use `draft RFC Version 03 <https://tools.ietf.org/id/draft-polli-ratelimit-
    headers-03.html>`_.
    """


class RateLimitConfigActionMetaDataSource(betterproto.Enum):
    DYNAMIC = 0
    """Query :ref:`dynamic metadata <well_known_dynamic_metadata>`"""

    ROUTE_ENTRY = 1
    """
    Query :ref:`route entry metadata
    <envoy_v3_api_field_config.route.v3.Route.metadata>`
    """


class RateLimitPerRouteVhRateLimitsOptions(betterproto.Enum):
    """
    [#next-major-version: unify with local ratelimit, should use
    common.ratelimit.v3.VhRateLimitsOptions instead.]
    """

    OVERRIDE = 0
    """
    Use the virtual host rate limits unless the route has a rate limit policy.
    """

    INCLUDE = 1
    """
    Use the virtual host rate limits even if the route has a rate limit policy.
    """

    IGNORE = 2
    """
    Ignore the virtual host rate limits even if the route does not have a rate
    limit policy.
    """


class RateLimitPerRouteOverrideOptions(betterproto.Enum):
    """
    The override option determines how the filter handles the cases where there
    is an override config at a more specific level than this one (from least to
    most specific: virtual host, route, cluster weight). [#not-implemented-
    hide:]
    """

    DEFAULT = 0
    """
    Client-defined default, typically OVERRIDE_POLICY. If VhRateLimitsOptions
    is set, that will be used instead.
    """

    OVERRIDE_POLICY = 1
    """
    If there is an override config at a more specific level, use that instead
    of this one.
    """

    INCLUDE_POLICY = 2
    """
    If there is an override config at a more specific level, use data from
    both.
    """

    IGNORE_POLICY = 3
    """
    If there is an override config at a more specific level, ignore it and use
    only this one.
    """


@dataclass(eq=False, repr=False)
class RateLimit(betterproto.Message):
    """[#next-free-field: 12]"""

    domain: str = betterproto.string_field(1)
    """The rate limit domain to use when calling the rate limit service."""

    stage: int = betterproto.uint32_field(2)
    """
    Specifies the rate limit configurations to be applied with the same stage
    number. If not set, the default stage number is 0. .. note::  The filter
    supports a range of 0 - 10 inclusively for stage numbers.
    """

    request_type: str = betterproto.string_field(3)
    """
    The type of requests the filter should apply to. The supported types are
    ``internal``, ``external`` or ``both``. A request is considered internal if
    :ref:`x-envoy-internal<config_http_conn_man_headers_x-envoy-internal>` is
    set to true. If :ref:`x-envoy-internal<config_http_conn_man_headers_x-
    envoy-internal>` is not set or false, a request is considered external. The
    filter defaults to ``both``, and it will apply to all request types.
    """

    timeout: timedelta = betterproto.message_field(4)
    """
    The timeout in milliseconds for the rate limit service RPC. If not set,
    this defaults to 20ms.
    """

    failure_mode_deny: bool = betterproto.bool_field(5)
    """
    The filter's behaviour in case the rate limiting service does not respond
    back. When it is set to true, Envoy will not allow traffic in case of
    communication failure between rate limiting service and the proxy.
    """

    rate_limited_as_resource_exhausted: bool = betterproto.bool_field(6)
    """
    Specifies whether a ``RESOURCE_EXHAUSTED`` gRPC code must be returned
    instead of the default ``UNAVAILABLE`` gRPC code for a rate limited gRPC
    call. The HTTP code will be 200 for a gRPC response.
    """

    rate_limit_service: "_____config_ratelimit_v3__.RateLimitServiceConfig" = (
        betterproto.message_field(7)
    )
    """
    Configuration for an external rate limit service provider. If not
    specified, any calls to the rate limit service will immediately return
    success.
    """

    enable_x_ratelimit_headers: "RateLimitXRateLimitHeadersRfcVersion" = (
        betterproto.enum_field(8)
    )
    """
    Defines the standard version to use for X-RateLimit headers emitted by the
    filter: * ``X-RateLimit-Limit`` - indicates the request-quota associated to
    the   client in the current time-window followed by the description of the
    quota policy. The values are returned by the rate limiting service in   :re
    f:`current_limit<envoy_v3_api_field_service.ratelimit.v3.RateLimitResponse.
    DescriptorStatus.current_limit>`   field. Example: ``10, 10;w=1;name="per-
    ip", 1000;w=3600``. * ``X-RateLimit-Remaining`` - indicates the remaining
    requests in the   current time-window. The values are returned by the rate
    limiting service   in :ref:`limit_remaining<envoy_v3_api_field_service.rate
    limit.v3.RateLimitResponse.DescriptorStatus.limit_remaining>`   field. *
    ``X-RateLimit-Reset`` - indicates the number of seconds until reset of
    the current time-window. The values are returned by the rate limiting
    service   in :ref:`duration_until_reset<envoy_v3_api_field_service.ratelimi
    t.v3.RateLimitResponse.DescriptorStatus.duration_until_reset>`   field. In
    case rate limiting policy specifies more then one time window, the values
    above represent the window that is closest to reaching its limit. For more
    information about the headers specification see selected version of the
    `draft RFC <https://tools.ietf.org/id/draft-polli-ratelimit-
    headers-03.html>`_. Disabled by default. [#next-major-version: unify with
    local ratelimit, should use common.ratelimit.v3.XRateLimitHeadersRFCVersion
    instead.]
    """

    disable_x_envoy_ratelimited_header: bool = betterproto.bool_field(9)
    """
    Disables emitting the :ref:`x-envoy-
    ratelimited<config_http_filters_router_x-envoy-ratelimited>` header in case
    of rate limiting (i.e. 429 responses). Having this header not present
    potentially makes the request retriable.
    """

    rate_limited_status: "_____type_v3__.HttpStatus" = betterproto.message_field(10)
    """
    This field allows for a custom HTTP response status code to the downstream
    client when the request has been rate limited. Defaults to 429
    (TooManyRequests). .. note::   If this is set to < 400, 429 will be used
    instead.
    """

    response_headers_to_add: List[
        "_____config_core_v3__.HeaderValueOption"
    ] = betterproto.message_field(11)
    """
    Specifies a list of HTTP headers that should be added to each response for
    requests that have been rate limited.
    """


@dataclass(eq=False, repr=False)
class RateLimitConfig(betterproto.Message):
    """
    Global rate limiting :ref:`architecture overview
    <arch_overview_global_rate_limit>`. Also applies to Local rate limiting
    :ref:`using descriptors
    <config_http_filters_local_rate_limit_descriptors>`. [#not-implemented-
    hide:]
    """

    stage: int = betterproto.uint32_field(1)
    """
    Refers to the stage set in the filter. The rate limit configuration only
    applies to filters with the same stage number. The default stage number is
    0. .. note::   The filter supports a range of 0 - 10 inclusively for stage
    numbers.
    """

    disable_key: str = betterproto.string_field(2)
    """
    The key to be set in runtime to disable this rate limit configuration.
    """

    actions: List["RateLimitConfigAction"] = betterproto.message_field(3)
    """
    A list of actions that are to be applied for this rate limit configuration.
    Order matters as the actions are processed sequentially and the descriptor
    is composed by appending descriptor entries in that sequence. If an action
    cannot append a descriptor entry, no descriptor is generated for the
    configuration. See :ref:`composing actions
    <config_http_filters_rate_limit_composing_actions>` for additional
    documentation.
    """

    limit: "RateLimitConfigOverride" = betterproto.message_field(4)
    """
    An optional limit override to be appended to the descriptor produced by
    this rate limit configuration. If the override value is invalid or cannot
    be resolved from metadata, no override is provided. See :ref:`rate limit
    override <config_http_filters_rate_limit_rate_limit_override>` for more
    information.
    """


@dataclass(eq=False, repr=False)
class RateLimitConfigAction(betterproto.Message):
    """[#next-free-field: 10]"""

    source_cluster: "RateLimitConfigActionSourceCluster" = betterproto.message_field(
        1, group="action_specifier"
    )
    """Rate limit on source cluster."""

    destination_cluster: "RateLimitConfigActionDestinationCluster" = (
        betterproto.message_field(2, group="action_specifier")
    )
    """Rate limit on destination cluster."""

    request_headers: "RateLimitConfigActionRequestHeaders" = betterproto.message_field(
        3, group="action_specifier"
    )
    """Rate limit on request headers."""

    remote_address: "RateLimitConfigActionRemoteAddress" = betterproto.message_field(
        4, group="action_specifier"
    )
    """Rate limit on remote address."""

    generic_key: "RateLimitConfigActionGenericKey" = betterproto.message_field(
        5, group="action_specifier"
    )
    """Rate limit on a generic key."""

    header_value_match: "RateLimitConfigActionHeaderValueMatch" = (
        betterproto.message_field(6, group="action_specifier")
    )
    """Rate limit on the existence of request headers."""

    metadata: "RateLimitConfigActionMetaData" = betterproto.message_field(
        8, group="action_specifier"
    )
    """Rate limit on metadata."""

    extension: "_____config_core_v3__.TypedExtensionConfig" = betterproto.message_field(
        9, group="action_specifier"
    )
    """
    Rate limit descriptor extension. See the rate limit descriptor extensions
    documentation. [#extension-category: envoy.rate_limit_descriptors]
    """


@dataclass(eq=False, repr=False)
class RateLimitConfigActionSourceCluster(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("source_cluster", "<local service cluster>") <local service
    cluster> is derived from the :option:`--service-cluster` option.
    """

    pass


@dataclass(eq=False, repr=False)
class RateLimitConfigActionDestinationCluster(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("destination_cluster", "<routed target cluster>") Once a
    request matches against a route table rule, a routed cluster is determined
    by one of the following :ref:`route table configuration
    <envoy_v3_api_msg_config.route.v3.RouteConfiguration>` settings: *
    :ref:`cluster <envoy_v3_api_field_config.route.v3.RouteAction.cluster>`
    indicates the upstream cluster   to route to. * :ref:`weighted_clusters
    <envoy_v3_api_field_config.route.v3.RouteAction.weighted_clusters>`
    chooses a cluster randomly from a set of clusters with attributed weight. *
    :ref:`cluster_header
    <envoy_v3_api_field_config.route.v3.RouteAction.cluster_header>` indicates
    which   header in the request contains the target cluster.
    """

    pass


@dataclass(eq=False, repr=False)
class RateLimitConfigActionRequestHeaders(betterproto.Message):
    """
    The following descriptor entry is appended when a header contains a key
    that matches the ``header_name``: .. code-block:: cpp
    ("<descriptor_key>", "<header_value_queried_from_header>")
    """

    header_name: str = betterproto.string_field(1)
    """
    The header name to be queried from the request headers. The header’s value
    is used to populate the value of the descriptor entry for the
    descriptor_key.
    """

    descriptor_key: str = betterproto.string_field(2)
    """The key to use in the descriptor entry."""

    skip_if_absent: bool = betterproto.bool_field(3)
    """
    If set to true, Envoy skips the descriptor while calling rate limiting
    service when header is not present in the request. By default it skips
    calling the rate limiting service if this header is not present in the
    request.
    """


@dataclass(eq=False, repr=False)
class RateLimitConfigActionRemoteAddress(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor and is
    populated using the trusted address from :ref:`x-forwarded-for
    <config_http_conn_man_headers_x-forwarded-for>`: .. code-block:: cpp
    ("remote_address", "<trusted address from x-forwarded-for>")
    """

    pass


@dataclass(eq=False, repr=False)
class RateLimitConfigActionGenericKey(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("generic_key", "<descriptor_value>")
    """

    descriptor_value: str = betterproto.string_field(1)
    """The value to use in the descriptor entry."""

    descriptor_key: str = betterproto.string_field(2)
    """
    An optional key to use in the descriptor entry. If not set it defaults to
    'generic_key' as the descriptor key.
    """


@dataclass(eq=False, repr=False)
class RateLimitConfigActionHeaderValueMatch(betterproto.Message):
    """
    The following descriptor entry is appended to the descriptor: .. code-
    block:: cpp   ("header_match", "<descriptor_value>")
    """

    descriptor_value: str = betterproto.string_field(1)
    """The value to use in the descriptor entry."""

    expect_match: bool = betterproto.bool_field(2)
    """
    If set to true, the action will append a descriptor entry when the request
    matches the headers. If set to false, the action will append a descriptor
    entry when the request does not match the headers. The default value is
    true.
    """

    headers: List["_____config_route_v3__.HeaderMatcher"] = betterproto.message_field(3)
    """
    Specifies a set of headers that the rate limit action should match on. The
    action will check the request’s headers against all the specified headers
    in the config. A match will happen if all the headers in the config are
    present in the request with the same values (or based on presence if the
    value field is not in the config).
    """


@dataclass(eq=False, repr=False)
class RateLimitConfigActionMetaData(betterproto.Message):
    """
    The following descriptor entry is appended when the metadata contains a key
    value: .. code-block:: cpp   ("<descriptor_key>",
    "<value_queried_from_metadata>")
    """

    descriptor_key: str = betterproto.string_field(1)
    """The key to use in the descriptor entry."""

    metadata_key: "_____type_metadata_v3__.MetadataKey" = betterproto.message_field(2)
    """
    Metadata struct that defines the key and path to retrieve the string value.
    A match will only happen if the value in the metadata is of type string.
    """

    default_value: str = betterproto.string_field(3)
    """
    An optional value to use if ``metadata_key`` is empty. If not set and no
    value is present under the metadata_key then no descriptor is generated.
    """

    source: "RateLimitConfigActionMetaDataSource" = betterproto.enum_field(4)
    """Source of metadata"""


@dataclass(eq=False, repr=False)
class RateLimitConfigOverride(betterproto.Message):
    dynamic_metadata: "RateLimitConfigOverrideDynamicMetadata" = (
        betterproto.message_field(1, group="override_specifier")
    )
    """Limit override from dynamic metadata."""


@dataclass(eq=False, repr=False)
class RateLimitConfigOverrideDynamicMetadata(betterproto.Message):
    """Fetches the override from the dynamic metadata."""

    metadata_key: "_____type_metadata_v3__.MetadataKey" = betterproto.message_field(1)
    """
    Metadata struct that defines the key and path to retrieve the struct value.
    The value must be a struct containing an integer "requests_per_unit"
    property and a "unit" property with a value parseable to
    :ref:`RateLimitUnit enum <envoy_v3_api_enum_type.v3.RateLimitUnit>`
    """


@dataclass(eq=False, repr=False)
class RateLimitPerRoute(betterproto.Message):
    vh_rate_limits: "RateLimitPerRouteVhRateLimitsOptions" = betterproto.enum_field(1)
    """
    Specifies if the rate limit filter should include the virtual host rate
    limits. [#next-major-version: unify with local ratelimit, should use
    common.ratelimit.v3.VhRateLimitsOptions instead.]
    """

    override_option: "RateLimitPerRouteOverrideOptions" = betterproto.enum_field(2)
    """
    Specifies if the rate limit filter should include the lower levels (route
    level, virtual host level or cluster weight level) rate limits override
    options. [#not-implemented-hide:]
    """

    rate_limits: List["RateLimitConfig"] = betterproto.message_field(3)
    """
    Rate limit configuration. If not set, uses the :ref:`VirtualHost.rate_limit
    s<envoy_v3_api_field_config.route.v3.VirtualHost.rate_limits>` or :ref:`Rou
    teAction.rate_limits<envoy_v3_api_field_config.route.v3.RouteAction.rate_li
    mits>` fields instead. [#not-implemented-hide:]
    """
