# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/http/oauth2/v3/oauth.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import List

import betterproto

from ......config.core import v3 as _____config_core_v3__
from ......config.route import v3 as _____config_route_v3__
from ......type.matcher import v3 as _____type_matcher_v3__
from .....transport_sockets.tls import v3 as ____transport_sockets_tls_v3__


class OAuth2ConfigAuthType(betterproto.Enum):
    URL_ENCODED_BODY = 0
    """
    The ``client_id`` and ``client_secret`` will be sent in the URL encoded
    request body. This type should only be used when Auth server does not
    support Basic authentication.
    """

    BASIC_AUTH = 1
    """
    The ``client_id`` and ``client_secret`` will be sent using HTTP Basic
    authentication scheme.
    """


@dataclass(eq=False, repr=False)
class OAuth2Credentials(betterproto.Message):
    client_id: str = betterproto.string_field(1)
    """
    The client_id to be used in the authorize calls. This value will be URL
    encoded when sent to the OAuth server.
    """

    token_secret: "____transport_sockets_tls_v3__.SdsSecretConfig" = (
        betterproto.message_field(2)
    )
    """
    The secret used to retrieve the access token. This value will be URL
    encoded when sent to the OAuth server.
    """

    hmac_secret: "____transport_sockets_tls_v3__.SdsSecretConfig" = (
        betterproto.message_field(3, group="token_formation")
    )
    """
    If present, the secret token will be a HMAC using the provided secret.
    """

    cookie_names: "OAuth2CredentialsCookieNames" = betterproto.message_field(4)
    """The cookie names used in OAuth filters flow."""


@dataclass(eq=False, repr=False)
class OAuth2CredentialsCookieNames(betterproto.Message):
    bearer_token: str = betterproto.string_field(1)
    """
    Cookie name to hold OAuth bearer token value. When the authentication
    server validates the client and returns an authorization token back to the
    OAuth filter, no matter what format that token is, if
    :ref:`forward_bearer_token <envoy_v3_api_field_extensions.filters.http.oaut
    h2.v3.OAuth2Config.forward_bearer_token>` is set to true the filter will
    send over the bearer token as a cookie with this name to the upstream.
    Defaults to ``BearerToken``.
    """

    oauth_hmac: str = betterproto.string_field(2)
    """Cookie name to hold OAuth HMAC value. Defaults to ``OauthHMAC``."""

    oauth_expires: str = betterproto.string_field(3)
    """
    Cookie name to hold OAuth expiry value. Defaults to ``OauthExpires``.
    """


@dataclass(eq=False, repr=False)
class OAuth2Config(betterproto.Message):
    """OAuth config [#next-free-field: 12]"""

    token_endpoint: "_____config_core_v3__.HttpUri" = betterproto.message_field(1)
    """
    Endpoint on the authorization server to retrieve the access token from.
    """

    authorization_endpoint: str = betterproto.string_field(2)
    """
    The endpoint redirect to for authorization in response to unauthorized
    requests.
    """

    credentials: "OAuth2Credentials" = betterproto.message_field(3)
    """Credentials used for OAuth."""

    redirect_uri: str = betterproto.string_field(4)
    """
    The redirect URI passed to the authorization endpoint. Supports header
    formatting tokens. For more information, including details on header value
    syntax, see the documentation on :ref:`custom request headers
    <config_http_conn_man_headers_custom_request_headers>`. This URI should not
    contain any query parameters.
    """

    redirect_path_matcher: "_____type_matcher_v3__.PathMatcher" = (
        betterproto.message_field(5)
    )
    """
    Matching criteria used to determine whether a path appears to be the result
    of a redirect from the authorization server.
    """

    signout_path: "_____type_matcher_v3__.PathMatcher" = betterproto.message_field(6)
    """The path to sign a user out, clearing their credential cookies."""

    forward_bearer_token: bool = betterproto.bool_field(7)
    """Forward the OAuth token as a Bearer to upstream web service."""

    pass_through_matcher: List[
        "_____config_route_v3__.HeaderMatcher"
    ] = betterproto.message_field(8)
    """
    Any request that matches any of the provided matchers will be passed
    through without OAuth validation.
    """

    auth_scopes: List[str] = betterproto.string_field(9)
    """
    Optional list of OAuth scopes to be claimed in the authorization request.
    If not specified, defaults to "user" scope. OAuth RFC
    https://tools.ietf.org/html/rfc6749#section-3.3
    """

    resources: List[str] = betterproto.string_field(10)
    """
    Optional resource parameter for authorization request RFC:
    https://tools.ietf.org/html/rfc8707
    """

    auth_type: "OAuth2ConfigAuthType" = betterproto.enum_field(11)
    """
    Defines how ``client_id`` and ``client_secret`` are sent in OAuth client to
    OAuth server requests. RFC
    https://datatracker.ietf.org/doc/html/rfc6749#section-2.3.1
    """


@dataclass(eq=False, repr=False)
class OAuth2(betterproto.Message):
    """Filter config."""

    config: "OAuth2Config" = betterproto.message_field(1)
    """
    Leave this empty to disable OAuth2 for a specific route, using per filter
    config.
    """
