# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/http/ext_authz/v3/ext_authz.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    Dict,
    List,
)

import betterproto

from ......config.core import v3 as _____config_core_v3__
from ......type import v3 as _____type_v3__
from ......type.matcher import v3 as _____type_matcher_v3__


@dataclass(eq=False, repr=False)
class ExtAuthz(betterproto.Message):
    """[#next-free-field: 18]"""

    grpc_service: "_____config_core_v3__.GrpcService" = betterproto.message_field(
        1, group="services"
    )
    """gRPC service configuration (default timeout: 200ms)."""

    http_service: "HttpService" = betterproto.message_field(3, group="services")
    """HTTP service configuration (default timeout: 200ms)."""

    transport_api_version: "_____config_core_v3__.ApiVersion" = betterproto.enum_field(
        12
    )
    """
    API version for ext_authz transport protocol. This describes the ext_authz
    gRPC endpoint and version of messages used on the wire.
    """

    failure_mode_allow: bool = betterproto.bool_field(2)
    """
    Changes filter's behaviour on errors:  1. When set to true, the filter will
    ``accept`` client request even if the communication with  the authorization
    service has failed, or if the authorization service has returned a HTTP 5xx
    error.  2. When set to false, ext-authz will ``reject`` client requests and
    return a ``Forbidden``  response if the communication with the
    authorization service has failed, or if the  authorization service has
    returned a HTTP 5xx error. Note that errors can be ``always`` tracked in
    the :ref:`stats <config_http_filters_ext_authz_stats>`.
    """

    with_request_body: "BufferSettings" = betterproto.message_field(5)
    """
    Enables filter to buffer the client request body and send it within the
    authorization request. A ``x-envoy-auth-partial-body: false|true`` metadata
    header will be added to the authorization request message indicating if the
    body data is partial.
    """

    clear_route_cache: bool = betterproto.bool_field(6)
    """
    Clears route cache in order to allow the external authorization service to
    correctly affect routing decisions. Filter clears all cached routes when:
    1. The field is set to ``true``. 2. The status returned from the
    authorization service is a HTTP 200 or gRPC 0. 3. At least one
    ``authorization response header`` is added to the client request, or is
    used for altering another client request header.
    """

    status_on_error: "_____type_v3__.HttpStatus" = betterproto.message_field(7)
    """
    Sets the HTTP status that is returned to the client when the authorization
    server returns an error or cannot be reached. The default status is HTTP
    403 Forbidden.
    """

    metadata_context_namespaces: List[str] = betterproto.string_field(8)
    """
    Specifies a list of metadata namespaces whose values, if present, will be
    passed to the ext_authz service. :ref:`filter_metadata
    <envoy_v3_api_field_config.core.v3.Metadata.filter_metadata>` is passed as
    an opaque ``protobuf::Struct``. For example, if the ``jwt_authn`` filter is
    used and :ref:`payload_in_metadata <envoy_v3_api_field_extensions.filters.h
    ttp.jwt_authn.v3.JwtProvider.payload_in_metadata>` is set, then the
    following will pass the jwt payload to the authorization server. .. code-
    block:: yaml    metadata_context_namespaces:    -
    envoy.filters.http.jwt_authn
    """

    typed_metadata_context_namespaces: List[str] = betterproto.string_field(16)
    """
    Specifies a list of metadata namespaces whose values, if present, will be
    passed to the ext_authz service. :ref:`typed_filter_metadata
    <envoy_v3_api_field_config.core.v3.Metadata.typed_filter_metadata>` is
    passed as an ``protobuf::Any``. It works in a way similar to
    ``metadata_context_namespaces`` but allows envoy and external authz server
    to share the protobuf message definition in order to do a safe parsing.
    """

    filter_enabled: "_____config_core_v3__.RuntimeFractionalPercent" = (
        betterproto.message_field(9)
    )
    """
    Specifies if the filter is enabled. If :ref:`runtime_key
    <envoy_v3_api_field_config.core.v3.RuntimeFractionalPercent.runtime_key>`
    is specified, Envoy will lookup the runtime key to get the percentage of
    requests to filter. If this field is not specified, the filter will be
    enabled for all requests.
    """

    filter_enabled_metadata: "_____type_matcher_v3__.MetadataMatcher" = (
        betterproto.message_field(14)
    )
    """
    Specifies if the filter is enabled with metadata matcher. If this field is
    not specified, the filter will be enabled for all requests.
    """

    deny_at_disable: "_____config_core_v3__.RuntimeFeatureFlag" = (
        betterproto.message_field(11)
    )
    """
    Specifies whether to deny the requests, when the filter is disabled. If
    :ref:`runtime_key
    <envoy_v3_api_field_config.core.v3.RuntimeFeatureFlag.runtime_key>` is
    specified, Envoy will lookup the runtime key to determine whether to deny
    request for filter protected path at filter disabling. If filter is
    disabled in typed_per_filter_config for the path, requests will not be
    denied. If this field is not specified, all requests will be allowed when
    disabled. If a request is denied due to this setting, the response code in
    :ref:`status_on_error <envoy_v3_api_field_extensions.filters.http.ext_authz
    .v3.ExtAuthz.status_on_error>` will be returned.
    """

    include_peer_certificate: bool = betterproto.bool_field(10)
    """
    Specifies if the peer certificate is sent to the external service. When
    this field is true, Envoy will include the peer X.509 certificate, if
    available, in the :ref:`certificate<envoy_v3_api_field_service.auth.v3.Attr
    ibuteContext.Peer.certificate>`.
    """

    stat_prefix: str = betterproto.string_field(13)
    """
    Optional additional prefix to use when emitting statistics. This allows to
    distinguish emitted statistics between configured ``ext_authz`` filters in
    an HTTP filter chain. For example: .. code-block:: yaml   http_filters:
    - name: envoy.filters.http.ext_authz       typed_config:         "@type":
    type.googleapis.com/envoy.extensions.filters.http.ext_authz.v3.ExtAuthz
    stat_prefix: waf # This emits ext_authz.waf.ok, ext_authz.waf.denied, etc.
    - name: envoy.filters.http.ext_authz       typed_config:         "@type":
    type.googleapis.com/envoy.extensions.filters.http.ext_authz.v3.ExtAuthz
    stat_prefix: blocker # This emits ext_authz.blocker.ok,
    ext_authz.blocker.denied, etc.
    """

    bootstrap_metadata_labels_key: str = betterproto.string_field(15)
    """
    Optional labels that will be passed to :ref:`labels<envoy_v3_api_field_serv
    ice.auth.v3.AttributeContext.Peer.labels>` in :ref:`destination<envoy_v3_ap
    i_field_service.auth.v3.AttributeContext.destination>`. The labels will be
    read from :ref:`metadata<envoy_v3_api_msg_config.core.v3.Node>` with the
    specified key.
    """

    allowed_headers: "_____type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(17)
    )
    """
    Check request to authorization server will include the client request
    headers that have a correspondent match in the :ref:`list
    <envoy_v3_api_msg_type.matcher.v3.ListStringMatcher>`. If this option isn't
    specified, then all client request headers are included in the check
    request to a gRPC authorization server, whereas no client request headers
    (besides the ones allowed by default - see note below) are included in the
    check request to an HTTP authorization server. This inconsistency between
    gRPC and HTTP servers is to maintain backwards compatibility with legacy
    behavior. .. note::  1. For requests to an HTTP authorization server: in
    addition to the the user's supplied matchers, ``Host``, ``Method``,
    ``Path``,     ``Content-Length``, and ``Authorization`` are **additionally
    included** in the list. .. note::  2. For requests to an HTTP authorization
    server: *Content-Length* will be set to 0 and the request to the
    authorization server will not have a message body. However, the check
    request can include the buffered  client request body (controlled by
    :ref:`with_request_body  <envoy_v3_api_field_extensions.filters.http.ext_au
    thz.v3.ExtAuthz.with_request_body>` setting),  consequently the value of
    *Content-Length* of the authorization request reflects the size of  its
    payload size.
    """


@dataclass(eq=False, repr=False)
class BufferSettings(betterproto.Message):
    """Configuration for buffering the request data."""

    max_request_bytes: int = betterproto.uint32_field(1)
    """
    Sets the maximum size of a message body that the filter will hold in
    memory. Envoy will return ``HTTP 413`` and will *not* initiate the
    authorization process when buffer reaches the number set in this field.
    Note that this setting will have precedence over :ref:`failure_mode_allow <
    envoy_v3_api_field_extensions.filters.http.ext_authz.v3.ExtAuthz.failure_mo
    de_allow>`.
    """

    allow_partial_message: bool = betterproto.bool_field(2)
    """
    When this field is true, Envoy will buffer the message until
    ``max_request_bytes`` is reached. The authorization request will be
    dispatched and no 413 HTTP error will be returned by the filter.
    """

    pack_as_bytes: bool = betterproto.bool_field(3)
    """
    If true, the body sent to the external authorization service is set with
    raw bytes, it sets the :ref:`raw_body<envoy_v3_api_field_service.auth.v3.At
    tributeContext.HttpRequest.raw_body>` field of HTTP request attribute
    context. Otherwise, :ref:`body
    <envoy_v3_api_field_service.auth.v3.AttributeContext.HttpRequest.body>`
    will be filled with UTF-8 string request body.
    """


@dataclass(eq=False, repr=False)
class HttpService(betterproto.Message):
    """
    HttpService is used for raw HTTP communication between the filter and the
    authorization service. When configured, the filter will parse the client
    request and use these attributes to call the authorization server.
    Depending on the response, the filter may reject or accept the client
    request. Note that in any of these events, metadata can be added, removed
    or overridden by the filter: *On authorization request*, a list of allowed
    request headers may be supplied. See :ref:`allowed_headers <envoy_v3_api_fi
    eld_extensions.filters.http.ext_authz.v3.AuthorizationRequest.allowed_heade
    rs>` for details. Additional headers metadata may be added to the
    authorization request. See :ref:`headers_to_add <envoy_v3_api_field_extensi
    ons.filters.http.ext_authz.v3.AuthorizationRequest.headers_to_add>` for
    details. On authorization response status HTTP 200 OK, the filter will
    allow traffic to the upstream and additional headers metadata may be added
    to the original client request. See :ref:`allowed_upstream_headers <envoy_v
    3_api_field_extensions.filters.http.ext_authz.v3.AuthorizationResponse.allo
    wed_upstream_headers>` for details. Additionally, the filter may add
    additional headers to the client's response. See
    :ref:`allowed_client_headers_on_success <envoy_v3_api_field_extensions.filt
    ers.http.ext_authz.v3.AuthorizationResponse.allowed_client_headers_on_succe
    ss>` for details. On other authorization response statuses, the filter will
    not allow traffic. Additional headers metadata as well as body may be added
    to the client's response. See :ref:`allowed_client_headers <envoy_v3_api_fi
    eld_extensions.filters.http.ext_authz.v3.AuthorizationResponse.allowed_clie
    nt_headers>` for details. [#next-free-field: 9]
    """

    server_uri: "_____config_core_v3__.HttpUri" = betterproto.message_field(1)
    """
    Sets the HTTP server URI which the authorization requests must be sent to.
    """

    path_prefix: str = betterproto.string_field(2)
    """Sets a prefix to the value of authorization request header ``Path``."""

    authorization_request: "AuthorizationRequest" = betterproto.message_field(7)
    """Settings used for controlling authorization request metadata."""

    authorization_response: "AuthorizationResponse" = betterproto.message_field(8)
    """Settings used for controlling authorization response metadata."""


@dataclass(eq=False, repr=False)
class AuthorizationRequest(betterproto.Message):
    allowed_headers: "_____type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(1)
    )
    """
    Authorization request includes the client request headers that have a
    correspondent match in the :ref:`list
    <envoy_v3_api_msg_type.matcher.v3.ListStringMatcher>`. .. note::   In
    addition to the the user's supplied matchers, ``Host``, ``Method``,
    ``Path``,   ``Content-Length``, and ``Authorization`` are **automatically
    included** to the list. .. note::   By default, ``Content-Length`` header
    is set to ``0`` and the request to the authorization   service has no
    message body. However, the authorization request *may* include the buffered
    client request body (controlled by :ref:`with_request_body   <envoy_v3_api_
    field_extensions.filters.http.ext_authz.v3.ExtAuthz.with_request_body>`
    setting) hence the value of its ``Content-Length`` reflects the size of its
    payload size.   This field has been deprecated in favor of
    :ref:`allowed_headers   <envoy_v3_api_field_extensions.filters.http.ext_aut
    hz.v3.ExtAuthz.allowed_headers>`.
    """

    headers_to_add: List[
        "_____config_core_v3__.HeaderValue"
    ] = betterproto.message_field(2)
    """
    Sets a list of headers that will be included to the request to
    authorization service. Note that client request of the same key will be
    overridden.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("allowed_headers"):
            warnings.warn(
                "AuthorizationRequest.allowed_headers is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class AuthorizationResponse(betterproto.Message):
    """[#next-free-field: 6]"""

    allowed_upstream_headers: "_____type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(1)
    )
    """
    When this :ref:`list <envoy_v3_api_msg_type.matcher.v3.ListStringMatcher>`
    is set, authorization response headers that have a correspondent match will
    be added to the original client request. Note that coexistent headers will
    be overridden.
    """

    allowed_upstream_headers_to_append: "_____type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(3)
    )
    """
    When this :ref:`list <envoy_v3_api_msg_type.matcher.v3.ListStringMatcher>`
    is set, authorization response headers that have a correspondent match will
    be added to the client's response. Note that coexistent headers will be
    appended.
    """

    allowed_client_headers: "_____type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(2)
    )
    """
    When this :ref:`list <envoy_v3_api_msg_type.matcher.v3.ListStringMatcher>`
    is set, authorization response headers that have a correspondent match will
    be added to the client's response. Note that when this list is *not* set,
    all the authorization response headers, except ``Authority (Host)`` will be
    in the response to the client. When a header is included in this list,
    ``Path``, ``Status``, ``Content-Length``, ``WWWAuthenticate`` and
    ``Location`` are automatically added.
    """

    allowed_client_headers_on_success: "_____type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(4)
    )
    """
    When this :ref:`list <envoy_v3_api_msg_type.matcher.v3.ListStringMatcher>`
    is set, authorization response headers that have a correspondent match will
    be added to the client's response when the authorization response itself is
    successful, i.e. not failed or denied. When this list is *not* set, no
    additional headers will be added to the client's response on success.
    """

    dynamic_metadata_from_headers: "_____type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(5)
    )
    """
    When this :ref:`list <envoy_v3_api_msg_type.matcher.v3.ListStringMatcher>`
    is set, authorization response headers that have a correspondent match will
    be emitted as dynamic metadata to be consumed by the next filter. This
    metadata lives in a namespace specified by the canonical name of extension
    filter that requires it: - :ref:`envoy.filters.http.ext_authz
    <config_http_filters_ext_authz_dynamic_metadata>` for HTTP filter. -
    :ref:`envoy.filters.network.ext_authz
    <config_network_filters_ext_authz_dynamic_metadata>` for network filter.
    """


@dataclass(eq=False, repr=False)
class ExtAuthzPerRoute(betterproto.Message):
    """Extra settings on a per virtualhost/route/weighted-cluster level."""

    disabled: bool = betterproto.bool_field(1, group="override")
    """
    Disable the ext auth filter for this particular vhost or route. If disabled
    is specified in multiple per-filter-configs, the most specific one will be
    used.
    """

    check_settings: "CheckSettings" = betterproto.message_field(2, group="override")
    """Check request settings for this route."""


@dataclass(eq=False, repr=False)
class CheckSettings(betterproto.Message):
    """Extra settings for the check request."""

    context_extensions: Dict[str, str] = betterproto.map_field(
        1, betterproto.TYPE_STRING, betterproto.TYPE_STRING
    )
    """
    Context extensions to set on the CheckRequest's :ref:`AttributeContext.cont
    ext_extensions<envoy_v3_api_field_service.auth.v3.AttributeContext.context_
    extensions>` You can use this to provide extra context for the external
    authorization server on specific virtual hosts/routes. For example, adding
    a context extension on the virtual host level can give the ext-authz server
    information on what virtual host is used without needing to parse the host
    header. If CheckSettings is specified in multiple per-filter-configs, they
    will be merged in order, and the result will be used. Merge semantics for
    this field are such that keys from more specific configs override. ..
    note::   These settings are only applied to a filter configured with a   :r
    ef:`grpc_service<envoy_v3_api_field_extensions.filters.http.ext_authz.v3.Ex
    tAuthz.grpc_service>`.
    """

    disable_request_body_buffering: bool = betterproto.bool_field(2)
    """
    When set to true, disable the configured :ref:`with_request_body <envoy_v3_
    api_field_extensions.filters.http.ext_authz.v3.ExtAuthz.with_request_body>`
    for a route.
    """
