# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/extensions/filters/http/compressor/v3/compressor.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    List,
    Optional,
)

import betterproto

from ......config.core import v3 as _____config_core_v3__


@dataclass(eq=False, repr=False)
class Compressor(betterproto.Message):
    """[#next-free-field: 10]"""

    content_length: Optional[int] = betterproto.message_field(
        1, wraps=betterproto.TYPE_UINT32
    )
    """
    Minimum response length, in bytes, which will trigger compression. The
    default value is 30.
    """

    content_type: List[str] = betterproto.string_field(2)
    """
    Set of strings that allows specifying which mime-types yield compression;
    e.g., application/json, text/html, etc. When this field is not defined,
    compression will be applied to the following mime-types:
    "application/javascript", "application/json", "application/xhtml+xml",
    "image/svg+xml", "text/css", "text/html", "text/plain", "text/xml" and
    their synonyms.
    """

    disable_on_etag_header: bool = betterproto.bool_field(3)
    """
    If true, disables compression when the response contains an etag header.
    When it is false, the filter will preserve weak etags and remove the ones
    that require strong validation.
    """

    remove_accept_encoding_header: bool = betterproto.bool_field(4)
    """
    If true, removes accept-encoding from the request headers before
    dispatching it to the upstream so that responses do not get compressed
    before reaching the filter. .. attention::    To avoid interfering with
    other compression filters in the same chain use this option in    the
    filter closest to the upstream.
    """

    runtime_enabled: "_____config_core_v3__.RuntimeFeatureFlag" = (
        betterproto.message_field(5)
    )
    """
    Runtime flag that controls whether the filter is enabled or not. If set to
    false, the filter will operate as a pass-through filter, unless overridden
    by CompressorPerRoute. If not specified, defaults to enabled.
    """

    compressor_library: "_____config_core_v3__.TypedExtensionConfig" = (
        betterproto.message_field(6)
    )
    """
    A compressor library to use for compression. Currently only :ref:`envoy.com
    pression.gzip.compressor<envoy_v3_api_msg_extensions.compression.gzip.compr
    essor.v3.Gzip>` is included in Envoy. [#extension-category:
    envoy.compression.compressor]
    """

    request_direction_config: "CompressorRequestDirectionConfig" = (
        betterproto.message_field(7)
    )
    """
    Configuration for request compression. Compression is disabled by default
    if left empty.
    """

    response_direction_config: "CompressorResponseDirectionConfig" = (
        betterproto.message_field(8)
    )
    """
    Configuration for response compression. Compression is enabled by default
    if left empty. .. attention::    If the field is not empty then the
    duplicate deprecated fields of the ``Compressor`` message,    such as
    ``content_length``, ``content_type``, ``disable_on_etag_header``,
    ``remove_accept_encoding_header`` and ``runtime_enabled``, are ignored.
    Also all the statistics related to response compression will be rooted in
    ``<stat_prefix>.compressor.<compressor_library.name>.<compressor_library_st
    at_prefix>.response.*``    instead of    ``<stat_prefix>.compressor.<compre
    ssor_library.name>.<compressor_library_stat_prefix>.*``.
    """

    choose_first: bool = betterproto.bool_field(9)
    """
    If true, chooses this compressor first to do compression when the q-values
    in `Accept-Encoding` are same. The last compressor which enables
    choose_first will be chosen if multiple compressor filters in the chain
    have choose_first as true.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("content_length"):
            warnings.warn("Compressor.content_length is deprecated", DeprecationWarning)
        if self.is_set("content_type"):
            warnings.warn("Compressor.content_type is deprecated", DeprecationWarning)
        if self.is_set("disable_on_etag_header"):
            warnings.warn(
                "Compressor.disable_on_etag_header is deprecated", DeprecationWarning
            )
        if self.is_set("remove_accept_encoding_header"):
            warnings.warn(
                "Compressor.remove_accept_encoding_header is deprecated",
                DeprecationWarning,
            )
        if self.is_set("runtime_enabled"):
            warnings.warn(
                "Compressor.runtime_enabled is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class CompressorCommonDirectionConfig(betterproto.Message):
    enabled: "_____config_core_v3__.RuntimeFeatureFlag" = betterproto.message_field(1)
    """
    Runtime flag that controls whether compression is enabled or not for the
    direction this common config is put in. If set to false, the filter will
    operate as a pass-through filter in the chosen direction, unless overridden
    by CompressorPerRoute. If the field is omitted, the filter will be enabled.
    """

    min_content_length: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    """
    Minimum value of Content-Length header of request or response messages
    (depending on the direction this common config is put in), in bytes, which
    will trigger compression. The default value is 30.
    """

    content_type: List[str] = betterproto.string_field(3)
    """
    Set of strings that allows specifying which mime-types yield compression;
    e.g., application/json, text/html, etc. When this field is not defined,
    compression will be applied to the following mime-types:
    "application/javascript", "application/json", "application/xhtml+xml",
    "image/svg+xml", "text/css", "text/html", "text/plain", "text/xml" and
    their synonyms.
    """


@dataclass(eq=False, repr=False)
class CompressorRequestDirectionConfig(betterproto.Message):
    """Configuration for filter behavior on the request direction."""

    common_config: "CompressorCommonDirectionConfig" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CompressorResponseDirectionConfig(betterproto.Message):
    """Configuration for filter behavior on the response direction."""

    common_config: "CompressorCommonDirectionConfig" = betterproto.message_field(1)
    disable_on_etag_header: bool = betterproto.bool_field(2)
    """
    If true, disables compression when the response contains an etag header.
    When it is false, the filter will preserve weak etags and remove the ones
    that require strong validation.
    """

    remove_accept_encoding_header: bool = betterproto.bool_field(3)
    """
    If true, removes accept-encoding from the request headers before
    dispatching it to the upstream so that responses do not get compressed
    before reaching the filter. .. attention::    To avoid interfering with
    other compression filters in the same chain use this option in    the
    filter closest to the upstream.
    """


@dataclass(eq=False, repr=False)
class ResponseDirectionOverrides(betterproto.Message):
    """
    Per-route overrides of `ResponseDirectionConfig`. Anything added here
    should be optional, to allow overriding arbitrary subsets of configuration.
    Omitted fields must have no affect.
    """

    pass


@dataclass(eq=False, repr=False)
class CompressorOverrides(betterproto.Message):
    """
    Per-route overrides. As per-route overrides are needed, they should be
    added here, mirroring the structure of `Compressor`. All fields should be
    optional, to allow overriding arbitrary subsets of configuration.
    """

    response_direction_config: "ResponseDirectionOverrides" = betterproto.message_field(
        1
    )
    """If present, response compression is enabled."""


@dataclass(eq=False, repr=False)
class CompressorPerRoute(betterproto.Message):
    disabled: bool = betterproto.bool_field(1, group="override")
    """
    If set, the filter will operate as a pass-through filter. Overrides
    Compressor.runtime_enabled and CommonDirectionConfig.enabled.
    """

    overrides: "CompressorOverrides" = betterproto.message_field(2, group="override")
    """
    Per-route overrides. Fields set here will override corresponding fields in
    `Compressor`.
    """
