# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/data/cluster/v2alpha/outlier_detection_event.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import Optional

import betterproto


class OutlierEjectionType(betterproto.Enum):
    """Type of ejection that took place"""

    CONSECUTIVE_5XX = 0
    """
    In case upstream host returns certain number of consecutive 5xx. If :ref:`o
    utlier_detection.split_external_local_origin_errors<envoy_api_field_cluster
    .OutlierDetection.split_external_local_origin_errors>` is *false*, all type
    of errors are treated as HTTP 5xx errors. See :ref:`Cluster outlier
    detection <arch_overview_outlier_detection>` documentation for details.
    """

    CONSECUTIVE_GATEWAY_FAILURE = 1
    """
    In case upstream host returns certain number of consecutive gateway errors
    """

    SUCCESS_RATE = 2
    """
    Runs over aggregated success rate statistics from every host in cluster and
    selects hosts for which ratio of successful replies deviates from other
    hosts in the cluster. If :ref:`outlier_detection.split_external_local_origi
    n_errors<envoy_api_field_cluster.OutlierDetection.split_external_local_orig
    in_errors>` is *false*, all errors (externally and locally generated) are
    used to calculate success rate statistics. See :ref:`Cluster outlier
    detection <arch_overview_outlier_detection>` documentation for details.
    """

    CONSECUTIVE_LOCAL_ORIGIN_FAILURE = 3
    """
    Consecutive local origin failures: Connection failures, resets, timeouts,
    etc This type of ejection happens only when :ref:`outlier_detection.split_e
    xternal_local_origin_errors<envoy_api_field_cluster.OutlierDetection.split_
    external_local_origin_errors>` is set to *true*. See :ref:`Cluster outlier
    detection <arch_overview_outlier_detection>` documentation for
    """

    SUCCESS_RATE_LOCAL_ORIGIN = 4
    """
    Runs over aggregated success rate statistics for local origin failures for
    all hosts in the cluster and selects hosts for which success rate deviates
    from other hosts in the cluster. This type of ejection happens only when :r
    ef:`outlier_detection.split_external_local_origin_errors<envoy_api_field_cl
    uster.OutlierDetection.split_external_local_origin_errors>` is set to
    *true*. See :ref:`Cluster outlier detection
    <arch_overview_outlier_detection>` documentation for
    """

    FAILURE_PERCENTAGE = 5
    """
    Runs over aggregated success rate statistics from every host in cluster and
    selects hosts for which ratio of failed replies is above configured value.
    """

    FAILURE_PERCENTAGE_LOCAL_ORIGIN = 6
    """
    Runs over aggregated success rate statistics for local origin failures from
    every host in cluster and selects hosts for which ratio of failed replies
    is above configured value.
    """


class Action(betterproto.Enum):
    """Represents possible action applied to upstream host"""

    EJECT = 0
    """In case host was excluded from service"""

    UNEJECT = 1
    """In case host was brought back into service"""


@dataclass(eq=False, repr=False)
class OutlierDetectionEvent(betterproto.Message):
    """[#next-free-field: 12]"""

    type: "OutlierEjectionType" = betterproto.enum_field(1)
    """In case of eject represents type of ejection that took place."""

    timestamp: datetime = betterproto.message_field(2)
    """Timestamp for event."""

    secs_since_last_action: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT64
    )
    """
    The time in seconds since the last action (either an ejection or
    unejection) took place.
    """

    cluster_name: str = betterproto.string_field(4)
    """
    The :ref:`cluster <envoy_api_msg_Cluster>` that owns the ejected host.
    """

    upstream_url: str = betterproto.string_field(5)
    """The URL of the ejected host. E.g., ``tcp://1.2.3.4:80``."""

    action: "Action" = betterproto.enum_field(6)
    """The action that took place."""

    num_ejections: int = betterproto.uint32_field(7)
    """
    If ``action`` is ``eject``, specifies the number of times the host has been
    ejected (local to that Envoy and gets reset if the host gets removed from
    the upstream cluster for any reason and then re-added).
    """

    enforced: bool = betterproto.bool_field(8)
    """
    If ``action`` is ``eject``, specifies if the ejection was enforced.
    ``true`` means the host was ejected. ``false`` means the event was logged
    but the host was not actually ejected.
    """

    eject_success_rate_event: "OutlierEjectSuccessRate" = betterproto.message_field(
        9, group="event"
    )
    eject_consecutive_event: "OutlierEjectConsecutive" = betterproto.message_field(
        10, group="event"
    )
    eject_failure_percentage_event: "OutlierEjectFailurePercentage" = (
        betterproto.message_field(11, group="event")
    )


@dataclass(eq=False, repr=False)
class OutlierEjectSuccessRate(betterproto.Message):
    host_success_rate: int = betterproto.uint32_field(1)
    """
    Host’s success rate at the time of the ejection event on a 0-100 range.
    """

    cluster_average_success_rate: int = betterproto.uint32_field(2)
    """
    Average success rate of the hosts in the cluster at the time of the
    ejection event on a 0-100 range.
    """

    cluster_success_rate_ejection_threshold: int = betterproto.uint32_field(3)
    """Success rate ejection threshold at the time of the ejection event."""


@dataclass(eq=False, repr=False)
class OutlierEjectConsecutive(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class OutlierEjectFailurePercentage(betterproto.Message):
    host_success_rate: int = betterproto.uint32_field(1)
    """
    Host's success rate at the time of the ejection event on a 0-100 range.
    """
