# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/trace/v3/datadog.proto, envoy/config/trace/v3/dynamic_ot.proto, envoy/config/trace/v3/http_tracer.proto, envoy/config/trace/v3/lightstep.proto, envoy/config/trace/v3/opencensus.proto, envoy/config/trace/v3/opentelemetry.proto, envoy/config/trace/v3/service.proto, envoy/config/trace/v3/skywalking.proto, envoy/config/trace/v3/trace.proto, envoy/config/trace/v3/xray.proto, envoy/config/trace/v3/zipkin.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from .....opencensus.proto.trace import v1 as ____opencensus_proto_trace_v1__
from ...core import v3 as __core_v3__


class LightstepConfigPropagationMode(betterproto.Enum):
    """Available propagation modes"""

    ENVOY = 0
    """Propagate trace context in the single header x-ot-span-context."""

    LIGHTSTEP = 1
    """Propagate trace context using LightStep's native format."""

    B3 = 2
    """Propagate trace context using the b3 format."""

    TRACE_CONTEXT = 3
    """Propagation trace context using the w3 trace-context standard."""


class OpenCensusConfigTraceContext(betterproto.Enum):
    NONE = 0
    """No-op default, no trace context is utilized."""

    TRACE_CONTEXT = 1
    """W3C Trace-Context format "traceparent:" header."""

    GRPC_TRACE_BIN = 2
    """Binary "grpc-trace-bin:" header."""

    CLOUD_TRACE_CONTEXT = 3
    """X-Cloud-Trace-Context:" header."""

    B3 = 4
    """X-B3-* headers."""


class ZipkinConfigCollectorEndpointVersion(betterproto.Enum):
    """Available Zipkin collector endpoint versions."""

    DEPRECATED_AND_UNAVAILABLE_DO_NOT_USE = 0
    """
    Zipkin API v1, JSON over HTTP. [#comment: The default implementation of
    Zipkin client before this field is added was only v1 and the way user
    configure this was by not explicitly specifying the version. Consequently,
    before this is added, the corresponding Zipkin collector expected to
    receive v1 payload. Hence the motivation of adding HTTP_JSON_V1 as the
    default is to avoid a breaking change when user upgrading Envoy with this
    change. Furthermore, we also immediately deprecate this field, since in
    Zipkin realm this v1 version is considered to be not preferable anymore.]
    """

    HTTP_JSON = 1
    """Zipkin API v2, JSON over HTTP."""

    HTTP_PROTO = 2
    """Zipkin API v2, protobuf over HTTP."""

    GRPC = 3
    """[#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class Tracing(betterproto.Message):
    """
    The tracing configuration specifies settings for an HTTP tracer provider
    used by Envoy. Envoy may support other tracers in the future, but right now
    the HTTP tracer is the only one supported. .. attention::   Use of this
    message type has been deprecated in favor of direct use of
    :ref:`Tracing.Http <envoy_v3_api_msg_config.trace.v3.Tracing.Http>`.
    """

    http: "TracingHttp" = betterproto.message_field(1)
    """Provides configuration for the HTTP tracer."""


@dataclass(eq=False, repr=False)
class TracingHttp(betterproto.Message):
    """
    Configuration for an HTTP tracer provider used by Envoy. The configuration
    is defined by the :ref:`HttpConnectionManager.Tracing <envoy_v3_api_msg_ext
    ensions.filters.network.http_connection_manager.v3.HttpConnectionManager.Tr
    acing>` :ref:`provider <envoy_v3_api_field_extensions.filters.network.http_
    connection_manager.v3.HttpConnectionManager.Tracing.provider>` field.
    """

    name: str = betterproto.string_field(1)
    """
    The name of the HTTP trace driver to instantiate. The name must match a
    supported HTTP trace driver. See the :ref:`extensions listed in
    typed_config below <extension_category_envoy.tracers>` for the default list
    of the HTTP trace driver.
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )


@dataclass(eq=False, repr=False)
class DatadogConfig(betterproto.Message):
    """
    Configuration for the Datadog tracer. [#extension: envoy.tracers.datadog]
    """

    collector_cluster: str = betterproto.string_field(1)
    """The cluster to use for submitting traces to the Datadog agent."""

    service_name: str = betterproto.string_field(2)
    """The name used for the service when traces are generated by envoy."""

    collector_hostname: str = betterproto.string_field(3)
    """
    Optional hostname to use when sending spans to the collector_cluster.
    Useful for collectors that require a specific hostname. Defaults to
    :ref:`collector_cluster
    <envoy_v3_api_field_config.trace.v3.DatadogConfig.collector_cluster>`
    above.
    """


@dataclass(eq=False, repr=False)
class DynamicOtConfig(betterproto.Message):
    """
    DynamicOtConfig is used to dynamically load a tracer from a shared library
    that implements the `OpenTracing dynamic loading API
    <https://github.com/opentracing/opentracing-cpp>`_. [#extension:
    envoy.tracers.dynamic_ot]
    """

    library: str = betterproto.string_field(1)
    """
    Dynamic library implementing the `OpenTracing API
    <https://github.com/opentracing/opentracing-cpp>`_.
    """

    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)
    """
    The configuration to use when creating a tracer from the given dynamic
    library.
    """


@dataclass(eq=False, repr=False)
class LightstepConfig(betterproto.Message):
    """
    Configuration for the LightStep tracer. [#extension:
    envoy.tracers.lightstep] [#not-implemented-hide:]
    """

    collector_cluster: str = betterproto.string_field(1)
    """The cluster manager cluster that hosts the LightStep collectors."""

    access_token_file: str = betterproto.string_field(2)
    """
    File containing the access token to the `LightStep
    <https://lightstep.com/>`_ API.
    """

    access_token: "__core_v3__.DataSource" = betterproto.message_field(4)
    """Access token to the `LightStep <https://lightstep.com/>`_ API."""

    propagation_modes: List["LightstepConfigPropagationMode"] = betterproto.enum_field(
        3
    )
    """Propagation modes to use by LightStep's tracer."""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("access_token_file"):
            warnings.warn(
                "LightstepConfig.access_token_file is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class OpenCensusConfig(betterproto.Message):
    """
    Configuration for the OpenCensus tracer. [#next-free-field: 15]
    [#extension: envoy.tracers.opencensus]
    """

    trace_config: "____opencensus_proto_trace_v1__.TraceConfig" = (
        betterproto.message_field(1)
    )
    """
    Configures tracing, e.g. the sampler, max number of annotations, etc.
    """

    stdout_exporter_enabled: bool = betterproto.bool_field(2)
    """
    Enables the stdout exporter if set to true. This is intended for debugging
    purposes.
    """

    stackdriver_exporter_enabled: bool = betterproto.bool_field(3)
    """
    Enables the Stackdriver exporter if set to true. The project_id must also
    be set.
    """

    stackdriver_project_id: str = betterproto.string_field(4)
    """The Cloud project_id to use for Stackdriver tracing."""

    stackdriver_address: str = betterproto.string_field(10)
    """
    (optional) By default, the Stackdriver exporter will connect to production
    Stackdriver. If stackdriver_address is non-empty, it will instead connect
    to this address, which is in the gRPC format:
    https://github.com/grpc/grpc/blob/master/doc/naming.md
    """

    stackdriver_grpc_service: "__core_v3__.GrpcService" = betterproto.message_field(13)
    """
    (optional) The gRPC server that hosts Stackdriver tracing service. Only
    Google gRPC is supported. If :ref:`target_uri
    <envoy_v3_api_field_config.core.v3.GrpcService.GoogleGrpc.target_uri>` is
    not provided, the default production Stackdriver address will be used.
    """

    zipkin_exporter_enabled: bool = betterproto.bool_field(5)
    """
    Enables the Zipkin exporter if set to true. The url and service name must
    also be set. This is deprecated, prefer to use Envoy's :ref:`native Zipkin
    tracer <envoy_v3_api_msg_config.trace.v3.ZipkinConfig>`.
    """

    zipkin_url: str = betterproto.string_field(6)
    """
    The URL to Zipkin, e.g. "http://127.0.0.1:9411/api/v2/spans". This is
    deprecated, prefer to use Envoy's :ref:`native Zipkin tracer
    <envoy_v3_api_msg_config.trace.v3.ZipkinConfig>`.
    """

    ocagent_exporter_enabled: bool = betterproto.bool_field(11)
    """
    Enables the OpenCensus Agent exporter if set to true. The ocagent_address
    or ocagent_grpc_service must also be set.
    """

    ocagent_address: str = betterproto.string_field(12)
    """
    The address of the OpenCensus Agent, if its exporter is enabled, in gRPC
    format: https://github.com/grpc/grpc/blob/master/doc/naming.md
    [#comment:TODO: deprecate this field]
    """

    ocagent_grpc_service: "__core_v3__.GrpcService" = betterproto.message_field(14)
    """
    (optional) The gRPC server hosted by the OpenCensus Agent. Only Google gRPC
    is supported. This is only used if the ocagent_address is left empty.
    """

    incoming_trace_context: List[
        "OpenCensusConfigTraceContext"
    ] = betterproto.enum_field(8)
    """
    List of incoming trace context headers we will accept. First one found
    wins.
    """

    outgoing_trace_context: List[
        "OpenCensusConfigTraceContext"
    ] = betterproto.enum_field(9)
    """List of outgoing trace context headers we will produce."""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("zipkin_exporter_enabled"):
            warnings.warn(
                "OpenCensusConfig.zipkin_exporter_enabled is deprecated",
                DeprecationWarning,
            )
        if self.is_set("zipkin_url"):
            warnings.warn(
                "OpenCensusConfig.zipkin_url is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class OpenTelemetryConfig(betterproto.Message):
    """
    Configuration for the OpenTelemetry tracer.  [#extension:
    envoy.tracers.opentelemetry]
    """

    grpc_service: "__core_v3__.GrpcService" = betterproto.message_field(1)
    """
    The upstream gRPC cluster that will receive OTLP traces. Note that the
    tracer drops traces if the server does not read data fast enough.
    """

    service_name: str = betterproto.string_field(2)
    """
    The name for the service. This will be populated in the ResourceSpan
    Resource attributes. If it is not provided, it will default to
    "unknown_service:envoy".
    """


@dataclass(eq=False, repr=False)
class TraceServiceConfig(betterproto.Message):
    """Configuration structure."""

    grpc_service: "__core_v3__.GrpcService" = betterproto.message_field(1)
    """The upstream gRPC cluster that hosts the metrics service."""


@dataclass(eq=False, repr=False)
class ZipkinConfig(betterproto.Message):
    """
    Configuration for the Zipkin tracer. [#extension: envoy.tracers.zipkin]
    [#next-free-field: 8]
    """

    collector_cluster: str = betterproto.string_field(1)
    """The cluster manager cluster that hosts the Zipkin collectors."""

    collector_endpoint: str = betterproto.string_field(2)
    """
    The API endpoint of the Zipkin service where the spans will be sent. When
    using a standard Zipkin installation.
    """

    trace_id_128_bit: bool = betterproto.bool_field(3)
    """
    Determines whether a 128bit trace id will be used when creating a new trace
    instance. The default value is false, which will result in a 64 bit trace
    id being used.
    """

    shared_span_context: Optional[bool] = betterproto.message_field(
        4, wraps=betterproto.TYPE_BOOL
    )
    """
    Determines whether client and server spans will share the same span
    context. The default value is true.
    """

    collector_endpoint_version: "ZipkinConfigCollectorEndpointVersion" = (
        betterproto.enum_field(5)
    )
    """Determines the selected collector endpoint version."""

    collector_hostname: str = betterproto.string_field(6)
    """
    Optional hostname to use when sending spans to the collector_cluster.
    Useful for collectors that require a specific hostname. Defaults to
    :ref:`collector_cluster
    <envoy_v3_api_field_config.trace.v3.ZipkinConfig.collector_cluster>` above.
    """

    split_spans_for_request: bool = betterproto.bool_field(7)
    """
    If this is set to true, then Envoy will be treated as an independent hop in
    trace chain. A complete span pair will be created for a single request.
    Server span will be created for the downstream request and client span will
    be created for the related upstream request. This should be set to true in
    the following cases: * The Envoy Proxy is used as gateway or ingress. * The
    Envoy Proxy is used as sidecar but inbound traffic capturing or outbound
    traffic capturing is disabled. * Any case that the `start_child_span of
    router <envoy_v3_api_field_extensions.filters.http.router.v3.Router.start_c
    hild_span>` is set to true. .. attention::   If this is set to true, then
    the   :ref:`start_child_span of router <envoy_v3_api_field_extensions.filte
    rs.http.router.v3.Router.start_child_span>`   SHOULD be set to true also to
    ensure the correctness of trace chain.
    """


@dataclass(eq=False, repr=False)
class XRayConfig(betterproto.Message):
    """[#extension: envoy.tracers.xray]"""

    daemon_endpoint: "__core_v3__.SocketAddress" = betterproto.message_field(1)
    """
    The UDP endpoint of the X-Ray Daemon where the spans will be sent. If this
    value is not set, the default value of 127.0.0.1:2000 will be used.
    """

    segment_name: str = betterproto.string_field(2)
    """The name of the X-Ray segment."""

    sampling_rule_manifest: "__core_v3__.DataSource" = betterproto.message_field(3)
    """
    The location of a local custom sampling rules JSON file. For an example of
    the sampling rules see: `X-Ray SDK documentation
    <https://docs.aws.amazon.com/xray/latest/devguide/xray-sdk-go-
    configuration.html#xray-sdk-go-configuration-sampling>`_
    """

    segment_fields: "XRayConfigSegmentFields" = betterproto.message_field(4)
    """
    Optional custom fields to be added to each trace segment. see: `X-Ray
    Segment Document documentation
    <https://docs.aws.amazon.com/xray/latest/devguide/xray-api-
    segmentdocuments.html>`__
    """


@dataclass(eq=False, repr=False)
class XRayConfigSegmentFields(betterproto.Message):
    origin: str = betterproto.string_field(1)
    """The type of AWS resource, e.g. "AWS::AppMesh::Proxy"."""

    aws: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(2)
    """
    AWS resource metadata dictionary. See: `X-Ray Segment Document
    documentation <https://docs.aws.amazon.com/xray/latest/devguide/xray-api-
    segmentdocuments.html#api-segmentdocuments-aws>`__
    """


@dataclass(eq=False, repr=False)
class SkyWalkingConfig(betterproto.Message):
    """
    Configuration for the SkyWalking tracer. Please note that if SkyWalking
    tracer is used as the provider of http tracer, then :ref:`start_child_span
    <envoy_v3_api_field_extensions.filters.http.router.v3.Router.start_child_sp
    an>` in the router must be set to true to get the correct topology and
    tracing data. Moreover, SkyWalking Tracer does not support SkyWalking
    extension header (``sw8-x``) temporarily. [#extension:
    envoy.tracers.skywalking]
    """

    grpc_service: "__core_v3__.GrpcService" = betterproto.message_field(1)
    """SkyWalking collector service."""

    client_config: "ClientConfig" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ClientConfig(betterproto.Message):
    """Client config for SkyWalking tracer."""

    service_name: str = betterproto.string_field(1)
    """
    Service name for SkyWalking tracer. If this field is empty, then local
    service cluster name that configured by :ref:`Bootstrap node
    <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.node>` message's
    :ref:`cluster <envoy_v3_api_field_config.core.v3.Node.cluster>` field or
    command line option :option:`--service-cluster` will be used. If both this
    field and local service cluster name are empty, ``EnvoyProxy`` is used as
    the service name by default.
    """

    instance_name: str = betterproto.string_field(2)
    """
    Service instance name for SkyWalking tracer. If this field is empty, then
    local service node that configured by :ref:`Bootstrap node
    <envoy_v3_api_field_config.bootstrap.v3.Bootstrap.node>` message's :ref:`id
    <envoy_v3_api_field_config.core.v3.Node.id>` field or command line  option
    :option:`--service-node` will be used. If both this field and local service
    node are empty, ``EnvoyProxy`` is used as the instance name by default.
    """

    backend_token: str = betterproto.string_field(3, group="backend_token_specifier")
    """Inline authentication token string."""

    max_cache_size: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    """
    Envoy caches the segment in memory when the SkyWalking backend service is
    temporarily unavailable. This field specifies the maximum number of
    segments that can be cached. If not specified, the default is 1024.
    """
