# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/tap/v3/common.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from datetime import timedelta
from typing import (
    List,
    Optional,
)

import betterproto

from ...common.matcher import v3 as __common_matcher_v3__
from ...core import v3 as __core_v3__
from ...route import v3 as __route_v3__


class OutputSinkFormat(betterproto.Enum):
    """
    Output format. All output is in the form of one or more :ref:`TraceWrapper
    <envoy_v3_api_msg_data.tap.v3.TraceWrapper>` messages. This enumeration
    indicates how those messages are written. Note that not all sinks support
    all output formats. See individual sink documentation for more information.
    """

    JSON_BODY_AS_BYTES = 0
    """
    Each message will be written as JSON. Any :ref:`body
    <envoy_v3_api_msg_data.tap.v3.Body>` data will be present in the
    :ref:`as_bytes <envoy_v3_api_field_data.tap.v3.Body.as_bytes>` field. This
    means that body data will be base64 encoded as per the `proto3 JSON
    mappings <https://developers.google.com/protocol-
    buffers/docs/proto3#json>`_.
    """

    JSON_BODY_AS_STRING = 1
    """
    Each message will be written as JSON. Any :ref:`body
    <envoy_v3_api_msg_data.tap.v3.Body>` data will be present in the
    :ref:`as_string <envoy_v3_api_field_data.tap.v3.Body.as_string>` field.
    This means that body data will be string encoded as per the `proto3 JSON
    mappings <https://developers.google.com/protocol-
    buffers/docs/proto3#json>`_. This format type is useful when it is known
    that that body is human readable (e.g., JSON over HTTP) and the user wishes
    to view it directly without being forced to base64 decode the body.
    """

    PROTO_BINARY = 2
    """
    Binary proto format. Note that binary proto is not self-delimiting. If a
    sink writes multiple binary messages without any length information the
    data stream will not be useful. However, for certain sinks that are self-
    delimiting (e.g., one message per file) this output format makes
    consumption simpler.
    """

    PROTO_BINARY_LENGTH_DELIMITED = 3
    """
    Messages are written as a sequence tuples, where each tuple is the message
    length encoded as a `protobuf 32-bit varint
    <https://developers.google.com/protocol-
    buffers/docs/reference/cpp/google.protobuf.io.coded_stream>`_ followed by
    the binary message. The messages can be read back using the language
    specific protobuf coded stream implementation to obtain the message length
    and the message.
    """

    PROTO_TEXT = 4
    """Text proto format."""


@dataclass(eq=False, repr=False)
class TapConfig(betterproto.Message):
    """Tap configuration."""

    match_config: "MatchPredicate" = betterproto.message_field(1)
    """
    The match configuration. If the configuration matches the data source being
    tapped, a tap will occur, with the result written to the configured output.
    Exactly one of :ref:`match
    <envoy_v3_api_field_config.tap.v3.TapConfig.match>` and :ref:`match_config
    <envoy_v3_api_field_config.tap.v3.TapConfig.match_config>` must be set. If
    both are set, the :ref:`match
    <envoy_v3_api_field_config.tap.v3.TapConfig.match>` will be used.
    """

    match: "__common_matcher_v3__.MatchPredicate" = betterproto.message_field(4)
    """
    The match configuration. If the configuration matches the data source being
    tapped, a tap will occur, with the result written to the configured output.
    Exactly one of :ref:`match
    <envoy_v3_api_field_config.tap.v3.TapConfig.match>` and :ref:`match_config
    <envoy_v3_api_field_config.tap.v3.TapConfig.match_config>` must be set. If
    both are set, the :ref:`match
    <envoy_v3_api_field_config.tap.v3.TapConfig.match>` will be used.
    """

    output_config: "OutputConfig" = betterproto.message_field(2)
    """
    The tap output configuration. If a match configuration matches a data
    source being tapped, a tap will occur and the data will be written to the
    configured output.
    """

    tap_enabled: "__core_v3__.RuntimeFractionalPercent" = betterproto.message_field(3)
    """
    [#not-implemented-hide:] Specify if Tap matching is enabled. The % of
    requests\connections for which the tap matching is enabled. When not
    enabled, the request\connection will not be recorded. .. note::   This
    field defaults to 100/:ref:`HUNDRED
    <envoy_v3_api_enum_type.v3.FractionalPercent.DenominatorType>`.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("match_config"):
            warnings.warn("TapConfig.match_config is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class MatchPredicate(betterproto.Message):
    """
    Tap match configuration. This is a recursive structure which allows complex
    nested match configurations to be built using various logical operators.
    [#next-free-field: 11]
    """

    or_match: "MatchPredicateMatchSet" = betterproto.message_field(1, group="rule")
    """
    A set that describes a logical OR. If any member of the set matches, the
    match configuration matches.
    """

    and_match: "MatchPredicateMatchSet" = betterproto.message_field(2, group="rule")
    """
    A set that describes a logical AND. If all members of the set match, the
    match configuration matches.
    """

    not_match: "MatchPredicate" = betterproto.message_field(3, group="rule")
    """
    A negation match. The match configuration will match if the negated match
    condition matches.
    """

    any_match: bool = betterproto.bool_field(4, group="rule")
    """The match configuration will always match."""

    http_request_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        5, group="rule"
    )
    """HTTP request headers match configuration."""

    http_request_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        6, group="rule"
    )
    """HTTP request trailers match configuration."""

    http_response_headers_match: "HttpHeadersMatch" = betterproto.message_field(
        7, group="rule"
    )
    """HTTP response headers match configuration."""

    http_response_trailers_match: "HttpHeadersMatch" = betterproto.message_field(
        8, group="rule"
    )
    """HTTP response trailers match configuration."""

    http_request_generic_body_match: "HttpGenericBodyMatch" = betterproto.message_field(
        9, group="rule"
    )
    """HTTP request generic body match configuration."""

    http_response_generic_body_match: "HttpGenericBodyMatch" = (
        betterproto.message_field(10, group="rule")
    )
    """HTTP response generic body match configuration."""


@dataclass(eq=False, repr=False)
class MatchPredicateMatchSet(betterproto.Message):
    """A set of match configurations used for logical operations."""

    rules: List["MatchPredicate"] = betterproto.message_field(1)
    """The list of rules that make up the set."""


@dataclass(eq=False, repr=False)
class HttpHeadersMatch(betterproto.Message):
    """HTTP headers match configuration."""

    headers: List["__route_v3__.HeaderMatcher"] = betterproto.message_field(1)
    """HTTP headers to match."""


@dataclass(eq=False, repr=False)
class HttpGenericBodyMatch(betterproto.Message):
    """
    HTTP generic body match configuration. List of text strings and hex strings
    to be located in HTTP body. All specified strings must be found in the HTTP
    body for positive match. The search may be limited to specified number of
    bytes from the body start. .. attention::   Searching for patterns in HTTP
    body is potentially cpu intensive. For each specified pattern, http body is
    scanned byte by byte to find a match.   If multiple patterns are specified,
    the process is repeated for each pattern. If location of a pattern is
    known, ``bytes_limit`` should be specified   to scan only part of the http
    body.
    """

    bytes_limit: int = betterproto.uint32_field(1)
    """
    Limits search to specified number of bytes - default zero (no limit - match
    entire captured buffer).
    """

    patterns: List["HttpGenericBodyMatchGenericTextMatch"] = betterproto.message_field(
        2
    )
    """List of patterns to match."""


@dataclass(eq=False, repr=False)
class HttpGenericBodyMatchGenericTextMatch(betterproto.Message):
    string_match: str = betterproto.string_field(1, group="rule")
    """Text string to be located in HTTP body."""

    binary_match: bytes = betterproto.bytes_field(2, group="rule")
    """Sequence of bytes to be located in HTTP body."""


@dataclass(eq=False, repr=False)
class OutputConfig(betterproto.Message):
    """Tap output configuration."""

    sinks: List["OutputSink"] = betterproto.message_field(1)
    """
    Output sinks for tap data. Currently a single sink is allowed in the list.
    Once multiple sink types are supported this constraint will be relaxed.
    """

    max_buffered_rx_bytes: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_UINT32
    )
    """
    For buffered tapping, the maximum amount of received body that will be
    buffered prior to truncation. If truncation occurs, the :ref:`truncated
    <envoy_v3_api_field_data.tap.v3.Body.truncated>` field will be set. If not
    specified, the default is 1KiB.
    """

    max_buffered_tx_bytes: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    """
    For buffered tapping, the maximum amount of transmitted body that will be
    buffered prior to truncation. If truncation occurs, the :ref:`truncated
    <envoy_v3_api_field_data.tap.v3.Body.truncated>` field will be set. If not
    specified, the default is 1KiB.
    """

    streaming: bool = betterproto.bool_field(4)
    """
    Indicates whether taps produce a single buffered message per tap, or
    multiple streamed messages per tap in the emitted :ref:`TraceWrapper
    <envoy_v3_api_msg_data.tap.v3.TraceWrapper>` messages. Note that streamed
    tapping does not mean that no buffering takes place. Buffering may be
    required if data is processed before a match can be determined. See the
    HTTP tap filter :ref:`streaming <config_http_filters_tap_streaming>`
    documentation for more information.
    """


@dataclass(eq=False, repr=False)
class OutputSink(betterproto.Message):
    """Tap output sink configuration. [#next-free-field: 6]"""

    format: "OutputSinkFormat" = betterproto.enum_field(1)
    """Sink output format."""

    streaming_admin: "StreamingAdminSink" = betterproto.message_field(
        2, group="output_sink_type"
    )
    """
    Tap output will be streamed out the :http:post:`/tap` admin endpoint. ..
    attention::   It is only allowed to specify the streaming admin output sink
    if the tap is being   configured from the :http:post:`/tap` admin endpoint.
    Thus, if an extension has   been configured to receive tap configuration
    from some other source (e.g., static   file, XDS, etc.) configuring the
    streaming admin output type will fail.
    """

    file_per_tap: "FilePerTapSink" = betterproto.message_field(
        3, group="output_sink_type"
    )
    """Tap output will be written to a file per tap sink."""

    streaming_grpc: "StreamingGrpcSink" = betterproto.message_field(
        4, group="output_sink_type"
    )
    """
    [#not-implemented-hide:] GrpcService to stream data to. The format argument
    must be PROTO_BINARY. [#comment: TODO(samflattery): remove cleanup in
    uber_per_filter.cc once implemented]
    """

    buffered_admin: "BufferedAdminSink" = betterproto.message_field(
        5, group="output_sink_type"
    )
    """
    Tap output will be buffered in a single block before flushing to the
    :http:post:`/tap` admin endpoint .. attention::   It is only allowed to
    specify the buffered admin output sink if the tap is being   configured
    from the :http:post:`/tap` admin endpoint. Thus, if an extension has   been
    configured to receive tap configuration from some other source (e.g.,
    static   file, XDS, etc.) configuring the buffered admin output type will
    fail.
    """


@dataclass(eq=False, repr=False)
class StreamingAdminSink(betterproto.Message):
    """Streaming admin sink configuration."""

    pass


@dataclass(eq=False, repr=False)
class BufferedAdminSink(betterproto.Message):
    """
    BufferedAdminSink configures a tap output to collect traces without
    returning them until one of multiple criteria are satisfied. Similar to
    StreamingAdminSink, it is only allowed to specify the buffered admin output
    sink if the tap is being configured from the ``/tap`` admin endpoint.
    """

    max_traces: int = betterproto.uint64_field(1)
    """
    Stop collecting traces when the specified number are collected. If other
    criteria for ending collection are reached first, this value will not be
    used.
    """

    timeout: timedelta = betterproto.message_field(2)
    """
    Acts as a fallback to prevent the client from waiting for long periods of
    time. After timeout has occurred, a buffer flush will be triggered,
    returning the traces buffered so far. This may result in returning fewer
    traces than were requested, and in the case that no traces are buffered
    during this time, no traces will be returned. Specifying 0 for the timeout
    value (or not specifying a value at all) indicates an infinite timeout.
    """


@dataclass(eq=False, repr=False)
class FilePerTapSink(betterproto.Message):
    """
    The file per tap sink outputs a discrete file for every tapped stream.
    """

    path_prefix: str = betterproto.string_field(1)
    """
    Path prefix. The output file will be of the form <path_prefix>_<id>.pb,
    where <id> is an identifier distinguishing the recorded trace for stream
    instances (the Envoy connection ID, HTTP stream ID, etc.).
    """


@dataclass(eq=False, repr=False)
class StreamingGrpcSink(betterproto.Message):
    """
    [#not-implemented-hide:] Streaming gRPC sink configuration sends the taps
    to an external gRPC server.
    """

    tap_id: str = betterproto.string_field(1)
    """
    Opaque identifier, that will be sent back to the streaming grpc server.
    """

    grpc_service: "__core_v3__.GrpcService" = betterproto.message_field(2)
    """The gRPC server that hosts the Tap Sink Service."""
