# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/metrics/v3/metrics_service.proto, envoy/config/metrics/v3/stats.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ....type.matcher import v3 as ___type_matcher_v3__
from ...core import v3 as __core_v3__


@dataclass(eq=False, repr=False)
class StatsSink(betterproto.Message):
    """Configuration for pluggable stats sinks."""

    name: str = betterproto.string_field(1)
    """
    The name of the stats sink to instantiate. The name must match a supported
    stats sink. See the :ref:`extensions listed in typed_config below
    <extension_category_envoy.stats_sinks>` for the default list of available
    stats sink. Sinks optionally support tagged/multiple dimensional metrics.
    """

    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )


@dataclass(eq=False, repr=False)
class StatsConfig(betterproto.Message):
    """Statistics configuration such as tagging."""

    stats_tags: List["TagSpecifier"] = betterproto.message_field(1)
    """
    Each stat name is independently processed through these tag specifiers.
    When a tag is matched, the first capture group is not immediately removed
    from the name, so later :ref:`TagSpecifiers
    <envoy_v3_api_msg_config.metrics.v3.TagSpecifier>` can also match that same
    portion of the match. After all tag matching is complete, a tag-extracted
    version of the name is produced and is used in stats sinks that represent
    tags, such as Prometheus.
    """

    use_all_default_tags: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL
    )
    """
    Use all default tag regexes specified in Envoy. These can be combined with
    custom tags specified in :ref:`stats_tags
    <envoy_v3_api_field_config.metrics.v3.StatsConfig.stats_tags>`. They will
    be processed before the custom tags. .. note::   If any default tags are
    specified twice, the config will be considered   invalid. See
    :repo:`well_known_names.h <source/common/config/well_known_names.h>` for a
    list of the default tags in Envoy. If not provided, the value is assumed to
    be true.
    """

    stats_matcher: "StatsMatcher" = betterproto.message_field(3)
    """
    Inclusion/exclusion matcher for stat name creation. If not provided, all
    stats are instantiated as normal. Preventing the instantiation of certain
    families of stats can improve memory performance for Envoys running
    especially large configs. .. warning::   Excluding stats may affect Envoy's
    behavior in undocumented ways. See   `issue #8771
    <https://github.com/envoyproxy/envoy/issues/8771>`_ for more information.
    If any unexpected behavior changes are observed, please open a new issue
    immediately.
    """

    histogram_bucket_settings: List[
        "HistogramBucketSettings"
    ] = betterproto.message_field(4)
    """
    Defines rules for setting the histogram buckets. Rules are evaluated in
    order, and the first match is applied. If no match is found (or if no rules
    are set), the following default buckets are used:   .. code-block:: json
    [       0.5,       1,       5,       10,       25,       50,       100,
    250,       500,       1000,       2500,       5000,       10000,
    30000,       60000,       300000,       600000,       1800000,
    3600000     ]
    """


@dataclass(eq=False, repr=False)
class StatsMatcher(betterproto.Message):
    """Configuration for disabling stat instantiation."""

    reject_all: bool = betterproto.bool_field(1, group="stats_matcher")
    """
    If ``reject_all`` is true, then all stats are disabled. If ``reject_all``
    is false, then all stats are enabled.
    """

    exclusion_list: "___type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(2, group="stats_matcher")
    )
    """
    Exclusive match. All stats are enabled except for those matching one of the
    supplied StringMatcher protos.
    """

    inclusion_list: "___type_matcher_v3__.ListStringMatcher" = (
        betterproto.message_field(3, group="stats_matcher")
    )
    """
    Inclusive match. No stats are enabled except for those matching one of the
    supplied StringMatcher protos.
    """


@dataclass(eq=False, repr=False)
class TagSpecifier(betterproto.Message):
    """
    Designates a tag name and value pair. The value may be either a fixed value
    or a regex providing the value via capture groups. The specified tag will
    be unconditionally set if a fixed value, otherwise it will only be set if
    one or more capture groups in the regex match.
    """

    tag_name: str = betterproto.string_field(1)
    """
    Attaches an identifier to the tag values to identify the tag being in the
    sink. Envoy has a set of default names and regexes to extract dynamic
    portions of existing stats, which can be found in :repo:`well_known_names.h
    <source/common/config/well_known_names.h>` in the Envoy repository. If a
    :ref:`tag_name
    <envoy_v3_api_field_config.metrics.v3.TagSpecifier.tag_name>` is provided
    in the config and neither :ref:`regex
    <envoy_v3_api_field_config.metrics.v3.TagSpecifier.regex>` or
    :ref:`fixed_value
    <envoy_v3_api_field_config.metrics.v3.TagSpecifier.fixed_value>` were
    specified, Envoy will attempt to find that name in its set of defaults and
    use the accompanying regex. .. note::   A stat name may be spelled in such
    a way that it matches two different   tag extractors for the same tag name.
    In that case, all but one of the   tag values will be dropped. It is not
    specified which tag value will be   retained. The extraction will only
    occur for one of the extractors, and   only the matched extraction will be
    removed from the tag name.
    """

    regex: str = betterproto.string_field(2, group="tag_value")
    """
    Designates a tag to strip from the tag extracted name and provide as a
    named tag value for all statistics. This will only occur if any part of the
    name matches the regex provided with one or more capture groups. The first
    capture group identifies the portion of the name to remove. The second
    capture group (which will normally be nested inside the first) will
    designate the value of the tag for the statistic. If no second capture
    group is provided, the first will also be used to set the value of the tag.
    All other capture groups will be ignored. Example 1. a stat name
    ``cluster.foo_cluster.upstream_rq_timeout`` and one tag specifier: .. code-
    block:: json   {     "tag_name": "envoy.cluster_name",     "regex":
    "^cluster\\.((.+?)\\.)"   } Note that the regex will remove
    ``foo_cluster.`` making the tag extracted name
    ``cluster.upstream_rq_timeout`` and the tag value for
    ``envoy.cluster_name`` will be ``foo_cluster`` (note: there will be no
    ``.`` character because of the second capture group). Example 2. a stat
    name ``http.connection_manager_1.user_agent.ios.downstream_cx_total`` and
    two tag specifiers: .. code-block:: json   [     {       "tag_name":
    "envoy.http_user_agent",       "regex":
    "^http(?=\\.).*?\\.user_agent\\.((.+?)\\.)\\w+?$"     },     {
    "tag_name": "envoy.http_conn_manager_prefix",       "regex":
    "^http\\.((.*?)\\.)"     }   ] The two regexes of the specifiers will be
    processed from the elaborated stat name. The first regex will save ``ios.``
    as the tag value for ``envoy.http_user_agent``. It will leave it in the
    name for potential matching with additional tag specifiers. After all tag
    specifiers are processed the tags will be removed from the name. The second
    regex will populate tag ``envoy.http_conn_manager_prefix`` with value
    ``connection_manager_1.``, based on the original stat name. As a final
    step, the matched tags are removed, leaving
    ``http.user_agent.downstream_cx_total`` as the tag extracted name.
    """

    fixed_value: str = betterproto.string_field(3, group="tag_value")
    """Specifies a fixed tag value for the ``tag_name``."""


@dataclass(eq=False, repr=False)
class HistogramBucketSettings(betterproto.Message):
    """
    Specifies a matcher for stats and the buckets that matching stats should
    use.
    """

    match: "___type_matcher_v3__.StringMatcher" = betterproto.message_field(1)
    """
    The stats that this rule applies to. The match is applied to the original
    stat name before tag-extraction, for example
    ``cluster.exampleclustername.upstream_cx_length_ms``.
    """

    buckets: List[float] = betterproto.double_field(2)
    """
    Each value is the upper bound of a bucket. Each bucket must be greater than
    0 and unique. The order of the buckets does not matter.
    """


@dataclass(eq=False, repr=False)
class StatsdSink(betterproto.Message):
    """
    Stats configuration proto schema for built-in ``envoy.stat_sinks.statsd``
    sink. This sink does not support tagged metrics. [#extension:
    envoy.stat_sinks.statsd]
    """

    address: "__core_v3__.Address" = betterproto.message_field(
        1, group="statsd_specifier"
    )
    """
    The UDP address of a running `statsd <https://github.com/etsy/statsd>`_
    compliant listener. If specified, statistics will be flushed to this
    address.
    """

    tcp_cluster_name: str = betterproto.string_field(2, group="statsd_specifier")
    """
    The name of a cluster that is running a TCP `statsd
    <https://github.com/etsy/statsd>`_ compliant listener. If specified, Envoy
    will connect to this cluster to flush statistics.
    """

    prefix: str = betterproto.string_field(3)
    """
    Optional custom prefix for StatsdSink. If specified, this will override the
    default prefix. For example: .. code-block:: json   {     "prefix" :
    "envoy-prod"   } will change emitted stats to .. code-block:: cpp   envoy-
    prod.test_counter:1|c   envoy-prod.test_timer:5|ms Note that the default
    prefix, "envoy", will be used if a prefix is not specified. Stats with
    default prefix: .. code-block:: cpp   envoy.test_counter:1|c
    envoy.test_timer:5|ms
    """


@dataclass(eq=False, repr=False)
class DogStatsdSink(betterproto.Message):
    """
    Stats configuration proto schema for built-in
    ``envoy.stat_sinks.dog_statsd`` sink. The sink emits stats with `DogStatsD
    <https://docs.datadoghq.com/guides/dogstatsd/>`_ compatible tags. Tags are
    configurable via :ref:`StatsConfig
    <envoy_v3_api_msg_config.metrics.v3.StatsConfig>`. [#extension:
    envoy.stat_sinks.dog_statsd]
    """

    address: "__core_v3__.Address" = betterproto.message_field(
        1, group="dog_statsd_specifier"
    )
    """
    The UDP address of a running DogStatsD compliant listener. If specified,
    statistics will be flushed to this address.
    """

    prefix: str = betterproto.string_field(3)
    """
    Optional custom metric name prefix. See :ref:`StatsdSink's prefix field
    <envoy_v3_api_field_config.metrics.v3.StatsdSink.prefix>` for more details.
    """

    max_bytes_per_datagram: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT64
    )
    """
    Optional max datagram size to use when sending UDP messages. By default
    Envoy will emit one metric per datagram. By specifying a max-size larger
    than a single metric, Envoy will emit multiple, new-line separated metrics.
    The max datagram size should not exceed your network's MTU. Note that this
    value may not be respected if smaller than a single metric.
    """


@dataclass(eq=False, repr=False)
class HystrixSink(betterproto.Message):
    """
    Stats configuration proto schema for built-in ``envoy.stat_sinks.hystrix``
    sink. The sink emits stats in `text/event-stream
    <https://developer.mozilla.org/en-US/docs/Web/API/Server-
    sent_events/Using_server-sent_events>`_ formatted stream for use by
    `Hystrix dashboard <https://github.com/Netflix-Skunkworks/hystrix-
    dashboard/wiki>`_. Note that only a single HystrixSink should be
    configured. Streaming is started through an admin endpoint
    :http:get:`/hystrix_event_stream`. [#extension: envoy.stat_sinks.hystrix]
    """

    num_buckets: int = betterproto.int64_field(1)
    """
    The number of buckets the rolling statistical window is divided into. Each
    time the sink is flushed, all relevant Envoy statistics are sampled and
    added to the rolling window (removing the oldest samples in the window in
    the process). The sink then outputs the aggregate statistics across the
    current rolling window to the event stream(s). ``rolling_window(ms)`` =
    ``stats_flush_interval(ms)`` * ``num_of_buckets`` More detailed explanation
    can be found in `Hystrix wiki
    <https://github.com/Netflix/Hystrix/wiki/Metrics-and-
    Monitoring#hystrixrollingnumber>`_.
    """


@dataclass(eq=False, repr=False)
class MetricsServiceConfig(betterproto.Message):
    """
    Metrics Service is configured as a built-in
    ``envoy.stat_sinks.metrics_service`` :ref:`StatsSink
    <envoy_v3_api_msg_config.metrics.v3.StatsSink>`. This opaque configuration
    will be used to create Metrics Service. Example: .. code-block:: yaml
    stats_sinks:       - name: envoy.stat_sinks.metrics_service
    typed_config:           "@type":
    type.googleapis.com/envoy.config.metrics.v3.MetricsServiceConfig
    transport_api_version: V3 [#extension: envoy.stat_sinks.metrics_service]
    """

    grpc_service: "__core_v3__.GrpcService" = betterproto.message_field(1)
    """The upstream gRPC cluster that hosts the metrics service."""

    transport_api_version: "__core_v3__.ApiVersion" = betterproto.enum_field(3)
    """
    API version for metric service transport protocol. This describes the
    metric service gRPC endpoint and version of messages used on the wire.
    """

    report_counters_as_deltas: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL
    )
    """
    If true, counters are reported as the delta between flushing intervals.
    Otherwise, the current counter value is reported. Defaults to false.
    Eventually (https://github.com/envoyproxy/envoy/issues/10968) if this value
    is not set, the sink will take updates from the :ref:`MetricsResponse
    <envoy_v3_api_msg_service.metrics.v3.StreamMetricsResponse>`.
    """

    emit_tags_as_labels: bool = betterproto.bool_field(4)
    """
    If true, metrics will have their tags emitted as labels on the metrics
    objects sent to the MetricsService, and the tag extracted name will be used
    instead of the full name, which may contain values used by the tag
    extractor or additional tags added during stats creation.
    """
