# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/config/filter/network/thrift_proxy/v2alpha1/route.proto, envoy/config/filter/network/thrift_proxy/v2alpha1/thrift_proxy.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ......api.v2 import (
    core as _____api_v2_core__,
    route as _____api_v2_route__,
)


class TransportType(betterproto.Enum):
    """Thrift transport types supported by Envoy."""

    AUTO_TRANSPORT = 0
    """
    For downstream connections, the Thrift proxy will attempt to determine
    which transport to use. For upstream connections, the Thrift proxy will use
    same transport as the downstream connection.
    """

    FRAMED = 1
    """The Thrift proxy will use the Thrift framed transport."""

    UNFRAMED = 2
    """The Thrift proxy will use the Thrift unframed transport."""

    HEADER = 3
    """
    The Thrift proxy will assume the client is using the Thrift header
    transport.
    """


class ProtocolType(betterproto.Enum):
    """Thrift Protocol types supported by Envoy."""

    AUTO_PROTOCOL = 0
    """
    For downstream connections, the Thrift proxy will attempt to determine
    which protocol to use. Note that the older, non-strict (or lax) binary
    protocol is not included in automatic protocol detection. For upstream
    connections, the Thrift proxy will use the same protocol as the downstream
    connection.
    """

    BINARY = 1
    """The Thrift proxy will use the Thrift binary protocol."""

    LAX_BINARY = 2
    """The Thrift proxy will use Thrift non-strict binary protocol."""

    COMPACT = 3
    """The Thrift proxy will use the Thrift compact protocol."""

    TWITTER = 4
    """
    The Thrift proxy will use the Thrift "Twitter" protocol implemented by the
    finagle library.
    """


@dataclass(eq=False, repr=False)
class RouteConfiguration(betterproto.Message):
    name: str = betterproto.string_field(1)
    """
    The name of the route configuration. Reserved for future use in
    asynchronous route discovery.
    """

    routes: List["Route"] = betterproto.message_field(2)
    """
    The list of routes that will be matched, in order, against incoming
    requests. The first route that matches will be used.
    """


@dataclass(eq=False, repr=False)
class Route(betterproto.Message):
    match: "RouteMatch" = betterproto.message_field(1)
    """Route matching parameters."""

    route: "RouteAction" = betterproto.message_field(2)
    """Route request to some upstream cluster."""


@dataclass(eq=False, repr=False)
class RouteMatch(betterproto.Message):
    method_name: str = betterproto.string_field(1, group="match_specifier")
    """
    If specified, the route must exactly match the request method name. As a
    special case, an empty string matches any request method name.
    """

    service_name: str = betterproto.string_field(2, group="match_specifier")
    """
    If specified, the route must have the service name as the request method
    name prefix. As a special case, an empty string matches any service name.
    Only relevant when service multiplexing.
    """

    invert: bool = betterproto.bool_field(3)
    """
    Inverts whatever matching is done in the :ref:`method_name <envoy_api_field
    _config.filter.network.thrift_proxy.v2alpha1.RouteMatch.method_name>` or
    :ref:`service_name <envoy_api_field_config.filter.network.thrift_proxy.v2al
    pha1.RouteMatch.service_name>` fields. Cannot be combined with wildcard
    matching as that would result in routes never being matched. .. note::
    This does not invert matching done as part of the :ref:`headers field   <en
    voy_api_field_config.filter.network.thrift_proxy.v2alpha1.RouteMatch.header
    s>` field. To   invert header matching, see :ref:`invert_match
    <envoy_api_field_route.HeaderMatcher.invert_match>`.
    """

    headers: List["_____api_v2_route__.HeaderMatcher"] = betterproto.message_field(4)
    """
    Specifies a set of headers that the route should match on. The router will
    check the request’s headers against all the specified headers in the route
    config. A match will happen if all the headers in the route are present in
    the request with the same values (or based on presence if the value field
    is not in the config). Note that this only applies for Thrift transports
    and/or protocols that support headers.
    """


@dataclass(eq=False, repr=False)
class RouteAction(betterproto.Message):
    """[#next-free-field: 7]"""

    cluster: str = betterproto.string_field(1, group="cluster_specifier")
    """
    Indicates a single upstream cluster to which the request should be routed
    to.
    """

    weighted_clusters: "WeightedCluster" = betterproto.message_field(
        2, group="cluster_specifier"
    )
    """
    Multiple upstream clusters can be specified for a given route. The request
    is routed to one of the upstream clusters based on weights assigned to each
    cluster.
    """

    cluster_header: str = betterproto.string_field(6, group="cluster_specifier")
    """
    Envoy will determine the cluster to route to by reading the value of the
    Thrift header named by cluster_header from the request headers. If the
    header is not found or the referenced cluster does not exist Envoy will
    respond with an unknown method exception or an internal error exception,
    respectively.
    """

    metadata_match: "_____api_v2_core__.Metadata" = betterproto.message_field(3)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what is set
    in this field will be considered. Note that this will be merged with what's
    provided in :ref:`WeightedCluster.metadata_match <envoy_api_field_config.fi
    lter.network.thrift_proxy.v2alpha1.WeightedCluster.ClusterWeight.metadata_m
    atch>`, with values there taking precedence. Keys and values should be
    provided under the "envoy.lb" metadata key.
    """

    rate_limits: List["_____api_v2_route__.RateLimit"] = betterproto.message_field(4)
    """
    Specifies a set of rate limit configurations that could be applied to the
    route. N.B. Thrift service or method name matching can be achieved by
    specifying a RequestHeaders action with the header name ":method-name".
    """

    strip_service_name: bool = betterproto.bool_field(5)
    """
    Strip the service prefix from the method name, if there's a prefix. For
    example, the method call Service:method would end up being just method.
    """


@dataclass(eq=False, repr=False)
class WeightedCluster(betterproto.Message):
    """
    Allows for specification of multiple upstream clusters along with weights
    that indicate the percentage of traffic to be forwarded to each cluster.
    The router selects an upstream cluster based on these weights.
    """

    clusters: List["WeightedClusterClusterWeight"] = betterproto.message_field(1)
    """Specifies one or more upstream clusters associated with the route."""


@dataclass(eq=False, repr=False)
class WeightedClusterClusterWeight(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Name of the upstream cluster."""

    weight: Optional[int] = betterproto.message_field(2, wraps=betterproto.TYPE_UINT32)
    """
    When a request matches the route, the choice of an upstream cluster is
    determined by its weight. The sum of weights across all entries in the
    clusters array determines the total weight.
    """

    metadata_match: "_____api_v2_core__.Metadata" = betterproto.message_field(3)
    """
    Optional endpoint metadata match criteria used by the subset load balancer.
    Only endpoints in the upstream cluster with metadata matching what is set
    in this field, combined with what's provided in :ref:`RouteAction's
    metadata_match <envoy_api_field_config.filter.network.thrift_proxy.v2alpha1
    .RouteAction.metadata_match>`, will be considered. Values here will take
    precedence. Keys and values should be provided under the "envoy.lb"
    metadata key.
    """


@dataclass(eq=False, repr=False)
class ThriftProxy(betterproto.Message):
    """[#next-free-field: 6]"""

    transport: "TransportType" = betterproto.enum_field(2)
    """
    Supplies the type of transport that the Thrift proxy should use. Defaults
    to :ref:`AUTO_TRANSPORT<envoy_api_enum_value_config.filter.network.thrift_p
    roxy.v2alpha1.TransportType.AUTO_TRANSPORT>`.
    """

    protocol: "ProtocolType" = betterproto.enum_field(3)
    """
    Supplies the type of protocol that the Thrift proxy should use. Defaults to
    :ref:`AUTO_PROTOCOL<envoy_api_enum_value_config.filter.network.thrift_proxy
    .v2alpha1.ProtocolType.AUTO_PROTOCOL>`.
    """

    stat_prefix: str = betterproto.string_field(1)
    """The human readable prefix to use when emitting statistics."""

    route_config: "RouteConfiguration" = betterproto.message_field(4)
    """
    The route table for the connection manager is static and is specified in
    this property.
    """

    thrift_filters: List["ThriftFilter"] = betterproto.message_field(5)
    """
    A list of individual Thrift filters that make up the filter chain for
    requests made to the Thrift proxy. Order matters as the filters are
    processed sequentially. For backwards compatibility, if no thrift_filters
    are specified, a default Thrift router filter
    (`envoy.filters.thrift.router`) is used.
    """


@dataclass(eq=False, repr=False)
class ThriftFilter(betterproto.Message):
    """ThriftFilter configures a Thrift filter."""

    name: str = betterproto.string_field(1)
    """
    The name of the filter to instantiate. The name must match a supported
    filter. The built-in filters are: [#comment:TODO(zuercher): Auto generate
    the following list] * :ref:`envoy.filters.thrift.router
    <config_thrift_filters_router>` * :ref:`envoy.filters.thrift.rate_limit
    <config_thrift_filters_rate_limit>`
    """

    config: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        2, group="config_type"
    )
    typed_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        3, group="config_type"
    )

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("config"):
            warnings.warn("ThriftFilter.config is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class ThriftProtocolOptions(betterproto.Message):
    """
    ThriftProtocolOptions specifies Thrift upstream protocol options. This
    object is used in in :ref:`typed_extension_protocol_options<envoy_api_field
    _Cluster.typed_extension_protocol_options>`, keyed by the name
    `envoy.filters.network.thrift_proxy`.
    """

    transport: "TransportType" = betterproto.enum_field(1)
    """
    Supplies the type of transport that the Thrift proxy should use for
    upstream connections. Selecting :ref:`AUTO_TRANSPORT<envoy_api_enum_value_c
    onfig.filter.network.thrift_proxy.v2alpha1.TransportType.AUTO_TRANSPORT>`,
    which is the default, causes the proxy to use the same transport as the
    downstream connection.
    """

    protocol: "ProtocolType" = betterproto.enum_field(2)
    """
    Supplies the type of protocol that the Thrift proxy should use for upstream
    connections. Selecting :ref:`AUTO_PROTOCOL<envoy_api_enum_value_config.filt
    er.network.thrift_proxy.v2alpha1.ProtocolType.AUTO_PROTOCOL>`, which is the
    default, causes the proxy to use the same protocol as the downstream
    connection.
    """
