# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: envoy/admin/v3/certs.proto, envoy/admin/v3/clusters.proto, envoy/admin/v3/config_dump.proto, envoy/admin/v3/config_dump_shared.proto, envoy/admin/v3/init_dump.proto, envoy/admin/v3/listeners.proto, envoy/admin/v3/memory.proto, envoy/admin/v3/metrics.proto, envoy/admin/v3/mutex_stats.proto, envoy/admin/v3/server_info.proto, envoy/admin/v3/tap.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import (
    datetime,
    timedelta,
)
from typing import List

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from ...config.bootstrap import v3 as __config_bootstrap_v3__
from ...config.cluster import v3 as __config_cluster_v3__
from ...config.core import v3 as __config_core_v3__
from ...config.tap import v3 as __config_tap_v3__
from ...type import v3 as __type_v3__


class ClientResourceStatus(betterproto.Enum):
    """
    Resource status from the view of a xDS client, which tells the
    synchronization status between the xDS client and the xDS server.
    """

    UNKNOWN = 0
    """Resource status is not available/unknown."""

    REQUESTED = 1
    """
    Client requested this resource but hasn't received any update from
    management server. The client will not fail requests, but will queue them
    until update arrives or the client times out waiting for the resource.
    """

    DOES_NOT_EXIST = 2
    """
    This resource has been requested by the client but has either not been
    delivered by the server or was previously delivered by the server and then
    subsequently removed from resources provided by the server. For more
    information, please refer to the :ref:`"Knowing When a Requested Resource
    Does Not Exist" <xds_protocol_resource_not_existed>` section.
    """

    ACKED = 3
    """Client received this resource and replied with ACK."""

    NACKED = 4
    """Client received this resource and replied with NACK."""


class SimpleMetricType(betterproto.Enum):
    COUNTER = 0
    GAUGE = 1


class ServerInfoState(betterproto.Enum):
    LIVE = 0
    """Server is live and serving traffic."""

    DRAINING = 1
    """
    Server is draining listeners in response to external health checks failing.
    """

    PRE_INITIALIZING = 2
    """Server has not yet completed cluster manager initialization."""

    INITIALIZING = 3
    """
    Server is running the cluster manager initialization callbacks (e.g., RDS).
    """


class CommandLineOptionsIpVersion(betterproto.Enum):
    v4 = 0
    v6 = 1


class CommandLineOptionsMode(betterproto.Enum):
    Serve = 0
    """Validate configs and then serve traffic normally."""

    Validate = 1
    """Validate configs and exit."""

    InitOnly = 2
    """
    Completely load and initialize the config, and then exit without running
    the listener loop.
    """


class CommandLineOptionsDrainStrategy(betterproto.Enum):
    Gradual = 0
    """
    Gradually discourage connections over the course of the drain period.
    """

    Immediate = 1
    """Discourage all connections for the duration of the drain sequence."""


@dataclass(eq=False, repr=False)
class UpdateFailureState(betterproto.Message):
    failed_configuration: "betterproto_lib_google_protobuf.Any" = (
        betterproto.message_field(1)
    )
    """
    What the component configuration would have been if the update had
    succeeded. This field may not be populated by xDS clients due to storage
    overhead.
    """

    last_update_attempt: datetime = betterproto.message_field(2)
    """Time of the latest failed update attempt."""

    details: str = betterproto.string_field(3)
    """Details about the last failed update attempt."""

    version_info: str = betterproto.string_field(4)
    """
    This is the version of the rejected resource. [#not-implemented-hide:]
    """


@dataclass(eq=False, repr=False)
class ListenersConfigDump(betterproto.Message):
    """
    Envoy's listener manager fills this message with all currently known
    listeners. Listener configuration information can be used to recreate an
    Envoy configuration by populating all listeners as static listeners or by
    returning them in a LDS response.
    """

    version_info: str = betterproto.string_field(1)
    """
    This is the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    in the last processed LDS discovery response. If there are only static
    bootstrap listeners, this field will be "".
    """

    static_listeners: List[
        "ListenersConfigDumpStaticListener"
    ] = betterproto.message_field(2)
    """The statically loaded listener configs."""

    dynamic_listeners: List[
        "ListenersConfigDumpDynamicListener"
    ] = betterproto.message_field(3)
    """State for any warming, active, or draining listeners."""


@dataclass(eq=False, repr=False)
class ListenersConfigDumpStaticListener(betterproto.Message):
    """Describes a statically loaded listener."""

    listener: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """The listener config."""

    last_updated: datetime = betterproto.message_field(2)
    """The timestamp when the Listener was last successfully updated."""


@dataclass(eq=False, repr=False)
class ListenersConfigDumpDynamicListenerState(betterproto.Message):
    version_info: str = betterproto.string_field(1)
    """
    This is the per-resource version information. This version is currently
    taken from the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    field at the time that the listener was loaded. In the future, discrete
    per-listener versions may be supported by the API.
    """

    listener: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """The listener config."""

    last_updated: datetime = betterproto.message_field(3)
    """The timestamp when the Listener was last successfully updated."""


@dataclass(eq=False, repr=False)
class ListenersConfigDumpDynamicListener(betterproto.Message):
    """
    Describes a dynamically loaded listener via the LDS API. [#next-free-field:
    7]
    """

    name: str = betterproto.string_field(1)
    """
    The name or unique id of this listener, pulled from the
    DynamicListenerState config.
    """

    active_state: "ListenersConfigDumpDynamicListenerState" = betterproto.message_field(
        2
    )
    """
    The listener state for any active listener by this name. These are
    listeners that are available to service data plane traffic.
    """

    warming_state: "ListenersConfigDumpDynamicListenerState" = (
        betterproto.message_field(3)
    )
    """
    The listener state for any warming listener by this name. These are
    listeners that are currently undergoing warming in preparation to service
    data plane traffic. Note that if attempting to recreate an Envoy
    configuration from a configuration dump, the warming listeners should
    generally be discarded.
    """

    draining_state: "ListenersConfigDumpDynamicListenerState" = (
        betterproto.message_field(4)
    )
    """
    The listener state for any draining listener by this name. These are
    listeners that are currently undergoing draining in preparation to stop
    servicing data plane traffic. Note that if attempting to recreate an Envoy
    configuration from a configuration dump, the draining listeners should
    generally be discarded.
    """

    error_state: "UpdateFailureState" = betterproto.message_field(5)
    """
    Set if the last update failed, cleared after the next successful update.
    The ``error_state`` field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty.
    """

    client_status: "ClientResourceStatus" = betterproto.enum_field(6)
    """The client status of this resource. [#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class ClustersConfigDump(betterproto.Message):
    """
    Envoy's cluster manager fills this message with all currently known
    clusters. Cluster configuration information can be used to recreate an
    Envoy configuration by populating all clusters as static clusters or by
    returning them in a CDS response.
    """

    version_info: str = betterproto.string_field(1)
    """
    This is the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    in the last processed CDS discovery response. If there are only static
    bootstrap clusters, this field will be "".
    """

    static_clusters: List[
        "ClustersConfigDumpStaticCluster"
    ] = betterproto.message_field(2)
    """The statically loaded cluster configs."""

    dynamic_active_clusters: List[
        "ClustersConfigDumpDynamicCluster"
    ] = betterproto.message_field(3)
    """
    The dynamically loaded active clusters. These are clusters that are
    available to service data plane traffic.
    """

    dynamic_warming_clusters: List[
        "ClustersConfigDumpDynamicCluster"
    ] = betterproto.message_field(4)
    """
    The dynamically loaded warming clusters. These are clusters that are
    currently undergoing warming in preparation to service data plane traffic.
    Note that if attempting to recreate an Envoy configuration from a
    configuration dump, the warming clusters should generally be discarded.
    """


@dataclass(eq=False, repr=False)
class ClustersConfigDumpStaticCluster(betterproto.Message):
    """Describes a statically loaded cluster."""

    cluster: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """The cluster config."""

    last_updated: datetime = betterproto.message_field(2)
    """The timestamp when the Cluster was last updated."""


@dataclass(eq=False, repr=False)
class ClustersConfigDumpDynamicCluster(betterproto.Message):
    """
    Describes a dynamically loaded cluster via the CDS API. [#next-free-field:
    6]
    """

    version_info: str = betterproto.string_field(1)
    """
    This is the per-resource version information. This version is currently
    taken from the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    field at the time that the cluster was loaded. In the future, discrete per-
    cluster versions may be supported by the API.
    """

    cluster: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """The cluster config."""

    last_updated: datetime = betterproto.message_field(3)
    """The timestamp when the Cluster was last updated."""

    error_state: "UpdateFailureState" = betterproto.message_field(4)
    """
    Set if the last update failed, cleared after the next successful update.
    The ``error_state`` field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty. [#not-implemented-hide:]
    """

    client_status: "ClientResourceStatus" = betterproto.enum_field(5)
    """The client status of this resource. [#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class RoutesConfigDump(betterproto.Message):
    """
    Envoy's RDS implementation fills this message with all currently loaded
    routes, as described by their RouteConfiguration objects. Static routes
    that are either defined in the bootstrap configuration or defined inline
    while configuring listeners are separated from those configured dynamically
    via RDS. Route configuration information can be used to recreate an Envoy
    configuration by populating all routes as static routes or by returning
    them in RDS responses.
    """

    static_route_configs: List[
        "RoutesConfigDumpStaticRouteConfig"
    ] = betterproto.message_field(2)
    """The statically loaded route configs."""

    dynamic_route_configs: List[
        "RoutesConfigDumpDynamicRouteConfig"
    ] = betterproto.message_field(3)
    """The dynamically loaded route configs."""


@dataclass(eq=False, repr=False)
class RoutesConfigDumpStaticRouteConfig(betterproto.Message):
    route_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """The route config."""

    last_updated: datetime = betterproto.message_field(2)
    """The timestamp when the Route was last updated."""


@dataclass(eq=False, repr=False)
class RoutesConfigDumpDynamicRouteConfig(betterproto.Message):
    """[#next-free-field: 6]"""

    version_info: str = betterproto.string_field(1)
    """
    This is the per-resource version information. This version is currently
    taken from the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    field at the time that the route configuration was loaded.
    """

    route_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """The route config."""

    last_updated: datetime = betterproto.message_field(3)
    """The timestamp when the Route was last updated."""

    error_state: "UpdateFailureState" = betterproto.message_field(4)
    """
    Set if the last update failed, cleared after the next successful update.
    The ``error_state`` field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty. [#not-implemented-hide:]
    """

    client_status: "ClientResourceStatus" = betterproto.enum_field(5)
    """The client status of this resource. [#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class ScopedRoutesConfigDump(betterproto.Message):
    """
    Envoy's scoped RDS implementation fills this message with all currently
    loaded route configuration scopes (defined via ScopedRouteConfigurationsSet
    protos). This message lists both the scopes defined inline with the higher
    order object (i.e., the HttpConnectionManager) and the dynamically obtained
    scopes via the SRDS API.
    """

    inline_scoped_route_configs: List[
        "ScopedRoutesConfigDumpInlineScopedRouteConfigs"
    ] = betterproto.message_field(1)
    """The statically loaded scoped route configs."""

    dynamic_scoped_route_configs: List[
        "ScopedRoutesConfigDumpDynamicScopedRouteConfigs"
    ] = betterproto.message_field(2)
    """The dynamically loaded scoped route configs."""


@dataclass(eq=False, repr=False)
class ScopedRoutesConfigDumpInlineScopedRouteConfigs(betterproto.Message):
    name: str = betterproto.string_field(1)
    """The name assigned to the scoped route configurations."""

    scoped_route_configs: List[
        "betterproto_lib_google_protobuf.Any"
    ] = betterproto.message_field(2)
    """The scoped route configurations."""

    last_updated: datetime = betterproto.message_field(3)
    """The timestamp when the scoped route config set was last updated."""


@dataclass(eq=False, repr=False)
class ScopedRoutesConfigDumpDynamicScopedRouteConfigs(betterproto.Message):
    """[#next-free-field: 7]"""

    name: str = betterproto.string_field(1)
    """The name assigned to the scoped route configurations."""

    version_info: str = betterproto.string_field(2)
    """
    This is the per-resource version information. This version is currently
    taken from the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    field at the time that the scoped routes configuration was loaded.
    """

    scoped_route_configs: List[
        "betterproto_lib_google_protobuf.Any"
    ] = betterproto.message_field(3)
    """The scoped route configurations."""

    last_updated: datetime = betterproto.message_field(4)
    """The timestamp when the scoped route config set was last updated."""

    error_state: "UpdateFailureState" = betterproto.message_field(5)
    """
    Set if the last update failed, cleared after the next successful update.
    The ``error_state`` field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty. [#not-implemented-hide:]
    """

    client_status: "ClientResourceStatus" = betterproto.enum_field(6)
    """The client status of this resource. [#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class EndpointsConfigDump(betterproto.Message):
    """
    Envoy's admin fill this message with all currently known endpoints.
    Endpoint configuration information can be used to recreate an Envoy
    configuration by populating all endpoints as static endpoints or by
    returning them in an EDS response.
    """

    static_endpoint_configs: List[
        "EndpointsConfigDumpStaticEndpointConfig"
    ] = betterproto.message_field(2)
    """The statically loaded endpoint configs."""

    dynamic_endpoint_configs: List[
        "EndpointsConfigDumpDynamicEndpointConfig"
    ] = betterproto.message_field(3)
    """The dynamically loaded endpoint configs."""


@dataclass(eq=False, repr=False)
class EndpointsConfigDumpStaticEndpointConfig(betterproto.Message):
    endpoint_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        1
    )
    """The endpoint config."""

    last_updated: datetime = betterproto.message_field(2)
    """
    [#not-implemented-hide:] The timestamp when the Endpoint was last updated.
    """


@dataclass(eq=False, repr=False)
class EndpointsConfigDumpDynamicEndpointConfig(betterproto.Message):
    """[#next-free-field: 6]"""

    version_info: str = betterproto.string_field(1)
    """
    [#not-implemented-hide:] This is the per-resource version information. This
    version is currently taken from the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    field at the time that the endpoint configuration was loaded.
    """

    endpoint_config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        2
    )
    """The endpoint config."""

    last_updated: datetime = betterproto.message_field(3)
    """
    [#not-implemented-hide:] The timestamp when the Endpoint was last updated.
    """

    error_state: "UpdateFailureState" = betterproto.message_field(4)
    """
    Set if the last update failed, cleared after the next successful update.
    The ``error_state`` field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty. [#not-implemented-hide:]
    """

    client_status: "ClientResourceStatus" = betterproto.enum_field(5)
    """The client status of this resource. [#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class EcdsConfigDump(betterproto.Message):
    """
    Envoy's ECDS service fills this message with all currently extension
    configuration. Extension configuration information can be used to recreate
    an Envoy ECDS listener and HTTP filters as static filters or by returning
    them in ECDS response.
    """

    ecds_filters: List["EcdsConfigDumpEcdsFilterConfig"] = betterproto.message_field(1)
    """The ECDS filter configs."""


@dataclass(eq=False, repr=False)
class EcdsConfigDumpEcdsFilterConfig(betterproto.Message):
    """[#next-free-field: 6]"""

    version_info: str = betterproto.string_field(1)
    """
    This is the per-resource version information. This version is currently
    taken from the :ref:`version_info
    <envoy_v3_api_field_service.discovery.v3.DiscoveryResponse.version_info>`
    field at the time that the ECDS filter was loaded.
    """

    ecds_filter: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """The ECDS filter config."""

    last_updated: datetime = betterproto.message_field(3)
    """The timestamp when the ECDS filter was last updated."""

    error_state: "UpdateFailureState" = betterproto.message_field(4)
    """
    Set if the last update failed, cleared after the next successful update.
    The ``error_state`` field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty. [#not-implemented-hide:]
    """

    client_status: "ClientResourceStatus" = betterproto.enum_field(5)
    """The client status of this resource. [#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class SimpleMetric(betterproto.Message):
    """Proto representation of an Envoy Counter or Gauge value."""

    type: "SimpleMetricType" = betterproto.enum_field(1)
    """Type of the metric represented."""

    value: int = betterproto.uint64_field(2)
    """Current metric value."""

    name: str = betterproto.string_field(3)
    """Name of the metric."""


@dataclass(eq=False, repr=False)
class ServerInfo(betterproto.Message):
    """
    Proto representation of the value returned by /server_info, containing
    server version/server status information. [#next-free-field: 8]
    """

    version: str = betterproto.string_field(1)
    """Server version."""

    state: "ServerInfoState" = betterproto.enum_field(2)
    """State of the server."""

    uptime_current_epoch: timedelta = betterproto.message_field(3)
    """Uptime since current epoch was started."""

    uptime_all_epochs: timedelta = betterproto.message_field(4)
    """Uptime since the start of the first epoch."""

    hot_restart_version: str = betterproto.string_field(5)
    """Hot restart version."""

    command_line_options: "CommandLineOptions" = betterproto.message_field(6)
    """Command line options the server is currently running with."""

    node: "__config_core_v3__.Node" = betterproto.message_field(7)
    """Populated node identity of this server."""


@dataclass(eq=False, repr=False)
class CommandLineOptions(betterproto.Message):
    """[#next-free-field: 39]"""

    base_id: int = betterproto.uint64_field(1)
    """See :option:`--base-id` for details."""

    use_dynamic_base_id: bool = betterproto.bool_field(31)
    """See :option:`--use-dynamic-base-id` for details."""

    base_id_path: str = betterproto.string_field(32)
    """See :option:`--base-id-path` for details."""

    concurrency: int = betterproto.uint32_field(2)
    """See :option:`--concurrency` for details."""

    config_path: str = betterproto.string_field(3)
    """See :option:`--config-path` for details."""

    config_yaml: str = betterproto.string_field(4)
    """See :option:`--config-yaml` for details."""

    allow_unknown_static_fields: bool = betterproto.bool_field(5)
    """See :option:`--allow-unknown-static-fields` for details."""

    reject_unknown_dynamic_fields: bool = betterproto.bool_field(26)
    """See :option:`--reject-unknown-dynamic-fields` for details."""

    ignore_unknown_dynamic_fields: bool = betterproto.bool_field(30)
    """See :option:`--ignore-unknown-dynamic-fields` for details."""

    admin_address_path: str = betterproto.string_field(6)
    """See :option:`--admin-address-path` for details."""

    local_address_ip_version: "CommandLineOptionsIpVersion" = betterproto.enum_field(7)
    """See :option:`--local-address-ip-version` for details."""

    log_level: str = betterproto.string_field(8)
    """See :option:`--log-level` for details."""

    component_log_level: str = betterproto.string_field(9)
    """See :option:`--component-log-level` for details."""

    log_format: str = betterproto.string_field(10)
    """See :option:`--log-format` for details."""

    log_format_escaped: bool = betterproto.bool_field(27)
    """See :option:`--log-format-escaped` for details."""

    log_path: str = betterproto.string_field(11)
    """See :option:`--log-path` for details."""

    service_cluster: str = betterproto.string_field(13)
    """See :option:`--service-cluster` for details."""

    service_node: str = betterproto.string_field(14)
    """See :option:`--service-node` for details."""

    service_zone: str = betterproto.string_field(15)
    """See :option:`--service-zone` for details."""

    file_flush_interval: timedelta = betterproto.message_field(16)
    """See :option:`--file-flush-interval-msec` for details."""

    drain_time: timedelta = betterproto.message_field(17)
    """See :option:`--drain-time-s` for details."""

    drain_strategy: "CommandLineOptionsDrainStrategy" = betterproto.enum_field(33)
    """See :option:`--drain-strategy` for details."""

    parent_shutdown_time: timedelta = betterproto.message_field(18)
    """See :option:`--parent-shutdown-time-s` for details."""

    mode: "CommandLineOptionsMode" = betterproto.enum_field(19)
    """See :option:`--mode` for details."""

    disable_hot_restart: bool = betterproto.bool_field(22)
    """See :option:`--disable-hot-restart` for details."""

    enable_mutex_tracing: bool = betterproto.bool_field(23)
    """See :option:`--enable-mutex-tracing` for details."""

    restart_epoch: int = betterproto.uint32_field(24)
    """See :option:`--restart-epoch` for details."""

    cpuset_threads: bool = betterproto.bool_field(25)
    """See :option:`--cpuset-threads` for details."""

    disabled_extensions: List[str] = betterproto.string_field(28)
    """See :option:`--disable-extensions` for details."""

    enable_fine_grain_logging: bool = betterproto.bool_field(34)
    """See :option:`--enable-fine-grain-logging` for details."""

    socket_path: str = betterproto.string_field(35)
    """See :option:`--socket-path` for details."""

    socket_mode: int = betterproto.uint32_field(36)
    """See :option:`--socket-mode` for details."""

    enable_core_dump: bool = betterproto.bool_field(37)
    """See :option:`--enable-core-dump` for details."""

    stats_tag: List[str] = betterproto.string_field(38)
    """See :option:`--stats-tag` for details."""


@dataclass(eq=False, repr=False)
class ConfigDump(betterproto.Message):
    """
    The :ref:`/config_dump <operations_admin_interface_config_dump>` admin
    endpoint uses this wrapper message to maintain and serve arbitrary
    configuration information from any component in Envoy.
    """

    configs: List["betterproto_lib_google_protobuf.Any"] = betterproto.message_field(1)
    """
    This list is serialized and dumped in its entirety at the
    :ref:`/config_dump <operations_admin_interface_config_dump>` endpoint. The
    following configurations are currently supported and will be dumped in the
    order given below: * ``bootstrap``: :ref:`BootstrapConfigDump
    <envoy_v3_api_msg_admin.v3.BootstrapConfigDump>` * ``clusters``:
    :ref:`ClustersConfigDump <envoy_v3_api_msg_admin.v3.ClustersConfigDump>` *
    ``ecds_filter_http``: :ref:`EcdsConfigDump
    <envoy_v3_api_msg_admin.v3.EcdsConfigDump>` * ``ecds_filter_tcp_listener``:
    :ref:`EcdsConfigDump <envoy_v3_api_msg_admin.v3.EcdsConfigDump>` *
    ``endpoints``:  :ref:`EndpointsConfigDump
    <envoy_v3_api_msg_admin.v3.EndpointsConfigDump>` * ``listeners``:
    :ref:`ListenersConfigDump <envoy_v3_api_msg_admin.v3.ListenersConfigDump>`
    * ``scoped_routes``: :ref:`ScopedRoutesConfigDump
    <envoy_v3_api_msg_admin.v3.ScopedRoutesConfigDump>` * ``routes``:
    :ref:`RoutesConfigDump <envoy_v3_api_msg_admin.v3.RoutesConfigDump>` *
    ``secrets``:  :ref:`SecretsConfigDump
    <envoy_v3_api_msg_admin.v3.SecretsConfigDump>` EDS Configuration will only
    be dumped by using parameter ``?include_eds`` Currently ECDS is supported
    in HTTP and listener filters. Note, ECDS configuration for either HTTP or
    listener filter will only be dumped if it is actually configured. You can
    filter output with the resource and mask query parameters. See
    :ref:`/config_dump?resource={}
    <operations_admin_interface_config_dump_by_resource>`,
    :ref:`/config_dump?mask={}
    <operations_admin_interface_config_dump_by_mask>`, or
    :ref:`/config_dump?resource={},mask={}
    <operations_admin_interface_config_dump_by_resource_and_mask>` for more
    information.
    """


@dataclass(eq=False, repr=False)
class BootstrapConfigDump(betterproto.Message):
    """
    This message describes the bootstrap configuration that Envoy was started
    with. This includes any CLI overrides that were merged. Bootstrap
    configuration information can be used to recreate the static portions of an
    Envoy configuration by reusing the output as the bootstrap configuration
    for another Envoy.
    """

    bootstrap: "__config_bootstrap_v3__.Bootstrap" = betterproto.message_field(1)
    last_updated: datetime = betterproto.message_field(2)
    """The timestamp when the BootstrapConfig was last updated."""


@dataclass(eq=False, repr=False)
class SecretsConfigDump(betterproto.Message):
    """
    Envoys SDS implementation fills this message with all secrets fetched
    dynamically via SDS.
    """

    static_secrets: List["SecretsConfigDumpStaticSecret"] = betterproto.message_field(1)
    """The statically loaded secrets."""

    dynamic_active_secrets: List[
        "SecretsConfigDumpDynamicSecret"
    ] = betterproto.message_field(2)
    """
    The dynamically loaded active secrets. These are secrets that are available
    to service clusters or listeners.
    """

    dynamic_warming_secrets: List[
        "SecretsConfigDumpDynamicSecret"
    ] = betterproto.message_field(3)
    """
    The dynamically loaded warming secrets. These are secrets that are
    currently undergoing warming in preparation to service clusters or
    listeners.
    """


@dataclass(eq=False, repr=False)
class SecretsConfigDumpDynamicSecret(betterproto.Message):
    """
    DynamicSecret contains secret information fetched via SDS. [#next-free-
    field: 7]
    """

    name: str = betterproto.string_field(1)
    """The name assigned to the secret."""

    version_info: str = betterproto.string_field(2)
    """This is the per-resource version information."""

    last_updated: datetime = betterproto.message_field(3)
    """The timestamp when the secret was last updated."""

    secret: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(4)
    """
    The actual secret information. Security sensitive information is redacted
    (replaced with "[redacted]") for private keys and passwords in TLS
    certificates.
    """

    error_state: "UpdateFailureState" = betterproto.message_field(5)
    """
    Set if the last update failed, cleared after the next successful update.
    The *error_state* field contains the rejected version of this particular
    resource along with the reason and timestamp. For successfully updated or
    acknowledged resource, this field should be empty. [#not-implemented-hide:]
    """

    client_status: "ClientResourceStatus" = betterproto.enum_field(6)
    """The client status of this resource. [#not-implemented-hide:]"""


@dataclass(eq=False, repr=False)
class SecretsConfigDumpStaticSecret(betterproto.Message):
    """StaticSecret specifies statically loaded secret in bootstrap."""

    name: str = betterproto.string_field(1)
    """The name assigned to the secret."""

    last_updated: datetime = betterproto.message_field(2)
    """The timestamp when the secret was last updated."""

    secret: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)
    """
    The actual secret information. Security sensitive information is redacted
    (replaced with "[redacted]") for private keys and passwords in TLS
    certificates.
    """


@dataclass(eq=False, repr=False)
class TapRequest(betterproto.Message):
    """
    The /tap admin request body that is used to configure an active tap
    session.
    """

    config_id: str = betterproto.string_field(1)
    """
    The opaque configuration ID used to match the configuration to a loaded
    extension. A tap extension configures a similar opaque ID that is used to
    match.
    """

    tap_config: "__config_tap_v3__.TapConfig" = betterproto.message_field(2)
    """The tap configuration to load."""


@dataclass(eq=False, repr=False)
class Listeners(betterproto.Message):
    """
    Admin endpoint uses this wrapper for ``/listeners`` to display listener
    status information. See :ref:`/listeners
    <operations_admin_interface_listeners>` for more information.
    """

    listener_statuses: List["ListenerStatus"] = betterproto.message_field(1)
    """List of listener statuses."""


@dataclass(eq=False, repr=False)
class ListenerStatus(betterproto.Message):
    """Details an individual listener's current status."""

    name: str = betterproto.string_field(1)
    """Name of the listener"""

    local_address: "__config_core_v3__.Address" = betterproto.message_field(2)
    """
    The actual local address that the listener is listening on. If a listener
    was configured to listen on port 0, then this address has the port that was
    allocated by the OS.
    """

    additional_local_addresses: List[
        "__config_core_v3__.Address"
    ] = betterproto.message_field(3)
    """
    The additional addresses the listener is listening on as specified via the
    :ref:`additional_addresses
    <envoy_v3_api_field_config.listener.v3.Listener.additional_addresses>`
    configuration.
    """


@dataclass(eq=False, repr=False)
class Certificates(betterproto.Message):
    """
    Proto representation of certificate details. Admin endpoint uses this
    wrapper for ``/certs`` to display certificate information. See :ref:`/certs
    <operations_admin_interface_certs>` for more information.
    """

    certificates: List["Certificate"] = betterproto.message_field(1)
    """List of certificates known to an Envoy."""


@dataclass(eq=False, repr=False)
class Certificate(betterproto.Message):
    ca_cert: List["CertificateDetails"] = betterproto.message_field(1)
    """Details of CA certificate."""

    cert_chain: List["CertificateDetails"] = betterproto.message_field(2)
    """Details of Certificate Chain"""


@dataclass(eq=False, repr=False)
class CertificateDetails(betterproto.Message):
    """[#next-free-field: 8]"""

    path: str = betterproto.string_field(1)
    """Path of the certificate."""

    serial_number: str = betterproto.string_field(2)
    """Certificate Serial Number."""

    subject_alt_names: List["SubjectAlternateName"] = betterproto.message_field(3)
    """List of Subject Alternate names."""

    days_until_expiration: int = betterproto.uint64_field(4)
    """Minimum of days until expiration of certificate and it's chain."""

    valid_from: datetime = betterproto.message_field(5)
    """Indicates the time from which the certificate is valid."""

    expiration_time: datetime = betterproto.message_field(6)
    """Indicates the time at which the certificate expires."""

    ocsp_details: "CertificateDetailsOcspDetails" = betterproto.message_field(7)
    """
    Details related to the OCSP response associated with this certificate, if
    any.
    """


@dataclass(eq=False, repr=False)
class CertificateDetailsOcspDetails(betterproto.Message):
    valid_from: datetime = betterproto.message_field(1)
    """Indicates the time from which the OCSP response is valid."""

    expiration: datetime = betterproto.message_field(2)
    """Indicates the time at which the OCSP response expires."""


@dataclass(eq=False, repr=False)
class SubjectAlternateName(betterproto.Message):
    dns: str = betterproto.string_field(1, group="name")
    uri: str = betterproto.string_field(2, group="name")
    ip_address: str = betterproto.string_field(3, group="name")


@dataclass(eq=False, repr=False)
class MutexStats(betterproto.Message):
    """
    Proto representation of the statistics collected upon absl::Mutex
    contention, if Envoy is run under :option:`--enable-mutex-tracing`. For
    more information, see the ``absl::Mutex``
    [docs](https://abseil.io/about/design/mutex#extra-features). *NB*: The wait
    cycles below are measured by ``absl::base_internal::CycleClock``, and may
    not correspond to core clock frequency. For more information, see the
    ``CycleClock`` [docs](https://github.com/abseil/abseil-
    cpp/blob/master/absl/base/internal/cycleclock.h).
    """

    num_contentions: int = betterproto.uint64_field(1)
    """
    The number of individual mutex contentions which have occurred since
    startup.
    """

    current_wait_cycles: int = betterproto.uint64_field(2)
    """The length of the current contention wait cycle."""

    lifetime_wait_cycles: int = betterproto.uint64_field(3)
    """The lifetime total of all contention wait cycles."""


@dataclass(eq=False, repr=False)
class UnreadyTargetsDumps(betterproto.Message):
    """
    Dumps of unready targets of envoy init managers. Envoy's admin fills this
    message with init managers, which provides the information of their unready
    targets. The :ref:`/init_dump <operations_admin_interface_init_dump>` will
    dump all unready targets information.
    """

    unready_targets_dumps: List[
        "UnreadyTargetsDumpsUnreadyTargetsDump"
    ] = betterproto.message_field(1)
    """
    You can choose specific component to dump unready targets with mask query
    parameter. See :ref:`/init_dump?mask={}
    <operations_admin_interface_init_dump_by_mask>` for more information. The
    dumps of unready targets of all init managers.
    """


@dataclass(eq=False, repr=False)
class UnreadyTargetsDumpsUnreadyTargetsDump(betterproto.Message):
    """Message of unready targets information of an init manager."""

    name: str = betterproto.string_field(1)
    """Name of the init manager. Example: "init_manager_xxx"."""

    target_names: List[str] = betterproto.string_field(2)
    """Names of unready targets of the init manager. Example: "target_xxx"."""


@dataclass(eq=False, repr=False)
class Memory(betterproto.Message):
    """
    Proto representation of the internal memory consumption of an Envoy
    instance. These represent values extracted from an internal TCMalloc
    instance. For more information, see the section of the docs entitled
    ["Generic Tcmalloc
    Status"](https://gperftools.github.io/gperftools/tcmalloc.html). [#next-
    free-field: 7]
    """

    allocated: int = betterproto.uint64_field(1)
    """
    The number of bytes allocated by the heap for Envoy. This is an alias for
    ``generic.current_allocated_bytes``.
    """

    heap_size: int = betterproto.uint64_field(2)
    """
    The number of bytes reserved by the heap but not necessarily allocated.
    This is an alias for ``generic.heap_size``.
    """

    pageheap_unmapped: int = betterproto.uint64_field(3)
    """
    The number of bytes in free, unmapped pages in the page heap. These bytes
    always count towards virtual memory usage, and depending on the OS,
    typically do not count towards physical memory usage. This is an alias for
    ``tcmalloc.pageheap_unmapped_bytes``.
    """

    pageheap_free: int = betterproto.uint64_field(4)
    """
    The number of bytes in free, mapped pages in the page heap. These bytes
    always count towards virtual memory usage, and unless the underlying memory
    is swapped out by the OS, they also count towards physical memory usage.
    This is an alias for ``tcmalloc.pageheap_free_bytes``.
    """

    total_thread_cache: int = betterproto.uint64_field(5)
    """
    The amount of memory used by the TCMalloc thread caches (for small
    objects). This is an alias for
    ``tcmalloc.current_total_thread_cache_bytes``.
    """

    total_physical_bytes: int = betterproto.uint64_field(6)
    """
    The number of bytes of the physical memory usage by the allocator. This is
    an alias for ``generic.total_physical_bytes``.
    """


@dataclass(eq=False, repr=False)
class Clusters(betterproto.Message):
    """
    Admin endpoint uses this wrapper for ``/clusters`` to display cluster
    status information. See :ref:`/clusters
    <operations_admin_interface_clusters>` for more information.
    """

    cluster_statuses: List["ClusterStatus"] = betterproto.message_field(1)
    """Mapping from cluster name to each cluster's status."""


@dataclass(eq=False, repr=False)
class ClusterStatus(betterproto.Message):
    """
    Details an individual cluster's current status. [#next-free-field: 9]
    """

    name: str = betterproto.string_field(1)
    """Name of the cluster."""

    added_via_api: bool = betterproto.bool_field(2)
    """
    Denotes whether this cluster was added via API or configured statically.
    """

    success_rate_ejection_threshold: "__type_v3__.Percent" = betterproto.message_field(
        3
    )
    """
    The success rate threshold used in the last interval. If :ref:`outlier_dete
    ction.split_external_local_origin_errors<envoy_v3_api_field_config.cluster.
    v3.OutlierDetection.split_external_local_origin_errors>` is ``false``, all
    errors: externally and locally generated were used to calculate the
    threshold. If :ref:`outlier_detection.split_external_local_origin_errors<en
    voy_v3_api_field_config.cluster.v3.OutlierDetection.split_external_local_or
    igin_errors>` is ``true``, only externally generated errors were used to
    calculate the threshold. The threshold is used to eject hosts based on
    their success rate. See :ref:`Cluster outlier detection
    <arch_overview_outlier_detection>` documentation for details. Note: this
    field may be omitted in any of the three following cases: 1. There were not
    enough hosts with enough request volume to proceed with success rate based
    outlier ejection. 2. The threshold is computed to be < 0 because a negative
    value implies that there was no    threshold for that interval. 3. Outlier
    detection is not enabled for this cluster.
    """

    host_statuses: List["HostStatus"] = betterproto.message_field(4)
    """Mapping from host address to the host's current status."""

    local_origin_success_rate_ejection_threshold: "__type_v3__.Percent" = (
        betterproto.message_field(5)
    )
    """
    The success rate threshold used in the last interval when only locally
    originated failures were taken into account and externally originated
    errors were treated as success. This field should be interpreted only when 
    :ref:`outlier_detection.split_external_local_origin_errors<envoy_v3_api_fie
    ld_config.cluster.v3.OutlierDetection.split_external_local_origin_errors>`
    is ``true``. The threshold is used to eject hosts based on their success
    rate. See :ref:`Cluster outlier detection
    <arch_overview_outlier_detection>` documentation for details. Note: this
    field may be omitted in any of the three following cases: 1. There were not
    enough hosts with enough request volume to proceed with success rate based
    outlier ejection. 2. The threshold is computed to be < 0 because a negative
    value implies that there was no    threshold for that interval. 3. Outlier
    detection is not enabled for this cluster.
    """

    circuit_breakers: "__config_cluster_v3__.CircuitBreakers" = (
        betterproto.message_field(6)
    )
    """
    :ref:`Circuit breaking <arch_overview_circuit_break>` settings of the
    cluster.
    """

    observability_name: str = betterproto.string_field(7)
    """Observability name of the cluster."""

    eds_service_name: str = betterproto.string_field(8)
    """
    The :ref:`EDS service name <envoy_v3_api_field_config.cluster.v3.Cluster.Ed
    sClusterConfig.service_name>` if the cluster is an EDS cluster.
    """


@dataclass(eq=False, repr=False)
class HostStatus(betterproto.Message):
    """Current state of a particular host. [#next-free-field: 10]"""

    address: "__config_core_v3__.Address" = betterproto.message_field(1)
    """Address of this host."""

    stats: List["SimpleMetric"] = betterproto.message_field(2)
    """List of stats specific to this host."""

    health_status: "HostHealthStatus" = betterproto.message_field(3)
    """The host's current health status."""

    success_rate: "__type_v3__.Percent" = betterproto.message_field(4)
    """
    Request success rate for this host over the last calculated interval. If :r
    ef:`outlier_detection.split_external_local_origin_errors<envoy_v3_api_field
    _config.cluster.v3.OutlierDetection.split_external_local_origin_errors>` is
    ``false``, all errors: externally and locally generated were used in
    success rate calculation. If :ref:`outlier_detection.split_external_local_o
    rigin_errors<envoy_v3_api_field_config.cluster.v3.OutlierDetection.split_ex
    ternal_local_origin_errors>` is ``true``, only externally generated errors
    were used in success rate calculation. See :ref:`Cluster outlier detection
    <arch_overview_outlier_detection>` documentation for details. Note: the
    message will not be present if host did not have enough request volume to
    calculate success rate or the cluster did not have enough hosts to run
    through success rate outlier ejection.
    """

    weight: int = betterproto.uint32_field(5)
    """The host's weight. If not configured, the value defaults to 1."""

    hostname: str = betterproto.string_field(6)
    """The hostname of the host, if applicable."""

    priority: int = betterproto.uint32_field(7)
    """
    The host's priority. If not configured, the value defaults to 0 (highest
    priority).
    """

    local_origin_success_rate: "__type_v3__.Percent" = betterproto.message_field(8)
    """
    Request success rate for this host over the last calculated interval when
    only locally originated errors are taken into account and externally
    originated errors were treated as success. This field should be interpreted
    only when :ref:`outlier_detection.split_external_local_origin_errors<envoy_
    v3_api_field_config.cluster.v3.OutlierDetection.split_external_local_origin
    _errors>` is ``true``. See :ref:`Cluster outlier detection
    <arch_overview_outlier_detection>` documentation for details. Note: the
    message will not be present if host did not have enough request volume to
    calculate success rate or the cluster did not have enough hosts to run
    through success rate outlier ejection.
    """

    locality: "__config_core_v3__.Locality" = betterproto.message_field(9)
    """locality of the host."""


@dataclass(eq=False, repr=False)
class HostHealthStatus(betterproto.Message):
    """Health status for a host. [#next-free-field: 9]"""

    failed_active_health_check: bool = betterproto.bool_field(1)
    """The host is currently failing active health checks."""

    failed_outlier_check: bool = betterproto.bool_field(2)
    """The host is currently considered an outlier and has been ejected."""

    failed_active_degraded_check: bool = betterproto.bool_field(4)
    """
    The host is currently being marked as degraded through active health
    checking.
    """

    pending_dynamic_removal: bool = betterproto.bool_field(5)
    """
    The host has been removed from service discovery, but is being stabilized
    due to active health checking.
    """

    pending_active_hc: bool = betterproto.bool_field(6)
    """The host has not yet been health checked."""

    excluded_via_immediate_hc_fail: bool = betterproto.bool_field(7)
    """
    The host should be excluded from panic, spillover, etc. calculations
    because it was explicitly taken out of rotation via protocol signal and is
    not meant to be routed to.
    """

    active_hc_timeout: bool = betterproto.bool_field(8)
    """The host failed active HC due to timeout."""

    eds_health_status: "__config_core_v3__.HealthStatus" = betterproto.enum_field(3)
    """
    Health status as reported by EDS. Note: only HEALTHY and UNHEALTHY are
    currently supported here. [#comment:TODO(mrice32): pipe through remaining
    EDS health status possibilities.]
    """
