# Constants

<a name="HALF_PI" href="#HALF_PI">#</a> cm.**HALF_PI**

HALF_PI is a mathematical constant with the value 1.5707964. It is half the ratio of the circumference of a circle to its diameter. It is useful in combination with the trigonometric functions sin() and cos().

```py
import charming as cm

cm.full_screen()
cm.no_cursor()

x = cm.get_width() / 2
y = cm.get_height() / 2
r = cm.get_height() * 0.8

cm.arc(x, y, r * 2, r, 0, cm.HALF_PI, cm.PIE)

cm.run()
```

<img src="https://raw.githubusercontent.com/charming-art/public-files/master/test_half_pi.png" width="100%"/>

<a name="PI" href="#PI">#</a> cm.**PI**

PI is a mathematical constant with the value 3.1415927. It is the ratio of the circumference of a circle to its diameter. It is useful in combination with the trigonometric functions sin() and cos().

```py
import charming as cm

cm.full_screen()
cm.no_cursor()

x = cm.get_width() / 2
y = cm.get_height() / 2
r = cm.get_height() * 0.8

cm.arc(x, y, r * 2, r, 0, cm.PI, cm.PIE)

cm.run()
```

<img src="https://raw.githubusercontent.com/charming-art/public-files/master/test_pi.png" width="100%"/>

<a name="QUARTER_PI" href="#QUARTER_PI">#</a> cm.**QUARTER_PI**

QUARTER_PI is a mathematical constant with the value 0.7853982. It is one quarter the ratio of the circumference of a circle to its diameter. It is useful in combination with the trigonometric functions sin() and cos().

```py
import charming as cm

cm.full_screen()
cm.no_cursor()

x = cm.get_width() / 2
y = cm.get_height() / 2
r = cm.get_height() * 0.8

cm.arc(x, y, r * 2, r, 0, cm.QUARTER_PI, cm.PIE)

cm.run()
```

<img src="https://raw.githubusercontent.com/charming-art/public-files/master/test_quarter_pi.png" width="100%"/>

<a name="TWO_PI" href="#TWO_PI">#</a> cm.**TWO_PI**

TWO_PI is a mathematical constant with the value 6.2831855. It is twice the ratio of the circumference of a circle to its diameter. It is useful in combination with the trigonometric functions sin() and cos().

```py
import charming as cm

cm.full_screen()
cm.no_cursor()

x = cm.get_width() / 2
y = cm.get_height() / 2
r = cm.get_height() * 0.8

cm.arc(x, y, r * 2, r, 0, cm.TWO_PI, cm.PIE)

cm.run()
```

<img src="https://raw.githubusercontent.com/charming-art/public-files/master/test_two_pi.png" width="100%"/>

<a name="TAU" href="#TAU">#</a> cm.**TAU**

TAU is a mathematical constant with the value 6.2831855. It is the circle constant relating the circumference of a circle to its linear dimension, the ratio of the circumference of a circle to its radius. It is useful in combination with trigonometric functions such as sin() and cos().

```py
import charming as cm

cm.full_screen()
cm.no_cursor()

x = cm.get_width() / 2
y = cm.get_height() / 2
r = cm.get_height() * 0.8

cm.arc(x, y, r * 2, r, 0, cm.TAU, cm.PIE)

cm.run()
```
  
<img src="https://raw.githubusercontent.com/charming-art/public-files/master/test_tau.png" width="100%"/>