# *Bacillus subtilis 168* WT RBA model

Bacillus subtilis RBA model was generated using the RBApy package (https://doi.org/10.1016/j.ymben.2019.06.001),
using manually curated metabolic reconstruction (https://doi.org/10.1186/1752-0509-2-20) 
and parameters estimated in (https://doi.org/10.1016/j.ymben.2015.10.003).

## Generation of the XML model


The *Bacillus subtilis* model was generated in a step-wise manner,
based on information from a hand-curated model.

### Step 1: generation of a default model


For the first step, we used the 5 following files:
 - data/sbml.xml: metabolic netwok from the hand-curated model.
 - data/chaperones.fasta: composition of machines involved in folding.
 - data/ribosome.fasta: composition of ribosome.
 - data/trnas.fasta: composition of tRNAs.
 - params.in: pipeline parameters.

 Then we ran RBApy in the current folder, using the
 generate_rba_model.py provided in the GitHub repository:

```
python generate_rba_model.py params.in
```

This first run downloaded data/uniprot.csv,
generated helper files data/*.tsv,
and generated a first XML model.

This model can be solved by running

```
python solve_rba_model.py .
```

Because the model uses numerous default values, it yields a very high growth rate.


### Step 2: generation of a model improved through helper files

In order to improve RBA's predictions, we modified the following helper files:
 - macrocomponents.tsv: we added concentration targets for lipids and other molecules in the cell membrane.
 - medium.tsv: we restricted the medium to glucose and key ions.
 - metabolites.tsv: we mapped the metabolites used in processes and added concentration targets for metabolites.
 - subunits.tsv: we imported protein stoichiometries from the hand-curated model.
 - unknown_proteins.tsv: the SBML contains two genes that could not be mapped
 to uniprot: average_protein_c and average_protein_mp.
 By default, they are replaced by an average protein in the cytoplasm.
 We remapped average_protein_mp to an average protein in the cell membrane.

The second model can be generated in the following way:
```
cp data/curated_macrocomponents.tsv data/macrocomponents.tsv
cp data/curated_metabolites.tsv data/metabolites.tsv
cp data/curated_subunits.tsv data/subunits.tsv
cp data/curated_unknown_proteins.tsv data/unknown_proteins.tsv

python generate_rba_model.py params.in

cp data/curated_medium.tsv medium.tsv
```

### Step 3: generation of the full model


In the last step, we use RBA.xml to introduce two additional changes:
 - we use the set_enzyme_efficiencies function to use the catalytic constants
 from the hand curated model listed in data/catalytic_activity_medium_2.csv.
 - we add a new target reflecting proton consumption through flagella.

These changes are implemented in the script generate_model.py.
The full model can be generated by running:
```
  python generate_model.py
```


## Differences between the hand-curated model and the model generated by RBApy

Note that even though we imported key elements from the hand-curated model
(protein stoichiometries, catalytic constants, flagella target),
there are still some secondary differences between the two models.

These differences include:
 - In RBApy, protein cofactors are automatically imported from Uniprot.
 - In the hand-curated model, some proteins have stoichiometries that depend
 on the enzyme they are part of (e.g. 4 copies, 5 copies, 6 copies).
 In RBApy, the stoichiometry is the same in every complex.
 - In RBApy, transport reactions and transport cofactors are detected automatically.
 They mostly overlap with hand-curated transport reactions, but they are not identical.
 - The hand-curated model defines enzymes for tRNA production,
 the RBApy model does not.
 - The hand-curated model uses the zero_cost flag, indicating that some low
 concentration enzymes need not be produced.
 This flag was introduced as a way to reduce numerical instabilities.
