# Generated by Django 3.2.7 on 2021-10-05 16:13

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import odk.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='XForm',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('xls_file', models.FileField(blank=True, help_text='XLSForm avec 3 onglets: survey, choices, settings', null=True, upload_to=odk.models.xform_path, verbose_name='Fichier Excel')),
                ('xml_file', models.FileField(help_text="XLSForm converti par <a href='https://getodk.org/xlsform/' target='_blank'>https://getodk.org/xlsform/</a>", upload_to=odk.models.xform_path, verbose_name='Fichier XML')),
                ('xml_content', models.TextField(verbose_name='Contenu du formulaire XML')),
                ('form_id', models.SlugField(editable=False, help_text='Extrait depuis XLSForm (onglet settings)', max_length=200)),
                ('version', models.CharField(editable=False, help_text='Extrait depuis XLSForm (onglet settings)', max_length=200)),
                ('title', models.CharField(editable=False, help_text='Extrait depuis XLSForm (onglet settings)', max_length=250, verbose_name='Titre')),
                ('short_desc', models.CharField(blank=True, max_length=250, verbose_name='Brève description')),
                ('created_on', models.DateTimeField(auto_now_add=True, verbose_name='Créé le')),
                ('modified_on', models.DateTimeField(auto_now=True, verbose_name='Modifié le')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='xform_created_by', to=settings.AUTH_USER_MODEL, verbose_name='Créé par')),
                ('modified_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='xform_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='Modifié par')),
            ],
            options={
                'verbose_name': 'Formulaire disponible',
                'ordering': ('xml_file',),
                'unique_together': {('form_id', 'version')},
            },
        ),
        migrations.CreateModel(
            name='XFormSubmit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('form_id', models.SlugField(editable=False, help_text='Retrieved from XML form (settings tab of Excel file)', max_length=200)),
                ('version', models.CharField(editable=False, help_text='Retrieved from XML form (settings tab of Excel file)', max_length=200)),
                ('instanceid', models.UUIDField(unique=True)),
                ('deviceid', models.CharField(blank=True, max_length=255, null=True)),
                ('survey_date', models.DateField(blank=True, null=True, verbose_name="Date d'encodage")),
                ('picture_files', models.JSONField(blank=True, null=True, verbose_name="Noms des fichiers d'image")),
                ('xml_file', models.FileField(blank=True, help_text='Fichier XML envoyé via ODK Collect (Application Mobile)', upload_to='', verbose_name='Formulaire soumis')),
                ('xml_content', models.TextField(help_text='Contenu XML envoyé via ODK Collect (Application Mobile)', verbose_name='Contenu du fichier XML soumis')),
                ('submitted_by', models.CharField(blank=True, max_length=255, null=True, verbose_name='Soumis par')),
                ('submitted_on', models.DateTimeField(verbose_name='Soumis le')),
                ('modified_by', models.CharField(blank=True, max_length=255, null=True, verbose_name='Modifié par')),
                ('modified_on', models.DateTimeField(auto_now=True, verbose_name='Modifié le')),
                ('xform', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='template_form', to='odk.xform', verbose_name='Template form')),
            ],
            options={
                'verbose_name': 'Formulaire soumis',
                'ordering': ('submitted_on',),
            },
        ),
    ]
