# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SettingsUpdateList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the SettingsUpdateList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.supersim.v1.settings_update.SettingsUpdateList
        :rtype: twilio.rest.supersim.v1.settings_update.SettingsUpdateList
        """
        super(SettingsUpdateList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/SettingsUpdates'.format(**self._solution)

    def stream(self, sim=values.unset, limit=None, page_size=None):
        """
        Streams SettingsUpdateInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode sim: Filter the Settings Updates by Super SIM
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.supersim.v1.settings_update.SettingsUpdateInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(sim=sim, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, sim=values.unset, limit=None, page_size=None):
        """
        Lists SettingsUpdateInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode sim: Filter the Settings Updates by Super SIM
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.supersim.v1.settings_update.SettingsUpdateInstance]
        """
        return list(self.stream(sim=sim, limit=limit, page_size=page_size, ))

    def page(self, sim=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of SettingsUpdateInstance records from the API.
        Request is executed immediately

        :param unicode sim: Filter the Settings Updates by Super SIM
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of SettingsUpdateInstance
        :rtype: twilio.rest.supersim.v1.settings_update.SettingsUpdatePage
        """
        data = values.of({'Sim': sim, 'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return SettingsUpdatePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of SettingsUpdateInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of SettingsUpdateInstance
        :rtype: twilio.rest.supersim.v1.settings_update.SettingsUpdatePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return SettingsUpdatePage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Supersim.V1.SettingsUpdateList>'


class SettingsUpdatePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the SettingsUpdatePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.supersim.v1.settings_update.SettingsUpdatePage
        :rtype: twilio.rest.supersim.v1.settings_update.SettingsUpdatePage
        """
        super(SettingsUpdatePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SettingsUpdateInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.supersim.v1.settings_update.SettingsUpdateInstance
        :rtype: twilio.rest.supersim.v1.settings_update.SettingsUpdateInstance
        """
        return SettingsUpdateInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Supersim.V1.SettingsUpdatePage>'


class SettingsUpdateInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class Status(object):
        SCHEDULED = "scheduled"
        IN_PROGRESS = "in-progress"
        SUCCESSFUL = "successful"
        FAILED = "failed"

    def __init__(self, version, payload):
        """
        Initialize the SettingsUpdateInstance

        :returns: twilio.rest.supersim.v1.settings_update.SettingsUpdateInstance
        :rtype: twilio.rest.supersim.v1.settings_update.SettingsUpdateInstance
        """
        super(SettingsUpdateInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'iccid': payload.get('iccid'),
            'sim_sid': payload.get('sim_sid'),
            'status': payload.get('status'),
            'packages': payload.get('packages'),
            'date_completed': deserialize.iso8601_datetime(payload.get('date_completed')),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def sid(self):
        """
        :returns: The unique identifier of this Settings Update
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def iccid(self):
        """
        :returns: The ICCID associated with the SIM
        :rtype: unicode
        """
        return self._properties['iccid']

    @property
    def sim_sid(self):
        """
        :returns: The SID of the Super SIM to which this Settings Update was applied
        :rtype: unicode
        """
        return self._properties['sim_sid']

    @property
    def status(self):
        """
        :returns: The Status of this Settings Update
        :rtype: SettingsUpdateInstance.Status
        """
        return self._properties['status']

    @property
    def packages(self):
        """
        :returns: Array containing the different Settings Packages that will be applied to the SIM after the update completes
        :rtype: list[dict]
        """
        return self._properties['packages']

    @property
    def date_completed(self):
        """
        :returns: The time when the update successfully completed and the new settings were applied to the SIM
        :rtype: datetime
        """
        return self._properties['date_completed']

    @property
    def date_created(self):
        """
        :returns: The date this Settings Update was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date this Settings Update was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Supersim.V1.SettingsUpdateInstance>'
