# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SipDomainList(ListResource):

    def __init__(self, version):
        """
        Initialize the SipDomainList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.routes.v2.sip_domain.SipDomainList
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainList
        """
        super(SipDomainList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, sip_domain):
        """
        Constructs a SipDomainContext

        :param sip_domain: The sip_domain

        :returns: twilio.rest.routes.v2.sip_domain.SipDomainContext
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainContext
        """
        return SipDomainContext(self._version, sip_domain=sip_domain, )

    def __call__(self, sip_domain):
        """
        Constructs a SipDomainContext

        :param sip_domain: The sip_domain

        :returns: twilio.rest.routes.v2.sip_domain.SipDomainContext
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainContext
        """
        return SipDomainContext(self._version, sip_domain=sip_domain, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Routes.V2.SipDomainList>'


class SipDomainPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the SipDomainPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.routes.v2.sip_domain.SipDomainPage
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainPage
        """
        super(SipDomainPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SipDomainInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        """
        return SipDomainInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Routes.V2.SipDomainPage>'


class SipDomainContext(InstanceContext):

    def __init__(self, version, sip_domain):
        """
        Initialize the SipDomainContext

        :param Version version: Version that contains the resource
        :param sip_domain: The sip_domain

        :returns: twilio.rest.routes.v2.sip_domain.SipDomainContext
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainContext
        """
        super(SipDomainContext, self).__init__(version)

        # Path Solution
        self._solution = {'sip_domain': sip_domain, }
        self._uri = '/SipDomains/{sip_domain}'.format(**self._solution)

    def update(self, voice_region=values.unset, friendly_name=values.unset):
        """
        Update the SipDomainInstance

        :param unicode voice_region: The voice_region
        :param unicode friendly_name: The friendly_name

        :returns: The updated SipDomainInstance
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        """
        data = values.of({'VoiceRegion': voice_region, 'FriendlyName': friendly_name, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return SipDomainInstance(self._version, payload, sip_domain=self._solution['sip_domain'], )

    def fetch(self):
        """
        Fetch the SipDomainInstance

        :returns: The fetched SipDomainInstance
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return SipDomainInstance(self._version, payload, sip_domain=self._solution['sip_domain'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Routes.V2.SipDomainContext {}>'.format(context)


class SipDomainInstance(InstanceResource):

    def __init__(self, version, payload, sip_domain=None):
        """
        Initialize the SipDomainInstance

        :returns: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        """
        super(SipDomainInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sip_domain': payload.get('sip_domain'),
            'url': payload.get('url'),
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'friendly_name': payload.get('friendly_name'),
            'voice_region': payload.get('voice_region'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
        }

        # Context
        self._context = None
        self._solution = {'sip_domain': sip_domain or self._properties['sip_domain'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SipDomainContext for this SipDomainInstance
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainContext
        """
        if self._context is None:
            self._context = SipDomainContext(self._version, sip_domain=self._solution['sip_domain'], )
        return self._context

    @property
    def sip_domain(self):
        """
        :returns: The sip_domain
        :rtype: unicode
        """
        return self._properties['sip_domain']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def sid(self):
        """
        :returns: The sid
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def friendly_name(self):
        """
        :returns: The friendly_name
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def voice_region(self):
        """
        :returns: The voice_region
        :rtype: unicode
        """
        return self._properties['voice_region']

    @property
    def date_created(self):
        """
        :returns: The date_created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date_updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    def update(self, voice_region=values.unset, friendly_name=values.unset):
        """
        Update the SipDomainInstance

        :param unicode voice_region: The voice_region
        :param unicode friendly_name: The friendly_name

        :returns: The updated SipDomainInstance
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        """
        return self._proxy.update(voice_region=voice_region, friendly_name=friendly_name, )

    def fetch(self):
        """
        Fetch the SipDomainInstance

        :returns: The fetched SipDomainInstance
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Routes.V2.SipDomainInstance {}>'.format(context)
