# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.routes.v2 import V2


class Routes(Domain):

    def __init__(self, twilio):
        """
        Initialize the Routes Domain

        :returns: Domain for Routes
        :rtype: twilio.rest.routes.Routes
        """
        super(Routes, self).__init__(twilio)

        self.base_url = 'https://routes.twilio.com'

        # Versions
        self._v2 = None

    @property
    def v2(self):
        """
        :returns: Version v2 of routes
        :rtype: twilio.rest.routes.v2.V2
        """
        if self._v2 is None:
            self._v2 = V2(self)
        return self._v2

    @property
    def phone_numbers(self):
        """
        :rtype: twilio.rest.routes.v2.phone_number.PhoneNumberList
        """
        return self.v2.phone_numbers

    @property
    def sip_domains(self):
        """
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainList
        """
        return self.v2.sip_domains

    @property
    def trunks(self):
        """
        :rtype: twilio.rest.routes.v2.trunk.TrunkList
        """
        return self.v2.trunks

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Routes>'
