# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class OpenidDiscoveryList(ListResource):

    def __init__(self, version):
        """
        Initialize the OpenidDiscoveryList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryList
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryList
        """
        super(OpenidDiscoveryList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a OpenidDiscoveryContext

        :returns: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryContext
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryContext
        """
        return OpenidDiscoveryContext(self._version, )

    def __call__(self):
        """
        Constructs a OpenidDiscoveryContext

        :returns: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryContext
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryContext
        """
        return OpenidDiscoveryContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.OpenidDiscoveryList>'


class OpenidDiscoveryPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the OpenidDiscoveryPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryPage
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryPage
        """
        super(OpenidDiscoveryPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of OpenidDiscoveryInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryInstance
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryInstance
        """
        return OpenidDiscoveryInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.OpenidDiscoveryPage>'


class OpenidDiscoveryContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the OpenidDiscoveryContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryContext
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryContext
        """
        super(OpenidDiscoveryContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/well-known/openid-configuration'.format(**self._solution)

    def fetch(self):
        """
        Fetch the OpenidDiscoveryInstance

        :returns: The fetched OpenidDiscoveryInstance
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return OpenidDiscoveryInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Oauth.V1.OpenidDiscoveryContext {}>'.format(context)


class OpenidDiscoveryInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the OpenidDiscoveryInstance

        :returns: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryInstance
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryInstance
        """
        super(OpenidDiscoveryInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'issuer': payload.get('issuer'),
            'authorization_endpoint': payload.get('authorization_endpoint'),
            'device_authorization_endpoint': payload.get('device_authorization_endpoint'),
            'token_endpoint': payload.get('token_endpoint'),
            'userinfo_endpoint': payload.get('userinfo_endpoint'),
            'revocation_endpoint': payload.get('revocation_endpoint'),
            'jwk_uri': payload.get('jwk_uri'),
            'response_type_supported': payload.get('response_type_supported'),
            'subject_type_supported': payload.get('subject_type_supported'),
            'id_token_signing_alg_values_supported': payload.get('id_token_signing_alg_values_supported'),
            'scopes_supported': payload.get('scopes_supported'),
            'claims_supported': payload.get('claims_supported'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: OpenidDiscoveryContext for this OpenidDiscoveryInstance
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryContext
        """
        if self._context is None:
            self._context = OpenidDiscoveryContext(self._version, )
        return self._context

    @property
    def issuer(self):
        """
        :returns: The issuer URL
        :rtype: unicode
        """
        return self._properties['issuer']

    @property
    def authorization_endpoint(self):
        """
        :returns: The URL of authorization endpoint
        :rtype: unicode
        """
        return self._properties['authorization_endpoint']

    @property
    def device_authorization_endpoint(self):
        """
        :returns: The URL of device code authorization endpoint
        :rtype: unicode
        """
        return self._properties['device_authorization_endpoint']

    @property
    def token_endpoint(self):
        """
        :returns: The URL of token endpoint
        :rtype: unicode
        """
        return self._properties['token_endpoint']

    @property
    def userinfo_endpoint(self):
        """
        :returns: The URL of user info endpoint
        :rtype: unicode
        """
        return self._properties['userinfo_endpoint']

    @property
    def revocation_endpoint(self):
        """
        :returns: The URL of revocation endpoint
        :rtype: unicode
        """
        return self._properties['revocation_endpoint']

    @property
    def jwk_uri(self):
        """
        :returns: The URL of public JWK endpoint
        :rtype: unicode
        """
        return self._properties['jwk_uri']

    @property
    def response_type_supported(self):
        """
        :returns: List of response type supported for identity token
        :rtype: list[unicode]
        """
        return self._properties['response_type_supported']

    @property
    def subject_type_supported(self):
        """
        :returns: List of subject supported for identity token
        :rtype: list[unicode]
        """
        return self._properties['subject_type_supported']

    @property
    def id_token_signing_alg_values_supported(self):
        """
        :returns: List of JWS signing algorithms supported for identity token
        :rtype: list[unicode]
        """
        return self._properties['id_token_signing_alg_values_supported']

    @property
    def scopes_supported(self):
        """
        :returns: List of scopes supported identity token
        :rtype: list[unicode]
        """
        return self._properties['scopes_supported']

    @property
    def claims_supported(self):
        """
        :returns: List of claims supported for identity token
        :rtype: list[unicode]
        """
        return self._properties['claims_supported']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the OpenidDiscoveryInstance

        :returns: The fetched OpenidDiscoveryInstance
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Oauth.V1.OpenidDiscoveryInstance {}>'.format(context)
