# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.messaging.v1 import V1


class Messaging(Domain):

    def __init__(self, twilio):
        """
        Initialize the Messaging Domain

        :returns: Domain for Messaging
        :rtype: twilio.rest.messaging.Messaging
        """
        super(Messaging, self).__init__(twilio)

        self.base_url = 'https://messaging.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of messaging
        :rtype: twilio.rest.messaging.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def brand_registrations(self):
        """
        :rtype: twilio.rest.messaging.v1.brand_registration.BrandRegistrationList
        """
        return self.v1.brand_registrations

    @property
    def deactivations(self):
        """
        :rtype: twilio.rest.messaging.v1.deactivation.DeactivationsList
        """
        return self.v1.deactivations

    @property
    def external_campaign(self):
        """
        :rtype: twilio.rest.messaging.v1.external_campaign.ExternalCampaignList
        """
        return self.v1.external_campaign

    @property
    def services(self):
        """
        :rtype: twilio.rest.messaging.v1.service.ServiceList
        """
        return self.v1.services

    @property
    def tollfree_verifications(self):
        """
        :rtype: twilio.rest.messaging.v1.tollfree_verification.TollfreeVerificationList
        """
        return self.v1.tollfree_verifications

    @property
    def usecases(self):
        """
        :rtype: twilio.rest.messaging.v1.usecase.UsecaseList
        """
        return self.v1.usecases

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging>'
