# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class GoodDataList(ListResource):

    def __init__(self, version):
        """
        Initialize the GoodDataList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.good_data.GoodDataList
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataList
        """
        super(GoodDataList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a GoodDataContext

        :returns: twilio.rest.flex_api.v1.good_data.GoodDataContext
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataContext
        """
        return GoodDataContext(self._version, )

    def __call__(self):
        """
        Constructs a GoodDataContext

        :returns: twilio.rest.flex_api.v1.good_data.GoodDataContext
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataContext
        """
        return GoodDataContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.GoodDataList>'


class GoodDataPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the GoodDataPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.good_data.GoodDataPage
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataPage
        """
        super(GoodDataPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of GoodDataInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.good_data.GoodDataInstance
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataInstance
        """
        return GoodDataInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.GoodDataPage>'


class GoodDataContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the GoodDataContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.good_data.GoodDataContext
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataContext
        """
        super(GoodDataContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Accounts/GoodData'.format(**self._solution)

    def create(self, token=values.unset):
        """
        Create the GoodDataInstance

        :param unicode token: The Token HTTP request header

        :returns: The created GoodDataInstance
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataInstance
        """
        headers = values.of({'Token': token, })

        payload = self._version.create(method='POST', uri=self._uri, headers=headers, )

        return GoodDataInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.GoodDataContext {}>'.format(context)


class GoodDataInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the GoodDataInstance

        :returns: twilio.rest.flex_api.v1.good_data.GoodDataInstance
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataInstance
        """
        super(GoodDataInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'workspace_id': payload.get('workspace_id'),
            'session_expiry': payload.get('session_expiry'),
            'session_id': payload.get('session_id'),
            'gd_base_url': payload.get('gd_base_url'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: GoodDataContext for this GoodDataInstance
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataContext
        """
        if self._context is None:
            self._context = GoodDataContext(self._version, )
        return self._context

    @property
    def workspace_id(self):
        """
        :returns: Unique workspace ID in gooddata
        :rtype: unicode
        """
        return self._properties['workspace_id']

    @property
    def session_expiry(self):
        """
        :returns: The session expiry date and time
        :rtype: unicode
        """
        return self._properties['session_expiry']

    @property
    def session_id(self):
        """
        :returns: Unique session ID
        :rtype: unicode
        """
        return self._properties['session_id']

    @property
    def gd_base_url(self):
        """
        :returns: GoodData login base URL
        :rtype: unicode
        """
        return self._properties['gd_base_url']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    def create(self, token=values.unset):
        """
        Create the GoodDataInstance

        :param unicode token: The Token HTTP request header

        :returns: The created GoodDataInstance
        :rtype: twilio.rest.flex_api.v1.good_data.GoodDataInstance
        """
        return self._proxy.create(token=token, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.GoodDataInstance {}>'.format(context)
