# mypy-boto3-fms

[![PyPI - mypy-boto3-fms](https://img.shields.io/pypi/v/mypy-boto3-fms.svg?color=blue)](https://pypi.org/project/mypy-boto3-fms)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-fms.svg?color=blue)](https://pypi.org/project/mypy-boto3-fms)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.FMS 1.16.39](https://boto3.amazonaws.com/v1/documentation/api/1.16.39/reference/services/fms.html#FMS) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-fms](#mypy-boto3-fms)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `FMS` service.

```bash
python -m pip install boto3-stubs[fms]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[fms]` in your environment: `python -m pip install 'boto3-stubs[fms]'`

Both type checking and auto-complete should work for `FMS` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[fms]` in your environment: `python -m pip install 'boto3-stubs[fms]'`

Both type checking and auto-complete should work for `FMS` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[fms]` in your environment: `python -m pip install 'boto3-stubs[fms]'`
- Run `mypy` as usual

Type checking should work for `FMS` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[fms]` in your environment: `python -m pip install 'boto3-stubs[fms]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `FMS` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`FMSClient` provides annotations for `boto3.client("fms")`.

```python
import boto3

from mypy_boto3_fms import FMSClient

client: FMSClient = boto3.client("fms")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: FMSClient = session.client("fms")
```

### Paginators annotations

`mypy_boto3_fms.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_fms import FMSClient
from mypy_boto3_fms.paginator import (
    ListComplianceStatusPaginator,
    ListMemberAccountsPaginator,
    ListPoliciesPaginator,
)

client: FMSClient = boto3.client("fms")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_compliance_status_paginator: ListComplianceStatusPaginator = client.get_paginator("list_compliance_status")
list_member_accounts_paginator: ListMemberAccountsPaginator = client.get_paginator("list_member_accounts")
list_policies_paginator: ListPoliciesPaginator = client.get_paginator("list_policies")
```







### Typed dictionations

`mypy_boto3_fms.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_fms.type_defs import (
    AppsListDataSummaryTypeDef,
    AppsListDataTypeDef,
    AppTypeDef,
    AwsEc2InstanceViolationTypeDef,
    AwsEc2NetworkInterfaceViolationTypeDef,
    AwsVPCSecurityGroupViolationTypeDef,
    ComplianceViolatorTypeDef,
    EvaluationResultTypeDef,
    GetAdminAccountResponseTypeDef,
    GetAppsListResponseTypeDef,
    GetComplianceDetailResponseTypeDef,
    GetNotificationChannelResponseTypeDef,
    GetPolicyResponseTypeDef,
    GetProtectionStatusResponseTypeDef,
    GetProtocolsListResponseTypeDef,
    GetViolationDetailsResponseTypeDef,
    ListAppsListsResponseTypeDef,
    ListComplianceStatusResponseTypeDef,
    ListMemberAccountsResponseTypeDef,
    ListPoliciesResponseTypeDef,
    ListProtocolsListsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    NetworkFirewallMissingExpectedRTViolationTypeDef,
    NetworkFirewallMissingFirewallViolationTypeDef,
    NetworkFirewallMissingSubnetViolationTypeDef,
    NetworkFirewallPolicyDescriptionTypeDef,
    NetworkFirewallPolicyModifiedViolationTypeDef,
    PaginatorConfigTypeDef,
    PartialMatchTypeDef,
    PolicyComplianceDetailTypeDef,
    PolicyComplianceStatusTypeDef,
    PolicySummaryTypeDef,
    PolicyTypeDef,
    ProtocolsListDataSummaryTypeDef,
    ProtocolsListDataTypeDef,
    PutAppsListResponseTypeDef,
    PutPolicyResponseTypeDef,
    PutProtocolsListResponseTypeDef,
    ResourceTagTypeDef,
    ResourceViolationTypeDef,
    SecurityGroupRemediationActionTypeDef,
    SecurityGroupRuleDescriptionTypeDef,
    SecurityServicePolicyDataTypeDef,
    StatefulRuleGroupTypeDef,
    StatelessRuleGroupTypeDef,
    TagTypeDef,
    ViolationDetailTypeDef,
)

def get_structure() -> AppTypeDef:
    return {
      ...
    }
```
