"""add unique contraints: on GenericAssetType.name & on GenericAssets for name+account_id

Revision ID: a918360f7d63
Revises: 830e72a8b218
Create Date: 2022-01-01 22:08:50.163734

"""
from alembic import op


# revision identifiers, used by Alembic.
revision = "a918360f7d63"
down_revision = "830e72a8b218"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_unique_constraint(
        "generic_asset_name_account_id_key", "generic_asset", ["name", "account_id"]
    )
    op.create_unique_constraint(
        op.f("generic_asset_type_name_key"), "generic_asset_type", ["name"]
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        op.f("generic_asset_type_name_key"), "generic_asset_type", type_="unique"
    )
    op.drop_constraint(
        "generic_asset_name_account_id_key", "generic_asset", type_="unique"
    )
    # ### end Alembic commands ###
