"""create_market_type_and_market_tables

Revision ID: 9254559dcac2
Revises: 45d937300b0f
Create Date: 2018-05-28 13:02:55.210603

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "9254559dcac2"
down_revision = "45d937300b0f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "market_type",
        sa.Column("name", sa.String(length=80), nullable=False),
        sa.Column("daily_seasonality", sa.Boolean(), nullable=False),
        sa.Column("weekly_seasonality", sa.Boolean(), nullable=False),
        sa.Column("yearly_seasonality", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("name"),
    )
    op.create_table(
        "market",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=80), nullable=True),
        sa.Column("market_type_name", sa.String(length=80), nullable=False),
        sa.ForeignKeyConstraint(["market_type_name"], ["market_type.name"]),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("market")
    op.drop_table("market_type")
    # ### end Alembic commands ###
