"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NagSuppressionHelper = void 0;
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
class NagSuppressionHelper {
    static toCfnFormat(suppression) {
        const { appliesTo, ...result } = suppression;
        if (appliesTo) {
            result.applies_to = appliesTo;
        }
        return result;
    }
    static toApiFormat(suppression) {
        const { applies_to, ...result } = suppression;
        if (applies_to) {
            result.appliesTo = applies_to;
        }
        return result;
    }
    static addRulesToMetadata(metadata, rules) {
        const { rules_to_suppress } = metadata !== null && metadata !== void 0 ? metadata : {};
        const serialisedRules = [
            ...(rules_to_suppress !== null && rules_to_suppress !== void 0 ? rules_to_suppress : []).map((r) => JSON.stringify(r)),
            ...rules
                .map(NagSuppressionHelper.toCfnFormat)
                .map((r) => JSON.stringify(r)),
        ];
        const deduplicatedRules = Array.from(new Set(serialisedRules));
        return { rules_to_suppress: deduplicatedRules.map((r) => JSON.parse(r)) };
    }
    static getSuppressions(node) {
        var _a, _b, _c, _d, _e;
        const resourceIgnores = (_b = (_a = node.getMetadata('cdk_nag')) === null || _a === void 0 ? void 0 : _a.rules_to_suppress) !== null && _b !== void 0 ? _b : [];
        const stackIgnores = (_e = (_d = (_c = monocdk_1.Stack.of(node).templateOptions.metadata) === null || _c === void 0 ? void 0 : _c.cdk_nag) === null || _d === void 0 ? void 0 : _d.rules_to_suppress) !== null && _e !== void 0 ? _e : [];
        return [...resourceIgnores, ...stackIgnores].map(NagSuppressionHelper.toApiFormat);
    }
    static assertSuppressionsAreValid(id, suppressions) {
        const errors = suppressions
            .map(NagSuppressionHelper.getSuppressionFormatError)
            .filter((errorMessage) => !!errorMessage);
        if (errors.length) {
            throw Error(`${id}: ${errors.join('')}\nSee https://github.com/cdklabs/cdk-nag#suppressing-a-rule for information on suppressing a rule.`);
        }
    }
    static getSuppressionFormatError(suppression) {
        let errors = '';
        const finding = suppression.id.match(/\[.*\]/);
        if (finding) {
            errors += `The suppression 'id' contains a finding '${finding}. A finding must be suppressed using 'applies_to'.`;
        }
        if (suppression.reason.length < 10) {
            errors +=
                "The suppression must have a 'reason' of 10 characters or more.";
        }
        return errors
            ? `\n\tError(s) detected in suppression with 'id' ${suppression.id}. ${errors}`
            : '';
    }
}
exports.NagSuppressionHelper = NagSuppressionHelper;
//# sourceMappingURL=data:application/json;base64,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