import { CfnResource } from 'monocdk';
import { NagPackSuppression } from '../models/nag-suppression';
interface NagCfnMetadata {
    rules_to_suppress: NagCfnSuppression[];
}
interface NagCfnSuppression extends Omit<NagPackSuppression, 'appliesTo'> {
    applies_to?: string[];
}
export declare class NagSuppressionHelper {
    static toCfnFormat(suppression: NagPackSuppression): NagCfnSuppression;
    static toApiFormat(suppression: NagCfnSuppression): NagPackSuppression;
    static addRulesToMetadata(metadata: NagCfnMetadata, rules: NagPackSuppression[]): NagCfnMetadata;
    static getSuppressions(node: CfnResource): NagPackSuppression[];
    static assertSuppressionsAreValid(id: string, suppressions: NagPackSuppression[]): void;
    private static getSuppressionFormatError;
}
export {};
