"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabRunnerAutoscaling = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_security_group_1 = require("@pepperize/cdk-security-group");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_autoscaling_1 = require("aws-cdk-lib/aws-autoscaling");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
const cache_1 = require("./cache");
const job_runner_1 = require("./job-runner");
const manager_1 = require("./manager");
const network_1 = require("./network");
/**
 * The Gitlab Runner autoscaling on EC2 by Docker Machine.
 *
 * @example <caption>Provisioning a basic Runner</caption>
 * const app = new cdk.App();
 * const stack = new cdk.Stack(app, "RunnerStack", {
 *   env: {
 *     account: "000000000000",
 *     region: "us-east-1",
 *   }
 * });
 *
 * const token = new StringParameter(stack, "imported-token", {
 *   parameterName: "/gitlab-runner/token1",
 *   stringValue: gitlabToken,
 *   type: ParameterType.SECURE_STRING,
 *   tier: ParameterTier.STANDARD,
 * });
 *
 * new GitlabRunnerAutoscaling(stack, "GitlabRunner", {
 *   runners: [{
 *     token: "xxxxxxxxxxxxxxxxxxxx"
 *     }],
 * });
 */
class GitlabRunnerAutoscaling extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { concurrent, checkInterval, logFormat, logLevel, manager, cache, runners, network, } = props;
        /**
         * Global Configuration
         * @link GlobalConfiguration
         */
        this.concurrent = concurrent !== null && concurrent !== void 0 ? concurrent : 10;
        this.checkInterval = checkInterval !== null && checkInterval !== void 0 ? checkInterval : 0;
        this.logFormat = logFormat !== null && logFormat !== void 0 ? logFormat : "runner";
        this.logLevel = logLevel !== null && logLevel !== void 0 ? logLevel : "info";
        /**
         * S3 Bucket for Runners' cache
         */
        this.cacheBucket = (cache === null || cache === void 0 ? void 0 : cache.bucket) || new cache_1.Cache(scope, "Cache", cache === null || cache === void 0 ? void 0 : cache.options).bucket;
        /**
         * Network
         */
        this.network = new network_1.Network(scope, "Network", network);
        /**
         * Security groups
         */
        const runnersSecurityGroupName = `${scope.stackName}-RunnersSecurityGroup`;
        const runnersSecurityGroup = new cdk_security_group_1.SecurityGroup(scope, "RunnersSecurityGroup", {
            securityGroupName: runnersSecurityGroupName,
            description: "Security group for GitLab Runners.",
            vpc: this.network.vpc,
        });
        const managerSecurityGroup = new cdk_security_group_1.SecurityGroup(scope, "ManagerSecurityGroup", {
            vpc: this.network.vpc,
            description: "Security group for GitLab Runners Manager.",
        });
        managerSecurityGroup.connections.allowTo(runnersSecurityGroup, aws_ec2_1.Port.tcp(22), "SSH traffic from Manager");
        managerSecurityGroup.connections.allowTo(runnersSecurityGroup, aws_ec2_1.Port.tcp(2376), "SSH traffic from Docker");
        this.runners = runners.map((runnerProps, index) => {
            return new job_runner_1.GitlabRunnerAutoscalingJobRunner(scope, `GitlabRunnerAutoscalingJobRunner${index}`, runnerProps);
        });
        /**
         * GitLab Manager
         */
        this.manager = new manager_1.GitlabRunnerAutoscalingManager(scope, "Manager", {
            ...manager,
            globalConfiguration: {
                concurrent: this.concurrent,
                checkInterval: this.checkInterval,
                logFormat: this.logFormat,
                logLevel: this.logLevel,
            },
            runnersSecurityGroup: runnersSecurityGroup,
            network: this.network,
            cacheBucket: this.cacheBucket,
            runners: this.runners,
        });
        new aws_autoscaling_1.AutoScalingGroup(scope, "ManagerAutoscalingGroup", {
            vpc: this.network.vpc,
            vpcSubnets: {
                subnets: [this.network.subnet],
            },
            instanceType: this.manager.instanceType,
            machineImage: this.manager.machineImage,
            keyName: this.manager.keyPairName,
            securityGroup: managerSecurityGroup,
            role: this.manager.role,
            userData: this.manager.userData,
            init: this.manager.initConfig,
            initOptions: {
                ignoreFailures: false,
            },
            maxCapacity: 1,
            minCapacity: 1,
            desiredCapacity: 1,
            signals: aws_autoscaling_1.Signals.waitForCount(1, { timeout: aws_cdk_lib_1.Duration.minutes(15) }),
        });
    }
}
exports.GitlabRunnerAutoscaling = GitlabRunnerAutoscaling;
_a = JSII_RTTI_SYMBOL_1;
GitlabRunnerAutoscaling[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.GitlabRunnerAutoscaling", version: "0.2.13" };
//# sourceMappingURL=data:application/json;base64,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