import datetime

from geoformat.conversion.feature_conversion import (
    feature_serialize,
    feature_deserialize,
    features_geometry_ref_scan,
    features_fields_type_scan,
    feature_list_to_geolayer,
    feature_filter_geometry,
    feature_filter_attributes,
    feature_filter,
    features_filter,
    check_if_value_is_from_datetime_lib,
    check_if_value_is_date,
    check_if_value_is_time,
    check_if_value_is_datetime,
    return_if_value_is_time_date_or_datetime,
)
from geoformat.conversion.geometry_conversion import geometry_to_wkb
from test_all import test_function
from tests.data.coordinates import (
    point_coordinates,
    linestring_coordinates,
    polygon_coordinates,
    multipoint_coordinates,
    multilinestring_coordinates,
    multipolygon_coordinates,
)


from tests.data.features import (
    velib_attributes_feature,
    feature_list_date_time_datetime_attributes_str,
    feature_list_date_time_datetime_attributes_lib,
    feature_attributes_only,
    feature_attributes_only_str,
    feature_dpt_geometry_only_a,
    feature_dpt_data_only_a,
    feature_dpt_data_and_geometry_a,
    feature_list_geometry_only,
    feature_list_geometry_only_with_all_geometries,
    feature_list_attribute_only,
    feature_list_structure_alpha,
    feature_list_bytes_attributes,
    feature_list_data_and_geometry,
    date_value,
    time_value,
    date_time_value,
    feature_geometry_only_point,
    feature_geometry_only_point_empty,
    feature_geometry_only_linestring,
    feature_geometry_only_linestring_empty,
    feature_geometry_only_polygon,
    feature_geometry_only_polygon_empty,
    feature_geometry_only_multipoint,
    feature_geometry_only_multipoint_empty,
    feature_geometry_only_multilinestring,
    feature_geometry_only_multilinestring_empty,
    feature_geometry_only_multipolygon,
    feature_geometry_only_multipolygon_empty,
    feature_geometry_only_collection,
    feature_geometry_only_collection_empty,
    feature_geometry_only_collection_with_empty_geometries,
)
from tests.data.geolayers import (
    geolayer_attributes_only,
    geolayer_attributes_to_force_only,
    geolayer_attributes_to_force_in_str,
    geolayer_fr_dept_geometry_only,
    geolayer_fr_dept_data_and_geometry,
    geolayer_fr_dept_data_only,
    feature_list_data_and_geometry_geolayer,
    feature_list_data_and_geometry_serialized_geolayer,
    geolayer_fields_with_bytes_values,
    geolayer_fields_with_bytes_values_forced,
)

feature_serialize_parameters = {
    0: {
        "feature": feature_dpt_data_only_a,
        "return_value": {"attributes": str(feature_dpt_data_only_a["attributes"])},
    },
    1: {
        "feature": feature_dpt_geometry_only_a,
        "return_value": {
            "geometry": geometry_to_wkb(feature_dpt_geometry_only_a["geometry"])
        },
    },
    2: {
        "feature": feature_dpt_data_and_geometry_a,
        "return_value": {
            "attributes": str(feature_dpt_data_only_a["attributes"]),
            "geometry": geometry_to_wkb(feature_dpt_geometry_only_a["geometry"]),
        },
    },
}

feature_deserialize_parameters = {
    0: {
        "serialized_feature": {
            "attributes": str(feature_dpt_data_only_a["attributes"])
        },
        "bbox": True,
        "return_value": feature_dpt_data_only_a,
    },
    1: {
        "serialized_feature": {
            "attributes": str(feature_dpt_data_only_a["attributes"])
        },
        "bbox": False,
        "return_value": feature_dpt_data_only_a,
    },
    2: {
        "serialized_feature": {
            "geometry": geometry_to_wkb(feature_dpt_geometry_only_a["geometry"])
        },
        "bbox": True,
        "return_value": feature_dpt_geometry_only_a,
    },
    3: {
        "serialized_feature": {
            "geometry": geometry_to_wkb(feature_dpt_geometry_only_a["geometry"])
        },
        "bbox": False,
        "return_value": {
            "geometry": {
                "type": feature_dpt_geometry_only_a["geometry"]["type"],
                "coordinates": feature_dpt_geometry_only_a["geometry"]["coordinates"],
            }
        },
    },
    4: {
        "serialized_feature": {
            "geometry": geometry_to_wkb(feature_dpt_geometry_only_a["geometry"]),
            "attributes": str(feature_dpt_data_only_a["attributes"]),
        },
        "bbox": True,
        "return_value": {
            "attributes": feature_dpt_data_only_a["attributes"],
            "geometry": feature_dpt_geometry_only_a["geometry"],
        },
    },
    5: {
        "serialized_feature": {
            "attributes": str(feature_dpt_data_only_a["attributes"]),
            "geometry": geometry_to_wkb(feature_dpt_geometry_only_a["geometry"]),
        },
        "bbox": False,
        "return_value": {
            "attributes": feature_dpt_data_and_geometry_a["attributes"],
            "geometry": {
                "type": feature_dpt_data_and_geometry_a["geometry"]["type"],
                "coordinates": feature_dpt_data_and_geometry_a["geometry"][
                    "coordinates"
                ],
            },
        },
    },
}

features_geometry_ref_scan_parameters = {
    0: {
        "geolayer_or_feature_list": geolayer_fr_dept_geometry_only,
        "extent": False,
        "return_value": {"type": {"Polygon", "MultiPolygon"}, "extent": None},
    },
    1: {
        "geolayer_or_feature_list": geolayer_fr_dept_data_and_geometry,
        "extent": False,
        "return_value": {"type": {"Polygon", "MultiPolygon"}, "extent": None},
    },
    2: {
        "geolayer_or_feature_list": geolayer_fr_dept_data_only,
        "extent": False,
        "return_value": {"type": None, "extent": None},
    },
    3: {
        "geolayer_or_feature_list": feature_list_geometry_only,
        "extent": False,
        "return_value": {"type": {"Polygon", "MultiPolygon"}, "extent": None},
    },
    4: {
        "geolayer_or_feature_list": feature_list_geometry_only_with_all_geometries,
        "extent": False,
        "return_value": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "extent": None,
        },
    },
    5: {
        "geolayer_or_feature_list": geolayer_fr_dept_geometry_only,
        "extent": False,
        "return_value": {"type": {"Polygon", "MultiPolygon"}, "extent": None},
    },
    6: {
        "geolayer_or_feature_list": geolayer_fr_dept_data_and_geometry,
        "extent": True,
        "return_value": {
            "type": {"Polygon", "MultiPolygon"},
            "extent": (124277.0, 6050136.0, 1242213.0, 7110430.0),
        },
    },
    7: {
        "geolayer_or_feature_list": geolayer_fr_dept_data_only,
        "extent": True,
        "return_value": {"type": None, "extent": None},
    },
    8: {
        "geolayer_or_feature_list": feature_list_geometry_only,
        "extent": True,
        "return_value": {
            "type": {"Polygon", "MultiPolygon"},
            "extent": (202166.0, 6704696.0, 790134.0, 6997000.0),
        },
    },
    9: {
        "geolayer_or_feature_list": feature_list_geometry_only_with_all_geometries,
        "extent": True,
        "return_value": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "extent": (-157.97, -34.29, 35.12, 77.95),
        },
    },
}

features_fields_type_scan_parameters = {
    0: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_integer",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    1: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_integer_list",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    2: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_real",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 9,
                "width_before_comma": 4,
                "width_after_comma": 5,
                "field_delete": False,
            }
        },
    },
    3: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_real_list",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            }
        },
    },
    4: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_string",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    5: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_string_list",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    6: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_date",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    7: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_time",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.time},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    8: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_datetime",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    9: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_binary",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    10: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": ["field_string_list", "field_integer"],
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    11: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": None,
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 9,
                "width_before_comma": 4,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": False,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 6,
                "field_recast": False,
                "native_type": set(),
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": False,
                "native_type": {bool},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    12: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_integer",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 3,
                "width_before_comma": 3,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    13: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_integer_list",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    14: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_real",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 9,
                "width_before_comma": 4,
                "width_after_comma": 5,
                "field_delete": False,
            }
        },
    },
    15: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_real_list",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            }
        },
    },
    16: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_string",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    17: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_string_list",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    18: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_date",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    19: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_time",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    20: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_datetime",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    21: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": "field_binary",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    22: {
        "geolayer_or_feature_list": geolayer_attributes_only,
        "field_name_filter": None,
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 3,
                "width_before_comma": 3,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 9,
                "width_before_comma": 4,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": False,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 6,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": False,
                "native_type": {bool},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    23: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_integer",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    24: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_integer_list",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 6,
                "field_width_list": 13,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str, int, float},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    25: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_real",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 7,
                "field_width_list": None,
                "field_precision": 2,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 6,
                "width_before_comma": 4,
                "width_after_comma": 2,
                "field_delete": False,
            }
        },
    },
    26: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_real_list",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 20,
                "field_precision": 4,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 9,
                "width_before_comma": 5,
                "width_after_comma": 4,
                "field_delete": False,
            }
        },
    },
    27: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_string",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str, datetime.datetime},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    28: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_string_list",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 6,
                "field_width_list": 16,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    29: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_date",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    30: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_time",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str, datetime.time},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    31: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_datetime",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    32: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_datetime",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    33: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_datetime",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    34_2: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_binary",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": True,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    34: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_boolean",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {bool, int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    35: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_boolean",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {bool, int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 1,
                "width_before_comma": 1,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    36: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_datetime",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    37: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": None,
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 12,
                "field_width_list": 13,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": True,
                "native_type": {str, int, float},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 7,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 19,
                "field_width_list": 6,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": True,
                "native_type": {str, datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {datetime.date},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 6,
                "field_recast": True,
                "native_type": {str, datetime.time},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": True,
                "native_type": {bool, int},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {str},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 16,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {str},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    38: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": None,
        "try_to_force_type": False,
        "fields_index": False,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {float},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 12,
                "field_width_list": 13,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int, float},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 7,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 19,
                "field_width_list": 6,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.time},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {bool, int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 16,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    39: {
        "geolayer_or_feature_list": feature_list_attribute_only,
        "field_name_filter": None,
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 3,
                "width_before_comma": 3,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 9,
                "width_before_comma": 4,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": False,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 6,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": False,
                "native_type": {bool},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    40: {
        "geolayer_or_feature_list": feature_list_structure_alpha,
        "field_name_filter": None,
        "try_to_force_type": False,
        "fields_index": False,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 12,
                "field_width_list": 13,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int, float},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 7,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 19,
                "field_width_list": 6,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.time},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {bool, int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 16,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    41: {
        "geolayer_or_feature_list": feature_list_structure_alpha,
        "field_name_filter": None,
        "try_to_force_type": True,
        "fields_index": False,
        "none_value_pattern": {None, "NULL"},
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 6,
                "field_width_list": 13,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int, float},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 7,
                "field_width_list": None,
                "field_precision": 2,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 6,
                "width_before_comma": 4,
                "width_after_comma": 2,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 20,
                "field_precision": 4,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 9,
                "width_before_comma": 5,
                "width_after_comma": 4,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.datetime},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.time},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": True,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {bool, int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 1,
                "width_before_comma": 1,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": False,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_recast": True,
                "native_type": set(),
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 6,
                "field_width_list": 16,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {datetime.datetime, datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    42: {
        "geolayer_or_feature_list": feature_list_bytes_attributes,
        "field_name_filter": None,
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_bytes": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 1647,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_hexa_a": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 1116,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_hexa_b": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 1116,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_bytes_hexa_a": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 1647,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": False,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_bytes_hexa_b": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 1116,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": True,
                "native_type": {bytes, str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    43: {
        "geolayer_or_feature_list": feature_list_bytes_attributes,
        "field_name_filter": None,
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_bytes": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 1647,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_hexa_a": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 1116,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_hexa_b": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 1116,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_bytes_hexa_a": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 1647,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": True,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_bytes_hexa_b": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 1116,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": True,
                "native_type": {bytes, str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    44: {
        "geolayer_or_feature_list": feature_list_data_and_geometry,
        "field_name_filter": ["CODE_DEPT"],
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "CODE_DEPT": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 2,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": True,
                "field_width_float": 2,
                "width_before_comma": 2,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    45: {
        "geolayer_or_feature_list": [
            {"attributes": {"shape_leng": 3358.17440629}},
            {"attributes": {"shape_leng": 58.1744062917440629}},
        ],
        "field_name_filter": ["shape_leng"],
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "shape_leng": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 17,
                "field_width_list": None,
                "field_precision": 14,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 18,
                "width_before_comma": 4,
                "width_after_comma": 14,
                "field_delete": False,
            }
        },
    },
    46: {
        "geolayer_or_feature_list": [
            {"attributes": {"shape_leng": 3358.17440629}},
            {"attributes": {"shape_leng": 58.1744062917440629}},
        ],
        "field_name_filter": ["shape_leng"],
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "shape_leng": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 17,
                "field_width_list": None,
                "field_precision": 14,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 18,
                "width_before_comma": 4,
                "width_after_comma": 14,
                "field_delete": False,
            }
        },
    },
    47: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_str,
        "field_name_filter": "field_date",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    48: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_str,
        "field_name_filter": "field_time",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    49: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_str,
        "field_name_filter": "field_datetime",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    50: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_str,
        "field_name_filter": "field_date",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    51: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_str,
        "field_name_filter": "field_time",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    52: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_str,
        "field_name_filter": "field_datetime",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    53: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_lib,
        "field_name_filter": "field_date",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    54: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_lib,
        "field_name_filter": "field_time",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    55: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_lib,
        "field_name_filter": "field_datetime",
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    56: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_lib,
        "field_name_filter": "field_date",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    57: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_lib,
        "field_name_filter": "field_time",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    58: {
        "geolayer_or_feature_list": feature_list_date_time_datetime_attributes_lib,
        "field_name_filter": "field_datetime",
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    59: {
        "geolayer_or_feature_list": [velib_attributes_feature],
        "field_name_filter": "Coordonnées géographiques",
        "try_to_force_type": False,
        "fields_index": False,
        "return_value": {
            "Coordonnées géographiques": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    60: {
        "geolayer_or_feature_list": [velib_attributes_feature],
        "field_name_filter": "Coordonnées géographiques",
        "try_to_force_type": True,
        "fields_index": False,
        "return_value": {
            "Coordonnées géographiques": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 13,
                "field_width_list": 29,
                "field_precision": 11,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 13,
                "width_before_comma": 2,
                "width_after_comma": 11,
                "field_delete": False,
            }
        },
    },
    61: {
        "geolayer_or_feature_list": [feature_attributes_only],
        "field_name_filter": None,
        "try_to_force_type": False,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 9,
                "width_before_comma": 4,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": False,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 6,
                "field_recast": False,
                "native_type": set(),
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": False,
                "native_type": {bool},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    62: {
        "geolayer_or_feature_list": [feature_attributes_only_str],
        "field_name_filter": None,
        "try_to_force_type": True,
        "fields_index": True,
        "return_value": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 3,
                "width_before_comma": 3,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 9,
                "width_before_comma": 4,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 6,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 102,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
    },
    63: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_in_str,
        "field_name_filter": "field_string",
        "try_to_force_type": True,
        "fields_index": False,
        "none_value_pattern": {None, ""},
        "return_value": {
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    64: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_none",
        "try_to_force_type": False,
        "fields_index": False,
        "none_value_pattern": {None},
        "return_value": {
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    65: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_only,
        "field_name_filter": "field_none",
        "try_to_force_type": False,
        "fields_index": False,
        "none_value_pattern": {None, "NULL"},
        "return_value": {
            "field_none": {
                "values_in_list": False,
                "values_out_list": False,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_recast": True,
                "native_type": set(),
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            }
        },
    },
    66: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_in_str,
        "field_name_filter": "field_string_list",
        "try_to_force_type": True,
        "fields_index": False,
        "none_value_pattern": {None, ""},
        "return_value": {
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 6,
                "field_width_list": 16,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
    67: {
        "geolayer_or_feature_list": geolayer_attributes_to_force_in_str,
        "field_name_filter": "field_date",
        "try_to_force_type": True,
        "fields_index": False,
        "none_value_pattern": {None, ""},
        "return_value": {
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
    },
}

feature_list_to_geolayer_parameters = {
    0: {
        "feature_list": feature_list_structure_alpha,
        "geolayer_name": "new_geolayer",
        "field_name_filter": None,
        "force_field_conversion": False,
        "bbox_extent": False,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "new_geolayer",
                "fields": {
                    "field_integer": {
                        "type": "Real",
                        "width": 4,
                        "precision": 0,
                        "index": 0,
                    },
                    "field_integer_list": {"type": "String", "width": 13, "index": 1},
                    "field_real": {"type": "String", "width": 7, "index": 2},
                    "field_real_list": {"type": "String", "width": 19, "index": 3},
                    "field_string": {"type": "String", "width": 26, "index": 4},
                    "field_date": {"type": "Date", "index": 5},
                    "field_time": {"type": "String", "width": 15, "index": 6},
                    "field_binary": {"type": "String", "width": 201, "index": 7},
                    "field_boolean": {"type": "String", "width": 5, "index": 8},
                    "field_none": {"type": "String", "width": 4, "index": 9},
                    "field_string_list": {"type": "String", "width": 16, "index": 10},
                    "field_datetime": {"type": "DateTime", "index": 11},
                },
            },
            "features": {
                0: {
                    "attributes": {
                        "field_integer": 586.0,
                        "field_integer_list": "[5879, 8557]",
                        "field_real": "8789.98",
                        "field_real_list": "[89798.3654, 8757.]",
                        "field_string": None,
                        "field_date": datetime.datetime(
                            year=2020,
                            month=3,
                            day=31,
                            hour=11,
                            minute=22,
                            second=10,
                            microsecond=999,
                        ).date(),  # 5
                        "field_time": "18:41:04",
                        "field_binary": "b'\\x00\\x00\\x00\\x00\\x04\\x00\\x00\\x00\\x02\\x00\\x00\\x00\\x00\\x01\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x01?\\xf0\\x00\\x00\\x00\\x00\\x00\\x00?\\xf0\\x00\\x00\\x00\\x00\\x00\\x00'",
                        "field_boolean": "True",
                        "field_none": None,
                    }
                },
                1: {
                    "attributes": {
                        "field_integer": 1466.0,
                        "field_integer_list": "[987, 2345.0]",  #  good value "[987, 2345.0]",
                        "field_real": "8789",
                        "field_real_list": "[2, 5]",
                        "field_string": "salut",
                        "field_string_list": "['hi', 'mister']",
                        "field_time": "11:22:10.000999",
                        "field_datetime": datetime.datetime(
                            year=2020,
                            month=3,
                            day=31,
                            hour=11,
                            minute=22,
                            second=10,
                            microsecond=999,
                        ),
                        "field_binary": b"\x00\x00\x00\x00\x01@\xef\xf3k\n=p\xa4@\xbd\xe6\x8b\x02\x0cI\xba".hex(),
                        "field_boolean": "False",
                        "field_none": None,
                    }
                },
                2: {
                    "attributes": {
                        "field_integer": 149.0,
                        "field_integer_list": "[987, 2345.0]",  # good value "[987, 2345.0]"
                        "field_real": "8789",
                        "field_real_list": "[2, 5]",
                        "field_string": "2020-03-31 11:22:10.000999",
                        "field_string_list": "['hi', 'mister']",
                        "field_time": "11:22:10.000999",
                        "field_datetime": datetime.datetime(
                            year=2020,
                            month=3,
                            day=31,
                            hour=0,
                            minute=0,
                            second=0,
                            microsecond=0,
                        ),
                        "field_binary": "000000000140eff36b0a3d70a440bde68b020c49ba",
                        "field_boolean": "1",
                        "field_none": "NULL",
                    }
                },
            },
        },
    },
    1: {
        "feature_list": feature_list_structure_alpha,
        "geolayer_name": "new_geolayer",
        "field_name_filter": None,
        "force_field_conversion": True,
        "bbox_extent": False,
        "crs": None,
        "none_value_pattern": {None, "NULL"},
        "return_value": {
            "metadata": {
                "name": "new_geolayer",
                "fields": {
                    "field_integer": {"type": "Integer", "index": 0},
                    "field_integer_list": {"type": "IntegerList", "index": 1},
                    "field_real": {
                        "type": "Real",
                        "width": 6,
                        "precision": 2,
                        "index": 2,
                    },
                    "field_real_list": {
                        "type": "RealList",
                        "width": 9,
                        "precision": 4,
                        "index": 3,
                    },
                    "field_string": {"type": "String", "width": 26, "index": 4},
                    "field_date": {"type": "Date", "index": 5},
                    "field_time": {"type": "Time", "index": 6},
                    "field_binary": {"type": "Binary", "index": 7},
                    "field_boolean": {"type": "Boolean", "index": 8},
                    "field_string_list": {"type": "StringList", "width": 6, "index": 9},
                    "field_datetime": {"type": "DateTime", "index": 10},
                },
            },
            "features": {
                0: {
                    "attributes": {
                        "field_integer": 586,
                        "field_integer_list": [5879, 8557],
                        "field_real": 8789.98,
                        "field_real_list": [89798.3654, 8757.0],
                        "field_string": None,
                        "field_date": datetime.datetime(
                            year=2020,
                            month=3,
                            day=31,
                            hour=11,
                            minute=22,
                            second=10,
                            microsecond=999,
                        ).date(),  # 5
                        "field_time": datetime.time.fromisoformat("18:41:04"),
                        "field_binary": b"\x00\x00\x00\x00\x04\x00\x00\x00\x02\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01?\xf0\x00\x00\x00\x00\x00\x00?\xf0\x00\x00\x00\x00\x00\x00",
                        "field_boolean": True,
                    }
                },
                1: {
                    "attributes": {
                        "field_integer": 1466,
                        "field_integer_list": [987, 2345],
                        "field_real": 8789.0,
                        "field_real_list": [2.0, 5.0],
                        "field_string": "salut",
                        "field_string_list": ["hi", "mister"],
                        "field_time": datetime.time.fromisoformat("11:22:10.000999"),
                        "field_datetime": datetime.datetime(
                            year=2020,
                            month=3,
                            day=31,
                            hour=11,
                            minute=22,
                            second=10,
                            microsecond=999,
                        ),
                        "field_binary": b"\x00\x00\x00\x00\x01@\xef\xf3k\n=p\xa4@\xbd\xe6\x8b\x02\x0cI\xba",
                        "field_boolean": False,
                    }
                },
                2: {
                    "attributes": {
                        "field_integer": 149,
                        "field_integer_list": [987, 2345],
                        "field_real": 8789.0,
                        "field_real_list": [2.0, 5.0],
                        "field_string": "2020-03-31 11:22:10.000999",
                        "field_string_list": ["hi", "mister"],
                        "field_time": datetime.time.fromisoformat("11:22:10.000999"),
                        "field_datetime": datetime.datetime(
                            year=2020,
                            month=3,
                            day=31,
                            hour=0,
                            minute=0,
                            second=0,
                            microsecond=0,
                        ),
                        "field_binary": b"\x00\x00\x00\x00\x01@\xef\xf3k\n=p\xa4@\xbd\xe6\x8b\x02\x0cI\xba",
                        "field_boolean": True,
                    }
                },
            },
        },
    },
    2: {
        "feature_list": feature_list_attribute_only,
        "geolayer_name": "attributes_only",
        "field_name_filter": None,
        "force_field_conversion": False,
        "bbox_extent": False,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "attributes_only",
                "fields": {
                    "field_binary": {"index": 9, "type": "Binary"},
                    "field_boolean": {"index": 10, "type": "Boolean"},
                    "field_date": {"index": 6, "type": "Date"},
                    "field_datetime": {"index": 8, "type": "DateTime"},
                    "field_integer": {"index": 0, "type": "Integer"},
                    "field_integer_list": {"index": 1, "type": "IntegerList"},
                    "field_real": {
                        "index": 2,
                        "precision": 5,
                        "type": "Real",
                        "width": 9,
                    },
                    "field_real_list": {
                        "index": 3,
                        "precision": 5,
                        "type": "RealList",
                        "width": 10,
                    },
                    "field_string": {"index": 4, "type": "String", "width": 5},
                    "field_string_list": {"index": 5, "type": "StringList", "width": 8},
                    "field_time": {"index": 7, "type": "Time"},
                },
            },
            "features": {
                0: {
                    "attributes": {
                        "field_integer": 586,
                        "field_integer_list": [5879, 8557],
                        "field_real": 8789.97568,
                        "field_real_list": [89798.3654, 8757.97568],
                        "field_string": "salut",
                        "field_string_list": ["bonjour", "monsieur"],
                        "field_date": date_value,
                        "field_time": time_value,
                        "field_datetime": date_time_value,
                        "field_binary": b"\x00\x00\x00\x00\x04\x00\x00\x00\x02\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01?\xf0\x00\x00\x00\x00\x00\x00?\xf0\x00\x00\x00\x00\x00\x00",
                        "field_boolean": True,
                    }
                }
            },
        },
    },
    3: {
        "feature_list": feature_list_attribute_only,
        "geolayer_name": "attributes_only",
        "field_name_filter": None,
        "force_field_conversion": True,
        "bbox_extent": False,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "attributes_only",
                "fields": {
                    "field_binary": {"index": 9, "type": "Binary"},
                    "field_boolean": {"index": 10, "type": "Boolean"},
                    "field_date": {"index": 6, "type": "Date"},
                    "field_datetime": {"index": 8, "type": "DateTime"},
                    "field_integer": {"index": 0, "type": "Integer"},
                    "field_integer_list": {"index": 1, "type": "IntegerList"},
                    "field_real": {
                        "index": 2,
                        "type": "Real",
                        "precision": 5,
                        "width": 9,
                    },
                    "field_real_list": {
                        "index": 3,
                        "precision": 5,
                        "type": "RealList",
                        "width": 10,
                    },
                    "field_string": {"index": 4, "type": "String", "width": 5},
                    "field_string_list": {"index": 5, "type": "StringList", "width": 8},
                    "field_time": {"index": 7, "type": "Time"},
                },
            },
            "features": {
                0: {
                    "attributes": {
                        "field_integer": 586,
                        "field_integer_list": [5879, 8557],
                        "field_real": 8789.97568,
                        "field_real_list": [89798.3654, 8757.97568],
                        "field_string": "salut",
                        "field_string_list": ["bonjour", "monsieur"],
                        "field_date": date_value,
                        "field_time": time_value,
                        "field_datetime": date_time_value,
                        "field_binary": b"\x00\x00\x00\x00\x04\x00\x00\x00\x02\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01?\xf0\x00\x00\x00\x00\x00\x00?\xf0\x00\x00\x00\x00\x00\x00",
                        "field_boolean": True,
                    }
                }
            },
        },
    },
    4: {
        "feature_list": feature_list_geometry_only,
        "geolayer_name": "geometry_only",
        "field_name_filter": None,
        "force_field_conversion": False,
        "bbox_extent": False,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "geometry_only",
                "geometry_ref": {"type": {"Polygon", "MultiPolygon"}},
            },
            "features": {
                0: feature_list_geometry_only[0],
                1: feature_list_geometry_only[1],
                2: feature_list_geometry_only[2],
                3: feature_list_geometry_only[3],
            },
        },
    },
    5: {
        "feature_list": feature_list_geometry_only,
        "geolayer_name": "geometry_only",
        "field_name_filter": None,
        "force_field_conversion": False,
        "bbox_extent": True,
        "crs": 2154,
        "return_value": {
            "metadata": {
                "name": "geometry_only",
                "geometry_ref": {
                    "type": {"Polygon", "MultiPolygon"},
                    "crs": 2154,
                    "extent": (202166.0, 6704696.0, 790134.0, 6997000.0),
                },
            },
            "features": {
                0: feature_list_geometry_only[0],
                1: feature_list_geometry_only[1],
                2: feature_list_geometry_only[2],
                3: feature_list_geometry_only[3],
            },
        },
    },
    6: {
        "feature_list": feature_list_geometry_only_with_all_geometries,
        "geolayer_name": "all_geometries",
        "field_name_filter": None,
        "force_field_conversion": False,
        "bbox_extent": False,
        "crs": 4326,
        "return_value": {
            "metadata": {
                "name": "all_geometries",
                "geometry_ref": {
                    "type": {
                        "Point",
                        "LineString",
                        "Polygon",
                        "MultiPoint",
                        "MultiLineString",
                        "MultiPolygon",
                        "GeometryCollection",
                    },
                    "crs": 4326,
                },
            },
            "features": {
                0: feature_geometry_only_point,
                1: feature_geometry_only_point_empty,
                2: feature_geometry_only_linestring,
                3: feature_geometry_only_linestring_empty,
                4: feature_geometry_only_polygon,
                5: feature_geometry_only_polygon_empty,
                6: feature_geometry_only_multipoint,
                7: feature_geometry_only_multipoint_empty,
                8: feature_geometry_only_multilinestring,
                9: feature_geometry_only_multilinestring_empty,
                10: feature_geometry_only_multipolygon,
                11: feature_geometry_only_multipolygon_empty,
                12: feature_geometry_only_collection,
                13: feature_geometry_only_collection_empty,
                14: feature_geometry_only_collection_with_empty_geometries,
            },
        },
    },
    7: {
        "feature_list": feature_list_geometry_only_with_all_geometries,
        "geolayer_name": "all_geometries",
        "field_name_filter": "foo",
        "force_field_conversion": True,
        "bbox_extent": True,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "crs": 4326,
        "return_value": {
            "metadata": {
                "name": "all_geometries",
                "geometry_ref": {
                    "type": {
                        "Point",
                        "LineString",
                        "Polygon",
                        "MultiPoint",
                        "MultiLineString",
                        "MultiPolygon",
                        "GeometryCollection",
                    },
                    "extent": (-157.97, -34.29, 35.12, 77.95),
                    "crs": 4326,
                },
            },
            "features": {
                0: {
                    "geometry": {
                        "type": "Point",
                        "coordinates": point_coordinates,
                        "bbox": (-115.81, 37.24, -115.81, 37.24),
                    }
                },
                1: feature_geometry_only_point_empty,
                2: {
                    "geometry": {
                        "type": "LineString",
                        "coordinates": linestring_coordinates,
                        "bbox": (8.919, 44.4074, 8.923, 44.4075),
                    }
                },
                3: feature_geometry_only_linestring_empty,
                4: {
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": polygon_coordinates,
                        "bbox": (-120.43, -20.28, 23.194, 57.322),
                    }
                },
                5: feature_geometry_only_polygon_empty,
                6: {
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": multipoint_coordinates,
                        "bbox": (-157.97, 19.61, -155.52, 21.46),
                    }
                },
                7: feature_geometry_only_multipoint_empty,
                8: {
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": multilinestring_coordinates,
                        "bbox": (-130.95, -34.25, 23.15, 77.95),
                    }
                },
                9: feature_geometry_only_multilinestring_empty,
                10: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": multipolygon_coordinates,
                        "bbox": (-130.91, -34.29, 35.12, 77.91),
                    }
                },
                11: feature_geometry_only_multipolygon_empty,
                12: {
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {
                                "type": "Point",
                                "coordinates": [-115.81, 37.24],
                                "bbox": (-115.81, 37.24, -115.81, 37.24),
                            },
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                                "bbox": (8.919, 44.4074, 8.923, 44.4075),
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                                "bbox": (-120.43, -20.28, 23.194, 57.322),
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                                "bbox": (-157.97, 19.61, -155.52, 21.46),
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                                "bbox": (-130.95, -34.25, 23.15, 77.95),
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                                "bbox": (-130.91, -34.29, 35.12, 77.91),
                            },
                        ],
                        "bbox": (-157.97, -34.29, 35.12, 77.95),
                    }
                },
                13: feature_geometry_only_collection_empty,
                14: {
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                                "bbox": (8.919, 44.4074, 8.923, 44.4075),
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                                "bbox": (-120.43, -20.28, 23.194, 57.322),
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                                "bbox": (-130.95, -34.25, 23.15, 77.95),
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                        "bbox": (-130.95, -34.25, 23.194, 77.95),
                    }
                },
            },
        },
    },
    8: {
        "feature_list": feature_list_geometry_only_with_all_geometries,
        "geolayer_name": "all_geometries",
        "field_name_filter": "foo",
        "force_field_conversion": True,
        "bbox_extent": False,
        "crs": 4326,
        "return_value": {
            "metadata": {
                "name": "all_geometries",
                "geometry_ref": {
                    "type": {
                        "Point",
                        "LineString",
                        "Polygon",
                        "MultiPoint",
                        "MultiLineString",
                        "MultiPolygon",
                        "GeometryCollection",
                    },
                    "crs": 4326,
                },
            },
            "features": {
                0: feature_geometry_only_point,
                1: feature_geometry_only_point_empty,
                2: feature_geometry_only_linestring,
                3: feature_geometry_only_linestring_empty,
                4: feature_geometry_only_polygon,
                5: feature_geometry_only_polygon_empty,
                6: feature_geometry_only_multipoint,
                7: feature_geometry_only_multipoint_empty,
                8: feature_geometry_only_multilinestring,
                9: feature_geometry_only_multilinestring_empty,
                10: feature_geometry_only_multipolygon,
                11: feature_geometry_only_multipolygon_empty,
                12: feature_geometry_only_collection,
                13: feature_geometry_only_collection_empty,
                14: feature_geometry_only_collection_with_empty_geometries,
            },
        },
    },
    9: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": None,
        "force_field_conversion": False,
        "bbox_extent": False,
        "crs": 2154,
        "return_value": feature_list_data_and_geometry_geolayer,
    },
    10: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": None,
        "force_field_conversion": True,
        "bbox_extent": True,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "data_and_geometries",
                "fields": {
                    "CODE_DEPT": {"type": "Integer", "index": 0},
                    "NOM_DEPT": {"type": "String", "width": 10, "index": 1},
                },
                "geometry_ref": {
                    "type": {"Polygon", "MultiPolygon"},
                    "extent": (202166.0, 6704696.0, 790134.0, 6997000.0),
                },
            },
            "features": {
                0: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (382932.0, 6743442.0, 474394.0, 6833996.0),
                        "coordinates": [
                            [
                                [399495.0, 6830885.0],
                                [398130.0, 6822559.0],
                                [400321.0, 6810723.0],
                                [395852.0, 6803336.0],
                                [398626.0, 6784333.0],
                                [400465.0, 6781914.0],
                                [400197.0, 6773697.0],
                                [394099.0, 6773357.0],
                                [390140.0, 6770978.0],
                                [386941.0, 6760260.0],
                                [382932.0, 6754022.0],
                                [389872.0, 6749698.0],
                                [393110.0, 6750366.0],
                                [402067.0, 6747685.0],
                                [404251.0, 6751414.0],
                                [412442.0, 6746090.0],
                                [419671.0, 6744167.0],
                                [429458.0, 6743442.0],
                                [440863.0, 6746201.0],
                                [446732.0, 6745443.0],
                                [446459.0, 6750432.0],
                                [442128.0, 6753611.0],
                                [448124.0, 6758669.0],
                                [447308.0, 6764356.0],
                                [455060.0, 6767070.0],
                                [451057.0, 6776681.0],
                                [459373.0, 6778102.0],
                                [460615.0, 6783387.0],
                                [458409.0, 6789055.0],
                                [466280.0, 6794064.0],
                                [465298.0, 6799724.0],
                                [467628.0, 6811401.0],
                                [473893.0, 6813452.0],
                                [474394.0, 6821359.0],
                                [467262.0, 6822174.0],
                                [466087.0, 6830999.0],
                                [463434.0, 6833996.0],
                                [457920.0, 6827997.0],
                                [451256.0, 6826715.0],
                                [446687.0, 6829012.0],
                                [441174.0, 6828584.0],
                                [437568.0, 6825109.0],
                                [429868.0, 6822252.0],
                                [422197.0, 6821752.0],
                                [414934.0, 6829326.0],
                                [407934.0, 6831360.0],
                                [404267.0, 6828490.0],
                                [399495.0, 6830885.0],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": 53, "NOM_DEPT": "MAYENNE"},
                },
                1: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (698137.0, 6861428.0, 790134.0, 6997000.0),
                        "coordinates": [
                            [
                                [776081.0, 6923412.0],
                                [775403.0, 6934852.0],
                                [777906.0, 6941851.0],
                                [774574.0, 6946610.0],
                                [779463.0, 6948255.0],
                                [781387.0, 6953785.0],
                                [790134.0, 6962730.0],
                                [787172.0, 6965431.0],
                                [789845.0, 6973793.0],
                                [788558.0, 6985051.0],
                                [781905.0, 6987282.0],
                                [778060.0, 6986162.0],
                                [770359.0, 6988977.0],
                                [766237.0, 6992385.0],
                                [753505.0, 6995276.0],
                                [751253.0, 6997000.0],
                                [744014.0, 6992056.0],
                                [739058.0, 6995179.0],
                                [735248.0, 6991264.0],
                                [725313.0, 6993104.0],
                                [720100.0, 6990781.0],
                                [716534.0, 6992565.0],
                                [712391.0, 6990404.0],
                                [713833.0, 6986563.0],
                                [708480.0, 6979518.0],
                                [705667.0, 6969289.0],
                                [708546.0, 6956332.0],
                                [707064.0, 6950845.0],
                                [709520.0, 6938240.0],
                                [706939.0, 6934901.0],
                                [711648.0, 6928031.0],
                                [706805.0, 6926038.0],
                                [706929.0, 6919738.0],
                                [698137.0, 6911415.0],
                                [701957.0, 6908433.0],
                                [704672.0, 6899225.0],
                                [710189.0, 6894765.0],
                                [705248.0, 6890863.0],
                                [712067.0, 6888882.0],
                                [712559.0, 6879371.0],
                                [722321.0, 6872132.0],
                                [724211.0, 6867685.0],
                                [729581.0, 6862815.0],
                                [735603.0, 6861428.0],
                                [738742.0, 6868146.0],
                                [744067.0, 6871735.0],
                                [747254.0, 6882494.0],
                                [743801.0, 6891376.0],
                                [745398.0, 6894771.0],
                                [751361.0, 6898188.0],
                                [747051.0, 6913033.0],
                                [761575.0, 6918670.0],
                                [767112.0, 6923360.0],
                                [775242.0, 6918312.0],
                                [776081.0, 6923412.0],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": 2, "NOM_DEPT": "AISNE"},
                },
                2: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (598361.0, 6867928.0, 670084.0, 6904387.0),
                        "coordinates": [
                            [
                                [598361.0, 6887345.0],
                                [603102.0, 6887292.0],
                                [606678.0, 6883543.0],
                                [614076.0, 6886919.0],
                                [622312.0, 6880731.0],
                                [628641.0, 6878089.0],
                                [633062.0, 6879807.0],
                                [641836.0, 6872490.0],
                                [641404.0, 6867928.0],
                                [648071.0, 6872567.0],
                                [653619.0, 6875101.0],
                                [660416.0, 6872923.0],
                                [667303.0, 6878971.0],
                                [670084.0, 6886723.0],
                                [659205.0, 6894147.0],
                                [652314.0, 6895981.0],
                                [649761.0, 6898738.0],
                                [645465.0, 6895048.0],
                                [633020.0, 6901508.0],
                                [626847.0, 6897876.0],
                                [618689.0, 6896449.0],
                                [612180.0, 6899061.0],
                                [608283.0, 6898554.0],
                                [605624.0, 6904387.0],
                                [603501.0, 6902160.0],
                                [601892.0, 6893098.0],
                                [598361.0, 6887345.0],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": 95, "NOM_DEPT": "VAL-D'OISE"},
                },
                3: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (202166.0, 6704696.0, 322365.0, 6807535.0),
                        "coordinates": [
                            [
                                [
                                    [229520.0, 6710085.0],
                                    [240383.0, 6704696.0],
                                    [240163.0, 6708285.0],
                                    [235835.0, 6713741.0],
                                    [229006.0, 6716339.0],
                                    [229520.0, 6710085.0],
                                ]
                            ],
                            [
                                [
                                    [212687.0, 6770001.0],
                                    [211559.0, 6762660.0],
                                    [216528.0, 6752538.0],
                                    [224759.0, 6753321.0],
                                    [234540.0, 6747533.0],
                                    [234220.0, 6745025.0],
                                    [240082.0, 6736634.0],
                                    [251238.0, 6736509.0],
                                    [260889.0, 6740570.0],
                                    [266327.0, 6740184.0],
                                    [271833.0, 6736526.0],
                                    [269308.0, 6731426.0],
                                    [263161.0, 6733044.0],
                                    [258643.0, 6731063.0],
                                    [263631.0, 6725691.0],
                                    [274085.0, 6728424.0],
                                    [283689.0, 6728526.0],
                                    [290663.0, 6724762.0],
                                    [288997.0, 6719519.0],
                                    [300067.0, 6720583.0],
                                    [315995.0, 6726944.0],
                                    [317487.0, 6738014.0],
                                    [315562.0, 6748257.0],
                                    [318803.0, 6749864.0],
                                    [322365.0, 6758359.0],
                                    [317839.0, 6765781.0],
                                    [320890.0, 6769878.0],
                                    [317014.0, 6776765.0],
                                    [309516.0, 6779524.0],
                                    [306739.0, 6782705.0],
                                    [310549.0, 6787938.0],
                                    [306966.0, 6794650.0],
                                    [300637.0, 6793781.0],
                                    [298204.0, 6799128.0],
                                    [291749.0, 6798375.0],
                                    [285132.0, 6789099.0],
                                    [280665.0, 6785525.0],
                                    [277875.0, 6787107.0],
                                    [279762.0, 6794931.0],
                                    [270150.0, 6795768.0],
                                    [252150.0, 6805897.0],
                                    [246074.0, 6807146.0],
                                    [242780.0, 6802066.0],
                                    [233945.0, 6800703.0],
                                    [229439.0, 6804532.0],
                                    [212675.0, 6807535.0],
                                    [202658.0, 6804638.0],
                                    [202166.0, 6798131.0],
                                    [205220.0, 6785800.0],
                                    [211608.0, 6786141.0],
                                    [216607.0, 6782805.0],
                                    [223352.0, 6780867.0],
                                    [221788.0, 6771592.0],
                                    [212687.0, 6770001.0],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": 56, "NOM_DEPT": "MORBIHAN"},
                },
            },
        },
    },
    11: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": ["NOM_DEPT", "CODE_DEPT"],
        "force_field_conversion": True,
        "bbox_extent": True,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "data_and_geometries",
                "fields": {
                    "CODE_DEPT": {"type": "Integer", "index": 1},
                    "NOM_DEPT": {"type": "String", "width": 10, "index": 0},
                },
                "geometry_ref": {
                    "type": {"Polygon", "MultiPolygon"},
                    "extent": (202166.0, 6704696.0, 790134.0, 6997000.0),
                },
            },
            "features": {
                0: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (382932.0, 6743442.0, 474394.0, 6833996.0),
                        "coordinates": [
                            [
                                [399495.0, 6830885.0],
                                [398130.0, 6822559.0],
                                [400321.0, 6810723.0],
                                [395852.0, 6803336.0],
                                [398626.0, 6784333.0],
                                [400465.0, 6781914.0],
                                [400197.0, 6773697.0],
                                [394099.0, 6773357.0],
                                [390140.0, 6770978.0],
                                [386941.0, 6760260.0],
                                [382932.0, 6754022.0],
                                [389872.0, 6749698.0],
                                [393110.0, 6750366.0],
                                [402067.0, 6747685.0],
                                [404251.0, 6751414.0],
                                [412442.0, 6746090.0],
                                [419671.0, 6744167.0],
                                [429458.0, 6743442.0],
                                [440863.0, 6746201.0],
                                [446732.0, 6745443.0],
                                [446459.0, 6750432.0],
                                [442128.0, 6753611.0],
                                [448124.0, 6758669.0],
                                [447308.0, 6764356.0],
                                [455060.0, 6767070.0],
                                [451057.0, 6776681.0],
                                [459373.0, 6778102.0],
                                [460615.0, 6783387.0],
                                [458409.0, 6789055.0],
                                [466280.0, 6794064.0],
                                [465298.0, 6799724.0],
                                [467628.0, 6811401.0],
                                [473893.0, 6813452.0],
                                [474394.0, 6821359.0],
                                [467262.0, 6822174.0],
                                [466087.0, 6830999.0],
                                [463434.0, 6833996.0],
                                [457920.0, 6827997.0],
                                [451256.0, 6826715.0],
                                [446687.0, 6829012.0],
                                [441174.0, 6828584.0],
                                [437568.0, 6825109.0],
                                [429868.0, 6822252.0],
                                [422197.0, 6821752.0],
                                [414934.0, 6829326.0],
                                [407934.0, 6831360.0],
                                [404267.0, 6828490.0],
                                [399495.0, 6830885.0],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": 53, "NOM_DEPT": "MAYENNE"},
                },
                1: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (698137.0, 6861428.0, 790134.0, 6997000.0),
                        "coordinates": [
                            [
                                [776081.0, 6923412.0],
                                [775403.0, 6934852.0],
                                [777906.0, 6941851.0],
                                [774574.0, 6946610.0],
                                [779463.0, 6948255.0],
                                [781387.0, 6953785.0],
                                [790134.0, 6962730.0],
                                [787172.0, 6965431.0],
                                [789845.0, 6973793.0],
                                [788558.0, 6985051.0],
                                [781905.0, 6987282.0],
                                [778060.0, 6986162.0],
                                [770359.0, 6988977.0],
                                [766237.0, 6992385.0],
                                [753505.0, 6995276.0],
                                [751253.0, 6997000.0],
                                [744014.0, 6992056.0],
                                [739058.0, 6995179.0],
                                [735248.0, 6991264.0],
                                [725313.0, 6993104.0],
                                [720100.0, 6990781.0],
                                [716534.0, 6992565.0],
                                [712391.0, 6990404.0],
                                [713833.0, 6986563.0],
                                [708480.0, 6979518.0],
                                [705667.0, 6969289.0],
                                [708546.0, 6956332.0],
                                [707064.0, 6950845.0],
                                [709520.0, 6938240.0],
                                [706939.0, 6934901.0],
                                [711648.0, 6928031.0],
                                [706805.0, 6926038.0],
                                [706929.0, 6919738.0],
                                [698137.0, 6911415.0],
                                [701957.0, 6908433.0],
                                [704672.0, 6899225.0],
                                [710189.0, 6894765.0],
                                [705248.0, 6890863.0],
                                [712067.0, 6888882.0],
                                [712559.0, 6879371.0],
                                [722321.0, 6872132.0],
                                [724211.0, 6867685.0],
                                [729581.0, 6862815.0],
                                [735603.0, 6861428.0],
                                [738742.0, 6868146.0],
                                [744067.0, 6871735.0],
                                [747254.0, 6882494.0],
                                [743801.0, 6891376.0],
                                [745398.0, 6894771.0],
                                [751361.0, 6898188.0],
                                [747051.0, 6913033.0],
                                [761575.0, 6918670.0],
                                [767112.0, 6923360.0],
                                [775242.0, 6918312.0],
                                [776081.0, 6923412.0],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": 2, "NOM_DEPT": "AISNE"},
                },
                2: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (598361.0, 6867928.0, 670084.0, 6904387.0),
                        "coordinates": [
                            [
                                [598361.0, 6887345.0],
                                [603102.0, 6887292.0],
                                [606678.0, 6883543.0],
                                [614076.0, 6886919.0],
                                [622312.0, 6880731.0],
                                [628641.0, 6878089.0],
                                [633062.0, 6879807.0],
                                [641836.0, 6872490.0],
                                [641404.0, 6867928.0],
                                [648071.0, 6872567.0],
                                [653619.0, 6875101.0],
                                [660416.0, 6872923.0],
                                [667303.0, 6878971.0],
                                [670084.0, 6886723.0],
                                [659205.0, 6894147.0],
                                [652314.0, 6895981.0],
                                [649761.0, 6898738.0],
                                [645465.0, 6895048.0],
                                [633020.0, 6901508.0],
                                [626847.0, 6897876.0],
                                [618689.0, 6896449.0],
                                [612180.0, 6899061.0],
                                [608283.0, 6898554.0],
                                [605624.0, 6904387.0],
                                [603501.0, 6902160.0],
                                [601892.0, 6893098.0],
                                [598361.0, 6887345.0],
                            ]
                        ],
                    },
                    "attributes": {"CODE_DEPT": 95, "NOM_DEPT": "VAL-D'OISE"},
                },
                3: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (202166.0, 6704696.0, 322365.0, 6807535.0),
                        "coordinates": [
                            [
                                [
                                    [229520.0, 6710085.0],
                                    [240383.0, 6704696.0],
                                    [240163.0, 6708285.0],
                                    [235835.0, 6713741.0],
                                    [229006.0, 6716339.0],
                                    [229520.0, 6710085.0],
                                ]
                            ],
                            [
                                [
                                    [212687.0, 6770001.0],
                                    [211559.0, 6762660.0],
                                    [216528.0, 6752538.0],
                                    [224759.0, 6753321.0],
                                    [234540.0, 6747533.0],
                                    [234220.0, 6745025.0],
                                    [240082.0, 6736634.0],
                                    [251238.0, 6736509.0],
                                    [260889.0, 6740570.0],
                                    [266327.0, 6740184.0],
                                    [271833.0, 6736526.0],
                                    [269308.0, 6731426.0],
                                    [263161.0, 6733044.0],
                                    [258643.0, 6731063.0],
                                    [263631.0, 6725691.0],
                                    [274085.0, 6728424.0],
                                    [283689.0, 6728526.0],
                                    [290663.0, 6724762.0],
                                    [288997.0, 6719519.0],
                                    [300067.0, 6720583.0],
                                    [315995.0, 6726944.0],
                                    [317487.0, 6738014.0],
                                    [315562.0, 6748257.0],
                                    [318803.0, 6749864.0],
                                    [322365.0, 6758359.0],
                                    [317839.0, 6765781.0],
                                    [320890.0, 6769878.0],
                                    [317014.0, 6776765.0],
                                    [309516.0, 6779524.0],
                                    [306739.0, 6782705.0],
                                    [310549.0, 6787938.0],
                                    [306966.0, 6794650.0],
                                    [300637.0, 6793781.0],
                                    [298204.0, 6799128.0],
                                    [291749.0, 6798375.0],
                                    [285132.0, 6789099.0],
                                    [280665.0, 6785525.0],
                                    [277875.0, 6787107.0],
                                    [279762.0, 6794931.0],
                                    [270150.0, 6795768.0],
                                    [252150.0, 6805897.0],
                                    [246074.0, 6807146.0],
                                    [242780.0, 6802066.0],
                                    [233945.0, 6800703.0],
                                    [229439.0, 6804532.0],
                                    [212675.0, 6807535.0],
                                    [202658.0, 6804638.0],
                                    [202166.0, 6798131.0],
                                    [205220.0, 6785800.0],
                                    [211608.0, 6786141.0],
                                    [216607.0, 6782805.0],
                                    [223352.0, 6780867.0],
                                    [221788.0, 6771592.0],
                                    [212687.0, 6770001.0],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"CODE_DEPT": 56, "NOM_DEPT": "MORBIHAN"},
                },
            },
        },
    },
    12: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": ["NOM_DEPT"],
        "force_field_conversion": True,
        "bbox_extent": True,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "data_and_geometries",
                "fields": {"NOM_DEPT": {"type": "String", "width": 10, "index": 0}},
                "geometry_ref": {
                    "type": {"Polygon", "MultiPolygon"},
                    "extent": (202166.0, 6704696.0, 790134.0, 6997000.0),
                },
            },
            "features": {
                0: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (382932.0, 6743442.0, 474394.0, 6833996.0),
                        "coordinates": [
                            [
                                [399495.0, 6830885.0],
                                [398130.0, 6822559.0],
                                [400321.0, 6810723.0],
                                [395852.0, 6803336.0],
                                [398626.0, 6784333.0],
                                [400465.0, 6781914.0],
                                [400197.0, 6773697.0],
                                [394099.0, 6773357.0],
                                [390140.0, 6770978.0],
                                [386941.0, 6760260.0],
                                [382932.0, 6754022.0],
                                [389872.0, 6749698.0],
                                [393110.0, 6750366.0],
                                [402067.0, 6747685.0],
                                [404251.0, 6751414.0],
                                [412442.0, 6746090.0],
                                [419671.0, 6744167.0],
                                [429458.0, 6743442.0],
                                [440863.0, 6746201.0],
                                [446732.0, 6745443.0],
                                [446459.0, 6750432.0],
                                [442128.0, 6753611.0],
                                [448124.0, 6758669.0],
                                [447308.0, 6764356.0],
                                [455060.0, 6767070.0],
                                [451057.0, 6776681.0],
                                [459373.0, 6778102.0],
                                [460615.0, 6783387.0],
                                [458409.0, 6789055.0],
                                [466280.0, 6794064.0],
                                [465298.0, 6799724.0],
                                [467628.0, 6811401.0],
                                [473893.0, 6813452.0],
                                [474394.0, 6821359.0],
                                [467262.0, 6822174.0],
                                [466087.0, 6830999.0],
                                [463434.0, 6833996.0],
                                [457920.0, 6827997.0],
                                [451256.0, 6826715.0],
                                [446687.0, 6829012.0],
                                [441174.0, 6828584.0],
                                [437568.0, 6825109.0],
                                [429868.0, 6822252.0],
                                [422197.0, 6821752.0],
                                [414934.0, 6829326.0],
                                [407934.0, 6831360.0],
                                [404267.0, 6828490.0],
                                [399495.0, 6830885.0],
                            ]
                        ],
                    },
                    "attributes": {"NOM_DEPT": "MAYENNE"},
                },
                1: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (698137.0, 6861428.0, 790134.0, 6997000.0),
                        "coordinates": [
                            [
                                [776081.0, 6923412.0],
                                [775403.0, 6934852.0],
                                [777906.0, 6941851.0],
                                [774574.0, 6946610.0],
                                [779463.0, 6948255.0],
                                [781387.0, 6953785.0],
                                [790134.0, 6962730.0],
                                [787172.0, 6965431.0],
                                [789845.0, 6973793.0],
                                [788558.0, 6985051.0],
                                [781905.0, 6987282.0],
                                [778060.0, 6986162.0],
                                [770359.0, 6988977.0],
                                [766237.0, 6992385.0],
                                [753505.0, 6995276.0],
                                [751253.0, 6997000.0],
                                [744014.0, 6992056.0],
                                [739058.0, 6995179.0],
                                [735248.0, 6991264.0],
                                [725313.0, 6993104.0],
                                [720100.0, 6990781.0],
                                [716534.0, 6992565.0],
                                [712391.0, 6990404.0],
                                [713833.0, 6986563.0],
                                [708480.0, 6979518.0],
                                [705667.0, 6969289.0],
                                [708546.0, 6956332.0],
                                [707064.0, 6950845.0],
                                [709520.0, 6938240.0],
                                [706939.0, 6934901.0],
                                [711648.0, 6928031.0],
                                [706805.0, 6926038.0],
                                [706929.0, 6919738.0],
                                [698137.0, 6911415.0],
                                [701957.0, 6908433.0],
                                [704672.0, 6899225.0],
                                [710189.0, 6894765.0],
                                [705248.0, 6890863.0],
                                [712067.0, 6888882.0],
                                [712559.0, 6879371.0],
                                [722321.0, 6872132.0],
                                [724211.0, 6867685.0],
                                [729581.0, 6862815.0],
                                [735603.0, 6861428.0],
                                [738742.0, 6868146.0],
                                [744067.0, 6871735.0],
                                [747254.0, 6882494.0],
                                [743801.0, 6891376.0],
                                [745398.0, 6894771.0],
                                [751361.0, 6898188.0],
                                [747051.0, 6913033.0],
                                [761575.0, 6918670.0],
                                [767112.0, 6923360.0],
                                [775242.0, 6918312.0],
                                [776081.0, 6923412.0],
                            ]
                        ],
                    },
                    "attributes": {"NOM_DEPT": "AISNE"},
                },
                2: {
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (598361.0, 6867928.0, 670084.0, 6904387.0),
                        "coordinates": [
                            [
                                [598361.0, 6887345.0],
                                [603102.0, 6887292.0],
                                [606678.0, 6883543.0],
                                [614076.0, 6886919.0],
                                [622312.0, 6880731.0],
                                [628641.0, 6878089.0],
                                [633062.0, 6879807.0],
                                [641836.0, 6872490.0],
                                [641404.0, 6867928.0],
                                [648071.0, 6872567.0],
                                [653619.0, 6875101.0],
                                [660416.0, 6872923.0],
                                [667303.0, 6878971.0],
                                [670084.0, 6886723.0],
                                [659205.0, 6894147.0],
                                [652314.0, 6895981.0],
                                [649761.0, 6898738.0],
                                [645465.0, 6895048.0],
                                [633020.0, 6901508.0],
                                [626847.0, 6897876.0],
                                [618689.0, 6896449.0],
                                [612180.0, 6899061.0],
                                [608283.0, 6898554.0],
                                [605624.0, 6904387.0],
                                [603501.0, 6902160.0],
                                [601892.0, 6893098.0],
                                [598361.0, 6887345.0],
                            ]
                        ],
                    },
                    "attributes": {"NOM_DEPT": "VAL-D'OISE"},
                },
                3: {
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (202166.0, 6704696.0, 322365.0, 6807535.0),
                        "coordinates": [
                            [
                                [
                                    [229520.0, 6710085.0],
                                    [240383.0, 6704696.0],
                                    [240163.0, 6708285.0],
                                    [235835.0, 6713741.0],
                                    [229006.0, 6716339.0],
                                    [229520.0, 6710085.0],
                                ]
                            ],
                            [
                                [
                                    [212687.0, 6770001.0],
                                    [211559.0, 6762660.0],
                                    [216528.0, 6752538.0],
                                    [224759.0, 6753321.0],
                                    [234540.0, 6747533.0],
                                    [234220.0, 6745025.0],
                                    [240082.0, 6736634.0],
                                    [251238.0, 6736509.0],
                                    [260889.0, 6740570.0],
                                    [266327.0, 6740184.0],
                                    [271833.0, 6736526.0],
                                    [269308.0, 6731426.0],
                                    [263161.0, 6733044.0],
                                    [258643.0, 6731063.0],
                                    [263631.0, 6725691.0],
                                    [274085.0, 6728424.0],
                                    [283689.0, 6728526.0],
                                    [290663.0, 6724762.0],
                                    [288997.0, 6719519.0],
                                    [300067.0, 6720583.0],
                                    [315995.0, 6726944.0],
                                    [317487.0, 6738014.0],
                                    [315562.0, 6748257.0],
                                    [318803.0, 6749864.0],
                                    [322365.0, 6758359.0],
                                    [317839.0, 6765781.0],
                                    [320890.0, 6769878.0],
                                    [317014.0, 6776765.0],
                                    [309516.0, 6779524.0],
                                    [306739.0, 6782705.0],
                                    [310549.0, 6787938.0],
                                    [306966.0, 6794650.0],
                                    [300637.0, 6793781.0],
                                    [298204.0, 6799128.0],
                                    [291749.0, 6798375.0],
                                    [285132.0, 6789099.0],
                                    [280665.0, 6785525.0],
                                    [277875.0, 6787107.0],
                                    [279762.0, 6794931.0],
                                    [270150.0, 6795768.0],
                                    [252150.0, 6805897.0],
                                    [246074.0, 6807146.0],
                                    [242780.0, 6802066.0],
                                    [233945.0, 6800703.0],
                                    [229439.0, 6804532.0],
                                    [212675.0, 6807535.0],
                                    [202658.0, 6804638.0],
                                    [202166.0, 6798131.0],
                                    [205220.0, 6785800.0],
                                    [211608.0, 6786141.0],
                                    [216607.0, 6782805.0],
                                    [223352.0, 6780867.0],
                                    [221788.0, 6771592.0],
                                    [212687.0, 6770001.0],
                                ]
                            ],
                        ],
                    },
                    "attributes": {"NOM_DEPT": "MORBIHAN"},
                },
            },
        },
    },
    13: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": "NOM_DEPT",
        "force_field_conversion": True,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox_extent": True,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "data_and_geometries",
                "fields": {"NOM_DEPT": {"type": "String", "width": 10, "index": 0}},
                "geometry_ref": {
                    "type": {"Polygon", "MultiPolygon"},
                    "extent": (202166.0, 6704696.0, 790134.0, 6997000.0),
                },
            },
            "features": {
                0: {
                    "attributes": {"NOM_DEPT": "MAYENNE"},
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (382932.0, 6743442.0, 474394.0, 6833996.0),
                        "coordinates": [
                            [
                                [399495.0, 6830885.0],
                                [398130.0, 6822559.0],
                                [400321.0, 6810723.0],
                                [395852.0, 6803336.0],
                                [398626.0, 6784333.0],
                                [400465.0, 6781914.0],
                                [400197.0, 6773697.0],
                                [394099.0, 6773357.0],
                                [390140.0, 6770978.0],
                                [386941.0, 6760260.0],
                                [382932.0, 6754022.0],
                                [389872.0, 6749698.0],
                                [393110.0, 6750366.0],
                                [402067.0, 6747685.0],
                                [404251.0, 6751414.0],
                                [412442.0, 6746090.0],
                                [419671.0, 6744167.0],
                                [429458.0, 6743442.0],
                                [440863.0, 6746201.0],
                                [446732.0, 6745443.0],
                                [446459.0, 6750432.0],
                                [442128.0, 6753611.0],
                                [448124.0, 6758669.0],
                                [447308.0, 6764356.0],
                                [455060.0, 6767070.0],
                                [451057.0, 6776681.0],
                                [459373.0, 6778102.0],
                                [460615.0, 6783387.0],
                                [458409.0, 6789055.0],
                                [466280.0, 6794064.0],
                                [465298.0, 6799724.0],
                                [467628.0, 6811401.0],
                                [473893.0, 6813452.0],
                                [474394.0, 6821359.0],
                                [467262.0, 6822174.0],
                                [466087.0, 6830999.0],
                                [463434.0, 6833996.0],
                                [457920.0, 6827997.0],
                                [451256.0, 6826715.0],
                                [446687.0, 6829012.0],
                                [441174.0, 6828584.0],
                                [437568.0, 6825109.0],
                                [429868.0, 6822252.0],
                                [422197.0, 6821752.0],
                                [414934.0, 6829326.0],
                                [407934.0, 6831360.0],
                                [404267.0, 6828490.0],
                                [399495.0, 6830885.0],
                            ]
                        ],
                    },
                },
                1: {
                    "attributes": {"NOM_DEPT": "AISNE"},
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (698137.0, 6861428.0, 790134.0, 6997000.0),
                        "coordinates": [
                            [
                                [776081.0, 6923412.0],
                                [775403.0, 6934852.0],
                                [777906.0, 6941851.0],
                                [774574.0, 6946610.0],
                                [779463.0, 6948255.0],
                                [781387.0, 6953785.0],
                                [790134.0, 6962730.0],
                                [787172.0, 6965431.0],
                                [789845.0, 6973793.0],
                                [788558.0, 6985051.0],
                                [781905.0, 6987282.0],
                                [778060.0, 6986162.0],
                                [770359.0, 6988977.0],
                                [766237.0, 6992385.0],
                                [753505.0, 6995276.0],
                                [751253.0, 6997000.0],
                                [744014.0, 6992056.0],
                                [739058.0, 6995179.0],
                                [735248.0, 6991264.0],
                                [725313.0, 6993104.0],
                                [720100.0, 6990781.0],
                                [716534.0, 6992565.0],
                                [712391.0, 6990404.0],
                                [713833.0, 6986563.0],
                                [708480.0, 6979518.0],
                                [705667.0, 6969289.0],
                                [708546.0, 6956332.0],
                                [707064.0, 6950845.0],
                                [709520.0, 6938240.0],
                                [706939.0, 6934901.0],
                                [711648.0, 6928031.0],
                                [706805.0, 6926038.0],
                                [706929.0, 6919738.0],
                                [698137.0, 6911415.0],
                                [701957.0, 6908433.0],
                                [704672.0, 6899225.0],
                                [710189.0, 6894765.0],
                                [705248.0, 6890863.0],
                                [712067.0, 6888882.0],
                                [712559.0, 6879371.0],
                                [722321.0, 6872132.0],
                                [724211.0, 6867685.0],
                                [729581.0, 6862815.0],
                                [735603.0, 6861428.0],
                                [738742.0, 6868146.0],
                                [744067.0, 6871735.0],
                                [747254.0, 6882494.0],
                                [743801.0, 6891376.0],
                                [745398.0, 6894771.0],
                                [751361.0, 6898188.0],
                                [747051.0, 6913033.0],
                                [761575.0, 6918670.0],
                                [767112.0, 6923360.0],
                                [775242.0, 6918312.0],
                                [776081.0, 6923412.0],
                            ]
                        ],
                    },
                },
                2: {
                    "attributes": {"NOM_DEPT": "VAL-D'OISE"},
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (598361.0, 6867928.0, 670084.0, 6904387.0),
                        "coordinates": [
                            [
                                [598361.0, 6887345.0],
                                [603102.0, 6887292.0],
                                [606678.0, 6883543.0],
                                [614076.0, 6886919.0],
                                [622312.0, 6880731.0],
                                [628641.0, 6878089.0],
                                [633062.0, 6879807.0],
                                [641836.0, 6872490.0],
                                [641404.0, 6867928.0],
                                [648071.0, 6872567.0],
                                [653619.0, 6875101.0],
                                [660416.0, 6872923.0],
                                [667303.0, 6878971.0],
                                [670084.0, 6886723.0],
                                [659205.0, 6894147.0],
                                [652314.0, 6895981.0],
                                [649761.0, 6898738.0],
                                [645465.0, 6895048.0],
                                [633020.0, 6901508.0],
                                [626847.0, 6897876.0],
                                [618689.0, 6896449.0],
                                [612180.0, 6899061.0],
                                [608283.0, 6898554.0],
                                [605624.0, 6904387.0],
                                [603501.0, 6902160.0],
                                [601892.0, 6893098.0],
                                [598361.0, 6887345.0],
                            ]
                        ],
                    },
                },
                3: {
                    "attributes": {"NOM_DEPT": "MORBIHAN"},
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (202166.0, 6704696.0, 322365.0, 6807535.0),
                        "coordinates": [
                            [
                                [
                                    [229520.0, 6710085.0],
                                    [240383.0, 6704696.0],
                                    [240163.0, 6708285.0],
                                    [235835.0, 6713741.0],
                                    [229006.0, 6716339.0],
                                    [229520.0, 6710085.0],
                                ]
                            ],
                            [
                                [
                                    [212687.0, 6770001.0],
                                    [211559.0, 6762660.0],
                                    [216528.0, 6752538.0],
                                    [224759.0, 6753321.0],
                                    [234540.0, 6747533.0],
                                    [234220.0, 6745025.0],
                                    [240082.0, 6736634.0],
                                    [251238.0, 6736509.0],
                                    [260889.0, 6740570.0],
                                    [266327.0, 6740184.0],
                                    [271833.0, 6736526.0],
                                    [269308.0, 6731426.0],
                                    [263161.0, 6733044.0],
                                    [258643.0, 6731063.0],
                                    [263631.0, 6725691.0],
                                    [274085.0, 6728424.0],
                                    [283689.0, 6728526.0],
                                    [290663.0, 6724762.0],
                                    [288997.0, 6719519.0],
                                    [300067.0, 6720583.0],
                                    [315995.0, 6726944.0],
                                    [317487.0, 6738014.0],
                                    [315562.0, 6748257.0],
                                    [318803.0, 6749864.0],
                                    [322365.0, 6758359.0],
                                    [317839.0, 6765781.0],
                                    [320890.0, 6769878.0],
                                    [317014.0, 6776765.0],
                                    [309516.0, 6779524.0],
                                    [306739.0, 6782705.0],
                                    [310549.0, 6787938.0],
                                    [306966.0, 6794650.0],
                                    [300637.0, 6793781.0],
                                    [298204.0, 6799128.0],
                                    [291749.0, 6798375.0],
                                    [285132.0, 6789099.0],
                                    [280665.0, 6785525.0],
                                    [277875.0, 6787107.0],
                                    [279762.0, 6794931.0],
                                    [270150.0, 6795768.0],
                                    [252150.0, 6805897.0],
                                    [246074.0, 6807146.0],
                                    [242780.0, 6802066.0],
                                    [233945.0, 6800703.0],
                                    [229439.0, 6804532.0],
                                    [212675.0, 6807535.0],
                                    [202658.0, 6804638.0],
                                    [202166.0, 6798131.0],
                                    [205220.0, 6785800.0],
                                    [211608.0, 6786141.0],
                                    [216607.0, 6782805.0],
                                    [223352.0, 6780867.0],
                                    [221788.0, 6771592.0],
                                    [212687.0, 6770001.0],
                                ]
                            ],
                        ],
                    },
                },
            },
        },
    },
    14: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": "NOM_DEPT",
        "force_field_conversion": True,
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": None,
        "bbox_extent": True,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "data_and_geometries",
                "fields": {"NOM_DEPT": {"type": "String", "width": 10, "index": 0}},
                "geometry_ref": {
                    "type": {"MultiPolygon"},
                    "extent": (202166.0, 6704696.0, 322365.0, 6807535.0),
                },
            },
            "features": {
                0: {
                    "attributes": {"NOM_DEPT": "MORBIHAN"},
                    "geometry": {
                        "type": "MultiPolygon",
                        "bbox": (202166.0, 6704696.0, 322365.0, 6807535.0),
                        "coordinates": [
                            [
                                [
                                    [229520.0, 6710085.0],
                                    [240383.0, 6704696.0],
                                    [240163.0, 6708285.0],
                                    [235835.0, 6713741.0],
                                    [229006.0, 6716339.0],
                                    [229520.0, 6710085.0],
                                ]
                            ],
                            [
                                [
                                    [212687.0, 6770001.0],
                                    [211559.0, 6762660.0],
                                    [216528.0, 6752538.0],
                                    [224759.0, 6753321.0],
                                    [234540.0, 6747533.0],
                                    [234220.0, 6745025.0],
                                    [240082.0, 6736634.0],
                                    [251238.0, 6736509.0],
                                    [260889.0, 6740570.0],
                                    [266327.0, 6740184.0],
                                    [271833.0, 6736526.0],
                                    [269308.0, 6731426.0],
                                    [263161.0, 6733044.0],
                                    [258643.0, 6731063.0],
                                    [263631.0, 6725691.0],
                                    [274085.0, 6728424.0],
                                    [283689.0, 6728526.0],
                                    [290663.0, 6724762.0],
                                    [288997.0, 6719519.0],
                                    [300067.0, 6720583.0],
                                    [315995.0, 6726944.0],
                                    [317487.0, 6738014.0],
                                    [315562.0, 6748257.0],
                                    [318803.0, 6749864.0],
                                    [322365.0, 6758359.0],
                                    [317839.0, 6765781.0],
                                    [320890.0, 6769878.0],
                                    [317014.0, 6776765.0],
                                    [309516.0, 6779524.0],
                                    [306739.0, 6782705.0],
                                    [310549.0, 6787938.0],
                                    [306966.0, 6794650.0],
                                    [300637.0, 6793781.0],
                                    [298204.0, 6799128.0],
                                    [291749.0, 6798375.0],
                                    [285132.0, 6789099.0],
                                    [280665.0, 6785525.0],
                                    [277875.0, 6787107.0],
                                    [279762.0, 6794931.0],
                                    [270150.0, 6795768.0],
                                    [252150.0, 6805897.0],
                                    [246074.0, 6807146.0],
                                    [242780.0, 6802066.0],
                                    [233945.0, 6800703.0],
                                    [229439.0, 6804532.0],
                                    [212675.0, 6807535.0],
                                    [202658.0, 6804638.0],
                                    [202166.0, 6798131.0],
                                    [205220.0, 6785800.0],
                                    [211608.0, 6786141.0],
                                    [216607.0, 6782805.0],
                                    [223352.0, 6780867.0],
                                    [221788.0, 6771592.0],
                                    [212687.0, 6770001.0],
                                ]
                            ],
                        ],
                    },
                }
            },
        },
    },
    15: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": "NOM_DEPT",
        "force_field_conversion": True,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (599361, 6868928, 669084, 6903387),
        "bbox_extent": True,
        "crs": None,
        "return_value": {
            "metadata": {
                "name": "data_and_geometries",
                "fields": {"NOM_DEPT": {"type": "String", "width": 10, "index": 0}},
                "geometry_ref": {
                    "type": {"Polygon"},
                    "extent": (598361.0, 6867928.0, 670084.0, 6904387.0),
                },
            },
            "features": {
                0: {
                    "attributes": {"NOM_DEPT": "VAL-D'OISE"},
                    "geometry": {
                        "type": "Polygon",
                        "bbox": (598361.0, 6867928.0, 670084.0, 6904387.0),
                        "coordinates": [
                            [
                                [598361.0, 6887345.0],
                                [603102.0, 6887292.0],
                                [606678.0, 6883543.0],
                                [614076.0, 6886919.0],
                                [622312.0, 6880731.0],
                                [628641.0, 6878089.0],
                                [633062.0, 6879807.0],
                                [641836.0, 6872490.0],
                                [641404.0, 6867928.0],
                                [648071.0, 6872567.0],
                                [653619.0, 6875101.0],
                                [660416.0, 6872923.0],
                                [667303.0, 6878971.0],
                                [670084.0, 6886723.0],
                                [659205.0, 6894147.0],
                                [652314.0, 6895981.0],
                                [649761.0, 6898738.0],
                                [645465.0, 6895048.0],
                                [633020.0, 6901508.0],
                                [626847.0, 6897876.0],
                                [618689.0, 6896449.0],
                                [612180.0, 6899061.0],
                                [608283.0, 6898554.0],
                                [605624.0, 6904387.0],
                                [603501.0, 6902160.0],
                                [601892.0, 6893098.0],
                                [598361.0, 6887345.0],
                            ]
                        ],
                    },
                }
            },
        },
    },
    16: {
        "feature_list": feature_list_data_and_geometry,
        "geolayer_name": "data_and_geometries",
        "field_name_filter": None,
        "force_field_conversion": False,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox_extent": False,
        "crs": 2154,
        "serialize": True,
        "return_value": feature_list_data_and_geometry_serialized_geolayer,
    },
    17: {
        "feature_list": feature_list_bytes_attributes,
        "geolayer_name": "bytes_values",
        "field_name_filter": None,
        "force_field_conversion": False,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox_extent": False,
        "crs": None,
        "serialize": False,
        "return_value": geolayer_fields_with_bytes_values,
    },
    18: {
        "feature_list": feature_list_bytes_attributes,
        "geolayer_name": "bytes_values",
        "field_name_filter": None,
        "force_field_conversion": True,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox_extent": False,
        "crs": None,
        "serialize": False,
        "return_value": geolayer_fields_with_bytes_values_forced,
    },
}

feature_filter_geometry_parameters = {
    0: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    1: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": "Point",
        "bbox_filter": None,
        "return_value": {},
    },
    2: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": None,
        "return_value": {},
    },
    3: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": "Polygon",
        "bbox_filter": None,
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    4: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": {"MultiPolygon", "Polygon"},
        "bbox_filter": None,
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    5: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": None,
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    6: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": None,
        "bbox_filter": (-10, -10, 10, 10),
        "return_value": {},
    },
    7: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": None,
        "bbox_filter": {(-10, -10, 10, 10), (381932, 6742442, 473394, 6832996)},
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    8: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": "Point",
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": {},
    },
    9: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": {},
    },
    10: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    11: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (-10, -10, 10, 10),
        "return_value": {},
    },
    12: {
        "feature": feature_dpt_geometry_only_a,
        "geometry_type_filter": {"MultiPolygon", "Polygon"},
        "bbox_filter": {(-10, -10, 10, 10), (381932, 6742442, 473394, 6832996)},
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    13: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    14: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": "Point",
        "bbox_filter": None,
        "return_value": {},
    },
    15: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": None,
        "return_value": {},
    },
    16: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": "Polygon",
        "bbox_filter": None,
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    17: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": {"MultiPolygon", "Polygon"},
        "bbox_filter": None,
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    18: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": None,
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    19: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": None,
        "bbox_filter": (-10, -10, 10, 10),
        "return_value": {},
    },
    20: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": None,
        "bbox_filter": {(-10, -10, 10, 10), (381932, 6742442, 473394, 6832996)},
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    21: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": "Point",
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": {},
    },
    22: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": {},
    },
    23: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (381932, 6742442, 473394, 6832996),
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    24: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (-10, -10, 10, 10),
        "return_value": {},
    },
    25: {
        "feature": feature_dpt_data_and_geometry_a,
        "geometry_type_filter": {"MultiPolygon", "Polygon"},
        "bbox_filter": {(-10, -10, 10, 10), (381932, 6742442, 473394, 6832996)},
        "return_value": feature_dpt_geometry_only_a["geometry"],
    },
    26: {
        "feature": feature_geometry_only_collection,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": False,
        "return_value": feature_geometry_only_collection["geometry"],
    },
    27: {
        "feature": feature_geometry_only_collection,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": True,
        "return_value": {
            "type": "GeometryCollection",
            "geometries": [
                {
                    "type": "Point",
                    "coordinates": [-115.81, 37.24],
                    "bbox": (-115.81, 37.24, -115.81, 37.24),
                },
                {
                    "type": "LineString",
                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    "bbox": (8.919, 44.4074, 8.923, 44.4075),
                },
                {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                    "bbox": (-120.43, -20.28, 23.194, 57.322),
                },
                {
                    "type": "MultiPoint",
                    "coordinates": [
                        [-155.52, 19.61],
                        [-156.22, 20.74],
                        [-157.97, 21.46],
                    ],
                    "bbox": (-157.97, 19.61, -155.52, 21.46),
                },
                {
                    "type": "MultiLineString",
                    "coordinates": [
                        [[3.75, 9.25], [-130.95, 1.52]],
                        [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                    ],
                    "bbox": (-130.95, -34.25, 23.15, 77.95),
                },
                {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [3.78, 9.28],
                                [-130.91, 1.52],
                                [35.12, 72.234],
                                [3.78, 9.28],
                            ]
                        ],
                        [
                            [
                                [23.18, -34.29],
                                [-1.31, -4.61],
                                [3.41, 77.91],
                                [23.18, -34.29],
                            ]
                        ],
                    ],
                    "bbox": (-130.91, -34.29, 35.12, 77.91),
                },
            ],
            "bbox": (-157.97, -34.29, 35.12, 77.95),
        },
    },
    28: {
        "feature": feature_geometry_only_collection_with_empty_geometries,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": True,
        "return_value": {
            "type": "GeometryCollection",
            "geometries": [
                {"type": "Point", "coordinates": []},
                {
                    "type": "LineString",
                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    "bbox": (8.919, 44.4074, 8.923, 44.4075),
                },
                {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                    "bbox": (-120.43, -20.28, 23.194, 57.322),
                },
                {"type": "MultiPoint", "coordinates": []},
                {
                    "type": "MultiLineString",
                    "coordinates": [
                        [[3.75, 9.25], [-130.95, 1.52]],
                        [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                    ],
                    "bbox": (-130.95, -34.25, 23.15, 77.95),
                },
                {"type": "MultiPolygon", "coordinates": []},
            ],
            "bbox": (-130.95, -34.25, 23.194, 77.95),
        },
    },
    29: {
        "feature": feature_geometry_only_collection_with_empty_geometries,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": False,
        "return_value": {
            "type": "GeometryCollection",
            "geometries": [
                {"type": "Point", "coordinates": []},
                {
                    "type": "LineString",
                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                },
                {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                },
                {"type": "MultiPoint", "coordinates": []},
                {
                    "type": "MultiLineString",
                    "coordinates": [
                        [[3.75, 9.25], [-130.95, 1.52]],
                        [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                    ],
                },
                {"type": "MultiPolygon", "coordinates": []},
            ],
        },
    },
    30: {
        "feature": feature_geometry_only_collection,
        "geometry_type_filter": "Point",
        "bbox_filter": None,
        "bbox": False,
        "return_value": {"type": "Point", "coordinates": [-115.81, 37.24]},
    },
    31: {
        "feature": feature_geometry_only_collection_with_empty_geometries,
        "geometry_type_filter": {"Point", "LineString"},
        "bbox_filter": None,
        "bbox": False,
        "return_value": {
            "type": "GeometryCollection",
            "geometries": [
                {"type": "Point", "coordinates": []},
                {
                    "type": "LineString",
                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                },
            ],
        },
    },
    32: {
        "feature": feature_geometry_only_point_empty,
        "geometry_type_filter": "Point",
        "bbox_filter": (-115.81, 37.24, -115.81, 37.24),
        "bbox": False,
        "return_value": {},
    },
    33: {
        "feature": feature_geometry_only_point,
        "geometry_type_filter": "Point",
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "bbox": False,
        "return_value": {"type": "Point", "coordinates": [-115.81, 37.24]},
    },
    34: {
        "feature": feature_geometry_only_polygon,
        "geometry_type_filter": None,
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "bbox": False,
        "return_value": {
            "type": "Polygon",
            "coordinates": [
                [[2.38, 57.322], [23.194, -20.28], [-120.43, 19.15], [2.38, 57.322]],
                [[-5.21, 23.51], [15.21, -10.81], [-20.51, 1.51], [-5.21, 23.51]],
            ],
        },
    },
    35: {
        "feature": feature_geometry_only_collection,
        "geometry_type_filter": None,
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "bbox": False,
        "return_value": {
            "type": "GeometryCollection",
            "geometries": [
                {"type": "Point", "coordinates": [-115.81, 37.24]},
                {
                    "type": "LineString",
                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                },
                {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                },
                {
                    "type": "MultiPoint",
                    "coordinates": [
                        [-155.52, 19.61],
                        [-156.22, 20.74],
                        [-157.97, 21.46],
                    ],
                },
                {
                    "type": "MultiLineString",
                    "coordinates": [
                        [[3.75, 9.25], [-130.95, 1.52]],
                        [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                    ],
                },
                {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [3.78, 9.28],
                                [-130.91, 1.52],
                                [35.12, 72.234],
                                [3.78, 9.28],
                            ]
                        ],
                        [
                            [
                                [23.18, -34.29],
                                [-1.31, -4.61],
                                [3.41, 77.91],
                                [23.18, -34.29],
                            ]
                        ],
                    ],
                },
            ],
        },
    },
}

feature_filter_attributes_parameters = {
    0: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": None,
        "return_value": {"CODE_DEPT": "53", "NOM_DEPT": "MAYENNE"},
    },
    1: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": "CODE_DEPT",
        "return_value": {"CODE_DEPT": "53"},
    },
    2: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ["CODE_DEPT"],
        "return_value": {"CODE_DEPT": "53"},
    },
    3: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ["foo"],
        "return_value": {},
    },
    4: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ["foo", "NOM_DEPT"],
        "return_value": {"NOM_DEPT": "MAYENNE"},
    },
    5: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": None,
        "return_value": {"CODE_DEPT": "53", "NOM_DEPT": "MAYENNE"},
    },
    6: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": "CODE_DEPT",
        "return_value": {"CODE_DEPT": "53"},
    },
    7: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["CODE_DEPT"],
        "return_value": {"CODE_DEPT": "53"},
    },
    8: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo"],
        "return_value": {},
    },
    9: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "NOM_DEPT"],
        "return_value": {"NOM_DEPT": "MAYENNE"},
    },
    10: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": ["foo", "NOM_DEPT"],
        "return_value": {},
    },
}

feature_filter_parameters = {
    0: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ["CODE_DEPT", "NOM_DEPT"],
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": True,
        "return_value": feature_dpt_data_only_a,
    },
    1: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ("NOM_DEPT",),
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": True,
        "return_value": {"attributes": {"NOM_DEPT": "MAYENNE"}},
    },
    2: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": None,
        "geometry_type_filter": "Polygon",
        "bbox_filter": None,
        "bbox": True,
        "return_value": None,
    },
    3: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": "foo",
        "geometry_type_filter": "Polygon",
        "bbox_filter": None,
        "bbox": True,
        "return_value": None,
    },
    4: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ("NOM_DEPT", "foo"),
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": True,
        "return_value": {"attributes": {"NOM_DEPT": "MAYENNE"}},
    },
    5: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    6: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ("NOM_DEPT",),
        "geometry_type_filter": "Polygon",
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    7: {
        "feature": feature_dpt_data_only_a,
        "field_name_filter": ("NOM_DEPT",),
        "geometry_type_filter": "Polygon",
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    8: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": None,
        "geometry_type_filter": "Polygon",
        "bbox_filter": None,
        "bbox": True,
        "return_value": feature_dpt_geometry_only_a,
    },
    9: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": None,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (382900, 6743400, 474400, 6834000),
        "bbox": True,
        "return_value": feature_dpt_geometry_only_a,
    },
    10: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": None,
        "geometry_type_filter": "Point",
        "bbox_filter": (382900, 6743400, 474400, 6834000),
        "bbox": True,
        "return_value": None,
    },
    11: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": None,
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": (382900, 6743400, 474400, 6834000),
        "bbox": True,
        "return_value": None,
    },
    12: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": None,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    13: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": None,
        "geometry_type_filter": "Polygon",
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    14: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": "foo",
        "geometry_type_filter": "Polygon",
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    15: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_filter": [(-10, -10, 10, 10), (382900, 6743400, 474400, 6834000)],
        "bbox": True,
        "return_value": feature_dpt_geometry_only_a,
    },
    16: {
        "feature": feature_dpt_geometry_only_a,
        "field_name_filter": "foo",
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": True,
        "return_value": feature_dpt_geometry_only_a,
    },
    17: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "bar"],
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": False,
        "return_value": {"geometry": feature_dpt_data_and_geometry_a["geometry"]},
    },
    18: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "bar", "NOM_DEPT"],
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": False,
        "return_value": {
            "attributes": {
                "NOM_DEPT": feature_dpt_data_and_geometry_a["attributes"]["NOM_DEPT"]
            },
            "geometry": feature_dpt_data_and_geometry_a["geometry"],
        },
    },
    19: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "bar", "NOM_DEPT"],
        "geometry_type_filter": "Polygon",
        "bbox_filter": None,
        "bbox": False,
        "return_value": {
            "attributes": {
                "NOM_DEPT": feature_dpt_data_and_geometry_a["attributes"]["NOM_DEPT"]
            },
            "geometry": feature_dpt_data_and_geometry_a["geometry"],
        },
    },
    20: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "bar", "NOM_DEPT"],
        "geometry_type_filter": "LineString",
        "bbox_filter": None,
        "bbox": True,
        "return_value": None,
    },
    21: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "bar", "NOM_DEPT"],
        "geometry_type_filter": None,
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    22: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "bar", "NOM_DEPT"],
        "geometry_type_filter": None,
        "bbox_filter": (-10, -10, 10, 10),
        "bbox": True,
        "return_value": None,
    },
    23: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": None,
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": None,
        "bbox": True,
        "return_value": None,
    },
    24: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": "foo",
        "geometry_type_filter": None,
        "bbox_filter": None,
        "bbox": False,
        "return_value": {"geometry": feature_dpt_data_and_geometry_a["geometry"]},
    },
    25: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": None,
        "geometry_type_filter": "Polygon",
        "bbox_filter": [(-10, -10, 10, 10), (382900, 6743400, 474400, 6834000)],
        "bbox": False,
        "return_value": feature_dpt_data_and_geometry_a,
    },
    26: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": "foo",
        "geometry_type_filter": "Polygon",
        "bbox_filter": [(-10, -10, 10, 10), (382900, 6743400, 474400, 6834000)],
        "bbox": False,
        "return_value": {"geometry": feature_dpt_data_and_geometry_a["geometry"]},
    },
    27: {
        "feature": feature_dpt_data_and_geometry_a,
        "field_name_filter": ["foo", "NOM_DEPT"],
        "geometry_type_filter": "Polygon",
        "bbox_filter": [(-10, -10, 10, 10), (382900, 6743400, 474400, 6834000)],
        "bbox": False,
        "return_value": {
            "attributes": {
                "NOM_DEPT": feature_dpt_data_and_geometry_a["attributes"]["NOM_DEPT"]
            },
            "geometry": feature_dpt_data_and_geometry_a["geometry"],
        },
    },
}

features_filter_parameters = {
    0: {
        "geolayer_feature_list_or_generator": feature_list_data_and_geometry,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "serialize": None,
        "bbox_extent": False,
        "feature_limit": None,
        "feature_offset": None,
        "return_value": tuple(feature_list_data_and_geometry),
    },
    1: {
        "geolayer_feature_list_or_generator": feature_list_data_and_geometry,
        "field_name_filter": ["CODE_DEPT"],
        "geometry_type_filter": None,
        "bbox_filter": None,
        "serialize": None,
        "bbox_extent": False,
        "feature_limit": None,
        "feature_offset": None,
        "return_value": (
            {
                "attributes": {"CODE_DEPT": "53"},
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [399495.0, 6830885.0],
                            [398130.0, 6822559.0],
                            [400321.0, 6810723.0],
                            [395852.0, 6803336.0],
                            [398626.0, 6784333.0],
                            [400465.0, 6781914.0],
                            [400197.0, 6773697.0],
                            [394099.0, 6773357.0],
                            [390140.0, 6770978.0],
                            [386941.0, 6760260.0],
                            [382932.0, 6754022.0],
                            [389872.0, 6749698.0],
                            [393110.0, 6750366.0],
                            [402067.0, 6747685.0],
                            [404251.0, 6751414.0],
                            [412442.0, 6746090.0],
                            [419671.0, 6744167.0],
                            [429458.0, 6743442.0],
                            [440863.0, 6746201.0],
                            [446732.0, 6745443.0],
                            [446459.0, 6750432.0],
                            [442128.0, 6753611.0],
                            [448124.0, 6758669.0],
                            [447308.0, 6764356.0],
                            [455060.0, 6767070.0],
                            [451057.0, 6776681.0],
                            [459373.0, 6778102.0],
                            [460615.0, 6783387.0],
                            [458409.0, 6789055.0],
                            [466280.0, 6794064.0],
                            [465298.0, 6799724.0],
                            [467628.0, 6811401.0],
                            [473893.0, 6813452.0],
                            [474394.0, 6821359.0],
                            [467262.0, 6822174.0],
                            [466087.0, 6830999.0],
                            [463434.0, 6833996.0],
                            [457920.0, 6827997.0],
                            [451256.0, 6826715.0],
                            [446687.0, 6829012.0],
                            [441174.0, 6828584.0],
                            [437568.0, 6825109.0],
                            [429868.0, 6822252.0],
                            [422197.0, 6821752.0],
                            [414934.0, 6829326.0],
                            [407934.0, 6831360.0],
                            [404267.0, 6828490.0],
                            [399495.0, 6830885.0],
                        ]
                    ],
                },
            },
            {
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [776081.0, 6923412.0],
                            [775403.0, 6934852.0],
                            [777906.0, 6941851.0],
                            [774574.0, 6946610.0],
                            [779463.0, 6948255.0],
                            [781387.0, 6953785.0],
                            [790134.0, 6962730.0],
                            [787172.0, 6965431.0],
                            [789845.0, 6973793.0],
                            [788558.0, 6985051.0],
                            [781905.0, 6987282.0],
                            [778060.0, 6986162.0],
                            [770359.0, 6988977.0],
                            [766237.0, 6992385.0],
                            [753505.0, 6995276.0],
                            [751253.0, 6997000.0],
                            [744014.0, 6992056.0],
                            [739058.0, 6995179.0],
                            [735248.0, 6991264.0],
                            [725313.0, 6993104.0],
                            [720100.0, 6990781.0],
                            [716534.0, 6992565.0],
                            [712391.0, 6990404.0],
                            [713833.0, 6986563.0],
                            [708480.0, 6979518.0],
                            [705667.0, 6969289.0],
                            [708546.0, 6956332.0],
                            [707064.0, 6950845.0],
                            [709520.0, 6938240.0],
                            [706939.0, 6934901.0],
                            [711648.0, 6928031.0],
                            [706805.0, 6926038.0],
                            [706929.0, 6919738.0],
                            [698137.0, 6911415.0],
                            [701957.0, 6908433.0],
                            [704672.0, 6899225.0],
                            [710189.0, 6894765.0],
                            [705248.0, 6890863.0],
                            [712067.0, 6888882.0],
                            [712559.0, 6879371.0],
                            [722321.0, 6872132.0],
                            [724211.0, 6867685.0],
                            [729581.0, 6862815.0],
                            [735603.0, 6861428.0],
                            [738742.0, 6868146.0],
                            [744067.0, 6871735.0],
                            [747254.0, 6882494.0],
                            [743801.0, 6891376.0],
                            [745398.0, 6894771.0],
                            [751361.0, 6898188.0],
                            [747051.0, 6913033.0],
                            [761575.0, 6918670.0],
                            [767112.0, 6923360.0],
                            [775242.0, 6918312.0],
                            [776081.0, 6923412.0],
                        ]
                    ],
                },
                "attributes": {"CODE_DEPT": "02"},
            },
            {
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [598361.0, 6887345.0],
                            [603102.0, 6887292.0],
                            [606678.0, 6883543.0],
                            [614076.0, 6886919.0],
                            [622312.0, 6880731.0],
                            [628641.0, 6878089.0],
                            [633062.0, 6879807.0],
                            [641836.0, 6872490.0],
                            [641404.0, 6867928.0],
                            [648071.0, 6872567.0],
                            [653619.0, 6875101.0],
                            [660416.0, 6872923.0],
                            [667303.0, 6878971.0],
                            [670084.0, 6886723.0],
                            [659205.0, 6894147.0],
                            [652314.0, 6895981.0],
                            [649761.0, 6898738.0],
                            [645465.0, 6895048.0],
                            [633020.0, 6901508.0],
                            [626847.0, 6897876.0],
                            [618689.0, 6896449.0],
                            [612180.0, 6899061.0],
                            [608283.0, 6898554.0],
                            [605624.0, 6904387.0],
                            [603501.0, 6902160.0],
                            [601892.0, 6893098.0],
                            [598361.0, 6887345.0],
                        ]
                    ],
                },
                "attributes": {"CODE_DEPT": "95"},
            },
            {
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [229520.0, 6710085.0],
                                [240383.0, 6704696.0],
                                [240163.0, 6708285.0],
                                [235835.0, 6713741.0],
                                [229006.0, 6716339.0],
                                [229520.0, 6710085.0],
                            ]
                        ],
                        [
                            [
                                [212687.0, 6770001.0],
                                [211559.0, 6762660.0],
                                [216528.0, 6752538.0],
                                [224759.0, 6753321.0],
                                [234540.0, 6747533.0],
                                [234220.0, 6745025.0],
                                [240082.0, 6736634.0],
                                [251238.0, 6736509.0],
                                [260889.0, 6740570.0],
                                [266327.0, 6740184.0],
                                [271833.0, 6736526.0],
                                [269308.0, 6731426.0],
                                [263161.0, 6733044.0],
                                [258643.0, 6731063.0],
                                [263631.0, 6725691.0],
                                [274085.0, 6728424.0],
                                [283689.0, 6728526.0],
                                [290663.0, 6724762.0],
                                [288997.0, 6719519.0],
                                [300067.0, 6720583.0],
                                [315995.0, 6726944.0],
                                [317487.0, 6738014.0],
                                [315562.0, 6748257.0],
                                [318803.0, 6749864.0],
                                [322365.0, 6758359.0],
                                [317839.0, 6765781.0],
                                [320890.0, 6769878.0],
                                [317014.0, 6776765.0],
                                [309516.0, 6779524.0],
                                [306739.0, 6782705.0],
                                [310549.0, 6787938.0],
                                [306966.0, 6794650.0],
                                [300637.0, 6793781.0],
                                [298204.0, 6799128.0],
                                [291749.0, 6798375.0],
                                [285132.0, 6789099.0],
                                [280665.0, 6785525.0],
                                [277875.0, 6787107.0],
                                [279762.0, 6794931.0],
                                [270150.0, 6795768.0],
                                [252150.0, 6805897.0],
                                [246074.0, 6807146.0],
                                [242780.0, 6802066.0],
                                [233945.0, 6800703.0],
                                [229439.0, 6804532.0],
                                [212675.0, 6807535.0],
                                [202658.0, 6804638.0],
                                [202166.0, 6798131.0],
                                [205220.0, 6785800.0],
                                [211608.0, 6786141.0],
                                [216607.0, 6782805.0],
                                [223352.0, 6780867.0],
                                [221788.0, 6771592.0],
                                [212687.0, 6770001.0],
                            ]
                        ],
                    ],
                },
                "attributes": {"CODE_DEPT": "56"},
            },
        ),
    },
}

check_if_value_is_from_datetime_lib_parameters = {
    0: {
        "datetime_type": datetime.date,
        "value": date_value,
        "try_to_force": False,
        "return_value": True,
    },
    1: {
        "datetime_type": datetime.time,
        "value": time_value,
        "try_to_force": False,
        "return_value": True,
    },
    2: {
        "datetime_type": datetime.datetime,
        "value": date_time_value,
        "try_to_force": False,
        "return_value": True,
    },
    3: {
        "datetime_type": datetime.date,
        "value": date_value.isoformat(),
        "try_to_force": False,
        "return_value": False,
    },
    4: {
        "datetime_type": datetime.time,
        "value": time_value.isoformat(),
        "try_to_force": False,
        "return_value": False,
    },
    5: {
        "datetime_type": datetime.datetime,
        "value": date_time_value.isoformat(),
        "try_to_force": False,
        "return_value": False,
    },
    6: {
        "datetime_type": datetime.date,
        "value": date_value.isoformat(),
        "try_to_force": True,
        "return_value": True,
    },
    7: {
        "datetime_type": datetime.time,
        "value": time_value.isoformat(),
        "try_to_force": True,
        "return_value": True,
    },
    8: {
        "datetime_type": datetime.datetime,
        "value": date_time_value.isoformat(),
        "try_to_force": True,
        "return_value": True,
    },
}

check_if_value_is_date_parameters = {
    0: {"value": "coucou", "try_to_force": False, "return_value": False},
    1: {"value": "coucou", "try_to_force": True, "return_value": False},
    2: {"value": date_value, "try_to_force": False, "return_value": True},
    3: {"value": date_value, "try_to_force": True, "return_value": True},
    4: {"value": date_value.isoformat(), "try_to_force": False, "return_value": False},
    5: {"value": date_value.isoformat(), "try_to_force": True, "return_value": True},
}

check_if_value_is_time_parameters = {
    0: {"value": "coucou", "try_to_force": False, "return_value": False},
    1: {"value": "coucou", "try_to_force": True, "return_value": False},
    2: {"value": time_value, "try_to_force": False, "return_value": True},
    3: {"value": time_value, "try_to_force": True, "return_value": True},
    4: {"value": time_value.isoformat(), "try_to_force": False, "return_value": False},
    5: {"value": time_value.isoformat(), "try_to_force": True, "return_value": True},
}

check_if_value_is_datetime_parameters = {
    0: {"value": "coucou", "try_to_force": False, "return_value": False},
    1: {"value": "coucou", "try_to_force": True, "return_value": False},
    2: {"value": date_time_value, "try_to_force": False, "return_value": True},
    3: {"value": date_time_value, "try_to_force": True, "return_value": True},
    4: {
        "value": date_time_value.isoformat(),
        "try_to_force": False,
        "return_value": False,
    },
    5: {
        "value": date_time_value.isoformat(),
        "try_to_force": True,
        "return_value": True,
    },
}

return_if_value_is_time_date_or_datetime_parameters = {
    0: {"value": "coucou", "try_to_force": False, "return_value": None},
    1: {"value": "coucou", "try_to_force": True, "return_value": None},
    2: {"value": date_value, "try_to_force": False, "return_value": datetime.date},
    3: {"value": date_value, "try_to_force": True, "return_value": datetime.date},
    4: {"value": date_value.isoformat(), "try_to_force": False, "return_value": None},
    5: {
        "value": date_value.isoformat(),
        "try_to_force": True,
        "return_value": datetime.date,
    },
    6: {"value": time_value, "try_to_force": False, "return_value": datetime.time},
    7: {"value": time_value, "try_to_force": True, "return_value": datetime.time},
    8: {"value": time_value.isoformat(), "try_to_force": False, "return_value": None},
    9: {
        "value": time_value.isoformat(),
        "try_to_force": True,
        "return_value": datetime.time,
    },
    10: {
        "value": date_time_value,
        "try_to_force": False,
        "return_value": datetime.datetime,
    },
    11: {
        "value": date_time_value,
        "try_to_force": True,
        "return_value": datetime.datetime,
    },
    12: {
        "value": date_time_value.isoformat(),
        "try_to_force": False,
        "return_value": None,
    },
    13: {
        "value": date_time_value.isoformat(),
        "try_to_force": True,
        "return_value": datetime.datetime,
    },
}


def test_all():
    # feature_serialize_parameters
    print(test_function(feature_serialize, feature_serialize_parameters))

    # feature_deserialize_parameters
    print(test_function(feature_deserialize, feature_deserialize_parameters))

    # features_geometry_ref_scan
    print(
        test_function(features_geometry_ref_scan, features_geometry_ref_scan_parameters)
    )

    # features_fields_type_scan
    print(
        test_function(features_fields_type_scan, features_fields_type_scan_parameters)
    )

    # feature_list_to_geolayer
    print(test_function(feature_list_to_geolayer, feature_list_to_geolayer_parameters))

    # feature_filter_geometry
    print(test_function(feature_filter_geometry, feature_filter_geometry_parameters))

    # feature_filter_attributes
    print(
        test_function(feature_filter_attributes, feature_filter_attributes_parameters)
    )

    # feature_filter
    print(test_function(feature_filter, feature_filter_parameters))

    # features_filter
    print(test_function(features_filter, features_filter_parameters))

    # check_if_value_is_from_datetime_lib
    print(
        test_function(
            check_if_value_is_from_datetime_lib,
            check_if_value_is_from_datetime_lib_parameters,
        )
    )

    # check_if_value_is_date
    print(test_function(check_if_value_is_date, check_if_value_is_date_parameters))

    # check_if_value_is_time
    print(test_function(check_if_value_is_time, check_if_value_is_time_parameters))

    # check_if_value_is_datetime
    print(
        test_function(check_if_value_is_datetime, check_if_value_is_datetime_parameters)
    )

    # return_if_value_is_time_date_or_datetime
    print(
        test_function(
            return_if_value_is_time_date_or_datetime,
            return_if_value_is_time_date_or_datetime_parameters,
        )
    )


if __name__ == "__main__":
    test_all()
