# Copyright 2018-2019 Open-MMLab.

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# error in training
# sparse_rcnn_r101_fpn_300_proposals_crop_mstrain_480-800_3x_coco.py, box AP=46.2

num_proposals = 300
num_stages = 6
model = dict(
    type="SparseRCNN",
    pretrained="torchvision://resnet101",
    backbone=dict(
        type="ResNet",
        depth=101,
        num_stages=4,
        out_indices=(0, 1, 2, 3),
        frozen_stages=1,
        norm_cfg=dict(type="BN", requires_grad=True),
        norm_eval=True,
        style="pytorch",
    ),
    neck=dict(
        type="FPN",
        in_channels=[256, 512, 1024, 2048],
        out_channels=256,
        start_level=0,
        add_extra_convs="on_input",
        num_outs=4,
    ),
    rpn_head=dict(
        type="EmbeddingRPNHead",
        num_proposals=num_proposals,
        proposal_feature_channel=256,
    ),
    roi_head=dict(
        type="SparseRoIHead",
        num_stages=num_stages,
        stage_loss_weights=[1] * num_stages,
        proposal_feature_channel=256,
        bbox_roi_extractor=dict(
            type="SingleRoIExtractor",
            roi_layer=dict(type="RoIAlign", output_size=7, sampling_ratio=2),
            out_channels=256,
            featmap_strides=[4, 8, 16, 32],
        ),
        bbox_head=[
            dict(
                type="DIIHead",
                num_classes=80,
                num_ffn_fcs=2,
                num_heads=8,
                num_cls_fcs=1,
                num_reg_fcs=3,
                feedforward_channels=2048,
                in_channels=256,
                dropout=0.0,
                ffn_act_cfg=dict(type="ReLU", inplace=True),
                dynamic_conv_cfg=dict(
                    type="DynamicConv",
                    in_channels=256,
                    feat_channels=64,
                    out_channels=256,
                    input_feat_shape=7,
                    act_cfg=dict(type="ReLU", inplace=True),
                    norm_cfg=dict(type="LN"),
                ),
                loss_bbox=dict(type="L1Loss", loss_weight=5.0),
                loss_iou=dict(type="GIoULoss", loss_weight=2.0),
                loss_cls=dict(
                    type="FocalLoss",
                    use_sigmoid=True,
                    gamma=2.0,
                    alpha=0.25,
                    loss_weight=2.0,
                ),
                bbox_coder=dict(
                    type="DeltaXYWHBBoxCoder",
                    clip_border=False,
                    target_means=[0.0, 0.0, 0.0, 0.0],
                    target_stds=[0.5, 0.5, 1.0, 1.0],
                ),
            )
            for _ in range(num_stages)
        ],
    ),
    # training and testing settings
    train_cfg=dict(
        rpn=None,
        rcnn=[
            dict(
                assigner=dict(
                    type="HungarianAssigner",
                    cls_cost=dict(type="FocalLossCost", weight=2.0),
                    reg_cost=dict(type="BBoxL1Cost", weight=5.0),
                    iou_cost=dict(type="IoUCost", iou_mode="giou", weight=2.0),
                ),
                sampler=dict(type="PseudoSampler"),
                pos_weight=1,
            )
            for _ in range(num_stages)
        ],
    ),
    test_cfg=dict(_delete_=True, rpn=None, rcnn=dict(max_per_img=num_proposals)),
)

checkpoint = "https://download.openmmlab.com/mmdetection/v2.0/sparse_rcnn/sparse_rcnn_r101_fpn_300_proposals_crop_mstrain_480-800_3x_coco/sparse_rcnn_r101_fpn_300_proposals_crop_mstrain_480-800_3x_coco_20201223_023452-c23c3564.pth"
