# Copyright 2018-2019 Open-MMLab.

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# sabl_cascade_rcnn_r101_fpn_1x_coco.py, box AP = 43.0
_base_ = "./_base_/models/cascade_rcnn_r50_fpn.py"
# model settings
model = dict(
    pretrained="torchvision://resnet101",
    backbone=dict(depth=101),
    roi_head=dict(
        bbox_head=[
            dict(
                type="SABLHead",
                num_classes=80,
                cls_in_channels=256,
                reg_in_channels=256,
                roi_feat_size=7,
                reg_feat_up_ratio=2,
                reg_pre_kernel=3,
                reg_post_kernel=3,
                reg_pre_num=2,
                reg_post_num=1,
                cls_out_channels=1024,
                reg_offset_out_channels=256,
                reg_cls_out_channels=256,
                num_cls_fcs=1,
                num_reg_fcs=0,
                reg_class_agnostic=True,
                norm_cfg=None,
                bbox_coder=dict(
                    type="BucketingBBoxCoder", num_buckets=14, scale_factor=1.7
                ),
                loss_cls=dict(
                    type="CrossEntropyLoss", use_sigmoid=False, loss_weight=1.0
                ),
                loss_bbox_cls=dict(
                    type="CrossEntropyLoss", use_sigmoid=True, loss_weight=1.0
                ),
                loss_bbox_reg=dict(type="SmoothL1Loss", beta=0.1, loss_weight=1.0),
            ),
            dict(
                type="SABLHead",
                num_classes=80,
                cls_in_channels=256,
                reg_in_channels=256,
                roi_feat_size=7,
                reg_feat_up_ratio=2,
                reg_pre_kernel=3,
                reg_post_kernel=3,
                reg_pre_num=2,
                reg_post_num=1,
                cls_out_channels=1024,
                reg_offset_out_channels=256,
                reg_cls_out_channels=256,
                num_cls_fcs=1,
                num_reg_fcs=0,
                reg_class_agnostic=True,
                norm_cfg=None,
                bbox_coder=dict(
                    type="BucketingBBoxCoder", num_buckets=14, scale_factor=1.5
                ),
                loss_cls=dict(
                    type="CrossEntropyLoss", use_sigmoid=False, loss_weight=1.0
                ),
                loss_bbox_cls=dict(
                    type="CrossEntropyLoss", use_sigmoid=True, loss_weight=1.0
                ),
                loss_bbox_reg=dict(type="SmoothL1Loss", beta=0.1, loss_weight=1.0),
            ),
            dict(
                type="SABLHead",
                num_classes=80,
                cls_in_channels=256,
                reg_in_channels=256,
                roi_feat_size=7,
                reg_feat_up_ratio=2,
                reg_pre_kernel=3,
                reg_post_kernel=3,
                reg_pre_num=2,
                reg_post_num=1,
                cls_out_channels=1024,
                reg_offset_out_channels=256,
                reg_cls_out_channels=256,
                num_cls_fcs=1,
                num_reg_fcs=0,
                reg_class_agnostic=True,
                norm_cfg=None,
                bbox_coder=dict(
                    type="BucketingBBoxCoder", num_buckets=14, scale_factor=1.3
                ),
                loss_cls=dict(
                    type="CrossEntropyLoss", use_sigmoid=False, loss_weight=1.0
                ),
                loss_bbox_cls=dict(
                    type="CrossEntropyLoss", use_sigmoid=True, loss_weight=1.0
                ),
                loss_bbox_reg=dict(type="SmoothL1Loss", beta=0.1, loss_weight=1.0),
            ),
        ]
    ),
)

checkpoint = "http://download.openmmlab.com/mmdetection/v2.0/sabl/sabl_cascade_rcnn_r101_fpn_1x_coco/sabl_cascade_rcnn_r101_fpn_1x_coco-2b83e87c.pth"
